/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.collection;

import com.gigaspaces.api.InternalApi;
import com.sun.jini.collection.WeakKeyReference;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;

@InternalApi
public class WeakTable {
    private HashMap table = new HashMap();
    private ReferenceQueue refQueue = new ReferenceQueue();
    private static PrintStream DEBUG = null;
    private KeyGCHandler handler = null;

    public WeakTable() {
        if (DEBUG != null) {
            DEBUG.println("Creating WeakTable");
        }
        this.table = new HashMap();
        this.refQueue = new ReferenceQueue();
    }

    public WeakTable(KeyGCHandler handler) {
        this();
        this.handler = handler;
    }

    public synchronized Object getOrAdd(Object key, Object proxy) {
        Object existing = this.get(key);
        if (existing != null) {
            if (DEBUG != null) {
                DEBUG.println("WeakTable.getOrAdd: found " + existing);
            }
            return existing;
        }
        if (DEBUG != null) {
            DEBUG.println("WeakTable.getOrAdd: adding " + proxy);
        }
        this.table.put(new WeakKeyReference(key, this.refQueue), new WeakReference<Object>(proxy, this.refQueue));
        return proxy;
    }

    public synchronized Object get(Object key) {
        Object existing;
        this.removeBlanks();
        WeakKeyReference keyRef = new WeakKeyReference(key);
        WeakReference ref = (WeakReference)this.table.get(keyRef);
        Object v0 = existing = ref == null ? null : ref.get();
        if (DEBUG != null) {
            DEBUG.println("WeakTable.get:ref = " + ref + ", existing = " + existing);
        }
        return existing;
    }

    public synchronized Object remove(Object key) {
        this.removeBlanks();
        WeakKeyReference keyRef = new WeakKeyReference(key);
        WeakReference ref = (WeakReference)this.table.remove(keyRef);
        if (ref == null) {
            return null;
        }
        return ref.get();
    }

    public synchronized void removeBlanks() {
        Reference ref;
        if (DEBUG != null) {
            DEBUG.println("WeakTable.removeBlanks: starting");
        }
        while ((ref = this.refQueue.poll()) != null) {
            if (ref instanceof WeakKeyReference) {
                WeakReference valref = (WeakReference)this.table.remove(ref);
                if (valref != null && this.handler != null && valref.get() != null) {
                    this.handler.keyGC(valref.get());
                }
                if (DEBUG == null) continue;
                boolean removed = valref != null;
                DEBUG.print("WeakTable.removeBlanks: key=" + ref);
                DEBUG.println(", " + (removed ? "" : "!") + "removed, " + this.table.size() + " remain");
                continue;
            }
            if (DEBUG == null) continue;
            DEBUG.println("WeakTable.removeBlanks: value=" + ref);
        }
        if (DEBUG != null) {
            DEBUG.println("WeakTable.removeBlanks: finished");
        }
    }

    public static interface KeyGCHandler {
        public void keyGC(Object var1);
    }
}

