/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.landlord;

import com.gigaspaces.api.InternalApi;
import com.sun.jini.landlord.LeasePeriodPolicy;
import com.sun.jini.landlord.LeasedResource;
import net.jini.core.lease.LeaseDeniedException;

@InternalApi
public class FixedLeasePeriodPolicy
implements LeasePeriodPolicy {
    private final long maximum;
    private final long defaultLength;

    public FixedLeasePeriodPolicy(long maximum, long defaultLength) {
        if (maximum <= 0L) {
            throw new IllegalArgumentException("FixedLeasePeriodPolicy:maximum lease time must be larger than 0, passed:" + maximum);
        }
        if (defaultLength <= 0L) {
            throw new IllegalArgumentException("FixedLeasePeriodPolicy:default lease time must be larger than 0, passed:" + defaultLength);
        }
        this.maximum = maximum;
        this.defaultLength = defaultLength;
    }

    protected long calculateDuration(LeasedResource resource, long requestedDuration) {
        if (requestedDuration == Long.MAX_VALUE) {
            requestedDuration = Long.MAX_VALUE;
        } else if (requestedDuration == -1L) {
            requestedDuration = this.defaultLength;
        } else if (requestedDuration < 0L) {
            throw new IllegalArgumentException("Negative lease duration requested");
        }
        return Math.min(requestedDuration, this.maximum);
    }

    protected long currentTime() {
        return System.currentTimeMillis();
    }

    private long calcExpiration(long preferredDuration, long now) {
        long expiration = now + preferredDuration;
        if (expiration < 0L) {
            return Long.MAX_VALUE;
        }
        return expiration;
    }

    @Override
    public LeasePeriodPolicy.Result grant(LeasedResource resource, long requestedDuration) throws LeaseDeniedException {
        long now = this.currentTime();
        long expiration = this.calcExpiration(this.calculateDuration(resource, requestedDuration), now);
        long duration = expiration - now;
        return new LeasePeriodPolicy.Result(expiration, duration);
    }

    @Override
    public LeasePeriodPolicy.Result renew(LeasedResource resource, long requestedDuration) throws LeaseDeniedException {
        long now = this.currentTime();
        long newExpiration = this.calcExpiration(this.calculateDuration(resource, requestedDuration), now);
        long oldExpiration = resource.getExpiration();
        if (oldExpiration > newExpiration) {
            long requestedExpiration;
            newExpiration = requestedDuration == -1L ? oldExpiration : ((requestedExpiration = this.calcExpiration(requestedDuration, now)) > oldExpiration ? oldExpiration : requestedExpiration);
        }
        return new LeasePeriodPolicy.Result(newExpiration, newExpiration - now);
    }
}

