/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.landlord;

import com.sun.jini.landlord.ConstrainableLandlordLease;
import com.sun.jini.landlord.Landlord;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.id.Uuid;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.TrustEquivalence;

public final class LandlordProxyVerifier
implements Serializable,
TrustVerifier {
    private static final long serialVersionUID = 1L;
    private final RemoteMethodControl landlord;
    private final Uuid landlordUuid;

    public LandlordProxyVerifier(Landlord landlord, Uuid landlordUuid) {
        if (landlord == null) {
            throw new NullPointerException("landlord must not be null");
        }
        if (landlordUuid == null) {
            throw new NullPointerException("landlordUuid must not be null");
        }
        if (!(landlord instanceof RemoteMethodControl)) {
            throw new UnsupportedOperationException("cannot construct verifier - server reference does not implement RemoteMethodControl");
        }
        if (!(landlord instanceof TrustEquivalence)) {
            throw new UnsupportedOperationException("cannot construct verifier - server reference does not implement TrustEquivalence");
        }
        this.landlord = (RemoteMethodControl)landlord;
        this.landlordUuid = landlordUuid;
    }

    public boolean isTrustedObject(Object obj, TrustVerifier.Context ctx) throws RemoteException {
        ConstrainableLandlordLease cll;
        if (obj == null || ctx == null) {
            throw new NullPointerException("arguments must not be null");
        }
        if (obj instanceof ConstrainableLandlordLease) {
            cll = (ConstrainableLandlordLease)((Object)obj);
            if (!this.landlordUuid.equals((Object)cll.landlordUuid())) {
                return false;
            }
        } else {
            return false;
        }
        RemoteMethodControl inputProxyServer = (RemoteMethodControl)cll.landlord();
        MethodConstraints mConstraints = inputProxyServer.getConstraints();
        TrustEquivalence constrainedServer = (TrustEquivalence)this.landlord.setConstraints(mConstraints);
        return constrainedServer.checkTrustEquivalence((Object)inputProxyServer);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.landlord == null) {
            throw new InvalidObjectException("null landlord reference");
        }
        if (this.landlordUuid == null) {
            throw new InvalidObjectException("null landlordUuid reference");
        }
        if (!(this.landlord instanceof TrustEquivalence)) {
            throw new InvalidObjectException("server does not implement TrustEquivalence");
        }
    }
}

