/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.landlord;

import com.gigaspaces.api.InternalApi;
import com.sun.jini.landlord.Landlord;
import com.sun.jini.landlord.LocalLandlord;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.jini.core.lease.LeaseException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.id.Uuid;

@InternalApi
public class LandlordUtil {
    public static Landlord.RenewResults renewAll(LocalLandlord landlord, Uuid[] cookies, long[] durations) {
        int count = cookies.length;
        long[] granted = new long[count];
        ArrayList<LeaseException> exceptions = new ArrayList<LeaseException>(count);
        for (int i = 0; i < count; ++i) {
            try {
                granted[i] = landlord.renew(cookies[i], durations[i]);
                continue;
            }
            catch (LeaseException le) {
                granted[i] = -1L;
                exceptions.add(le);
            }
        }
        if (exceptions.size() == 0) {
            return new Landlord.RenewResults(granted);
        }
        Exception[] es = new Exception[exceptions.size()];
        return new Landlord.RenewResults(granted, exceptions.toArray(es));
    }

    public static Map cancelAll(LocalLandlord landlord, Uuid[] cookies) {
        int count = cookies.length;
        HashMap<Uuid, UnknownLeaseException> map = null;
        for (int i = 0; i < count; ++i) {
            try {
                landlord.cancel(cookies[i]);
                continue;
            }
            catch (UnknownLeaseException e) {
                if (map == null) {
                    map = new HashMap<Uuid, UnknownLeaseException>();
                }
                map.put(cookies[i], e);
            }
        }
        return map;
    }
}

