/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.operations.AbortPreparedTransactionSpaceOperationRequest;
import com.gigaspaces.internal.client.spaceproxy.operations.AbortPreparedTransactionSpaceOperationResult;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.j_spaces.core.OperationID;
import com.sun.jini.mahalo.Job;
import com.sun.jini.mahalo.JobException;
import com.sun.jini.mahalo.JobNotStartedException;
import com.sun.jini.mahalo.ParticipantAbortRecord;
import com.sun.jini.mahalo.ParticipantHandle;
import com.sun.jini.mahalo.ParticipantTask;
import com.sun.jini.mahalo.ResultNotReadyException;
import com.sun.jini.mahalo.TxnManagerImpl;
import com.sun.jini.mahalo.log.ClientLog;
import com.sun.jini.mahalo.log.LogException;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.rmi.AccessException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.rmi.activation.ActivateFailedException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.CannotAbortException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.server.ExtendedTransactionManager;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionConstants;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.core.transaction.server.TransactionParticipant;

@InternalApi
public class AbortJob
extends Job
implements TransactionConstants {
    private final ServerTransaction tr;
    private final ClientLog log;
    private final ParticipantHandle[] handles;
    private final int maxtries = 5;
    private static final Logger logger = TxnManagerImpl.participantLogger;
    private final Object _xid;

    public AbortJob(Transaction tr, TaskManager pool, WakeupManager wm, ClientLog log, ParticipantHandle[] handles, boolean directCall, Object xid) {
        super(pool, wm, directCall);
        if (log == null) {
            throw new IllegalArgumentException("AbortJob: AbortJob: log is null");
        }
        this.log = log;
        if (!(tr instanceof ServerTransaction)) {
            throw new IllegalArgumentException("PrepareJob: PrepareJob: must be a ServerTransaction");
        }
        this.tr = (ServerTransaction)tr;
        if (handles == null) {
            throw new IllegalArgumentException("PrepareJob: PrepareJob: must have participants");
        }
        if (handles.length == 0) {
            throw new IllegalArgumentException("PrepareJob: PrepareJob: must have participants");
        }
        this.handles = handles;
        if (this._directCall) {
            this.results = new Integer[1];
        }
        this._xid = xid;
    }

    @Override
    TaskManager.Task[] createTasks() {
        TaskManager.Task[] tmp = new TaskManager.Task[this.handles.length];
        for (int i = 0; i < this.handles.length; ++i) {
            tmp[i] = new ParticipantTask(this.getPool(), this.getMgr(), this, this.handles[i]);
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object doWork(TaskManager.Task who, Object param) {
        Integer response = null;
        try {
            Integer n;
            ParticipantHandle handle = (ParticipantHandle)param;
            TransactionParticipant par = null;
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "AbortJob:doWork aborting handle: {0}", handle);
            }
            int vote = 0;
            vote = handle.getPrepState();
            switch (vote) {
                case 4: {
                    Integer n2 = new Integer(6);
                    return n2;
                }
                case 6: {
                    if (handle.isPrepared()) break;
                    Integer n3 = new Integer(6);
                    return n3;
                }
            }
            if (par == null) {
                par = handle.getParticipant();
            }
            try {
                if (!this._directCall && this.attempt(who) > 5) {
                    Integer n4 = response = Integer.valueOf(6);
                    return n4;
                }
            }
            catch (JobException je) {
                Object var8_24 = null;
                return var8_24;
            }
            if (par == null) {
                Object je = null;
                return je;
            }
            try {
                if (handle.isSuitableForCommitFailover()) {
                    AbortJob.abortPartitionWithEnabledFailover(handle, this.tr.mgr, this.tr.id, this._xid);
                } else if (this._xid == null) {
                    par.abort((TransactionManager)this.tr.mgr, this.tr.id);
                } else {
                    ((IRemoteSpace)par).abort((TransactionManager)this.tr.mgr, this._xid);
                }
                response = 6;
            }
            catch (TransactionException bte) {
                response = 6;
            }
            catch (NoSuchObjectException nsoe) {
                response = 6;
            }
            catch (ConnectException ce) {
                if (this.numberOfRetriesDueToConnectionExceptionExceeded(who)) {
                    response = 6;
                }
            }
            catch (UnknownHostException uhe) {
                response = 6;
            }
            catch (ConnectIOException cioe) {
                if (this.numberOfRetriesDueToConnectionExceptionExceeded(who)) {
                    response = 6;
                }
            }
            catch (MarshalException me) {
                response = 6;
            }
            catch (AccessException ae) {
                response = 6;
            }
            catch (ActivateFailedException afe) {
                response = 6;
            }
            catch (RemoteException re) {
                response = 6;
            }
            catch (RuntimeException rte) {
                response = 6;
            }
            if (response != null) {
                handle.setPrepState(6);
                try {
                    this.log.write(new ParticipantAbortRecord(handle));
                }
                catch (LogException logException) {
                    // empty catch block
                }
                n = response;
                return n;
            }
            n = null;
            return n;
        }
        finally {
            if (this._directCall && response != null) {
                this.results[0] = response;
                this.pending = 0;
            }
        }
    }

    public static Object abortPartitionWithEnabledFailover(ParticipantHandle handle, ExtendedTransactionManager mgr, long id, Object xid) {
        try {
            AbortPreparedTransactionSpaceOperationRequest request = null;
            OperationID operationID = handle.getClusterProxy().createNewOperationID();
            request = xid == null ? new AbortPreparedTransactionSpaceOperationRequest((TransactionManager)mgr, id, handle.getPartionId(), operationID) : new AbortPreparedTransactionSpaceOperationRequest((TransactionManager)mgr, xid, handle.getPartionId(), operationID);
            handle.getClusterProxy().getProxyRouter().execute(request);
            ((AbortPreparedTransactionSpaceOperationResult)request.getRemoteOperationResult()).processExecutionException();
            return new Integer(6);
        }
        catch (Exception ex) {
            CannotAbortException ex1 = new CannotAbortException(" abort failed reason=" + ex);
            handle.setAbortException(ex1);
            return new Integer(6);
        }
    }

    @Override
    Object computeResult() throws JobException {
        try {
            if (!this.isCompleted(0L)) {
                throw new ResultNotReadyException("Cannot compute result since there are jobs pending");
            }
        }
        catch (JobNotStartedException jnse) {
            throw new ResultNotReadyException("Cannot compute result since jobs were not created");
        }
        int tmp = 0;
        int count = 0;
        for (int i = 0; i < this.results.length; ++i) {
            tmp = (Integer)this.results[i];
            if (tmp != 6) continue;
            ++count;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "AbortJob:computeResult {0} participants ABORTED", new Integer(count));
        }
        return new Integer(6);
    }
}

