/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.operations.CommitPreparedTransactionSpaceOperationRequest;
import com.gigaspaces.internal.client.spaceproxy.operations.CommitPreparedTransactionSpaceOperationResult;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.j_spaces.core.OperationID;
import com.sun.jini.mahalo.Job;
import com.sun.jini.mahalo.JobException;
import com.sun.jini.mahalo.JobNotStartedException;
import com.sun.jini.mahalo.ParticipantCommitRecord;
import com.sun.jini.mahalo.ParticipantHandle;
import com.sun.jini.mahalo.ParticipantTask;
import com.sun.jini.mahalo.ResultNotReadyException;
import com.sun.jini.mahalo.TxnManagerImpl;
import com.sun.jini.mahalo.log.ClientLog;
import com.sun.jini.mahalo.log.LogException;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.rmi.AccessException;
import java.rmi.ConnectException;
import java.rmi.ConnectIOException;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.rmi.activation.ActivateFailedException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.CannotCommitException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.server.ExtendedTransactionManager;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionConstants;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.core.transaction.server.TransactionParticipant;

@InternalApi
public class CommitJob
extends Job
implements TransactionConstants {
    ServerTransaction tr;
    ClientLog log;
    ParticipantHandle[] handles;
    int maxtries = Integer.MAX_VALUE;
    static final Logger logger = TxnManagerImpl.participantLogger;
    private final Object _xid;

    public CommitJob(Transaction tr, TaskManager pool, WakeupManager wm, ClientLog log, ParticipantHandle[] handles, Object xid) {
        super(pool, wm, false);
        if (log == null) {
            throw new IllegalArgumentException("CommitJob: CommitJob: log is null");
        }
        this.log = log;
        if (!(tr instanceof ServerTransaction)) {
            throw new IllegalArgumentException("PrepareJob: PrepareJob: must be a ServerTransaction");
        }
        this.tr = (ServerTransaction)tr;
        if (handles == null) {
            throw new IllegalArgumentException("PrepareJob: PrepareJob: must have participants");
        }
        if (handles.length == 0) {
            throw new IllegalArgumentException("PrepareJob: PrepareJob: must have participants");
        }
        this.handles = handles;
        this._xid = xid;
    }

    @Override
    Object doWork(TaskManager.Task who, Object param) {
        ParticipantHandle handle = (ParticipantHandle)param;
        TransactionParticipant par = null;
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "CommitJob:doWork committing handle: {0}", handle);
        }
        int vote = handle.getPrepState();
        switch (vote) {
            case 4: 
            case 5: 
            case 6: {
                return new Integer(vote);
            }
        }
        if (par == null) {
            par = handle.getParticipant();
        }
        try {
            if (this.attempt(who) > this.maxtries) {
                return new Integer(5);
            }
        }
        catch (JobException je) {
            return null;
        }
        if (par == null) {
            return null;
        }
        Integer response = null;
        try {
            int preparedParticipants = 0;
            for (int i = 0; i < this.handles.length; ++i) {
                if (this.handles[i].getPrepState() == 4 || handle.getClusterName() != this.handles[i].getClusterName() && (handle.getClusterName() == null || !handle.getClusterName().equals(this.handles[i].getClusterName()))) continue;
                ++preparedParticipants;
            }
            if (handle.isSuitableForCommitFailover()) {
                CommitJob.commitPartitionWithEnabledFailover(handle, this.tr.mgr, this.tr.id, this._xid, preparedParticipants);
            } else if (this._xid == null) {
                par.commit((TransactionManager)this.tr.mgr, this.tr.id, preparedParticipants);
            } else {
                ((IRemoteSpace)par).commit((TransactionManager)this.tr.mgr, this._xid, preparedParticipants);
            }
            response = new Integer(5);
        }
        catch (TransactionException bte) {
            response = new Integer(5);
        }
        catch (NoSuchObjectException nsoe) {
            response = new Integer(5);
        }
        catch (ConnectException ce) {
            if (this.numberOfRetriesDueToConnectionExceptionExceeded(who)) {
                response = new Integer(5);
            }
        }
        catch (UnknownHostException uhe) {
            response = new Integer(5);
        }
        catch (ConnectIOException cioe) {
            if (this.numberOfRetriesDueToConnectionExceptionExceeded(who)) {
                response = new Integer(5);
            }
        }
        catch (MarshalException me) {
            response = new Integer(5);
        }
        catch (AccessException ae) {
            response = new Integer(5);
        }
        catch (ActivateFailedException afe) {
            response = new Integer(5);
        }
        catch (RemoteException re) {
            response = new Integer(5);
        }
        catch (RuntimeException rte) {
            response = new Integer(5);
        }
        if (response != null) {
            handle.setPrepState(5);
            try {
                this.log.write(new ParticipantCommitRecord(handle));
            }
            catch (LogException logException) {
                // empty catch block
            }
            return response;
        }
        return null;
    }

    public static void commitPartitionWithEnabledFailover(ParticipantHandle handle, ExtendedTransactionManager mgr, long id, Object xid, int numPrepared) {
        try {
            CommitPreparedTransactionSpaceOperationRequest request = null;
            OperationID operationID = handle.getClusterProxy().createNewOperationID();
            request = xid == null ? new CommitPreparedTransactionSpaceOperationRequest((TransactionManager)mgr, id, handle.getPartionId(), numPrepared, operationID) : new CommitPreparedTransactionSpaceOperationRequest((TransactionManager)mgr, xid, handle.getPartionId(), numPrepared, operationID);
            handle.getClusterProxy().getProxyRouter().execute(request);
            ((CommitPreparedTransactionSpaceOperationResult)request.getRemoteOperationResult()).processExecutionException();
        }
        catch (Exception ex) {
            CannotCommitException ex1 = new CannotCommitException("commit failed [ID=" + id + "]: reason=" + ex, (Throwable)ex);
            handle.setCommitException(ex1);
        }
    }

    @Override
    TaskManager.Task[] createTasks() {
        TaskManager.Task[] tmp = new TaskManager.Task[this.handles.length];
        for (int i = 0; i < this.handles.length; ++i) {
            tmp[i] = new ParticipantTask(this.getPool(), this.getMgr(), this, this.handles[i]);
        }
        return tmp;
    }

    @Override
    Object computeResult() throws JobException {
        try {
            if (!this.isCompleted(0L)) {
                throw new ResultNotReadyException("Cannot compute result since there are jobs pending");
            }
        }
        catch (JobNotStartedException jnse) {
            throw new ResultNotReadyException("Cannot compute result since jobs were not created");
        }
        int tmp = 0;
        int count = 0;
        for (int i = 0; i < this.results.length; ++i) {
            tmp = (Integer)this.results[i];
            if (tmp != 5) continue;
            ++count;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "CommitJob:computeResult {0} participants COMMITTED", new Integer(count));
        }
        return new Integer(5);
    }
}

