/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.gigaspaces.start.SystemInfo;
import com.sun.jini.config.Config;
import com.sun.jini.logging.Levels;
import com.sun.jini.mahalo.TxnManagerImpl;
import com.sun.jini.reliableLog.LogHandler;
import com.sun.jini.reliableLog.ReliableLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.discovery.LookupGroups;
import net.jini.id.Uuid;
import net.jini.lookup.JoinManager;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import org.jini.rio.boot.BootUtil;

class JoinStateManager
extends LogHandler {
    private static final Logger initlogger = TxnManagerImpl.initLogger;
    private static final Logger operationsLogger = TxnManagerImpl.operationsLogger;
    private static final Logger persistenceLogger = TxnManagerImpl.persistenceLogger;
    private ProxyPreparer lookupLocatorPreparer;
    private DiscoveryManagement dm;
    private JoinManager mgr;
    private ReliableLog log;
    private Entry[] attributes;
    private LookupLocator[] locators;
    private String[] groups;
    private Uuid serviceUuid;
    private boolean initial = true;

    JoinStateManager(String logPath) throws IOException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "JoinStateManager", logPath);
        }
        ReliableLog reliableLog = this.log = logPath == null ? null : new ReliableLog(logPath, this);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "JoinStateManager");
        }
    }

    void recover() throws IOException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "recover");
        }
        if (this.log != null) {
            this.log.recover();
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "recover");
        }
    }

    public static LookupLocator[] toLookupLocators(String lookupLocatorURLs) {
        String locatorURL = null;
        ArrayList<LookupLocator> locatorList = new ArrayList<LookupLocator>();
        if (lookupLocatorURLs != null && lookupLocatorURLs.length() > 0) {
            StringTokenizer st = new StringTokenizer(lookupLocatorURLs, ",");
            while (st.hasMoreTokens()) {
                try {
                    locatorURL = st.nextToken().trim();
                    if (locatorURL.length() == 0 || locatorURL.equals("\"\"")) continue;
                    LookupLocator lookupLocator = new LookupLocator("jini://" + locatorURL);
                    locatorList.add(lookupLocator);
                }
                catch (MalformedURLException ex) {
                    if (!initlogger.isLoggable(Level.WARNING)) continue;
                    initlogger.log(Level.WARNING, "Failed to parse list of LookupLocator URLs: " + locatorURL + " - " + ex.toString(), ex);
                }
            }
        }
        if (initlogger.isLoggable(Level.FINE)) {
            initlogger.log(Level.FINE, locatorList.toString());
        }
        return locatorList.toArray(new LookupLocator[0]);
    }

    void startManager(Configuration config, Object service, ServiceID serviceID, Entry[] baseAttributes) throws IOException, ConfigurationException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "startManager", new Object[]{config, service, serviceID, Arrays.asList(baseAttributes)});
        }
        if (serviceID == null || this.serviceUuid == null) {
            throw new AssertionError((Object)"serviceID and serviceUuid must be set");
        }
        BasicProxyPreparer defaultPreparer = new BasicProxyPreparer();
        this.lookupLocatorPreparer = (ProxyPreparer)Config.getNonNullEntry((Configuration)config, (String)"com.sun.jini.mahalo", (String)"lookupLocatorPreparer", ProxyPreparer.class, (Object)defaultPreparer);
        if (initlogger.isLoggable(Level.CONFIG)) {
            initlogger.log(Level.CONFIG, "lookupLocatorPreparer: {0}", this.lookupLocatorPreparer);
        }
        this.dm = (DiscoveryManagement)Config.getNonNullEntry((Configuration)config, (String)"com.sun.jini.mahalo", (String)"discoveryManager", DiscoveryManagement.class, (Object)new LookupDiscoveryManager(LookupGroups.none(), null, null, config));
        if (initlogger.isLoggable(Level.CONFIG)) {
            initlogger.log(Level.CONFIG, "discoveryManager: {0}", this.dm);
        }
        if (this.dm instanceof DiscoveryGroupManagement) {
            String[] groups = ((DiscoveryGroupManagement)((Object)this.dm)).getGroups();
            if (groups == LookupGroups.all() || groups.length != 0) {
                throw new ConfigurationException("discoveryManager entry must be configured to initially discover/join NO_GROUPS");
            }
        } else {
            throw new ConfigurationException("Entry for component com.sun.jini.mahalo, name discoveryManager must implement net.jini.discovery.DiscoveryGroupManagement");
        }
        if (this.dm instanceof DiscoveryLocatorManagement) {
            LookupLocator[] locs = ((DiscoveryLocatorManagement)((Object)this.dm)).getLocators();
            if (locs != null && locs.length != 0) {
                throw new ConfigurationException("discoveryManager entry must be initiallyconfigured with no locators");
            }
        } else {
            throw new ConfigurationException("Entry for component com.sun.jini.mahalo, name discoveryManager must implement net.jini.discovery.DiscoveryLocatorManagement");
        }
        if (this.initial) {
            if (initlogger.isLoggable(Level.FINEST)) {
                initlogger.log(Level.FINEST, "Obtaining initial values");
            }
            this.groups = (String[])config.getEntry("com.sun.jini.mahalo", "initialLookupGroups", String[].class, (Object)BootUtil.toArray((String)SystemInfo.singleton().lookup().groups()));
            if (initlogger.isLoggable(Level.CONFIG)) {
                initlogger.log(Level.CONFIG, "Obtaining initial groups: {0}", this.groups == null ? Arrays.asList("<ALL_GROUPS>") : Arrays.asList(this.groups));
            }
            this.locators = (LookupLocator[])Config.getNonNullEntry((Configuration)config, (String)"com.sun.jini.mahalo", (String)"initialLookupLocators", LookupLocator[].class, (Object)JoinStateManager.toLookupLocators(System.getProperty("com.gs.jini_lus.locators", "")));
            if (initlogger.isLoggable(Level.CONFIG)) {
                initlogger.log(Level.CONFIG, "Obtaining initial locators: {0}", Arrays.asList(this.locators));
            }
            Entry[] cAttrs = (Entry[])Config.getNonNullEntry((Configuration)config, (String)"com.sun.jini.mahalo", (String)"initialLookupAttributes", Entry[].class, (Object)new Entry[0]);
            if (initlogger.isLoggable(Level.CONFIG)) {
                initlogger.log(Level.CONFIG, "Obtaining initial attributes: {0}", Arrays.asList(cAttrs));
            }
            if (cAttrs.length == 0) {
                this.attributes = baseAttributes;
            } else {
                this.attributes = new Entry[cAttrs.length + baseAttributes.length];
                System.arraycopy(baseAttributes, 0, this.attributes, 0, baseAttributes.length);
                System.arraycopy(cAttrs, 0, this.attributes, baseAttributes.length, cAttrs.length);
            }
            if (initlogger.isLoggable(Level.FINEST)) {
                initlogger.log(Level.FINEST, "Combined attributes: {0}", Arrays.asList(this.attributes));
            }
        } else {
            if (initlogger.isLoggable(Level.FINEST)) {
                initlogger.log(Level.FINEST, "Recovered locators: {0}", Arrays.asList(this.locators));
            }
            if (this.locators.length > 0) {
                ProxyPreparer recoveredLookupLocatorPreparer = (ProxyPreparer)Config.getNonNullEntry((Configuration)config, (String)"com.sun.jini.mahalo", (String)"recoveredLookupLocatorPreparer", ProxyPreparer.class, (Object)defaultPreparer);
                if (initlogger.isLoggable(Level.CONFIG)) {
                    initlogger.log(Level.CONFIG, "recoveredLookupLocatorPreparer: {0}", recoveredLookupLocatorPreparer);
                }
                LinkedList<Object> prepared = new LinkedList<Object>();
                for (int i = 0; i < this.locators.length; ++i) {
                    try {
                        prepared.add(recoveredLookupLocatorPreparer.prepareProxy((Object)this.locators[i]));
                        continue;
                    }
                    catch (Throwable t) {
                        if (initlogger.isLoggable(Levels.HANDLED)) {
                            initlogger.log(Levels.HANDLED, "Exception re-preparing LookupLocator: {0}. Dropping locator.", this.locators[i]);
                        }
                        if (!initlogger.isLoggable(Levels.HANDLED)) continue;
                        initlogger.log(Levels.HANDLED, "Preparer exception: ", t);
                    }
                }
                this.locators = prepared.toArray(new LookupLocator[0]);
            }
        }
        if (initlogger.isLoggable(Level.FINEST)) {
            initlogger.log(Level.FINEST, "Setting groups and locators");
        }
        ((DiscoveryGroupManagement)((Object)this.dm)).setGroups(this.groups);
        ((DiscoveryLocatorManagement)((Object)this.dm)).setLocators(this.locators);
        if (initlogger.isLoggable(Level.FINEST)) {
            initlogger.log(Level.FINEST, "Creating JoinManager");
        }
        this.mgr = new JoinManager(service, this.attributes, serviceID, this.dm, null, config);
        this.attributes = null;
        this.groups = null;
        this.locators = null;
        if (initlogger.isLoggable(Level.FINEST)) {
            initlogger.log(Level.FINEST, "Taking snapshot");
        }
        this.update();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "startManager");
        }
    }

    public void setServiceUuid(Uuid serviceUuid) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "setServiceUuid", serviceUuid);
        }
        if (serviceUuid == null) {
            throw new NullPointerException("serviceUuid can't be null");
        }
        this.serviceUuid = serviceUuid;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "setServiceUuid");
        }
    }

    public Uuid getServiceUuid() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "getServiceUuid");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "getServiceUuid", this.serviceUuid);
        }
        return this.serviceUuid;
    }

    public void stop() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "stop");
        }
        if (this.mgr != null) {
            this.mgr.terminate();
        }
        if (this.dm != null) {
            this.dm.terminate();
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "stop");
        }
    }

    public void destroy() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "destroy");
        }
        this.stop();
        if (this.log != null) {
            this.log.deletePersistentStore();
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "destroy");
        }
    }

    public Entry[] getLookupAttributes() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "getLookupAttributes");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "getLookupAttributes");
        }
        return this.mgr.getAttributes();
    }

    public void addLookupAttributes(Entry[] attrSets) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "addLookupAttributes");
        }
        this.mgr.addAttributes(attrSets, true);
        this.update();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "addLookupAttributes");
        }
    }

    public void modifyLookupAttributes(Entry[] attrSetTemplates, Entry[] attrSets) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "modifyLookupAttributes");
        }
        this.mgr.modifyAttributes(attrSetTemplates, attrSets, true);
        this.update();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "modifyLookupAttributes");
        }
    }

    public String[] getLookupGroups() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "getLookupGroups");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "getLookupGroups");
        }
        return ((DiscoveryGroupManagement)((Object)this.dm)).getGroups();
    }

    public void addLookupGroups(String[] groups) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "addLookupGroups");
        }
        try {
            ((DiscoveryGroupManagement)((Object)this.dm)).addGroups(groups);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not change groups");
        }
        this.update();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "addLookupGroups");
        }
    }

    public void removeLookupGroups(String[] groups) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "removeLookupGroups");
        }
        ((DiscoveryGroupManagement)((Object)this.dm)).removeGroups(groups);
        this.update();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "removeLookupGroups");
        }
    }

    public void setLookupGroups(String[] groups) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "setLookupGroups");
        }
        try {
            ((DiscoveryGroupManagement)((Object)this.dm)).setGroups(groups);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not change groups");
        }
        this.update();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "setLookupGroups");
        }
    }

    public LookupLocator[] getLookupLocators() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "getLookupLocators");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "getLookupLocators");
        }
        return ((DiscoveryLocatorManagement)((Object)this.dm)).getLocators();
    }

    public void addLookupLocators(LookupLocator[] locators) throws RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "addLookupLocators");
        }
        this.prepareLocators(locators);
        ((DiscoveryLocatorManagement)((Object)this.dm)).addLocators(locators);
        this.update();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "addLookupLocators");
        }
    }

    public void removeLookupLocators(LookupLocator[] locators) throws RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "removeLookupLocators");
        }
        this.prepareLocators(locators);
        ((DiscoveryLocatorManagement)((Object)this.dm)).removeLocators(locators);
        this.update();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "removeLookupLocators");
        }
    }

    public void setLookupLocators(LookupLocator[] locators) throws RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "setLookupLocators");
        }
        this.prepareLocators(locators);
        ((DiscoveryLocatorManagement)((Object)this.dm)).setLocators(locators);
        this.update();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "setLookupLocators");
        }
    }

    private void prepareLocators(LookupLocator[] locators) throws RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(JoinStateManager.class.getName(), "prepareLocators");
        }
        for (int i = 0; i < locators.length; ++i) {
            locators[i] = (LookupLocator)this.lookupLocatorPreparer.prepareProxy((Object)locators[i]);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(JoinStateManager.class.getName(), "prepareLocators");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        if (this.log != null) {
            ReliableLog reliableLog = this.log;
            synchronized (reliableLog) {
                try {
                    this.log.snapshot();
                }
                catch (IOException e) {
                    if (persistenceLogger.isLoggable(Level.WARNING)) {
                        persistenceLogger.log(Level.WARNING, "Failed to persist join state", e);
                    }
                    throw new RuntimeException("Problem persisting state.", e);
                }
            }
        }
    }

    private static void writeAttributes(Entry[] attributes, ObjectOutput out) throws IOException {
        out.writeInt(attributes.length);
        for (int i = 0; i < attributes.length; ++i) {
            out.writeObject(new MarshalledObject<Entry>(attributes[i]));
        }
    }

    private static Entry[] readAttributes(ObjectInput in) throws IOException, ClassNotFoundException {
        LinkedList entries = new LinkedList();
        int objectCount = in.readInt();
        for (int i = 0; i < objectCount; ++i) {
            try {
                MarshalledObject mo = (MarshalledObject)in.readObject();
                entries.add(mo.get());
                continue;
            }
            catch (IOException e) {
                if (!initlogger.isLoggable(Levels.HANDLED)) continue;
                initlogger.log(Levels.HANDLED, "Exception getting service attribute ... skipping", e);
                continue;
            }
            catch (ClassNotFoundException e) {
                if (!initlogger.isLoggable(Levels.HANDLED)) continue;
                initlogger.log(Levels.HANDLED, "Exception getting service attribute ... skipping", e);
            }
        }
        return entries.toArray(new Entry[0]);
    }

    @Override
    public void snapshot(OutputStream out) throws IOException {
        ObjectOutputStream oostream = new ObjectOutputStream(out);
        oostream.writeObject(this.serviceUuid);
        JoinStateManager.writeAttributes(this.mgr.getAttributes(), oostream);
        oostream.writeObject(((DiscoveryLocatorManagement)((Object)this.dm)).getLocators());
        oostream.writeObject(((DiscoveryGroupManagement)((Object)this.dm)).getGroups());
        oostream.flush();
    }

    @Override
    public void recover(InputStream in) throws Exception {
        this.initial = false;
        ObjectInputStream oistream = new ObjectInputStream(in);
        this.serviceUuid = (Uuid)oistream.readObject();
        this.attributes = JoinStateManager.readAttributes(oistream);
        this.locators = (LookupLocator[])oistream.readObject();
        this.groups = (String[])oistream.readObject();
    }

    @Override
    public void applyUpdate(Object update) throws Exception {
        throw new UnsupportedOperationException("JoinStateManager:Updating log, this should not happen");
    }
}

