/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.time.SystemTime;
import com.sun.jini.collection.WeakTable;
import com.sun.jini.landlord.LeasedResource;
import com.sun.jini.mahalo.LeaseManager;
import com.sun.jini.thread.WakeupManager;
import java.lang.ref.WeakReference;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.id.Uuid;

@InternalApi
public class LeaseExpirationMgr
implements LeaseManager,
WeakTable.KeyGCHandler {
    private final WeakTable ticketMap = new WeakTable(this);
    private final Expirer landlord;
    private final WakeupManager expirationQueue = new WakeupManager(new WakeupManager.ThreadDesc(null, true));

    LeaseExpirationMgr(Expirer landlord) {
        this.landlord = landlord;
    }

    void terminate() {
        this.expirationQueue.stop();
        this.expirationQueue.cancelAll();
    }

    @Override
    public void register(LeasedResource resource) {
        this.schedule(resource);
    }

    @Override
    public void renewed(LeasedResource resource) {
        this.expirationQueue.cancel((WakeupManager.Ticket)this.ticketMap.remove(resource));
        this.schedule(resource);
    }

    private void schedule(LeasedResource resource) {
        WakeupManager.Ticket ticket = this.expirationQueue.schedule(resource.getExpiration(), new Canceler(resource));
        this.ticketMap.getOrAdd(resource, ticket);
    }

    @Override
    public void keyGC(Object value) {
        WakeupManager.Ticket ticket = (WakeupManager.Ticket)value;
        this.expirationQueue.cancel(ticket);
    }

    private class Canceler
    implements Runnable {
        private final WeakReference resourceRef;

        Canceler(LeasedResource resource) {
            this.resourceRef = new WeakReference<LeasedResource>(resource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LeasedResource resource = (LeasedResource)this.resourceRef.get();
            if (resource == null) {
                return;
            }
            LeasedResource leasedResource = resource;
            synchronized (leasedResource) {
                if (resource.getExpiration() <= SystemTime.timeMillis()) {
                    try {
                        LeaseExpirationMgr.this.ticketMap.remove(resource);
                        LeaseExpirationMgr.this.landlord.cancel(resource.getCookie());
                    }
                    catch (UnknownLeaseException unknownLeaseException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static interface Expirer {
        public void cancel(Uuid var1) throws UnknownLeaseException;
    }
}

