/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.stubcache.StubId;
import com.sun.jini.constants.TxnConstants;
import com.sun.jini.mahalo.StorableObject;
import com.sun.jini.mahalo.TxnManagerImpl;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.CannotAbortException;
import net.jini.core.transaction.CannotCommitException;
import net.jini.core.transaction.server.TransactionConstants;
import net.jini.core.transaction.server.TransactionParticipant;
import net.jini.security.ProxyPreparer;

class ParticipantHandle
implements Serializable,
TransactionConstants {
    static final long serialVersionUID = -1776073824495304317L;
    private transient TransactionParticipant _part;
    private StorableObject storedpart;
    private long crashcount;
    private int prepstate;
    private StubId _stubId;
    private boolean _disableDisjoin;
    private int _partitionId;
    private String _clusterName;
    private IDirectSpaceProxy _clusterProxy;
    private volatile boolean _prepared;
    private volatile CannotCommitException _commitEx;
    private volatile CannotAbortException _abortEx;
    private static final Logger persistenceLogger = TxnManagerImpl.persistenceLogger;

    ParticipantHandle(TransactionParticipant preparedPart, long crashcount, StubId stubId, boolean persistent) throws RemoteException {
        this(preparedPart, crashcount, stubId, persistent, -1, null, null);
    }

    ParticipantHandle(TransactionParticipant preparedPart, long crashcount, StubId stubId, boolean persistent, int partitionId, String clusterName, IDirectSpaceProxy clusterProxy) throws RemoteException {
        block6: {
            this.crashcount = 0L;
            if (preparedPart == null) {
                throw new NullPointerException("TransactionParticipant argument cannot be null");
            }
            this._partitionId = partitionId;
            this._clusterName = clusterName;
            try {
                this._stubId = stubId;
                if (persistent) {
                    this.storedpart = new StorableObject(preparedPart);
                }
                this._part = preparedPart;
                this.crashcount = crashcount;
                if (crashcount != Long.MAX_VALUE) {
                    this._disableDisjoin = true;
                }
                if (clusterProxy != null) {
                    this._clusterProxy = clusterProxy;
                }
            }
            catch (RemoteException re) {
                if (!persistenceLogger.isLoggable(Level.WARNING)) break block6;
                persistenceLogger.log(Level.WARNING, "Cannot store the TransactionParticipant", re);
            }
        }
        this.prepstate = 1;
    }

    long getCrashCount() {
        return this.crashcount;
    }

    TransactionParticipant getParticipant() {
        return this._part;
    }

    void restoreTransientState(ProxyPreparer recoveredListenerPreparer) throws RemoteException {
        if (recoveredListenerPreparer == null) {
            throw new NullPointerException("Preparer argument cannot be null");
        }
        this._part = (TransactionParticipant)recoveredListenerPreparer.prepareProxy(this.storedpart.get());
    }

    StorableObject getStoredPart() {
        return this.storedpart;
    }

    synchronized void setPrepState(int state) {
        switch (state) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                throw new IllegalArgumentException("ParticipantHandle: setPrepState: cannot set to " + TxnConstants.getName(state));
            }
        }
        this.prepstate = state;
    }

    synchronized int getPrepState() {
        return this.prepstate;
    }

    boolean compareTo(ParticipantHandle other) {
        if (this.storedpart != null) {
            return this.storedpart.equals(other);
        }
        if (other == null) {
            return false;
        }
        return false;
    }

    public StubId getStubId() {
        return this._stubId;
    }

    public void setStubId(StubId stubid) {
        this._stubId = stubid;
    }

    public boolean isDisableDisjoin() {
        return this._disableDisjoin;
    }

    public void setDisableDisjoin() {
        if (!this._disableDisjoin) {
            this._disableDisjoin = true;
        }
    }

    public IDirectSpaceProxy getClusterProxy() {
        return this._clusterProxy;
    }

    public void setClusterProxy(IDirectSpaceProxy clusterProxy) {
        this._clusterProxy = clusterProxy;
    }

    public String getClusterName() {
        return this._clusterName;
    }

    public void setClusterName(String cname) {
        this._clusterName = cname;
    }

    public void setPartitionId(int pid) {
        this._partitionId = pid;
    }

    public int getPartionId() {
        return this._partitionId;
    }

    public boolean isSuitableForCommitFailover() {
        return this.isSuitableForFailover() && this._prepared;
    }

    public boolean isNeedProxyInCommit() {
        return this._partitionId >= 0 && this._clusterProxy == null && this._clusterName != null;
    }

    public boolean isSuitableForFailover() {
        return this._partitionId >= 0 && this._clusterProxy != null && this._clusterName != null;
    }

    public boolean isPrepared() {
        return this._prepared;
    }

    public void setPrepared() {
        this._prepared = true;
    }

    public CannotCommitException getCommitException() {
        return this._commitEx;
    }

    public CannotAbortException getAbortException() {
        return this._abortEx;
    }

    public void setCommitException(CannotCommitException ex) {
        this._commitEx = ex;
    }

    public void setAbortException(CannotAbortException ex) {
        this._abortEx = ex;
    }

    public int hashCode() {
        if (this._stubId != null) {
            return this._stubId.hashCode();
        }
        return this._part.hashCode();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        ParticipantHandle h = (ParticipantHandle)that;
        if (this._stubId != null) {
            if (this._stubId == h._stubId) {
                return true;
            }
            if (h._stubId != null) {
                return this._stubId.equals(h._stubId);
            }
        }
        return this._part.equals(h._part);
    }
}

