/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.operations.PrepareAndCommitTransactionSpaceOperationRequest;
import com.gigaspaces.internal.client.spaceproxy.operations.PrepareAndCommitTransactionSpaceOperationResult;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.j_spaces.core.OperationID;
import com.sun.jini.mahalo.Job;
import com.sun.jini.mahalo.JobException;
import com.sun.jini.mahalo.JobNotStartedException;
import com.sun.jini.mahalo.ParticipantHandle;
import com.sun.jini.mahalo.ParticipantTask;
import com.sun.jini.mahalo.PrepareAndCommitRecord;
import com.sun.jini.mahalo.ResultNotReadyException;
import com.sun.jini.mahalo.TxnManagerImpl;
import com.sun.jini.mahalo.TxnMgrProxy;
import com.sun.jini.mahalo.log.ClientLog;
import com.sun.jini.mahalo.log.LogException;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.CannotCommitException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionConstants;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.core.transaction.server.TransactionParticipant;

@InternalApi
public class PrepareAndCommitJob
extends Job
implements TransactionConstants {
    ServerTransaction tr;
    ClientLog log;
    ParticipantHandle handle;
    int maxtries = 5;
    private volatile RemoteException reCaught = null;
    private volatile boolean notifyClient = false;
    private static final Logger operationsLogger = TxnManagerImpl.operationsLogger;
    private static final Logger persistenceLogger = TxnManagerImpl.persistenceLogger;
    private final Object _xid;

    public PrepareAndCommitJob(Transaction tr, TaskManager pool, WakeupManager wm, ClientLog log, ParticipantHandle handle, boolean directCall, Object tid) {
        super(pool, wm, directCall);
        if (log == null) {
            throw new IllegalArgumentException("PrepareAndCommitJob: PrepareAndCommitJob: log is null");
        }
        this.log = log;
        if (!(tr instanceof ServerTransaction)) {
            throw new IllegalArgumentException("PrepareAndCommitJob: PrepareAndCommitJob: must be a ServerTransaction");
        }
        this.tr = (ServerTransaction)tr;
        if (handle == null) {
            throw new IllegalArgumentException("PrepareAndCommitJob: PrepareJob: must have participants");
        }
        this.handle = handle;
        if (this._directCall) {
            this.results = new Integer[1];
        }
        this._xid = tid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Object doWork(TaskManager.Task who, Object param) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(PrepareAndCommitJob.class.getName(), "doWork", new Object[]{who, param});
        }
        Integer res = null;
        try {
            Integer n;
            ParticipantHandle handle = (ParticipantHandle)param;
            TransactionParticipant par = null;
            int vote = handle.getPrepState();
            switch (vote) {
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    if (operationsLogger.isLoggable(Level.FINER)) {
                        operationsLogger.exiting(PrepareAndCommitJob.class.getName(), "doWork", new Integer(vote));
                    }
                    Integer n2 = res = Integer.valueOf(vote);
                    return n2;
                }
            }
            if (par == null) {
                par = handle.getParticipant();
            }
            try {
                if (!this._directCall && this.attempt(who) > this.maxtries) {
                    if (operationsLogger.isLoggable(Level.FINER)) {
                        operationsLogger.exiting(PrepareAndCommitJob.class.getName(), "doWork", new Integer(6));
                    }
                    Integer n3 = res = Integer.valueOf(6);
                    return n3;
                }
            }
            catch (JobException je) {
                if (operationsLogger.isLoggable(Level.FINER)) {
                    operationsLogger.exiting(PrepareAndCommitJob.class.getName(), "doWork", null);
                }
                Object var8_12 = null;
                return var8_12;
            }
            if (par == null) {
                if (operationsLogger.isLoggable(Level.FINER)) {
                    operationsLogger.exiting(PrepareAndCommitJob.class.getName(), "doWork", null);
                }
                Object je = null;
                return je;
            }
            Integer response = null;
            try {
                TxnMgrProxy txnManager;
                TxnMgrProxy cur = (TxnMgrProxy)this.tr.mgr;
                boolean optimize = cur.isEmbeddedMgr();
                Object object = txnManager = optimize ? cur.createLightProxy() : this.tr.mgr;
                if (handle.isSuitableForFailover()) {
                    vote = PrepareAndCommitJob.commitAndPreparePartitionWithEnabledFailover(handle, (TransactionManager)txnManager, this.tr.id, this._xid);
                } else if (this._xid == null) {
                    vote = par.prepareAndCommit((TransactionManager)txnManager, this.tr.id);
                } else {
                    IRemoteSpace rs = (IRemoteSpace)par;
                    vote = rs.prepareAndCommit((TransactionManager)txnManager, this._xid);
                }
                response = vote;
            }
            catch (UnknownTransactionException ute) {
                if (this.reCaught != null) {
                    this.notifyClient = true;
                }
                vote = 6;
                response = vote;
            }
            catch (RemoteException re) {
                this.reCaught = re;
                vote = 6;
                response = vote;
            }
            catch (RuntimeException rte) {
                vote = 6;
                response = vote;
            }
            if (response != null) {
                block36: {
                    handle.setPrepState(vote);
                    try {
                        this.log.write(new PrepareAndCommitRecord(handle, vote));
                    }
                    catch (LogException le) {
                        if (!persistenceLogger.isLoggable(Level.WARNING)) break block36;
                        persistenceLogger.log(Level.WARNING, "Problem writing PrepareAndCommitRecord.", le);
                    }
                }
                if (operationsLogger.isLoggable(Level.FINER)) {
                    operationsLogger.exiting(PrepareAndCommitJob.class.getName(), "doWork", response);
                }
                n = res = response;
                return n;
            }
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(PrepareAndCommitJob.class.getName(), "doWork", null);
            }
            n = null;
            return n;
        }
        finally {
            if (this._directCall && res != null) {
                this.results[0] = res;
                this.pending = 0;
            }
        }
    }

    public static int commitAndPreparePartitionWithEnabledFailover(ParticipantHandle handle, TransactionManager mgr, long id, Object xid) {
        try {
            OperationID operationID = handle.getClusterProxy().createNewOperationID();
            PrepareAndCommitTransactionSpaceOperationRequest request = xid == null ? new PrepareAndCommitTransactionSpaceOperationRequest(mgr, id, handle.getPartionId(), operationID) : new PrepareAndCommitTransactionSpaceOperationRequest(mgr, xid, handle.getPartionId(), operationID);
            handle.getClusterProxy().getProxyRouter().execute(request);
            ((PrepareAndCommitTransactionSpaceOperationResult)request.getRemoteOperationResult()).processExecutionException();
            return ((PrepareAndCommitTransactionSpaceOperationResult)request.getRemoteOperationResult()).getState();
        }
        catch (Exception ex) {
            CannotCommitException ex1 = new CannotCommitException("commit failed [ID=" + id + "]: reason=" + ex, (Throwable)ex);
            handle.setCommitException(ex1);
            return 6;
        }
    }

    @Override
    TaskManager.Task[] createTasks() {
        TaskManager.Task[] tmp = new TaskManager.Task[]{new ParticipantTask(this.getPool(), this.getMgr(), this, this.handle)};
        return tmp;
    }

    @Override
    Object computeResult() throws JobException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(PrepareAndCommitJob.class.getName(), "computeResult");
        }
        try {
            if (!this.isCompleted(0L)) {
                throw new ResultNotReadyException("Cannot compute result since there are jobs pending");
            }
        }
        catch (JobNotStartedException jnse) {
            throw new ResultNotReadyException("Cannot compute result since jobs were not created");
        }
        int prepstate = 4;
        prepstate = (Integer)this.results[0];
        Integer result = new Integer(prepstate);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(PrepareAndCommitJob.class.getName(), "computeResult", result);
        }
        return result;
    }

    Exception getAlternateException() {
        if (this.notifyClient) {
            return this.reCaught;
        }
        return null;
    }
}

