/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.time.SystemTime;
import com.sun.jini.config.Config;
import com.sun.jini.constants.TimeConstants;
import com.sun.jini.landlord.Landlord;
import com.sun.jini.landlord.LandlordLease;
import com.sun.jini.landlord.LandlordUtil;
import com.sun.jini.landlord.LeaseFactory;
import com.sun.jini.landlord.LeasePeriodPolicy;
import com.sun.jini.landlord.LeasedResource;
import com.sun.jini.landlord.LocalLandlord;
import com.sun.jini.landlord.SystemTimeFixedLeasePeriodPolicy;
import com.sun.jini.logging.Levels;
import com.sun.jini.lookup.entry.BasicServiceType;
import com.sun.jini.mahalo.JoinStateManager;
import com.sun.jini.mahalo.LeaseExpirationMgr;
import com.sun.jini.mahalo.ProxyVerifier;
import com.sun.jini.mahalo.SettlerTask;
import com.sun.jini.mahalo.TxnLogRecord;
import com.sun.jini.mahalo.TxnManager;
import com.sun.jini.mahalo.TxnManagerTransaction;
import com.sun.jini.mahalo.TxnMgrAdminProxy;
import com.sun.jini.mahalo.TxnMgrProxy;
import com.sun.jini.mahalo.TxnSettler;
import com.sun.jini.mahalo.log.LogException;
import com.sun.jini.mahalo.log.LogManager;
import com.sun.jini.mahalo.log.LogRecord;
import com.sun.jini.mahalo.log.LogRecovery;
import com.sun.jini.mahalo.log.MockLogManager;
import com.sun.jini.mahalo.log.MultiLogManager;
import com.sun.jini.mahalo.log.MultiLogManagerAdmin;
import com.sun.jini.start.LifeCycle;
import com.sun.jini.system.FileSystem;
import com.sun.jini.thread.InterruptedStatusThread;
import com.sun.jini.thread.ReadyState;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationSystem;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.jini.activation.ActivationExporter;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationProvider;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.lookup.ServiceID;
import net.jini.core.transaction.CannotAbortException;
import net.jini.core.transaction.CannotCommitException;
import net.jini.core.transaction.CannotJoinException;
import net.jini.core.transaction.TimeoutExpiredException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.CrashCountException;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.core.transaction.server.TransactionParticipant;
import net.jini.export.Exporter;
import net.jini.export.ProxyAccessor;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.lookup.entry.ServiceInfo;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;

@InternalApi
public class TxnManagerImpl
implements TxnManager,
LeaseExpirationMgr.Expirer,
LogRecovery,
TxnSettler,
TimeConstants,
LocalLandlord,
ServerProxyTrust,
ProxyAccessor {
    static final Logger startupLogger = Logger.getLogger("com.sun.jini.mahalo.startup");
    static final Logger initLogger = Logger.getLogger("com.sun.jini.mahalo.init");
    static final Logger destroyLogger = Logger.getLogger("com.sun.jini.mahalo.destroy");
    static final Logger operationsLogger = Logger.getLogger("com.sun.jini.mahalo.operations");
    static final Logger transactionsLogger = Logger.getLogger("com.sun.jini.mahalo.transactions");
    static final Logger participantLogger = Logger.getLogger("com.sun.jini.mahalo.participant");
    static final Logger persistenceLogger = Logger.getLogger("com.sun.jini.mahalo.persistence");
    private LogManager logmgr;
    private transient int settlerthreads = 150;
    private transient long settlertimeout = 15000L;
    private transient float settlerload = 1.0f;
    private transient int taskthreads = 50;
    private transient long tasktimeout = 15000L;
    private transient float taskload = 3.0f;
    private transient TaskManager settlerpool;
    private WakeupManager settlerWakeupMgr;
    private transient TaskManager taskpool;
    private WakeupManager taskWakeupMgr;
    private final transient Map<Object, TxnManagerTransaction> _txns = new ConcurrentHashMap<Object, TxnManagerTransaction>();
    private transient Vector unsettledtxns;
    private transient InterruptedStatusThread settleThread;
    private String persistenceDirectory = null;
    private ActivationID activationID;
    private boolean activationPrepared;
    private ActivationSystem activationSystem;
    private ProxyPreparer participantPreparer;
    protected Exporter exporter;
    protected LoginContext loginContext;
    private static transient SecureRandom idGen = new SecureRandom();
    private static final transient byte[] idGenBuf = new byte[8];
    private LeaseExpirationMgr expMgr;
    private LeasePeriodPolicy txnLeasePeriodPolicy = null;
    private LeaseFactory leaseFactory = null;
    private JoinStateManager joinStateManager;
    private Uuid topUuid = null;
    private Uuid _dummyLeaseUuid = null;
    private TxnMgrProxy txnMgrLocalProxy;
    private TxnMgrProxy txnMgrProxy;
    private TxnMgrAdminProxy txnMgrAdminProxy;
    private TxnManager serverStub = null;
    private LifeCycle lifeCycle = null;
    private final ReadyState readyState = new ReadyState();
    private boolean persistent = true;
    private boolean lookupRegister = true;
    private static final NullLandlord nullLandlord = new NullLandlord();
    private static final int IDSIZE = 100;
    private final IdGenT[] _idGens = new IdGenT[100];
    private final boolean finer_par_logger;
    private final boolean finest_par_logger;
    private final boolean finer_op_logger;
    private final boolean finest_op_logger;
    private final boolean finer_tr_logger;
    private final boolean finest_tr_logger;
    private TxnManagerTransaction _lastTxn;
    private final Hashtable<Long, Object> _tidToExternalXid = new Hashtable();
    private final ConcurrentMap<String, IDirectSpaceProxy> _proxiesMap = new ConcurrentHashMap<String, IDirectSpaceProxy>();
    private static final long MAX_UNEXPORT_DELAY = 120000L;

    TxnManagerImpl(String[] args, LifeCycle lc, boolean persistent) throws Exception {
        this(args, lc, persistent, true);
    }

    TxnManagerImpl(String[] args, LifeCycle lc, boolean persistent, boolean lookupRegister) throws Exception {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "TxnManagerImpl", new Object[]{Arrays.asList(args), lc, persistent});
        }
        this.lifeCycle = lc;
        this.persistent = persistent;
        this.lookupRegister = lookupRegister;
        for (int j = 0; j < 100; ++j) {
            this._idGens[j] = new IdGenT();
        }
        try {
            this.init(args);
        }
        catch (Throwable e) {
            this.cleanup();
            this.initFailed(e);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "TxnManagerImpl");
        }
        this.finer_par_logger = participantLogger.isLoggable(Level.FINER);
        this.finest_par_logger = participantLogger.isLoggable(Level.FINEST);
        this.finer_op_logger = operationsLogger.isLoggable(Level.FINER);
        this.finest_op_logger = operationsLogger.isLoggable(Level.FINEST);
        this.finer_tr_logger = transactionsLogger.isLoggable(Level.FINER);
        this.finest_tr_logger = transactionsLogger.isLoggable(Level.FINEST);
    }

    TxnManagerImpl(ActivationID activationID, MarshalledObject data) throws Exception {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "TxnManagerImpl", new Object[]{activationID, data});
        }
        this.activationID = activationID;
        try {
            this.init((String[])data.get());
        }
        catch (Throwable e) {
            this.cleanup();
            this.initFailed(e);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "TxnManagerImpl");
        }
        this.finer_par_logger = participantLogger.isLoggable(Level.FINER);
        this.finest_par_logger = participantLogger.isLoggable(Level.FINEST);
        this.finer_op_logger = operationsLogger.isLoggable(Level.FINER);
        this.finest_op_logger = operationsLogger.isLoggable(Level.FINEST);
        this.finer_tr_logger = transactionsLogger.isLoggable(Level.FINER);
        this.finest_tr_logger = transactionsLogger.isLoggable(Level.FINEST);
    }

    private void init(String[] configArgs) throws Exception {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "init", configArgs);
        }
        Configuration config = ConfigurationProvider.getInstance((String[])configArgs, (ClassLoader)this.getClass().getClassLoader());
        this.loginContext = (LoginContext)config.getEntry("com.sun.jini.mahalo", "loginContext", LoginContext.class, null);
        if (this.loginContext != null) {
            this.doInitWithLogin(config, this.loginContext);
        } else {
            this.doInit(config);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "init");
        }
    }

    private void doInitWithLogin(final Configuration config, LoginContext loginContext) throws Exception {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "doInitWithLogin", new Object[]{config, loginContext});
        }
        loginContext.login();
        try {
            Subject.doAsPrivileged(loginContext.getSubject(), new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    TxnManagerImpl.this.doInit(config);
                    return null;
                }
            }, null);
        }
        catch (PrivilegedActionException e) {
            block6: {
                try {
                    loginContext.logout();
                }
                catch (LoginException le) {
                    if (!initLogger.isLoggable(Levels.HANDLED)) break block6;
                    initLogger.log(Levels.HANDLED, "Trouble logging out", le);
                }
            }
            throw e.getException();
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "doInitWithLogin");
        }
    }

    private void doInit(Configuration config) throws Exception {
        long startTime = System.currentTimeMillis();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "doInit", config);
        }
        if (this.activationID != null) {
            ProxyPreparer activationSystemPreparer = (ProxyPreparer)Config.getNonNullEntry((Configuration)config, (String)"com.sun.jini.mahalo", (String)"activationSystemPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "activationSystemPreparer: {0}", activationSystemPreparer);
            }
            this.activationSystem = (ActivationSystem)activationSystemPreparer.prepareProxy((Object)ActivationGroup.getSystem());
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "Prepared activation system is: {0}", this.activationSystem);
            }
            ProxyPreparer activationIdPreparer = (ProxyPreparer)Config.getNonNullEntry((Configuration)config, (String)"com.sun.jini.mahalo", (String)"activationIdPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "activationIdPreparer: {0}", activationIdPreparer);
            }
            this.activationID = (ActivationID)activationIdPreparer.prepareProxy((Object)this.activationID);
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "Prepared activationID is: {0}", this.activationID);
            }
            this.activationPrepared = true;
            this.exporter = (Exporter)Config.getNonNullEntry((Configuration)config, (String)"com.sun.jini.mahalo", (String)"serverExporter", Exporter.class);
            this.exporter = new ActivationExporter(this.activationID, this.exporter);
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "Activatable service exporter is: {0}", this.exporter);
            }
        } else {
            this.exporter = (Exporter)Config.getNonNullEntry((Configuration)config, (String)"com.sun.jini.mahalo", (String)"serverExporter", Exporter.class);
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "Non-activatable service exporter is: {0}", this.exporter);
            }
        }
        ProxyPreparer recoveredParticipantPreparer = (ProxyPreparer)Config.getNonNullEntry((Configuration)config, (String)"com.sun.jini.mahalo", (String)"recoveredParticipantPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
        if (initLogger.isLoggable(Level.CONFIG)) {
            initLogger.log(Level.CONFIG, "Recovered participant preparer is: {0}", recoveredParticipantPreparer);
        }
        if (this.persistent) {
            this.participantPreparer = (ProxyPreparer)Config.getNonNullEntry((Configuration)config, (String)"com.sun.jini.mahalo", (String)"participantPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "Participant preparer is: {0}", this.participantPreparer);
            }
        }
        this.txnLeasePeriodPolicy = (LeasePeriodPolicy)Config.getNonNullEntry((Configuration)config, (String)"com.sun.jini.mahalo", (String)"leasePeriodPolicy", LeasePeriodPolicy.class, (Object)new SystemTimeFixedLeasePeriodPolicy(10800000L, 3600000L));
        if (initLogger.isLoggable(Level.CONFIG)) {
            initLogger.log(Level.CONFIG, "leasePeriodPolicy is: {0}", this.txnLeasePeriodPolicy);
        }
        if (this.persistent) {
            this.persistenceDirectory = (String)Config.getNonNullEntry((Configuration)config, (String)"com.sun.jini.mahalo", (String)"persistenceDirectory", String.class);
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "Persistence directory is: {0}", this.persistenceDirectory);
            }
        } else {
            this.persistenceDirectory = null;
        }
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Creating JoinStateManager");
        }
        this.joinStateManager = new JoinStateManager(this.persistenceDirectory);
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Recovering join state ...");
        }
        this.joinStateManager.recover();
        if (this.joinStateManager.getServiceUuid() == null) {
            if (initLogger.isLoggable(Level.FINEST)) {
                initLogger.log(Level.FINEST, "Generating service Uuid");
            }
            this.topUuid = UuidFactory.generate();
            this.joinStateManager.setServiceUuid(this.topUuid);
        } else {
            if (initLogger.isLoggable(Level.FINEST)) {
                initLogger.log(Level.FINEST, "Recovering service Uuid");
            }
            this.topUuid = this.joinStateManager.getServiceUuid();
        }
        this._dummyLeaseUuid = new Uuid(this.topUuid.getLeastSignificantBits(), -1L);
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Uuid is: {0}", this.topUuid);
        }
        if (this.persistent) {
            FileSystem.ensureDir(this.persistenceDirectory);
        }
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Exporting server");
        }
        this.serverStub = (TxnManager)this.exporter.export((Remote)((Object)this));
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Server stub: {0}", this.serverStub);
        }
        this.txnMgrLocalProxy = TxnMgrProxy.create((TxnManager)this.serverStub, (TxnManager)this, (Uuid)this.topUuid);
        this.txnMgrProxy = TxnMgrProxy.create((TxnManager)this.serverStub, (TxnManager)this, (Uuid)this.topUuid);
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Service proxy is: {0}", this.txnMgrProxy);
        }
        this.txnMgrAdminProxy = TxnMgrAdminProxy.create(this.serverStub, this.topUuid);
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Service admin proxy is: {0}", this.txnMgrAdminProxy);
        }
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Setting up data structures");
        }
        this.settlerWakeupMgr = new WakeupManager(new WakeupManager.ThreadDesc(null, true));
        this.taskWakeupMgr = new WakeupManager(new WakeupManager.ThreadDesc(null, true));
        this.settlerpool = (TaskManager)Config.getNonNullEntry((Configuration)config, (String)"com.sun.jini.mahalo", (String)"settlerPool", TaskManager.class, (Object)new TaskManager(this.settlerthreads, this.settlertimeout, this.settlerload, "Mahalo-settler", 2));
        this.taskpool = (TaskManager)Config.getNonNullEntry((Configuration)config, (String)"com.sun.jini.mahalo", (String)"taskPool", TaskManager.class, (Object)new TaskManager(this.taskthreads, this.tasktimeout, this.taskload, "Mahalo-taskPool", 2));
        this.unsettledtxns = new Vector();
        this.leaseFactory = new LeaseFactory((Landlord)this.serverStub, this.topUuid);
        this.expMgr = new LeaseExpirationMgr(this);
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Setting up log manager");
        }
        this.logmgr = this.persistent ? new MultiLogManager(this, this.persistenceDirectory) : new MockLogManager();
        try {
            if (initLogger.isLoggable(Level.FINEST)) {
                initLogger.log(Level.FINEST, "Recovering state");
            }
            this.logmgr.recover();
            for (TxnManagerTransaction txn : this._txns.values()) {
                if (initLogger.isLoggable(Level.FINEST)) {
                    initLogger.log(Level.FINEST, "Restoring transient state for txn id: {0}", new Long(txn.getTransaction().id));
                }
                try {
                    txn.restoreTransientState(recoveredParticipantPreparer);
                }
                catch (RemoteException re) {
                    if (!persistenceLogger.isLoggable(Level.WARNING)) continue;
                    persistenceLogger.log(Level.WARNING, "Cannot restore the TransactionParticipant", re);
                }
            }
            if (initLogger.isLoggable(Level.FINEST)) {
                initLogger.log(Level.FINEST, "Settling incomplete transactions");
            }
            this.settleThread = new InterruptedStatusThread("settleThread"){

                public void run() {
                    try {
                        TxnManagerImpl.this.settleTxns();
                    }
                    catch (InterruptedException ie) {
                        if (transactionsLogger.isLoggable(Level.FINEST)) {
                            transactionsLogger.log(Level.FINEST, "settleThread interrupted -- exiting");
                        }
                        return;
                    }
                }
            };
            this.settleThread.start();
        }
        catch (LogException le) {
            RemoteException re = new RemoteException("Problem recovering state");
            initLogger.throwing(TxnManagerImpl.class.getName(), "doInit", re);
            throw re;
        }
        this.nextID();
        if (this.lookupRegister) {
            if (initLogger.isLoggable(Level.FINEST)) {
                initLogger.log(Level.FINEST, "Starting JoinStateManager");
            }
            this.joinStateManager.startManager(config, this.txnMgrProxy, new ServiceID(this.topUuid.getMostSignificantBits(), this.topUuid.getLeastSignificantBits()), TxnManagerImpl.attributesFor());
        }
        if (startupLogger.isLoggable(Level.INFO)) {
            double duration = (double)(System.currentTimeMillis() - startTime) / 1000.0;
            startupLogger.log(Level.INFO, "Started Mahalo (duration={0}): {1}", new Object[]{duration, this});
        }
        this.readyState.ready();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "doInit");
        }
    }

    public TransactionManager.Created create(long lease) throws LeaseDeniedException {
        return this.create(null, lease);
    }

    public TransactionManager.Created create(Object externalXid, long lease) throws LeaseDeniedException {
        Uuid uuid;
        if (this.finer_op_logger) {
            if (externalXid == null) {
                operationsLogger.entering(TxnManagerImpl.class.getName(), "create", new Long(lease));
            } else {
                String create_xid = "create xid=" + externalXid.toString();
                operationsLogger.entering(TxnManagerImpl.class.getName(), create_xid, new Long(lease));
            }
        }
        if (!this.readyState.isReady()) {
            this.readyState.check();
        }
        TxnManagerTransaction txntr = null;
        long tid = this.nextID();
        Uuid uuid2 = uuid = lease != Long.MAX_VALUE ? this.createLeaseUuid(tid) : this._dummyLeaseUuid;
        if (this.finest_tr_logger) {
            transactionsLogger.log(Level.FINEST, "Transaction ID is: {0}", new Long(tid));
        }
        txntr = new TxnManagerTransaction((TransactionManager)this.txnMgrProxy, this.logmgr, tid, this.taskpool, this.taskWakeupMgr, this, uuid, lease, this.persistent, externalXid, this._proxiesMap);
        LandlordLease txnmgrlease = null;
        try {
            if (lease != Long.MAX_VALUE) {
                LeasePeriodPolicy.Result r = this.txnLeasePeriodPolicy.grant(txntr, lease);
                txntr.setExpirationUnsafe(r.expiration);
                txnmgrlease = this.leaseFactory.newTransactionLease(uuid, r.expiration);
                this.expMgr.register(txntr);
            } else {
                txnmgrlease = this.leaseFactory.newTransactionLease(uuid, Long.MAX_VALUE);
                txntr.setExpirationUnsafe(Long.MAX_VALUE);
            }
        }
        catch (LeaseDeniedException lde) {
            throw new AssertionError((Object)("Transaction lease was denied" + (Object)((Object)lde)));
        }
        if (this.finest_tr_logger) {
            transactionsLogger.log(Level.FINEST, "Created new TxnManagerTransaction ID is: {0}", new Long(tid));
        }
        if (externalXid != null) {
            this._tidToExternalXid.put(tid, externalXid);
            this._txns.put(externalXid, txntr);
        } else {
            this._txns.put(tid, txntr);
        }
        if (this.finest_tr_logger) {
            transactionsLogger.log(Level.FINEST, "recorded new TxnManagerTransaction", txntr);
        }
        TransactionManager.Created tmp = new TransactionManager.Created(tid, (Lease)txnmgrlease);
        if (this.finer_op_logger) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "create", tmp);
        }
        txnmgrlease.setLandlord((Landlord)nullLandlord);
        return tmp;
    }

    public void join(long id, TransactionParticipant part, long crashCount) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        this.join_impl(id, part, crashCount, id, false, null, -1, null, null);
    }

    public void join(Object xid, TransactionParticipant part, long crashCount) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        this.join_impl(xid, part, crashCount, -1L, true, null, -1, null, null);
    }

    public void join(long id, TransactionParticipant part, long crashCount, int partitionId, String clusterName) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        this.join_impl(id, part, crashCount, id, false, null, partitionId, clusterName, null);
    }

    public void join(Object xid, TransactionParticipant part, long crashCount, int partitionId, String clusterName) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        this.join_impl(xid, part, crashCount, -1L, true, null, partitionId, clusterName, null);
    }

    public void join(long id, TransactionParticipant part, long crashCount, ServerTransaction userXtnObject) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        this.join_impl(id, part, crashCount, id, false, userXtnObject, -1, null, null);
    }

    public void join(Object xid, TransactionParticipant part, long crashCount, ServerTransaction userXtnObject) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        this.join_impl(xid, part, crashCount, -1L, true, userXtnObject, -1, null, null);
    }

    public void join(long id, TransactionParticipant part, long crashCount, ServerTransaction userXtnObject, int partitionId, String clusterName, Object clusterProxy) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        this.join_impl(id, part, crashCount, id, false, userXtnObject, partitionId, clusterName, (IDirectSpaceProxy)clusterProxy);
    }

    public void join(Object xid, TransactionParticipant part, long crashCount, ServerTransaction userXtnObject, int partitionId, String clusterName, Object clusterProxy) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        this.join_impl(xid, part, crashCount, -1L, true, userXtnObject, partitionId, clusterName, (IDirectSpaceProxy)clusterProxy);
    }

    private void join_impl(Object id, TransactionParticipant part, long crashCount, long tid, boolean fromXid, ServerTransaction userXtnObject, int partitionId, String clusterName, IDirectSpaceProxy clusterProxy) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        TxnManagerTransaction txntr;
        TxnManagerTransaction lastTxn;
        TransactionParticipant preparedTarget = part;
        if (crashCount == Long.MAX_VALUE && (lastTxn = this._lastTxn) != null && lastTxn.getTransaction().id == tid && !fromXid) {
            lastTxn.join(preparedTarget, crashCount, userXtnObject, partitionId, clusterName, clusterProxy);
            return;
        }
        if (this.finer_op_logger) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "join", new Object[]{id, part, new Long(crashCount)});
        }
        if (crashCount != Long.MAX_VALUE) {
            this.readyState.check();
        }
        if (crashCount != Long.MAX_VALUE && this.participantPreparer != null) {
            preparedTarget = (TransactionParticipant)this.participantPreparer.prepareProxy((Object)part);
        }
        if (this.finest_par_logger) {
            participantLogger.log(Level.FINEST, "prepared participant: {0}", preparedTarget);
        }
        if ((txntr = this._txns.get(id)) == null) {
            throw new UnknownTransactionException("unknown transaction");
        }
        txntr.join(preparedTarget, crashCount, userXtnObject, partitionId, clusterName, clusterProxy);
        if (crashCount == Long.MAX_VALUE && !fromXid) {
            this._lastTxn = txntr;
        }
        if (this.finer_op_logger) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "join");
        }
    }

    public boolean disJoin(long id, TransactionParticipant part) throws UnknownTransactionException, RemoteException {
        return this.disJoin_impl(id, part);
    }

    public boolean disJoin(Object id, TransactionParticipant part) throws UnknownTransactionException, RemoteException {
        return this.disJoin_impl(id, part);
    }

    private boolean disJoin_impl(Object id, TransactionParticipant part) throws UnknownTransactionException, RemoteException {
        TxnManagerTransaction txntr;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "disJoin", new Object[]{id, part});
        }
        TransactionParticipant preparedTarget = part;
        if (participantLogger.isLoggable(Level.FINEST)) {
            participantLogger.log(Level.FINEST, "prepared participant: {0}", preparedTarget);
        }
        if ((txntr = this._txns.get(id)) == null) {
            throw new UnknownTransactionException("unknown transaction");
        }
        boolean res = txntr.disJoin(preparedTarget);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "disJoin");
        }
        return res;
    }

    public int prepare(Object xid) throws CannotCommitException, UnknownTransactionException, RemoteException {
        TxnManagerTransaction txntr;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "prepare-xid", xid);
        }
        if ((txntr = this._txns.get(xid)) == null) {
            throw new UnknownTransactionException("unknown transaction");
        }
        return txntr.prepare(Long.MAX_VALUE);
    }

    public int getState(long id) throws UnknownTransactionException {
        return this.getState((Object)id);
    }

    public int getState(Object id) throws UnknownTransactionException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "getState", new Object[]{id});
        }
        this.readyState.check();
        TxnManagerTransaction txntr = this._txns.get(id);
        if (txntr == null) {
            throw new UnknownTransactionException("unknown transaction");
        }
        int state = txntr.getState();
        if (state == 1 && !TxnManagerImpl.ensureCurrent(txntr)) {
            throw new UnknownTransactionException("unknown transaction");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "getState", new Integer(state));
        }
        return state;
    }

    public void commit(long id) throws UnknownTransactionException, CannotCommitException, RemoteException {
        try {
            this.commit_impl(id, 0L);
        }
        catch (TimeoutExpiredException timeoutExpiredException) {
            // empty catch block
        }
    }

    public void commit(long id, long waitFor) throws UnknownTransactionException, CannotCommitException, TimeoutExpiredException, RemoteException {
        this.commit_impl(id, waitFor);
    }

    private void commit_impl(Object id, long waitFor) throws UnknownTransactionException, CannotCommitException, TimeoutExpiredException, RemoteException {
        if (this.finer_op_logger) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "commit", new Object[]{id, new Long(waitFor)});
        }
        if (!this.readyState.isReady()) {
            this.readyState.check();
        }
        TxnManagerTransaction txntr = this._txns.get(id);
        if (this.finest_tr_logger) {
            transactionsLogger.log(Level.FINEST, "Retrieved TxnManagerTransaction: {0}", txntr);
        }
        if (txntr == null) {
            throw new UnknownTransactionException("Unknown transaction");
        }
        txntr.commit(waitFor);
        this._txns.remove(id);
        if (txntr.isExternalXid()) {
            this._tidToExternalXid.remove(txntr.getTransaction().id);
        }
        if (this.finest_tr_logger) {
            transactionsLogger.log(Level.FINEST, "Committed transaction id {0}", id);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "commit");
        }
    }

    public void commit(Object xid) throws UnknownTransactionException, CannotCommitException, RemoteException {
        if (this.finer_op_logger) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "commit-xid", new Object[]{xid.toString(), new Long(0L)});
        }
        try {
            this.commit_impl(xid, 0L);
        }
        catch (TimeoutExpiredException timeoutExpiredException) {
            // empty catch block
        }
    }

    public void commit(Object xid, long waitFor) throws UnknownTransactionException, CannotCommitException, TimeoutExpiredException, RemoteException {
        if (this.finer_op_logger) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "commit-xid", new Object[]{xid.toString(), new Long(waitFor)});
        }
        this.commit_impl(xid, waitFor);
    }

    public void abort(long id) throws UnknownTransactionException, CannotAbortException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "abort", new Object[]{new Long(id)});
        }
        this.readyState.check();
        try {
            this.abort_impl(id, 0L);
        }
        catch (TimeoutExpiredException timeoutExpiredException) {
            // empty catch block
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "abort");
        }
    }

    public void abort(long id, long waitFor) throws UnknownTransactionException, CannotAbortException, TimeoutExpiredException {
        this.abort_impl(id, waitFor);
    }

    public void abort_impl(Object id, long waitFor) throws UnknownTransactionException, CannotAbortException, TimeoutExpiredException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "abort", new Object[]{id, new Long(waitFor)});
        }
        this.readyState.check();
        TxnManagerTransaction txntr = this._txns.get(id);
        if (transactionsLogger.isLoggable(Level.FINEST)) {
            transactionsLogger.log(Level.FINEST, "Retrieved TxnManagerTransaction: {0}", txntr);
        }
        if (txntr == null) {
            throw new CannotAbortException();
        }
        txntr.abort(waitFor);
        this._txns.remove(id);
        if (txntr.isExternalXid()) {
            this._tidToExternalXid.remove(txntr.getTransaction().id);
        }
        if (transactionsLogger.isLoggable(Level.FINEST)) {
            transactionsLogger.log(Level.FINEST, "aborted transaction id {0}", id);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "abort");
        }
    }

    public void abort(Object xid) throws UnknownTransactionException, CannotAbortException, RemoteException {
        if (this.finer_op_logger) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "abort-xid", new Object[]{xid.toString(), new Long(0L)});
        }
        try {
            this.abort_impl(xid, 0L);
        }
        catch (TimeoutExpiredException timeoutExpiredException) {
            // empty catch block
        }
    }

    public void abort(Object xid, long waitFor) throws UnknownTransactionException, CannotAbortException, TimeoutExpiredException, RemoteException {
        if (this.finer_op_logger) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "abort-xid", new Object[]{xid.toString(), new Long(waitFor)});
        }
        this.abort_impl(xid, waitFor);
    }

    @Override
    public void recover(long cookie, LogRecord rec) throws LogException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "recover", new Object[]{new Long(cookie), rec});
        }
        TxnManagerTransaction tmt = this.enterTMT(cookie);
        TxnLogRecord trec = (TxnLogRecord)rec;
        trec.recover(tmt);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "recover");
        }
    }

    @Override
    public synchronized void noteUnsettledTxn(Object tid) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "noteUnsettledTxn", new Object[]{tid});
        }
        this.unsettledtxns.add(tid);
        this.notifyAll();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "noteUnsettledTxn");
        }
    }

    private synchronized void settleTxns() throws InterruptedException {
        Object log = null;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "settleTxns");
        }
        if (transactionsLogger.isLoggable(Level.FINEST)) {
            transactionsLogger.log(Level.FINEST, "Settling {0} transactions.", new Integer(this.unsettledtxns.size()));
        }
        int numtxns = 0;
        Object first = null;
        Object tid = null;
        while (true) {
            if ((numtxns = this.unsettledtxns.size()) == 0) {
                if (transactionsLogger.isLoggable(Level.FINEST)) {
                    transactionsLogger.log(Level.FINEST, "Settler waiting");
                }
                this.wait();
                if (!transactionsLogger.isLoggable(Level.FINEST)) continue;
                transactionsLogger.log(Level.FINEST, "Settler notified");
                continue;
            }
            first = null;
            tid = first = this.unsettledtxns.firstElement();
            SettlerTask task = new SettlerTask(this.settlerpool, this.settlerWakeupMgr, (TransactionManager)this, tid);
            this.settlerpool.add(task);
            this.unsettledtxns.remove(first);
            if (this.settleThread.hasBeenInterrupted()) {
                throw new InterruptedException("settleTxns interrupted");
            }
            if (!transactionsLogger.isLoggable(Level.FINEST)) continue;
            transactionsLogger.log(Level.FINEST, "Added SettlerTask for tid {0}", (Object)tid);
        }
    }

    public Transaction getTransaction(long id) throws UnknownTransactionException {
        this.readyState.check();
        if (id == -1L) {
            return null;
        }
        TxnManagerTransaction txntr = this._txns.get(id);
        if (txntr == null) {
            throw new UnknownTransactionException("unknown transaction");
        }
        ServerTransaction tn = txntr.getTransaction();
        ServerTransaction tr = this.serverTransaction((Transaction)tn);
        if (tr == null) {
            throw new UnknownTransactionException("TxnManagerImpl: getTransaction: unable to find transaction(" + id + ")");
        }
        if (!tr.mgr.equals(this)) {
            throw new UnknownTransactionException("wrong manager (" + tr.mgr + " instead of " + this + ")");
        }
        return tr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long renew(Uuid uuid, long extension) throws UnknownLeaseException, LeaseDeniedException {
        Object xid;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "renew", new Object[]{uuid, new Long(extension)});
        }
        this.readyState.check();
        this.verifyLeaseUuid(uuid);
        Long tid = this.getLeaseTid(uuid);
        TxnManagerTransaction txntr = this._txns.get(tid);
        if (txntr == null && (xid = this._tidToExternalXid.get(tid)) != null) {
            txntr = this._txns.get(xid);
        }
        if (txntr == null) {
            throw new UnknownLeaseException();
        }
        TxnManagerTransaction txnManagerTransaction = txntr;
        synchronized (txnManagerTransaction) {
            if (!TxnManagerImpl.ensureCurrent(txntr)) {
                throw new UnknownLeaseException("Lease already expired");
            }
            long oldExpiration = txntr.getExpiration();
            LeasePeriodPolicy.Result r = this.txnLeasePeriodPolicy.renew(txntr, extension);
            txntr.setExpiration(r.expiration);
            this.expMgr.renewed(txntr);
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(TxnManagerImpl.class.getName(), "renew", new Object[]{new Long(r.duration)});
            }
            txntr.renew(extension);
            return r.duration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(Uuid uuid) throws UnknownLeaseException {
        Object xid;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "cancel", new Object[]{uuid});
        }
        this.readyState.check();
        this.verifyLeaseUuid(uuid);
        Long tid = this.getLeaseTid(uuid);
        TxnManagerTransaction txntr = this._txns.get(tid);
        if (txntr == null && (xid = this._tidToExternalXid.get(tid)) != null) {
            txntr = this._txns.get(xid);
        }
        if (txntr == null) {
            throw new UnknownLeaseException();
        }
        int state = txntr.getState();
        if (state == 1) {
            TxnManagerTransaction txnManagerTransaction = txntr;
            synchronized (txnManagerTransaction) {
                txntr.setExpiration(0L);
            }
            try {
                this.abort(tid, Long.MAX_VALUE);
            }
            catch (TransactionException e) {
                throw new UnknownLeaseException("When canceling abort threw:" + ((Object)((Object)e)).getClass().getName() + ":" + e.getLocalizedMessage());
            }
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "cancel");
        }
    }

    public Landlord.RenewResults renewAll(Uuid[] cookies, long[] extensions) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "renewAll");
        }
        this.readyState.check();
        Landlord.RenewResults results = LandlordUtil.renewAll(this, cookies, extensions);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "renewAll");
        }
        return results;
    }

    public Map cancelAll(Uuid[] cookies) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "cancelAll");
        }
        this.readyState.check();
        Map results = LandlordUtil.cancelAll(this, cookies);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "cancelAll");
        }
        return results;
    }

    private long nextID() {
        return this._idGens[(int)Thread.currentThread().getId() % 100].getNum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long nextID__() {
        long id;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "nextID");
        }
        SecureRandom secureRandom = idGen;
        synchronized (secureRandom) {
            do {
                id = 0L;
                idGen.nextBytes(idGenBuf);
                for (int i = 0; i < 8; ++i) {
                    id = id << 8 | (long)(idGenBuf[i] & 0xFF);
                }
            } while (id == 0L);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "nextID", new Long(id));
        }
        return id;
    }

    private ServerTransaction serverTransaction(Transaction baseTr) throws UnknownTransactionException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "serverTransaction", baseTr);
        }
        try {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(TxnManagerImpl.class.getName(), "serverTransaction", baseTr);
            }
            return (ServerTransaction)baseTr;
        }
        catch (ClassCastException e) {
            throw new UnknownTransactionException("unexpected transaction type");
        }
    }

    public TransactionManager manager() {
        this.readyState.check();
        return this.txnMgrProxy;
    }

    private TxnManagerTransaction enterTMT(long cookie) {
        TxnManagerTransaction tmt;
        Long key = new Long(cookie);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "enterTMT", key);
        }
        if ((tmt = this._txns.get(key)) == null) {
            Uuid uuid = this.createLeaseUuid(cookie);
            tmt = new TxnManagerTransaction((TransactionManager)this.txnMgrProxy, this.logmgr, cookie, this.taskpool, this.taskWakeupMgr, this, uuid, -1L, this.persistent);
            this.noteUnsettledTxn(cookie);
        }
        this._txns.put(key, tmt);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "enterTMT", tmt);
        }
        return tmt;
    }

    public void reenterPreparedExternalXid(Object xid, List<TransactionParticipant> parts) throws CannotCommitException {
        TxnManagerTransaction txntr = this._txns.get(xid);
        if (txntr == null) {
            try {
                this.create(xid, Long.MAX_VALUE);
            }
            catch (LeaseDeniedException leaseDeniedException) {
                // empty catch block
            }
        }
        txntr = this._txns.get(xid);
        txntr.setReenteredPreparedXid();
        for (TransactionParticipant part : parts) {
            try {
                this.join_impl(xid, part, Long.MAX_VALUE, -1L, true, null, -1, null, null);
            }
            catch (Exception ex) {
                throw new CannotCommitException(" reason=" + ex.toString(), (Throwable)ex);
            }
        }
    }

    public synchronized void destroy() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "destroy");
        }
        this.readyState.check();
        new DestroyThread().start();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "destroy");
        }
    }

    public Object getAdmin() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "getAdmin");
        }
        this.readyState.check();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "getAdmin", this.txnMgrAdminProxy);
        }
        return this.txnMgrAdminProxy;
    }

    public Entry[] getLookupAttributes() {
        this.readyState.check();
        return this.joinStateManager.getLookupAttributes();
    }

    public void addLookupAttributes(Entry[] attrSets) {
        this.readyState.check();
        this.joinStateManager.addLookupAttributes(attrSets);
    }

    public void modifyLookupAttributes(Entry[] attrSetTemplates, Entry[] attrSets) {
        this.readyState.check();
        this.joinStateManager.modifyLookupAttributes(attrSetTemplates, attrSets);
    }

    public String[] getLookupGroups() {
        this.readyState.check();
        return this.joinStateManager.getLookupGroups();
    }

    public void addLookupGroups(String[] groups) {
        this.readyState.check();
        this.joinStateManager.addLookupGroups(groups);
    }

    public void removeLookupGroups(String[] groups) {
        this.readyState.check();
        this.joinStateManager.removeLookupGroups(groups);
    }

    public void setLookupGroups(String[] groups) {
        this.readyState.check();
        this.joinStateManager.setLookupGroups(groups);
    }

    public LookupLocator[] getLookupLocators() {
        this.readyState.check();
        return this.joinStateManager.getLookupLocators();
    }

    public void addLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.readyState.check();
        this.joinStateManager.addLookupLocators(locators);
    }

    public void removeLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.readyState.check();
        this.joinStateManager.removeLookupLocators(locators);
    }

    public void setLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.readyState.check();
        this.joinStateManager.setLookupLocators(locators);
    }

    private static Entry[] attributesFor() {
        ServiceInfo info = new ServiceInfo("Transaction Manager", "Sun Microsystems, Inc.", "Sun Microsystems, Inc.", "2.1", "", "");
        BasicServiceType type = new BasicServiceType("Transaction Manager");
        return new Entry[]{info, type};
    }

    public Object getProxy() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "getProxy");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "getProxy", this.serverStub);
        }
        return this.serverStub;
    }

    public TransactionManager getLocalProxy() {
        return this.txnMgrLocalProxy;
    }

    public Object getServiceProxy() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "getServiceProxy");
        }
        this.readyState.check();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "getServiceProxy", this.txnMgrProxy);
        }
        return this.txnMgrProxy;
    }

    protected void initFailed(Throwable e) throws Exception {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "initFailed");
        }
        if (initLogger.isLoggable(Level.SEVERE)) {
            initLogger.log(Level.SEVERE, "Mahalo failed to initialize", e);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "initFailed");
        }
        if (e instanceof Exception) {
            throw (Exception)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        IllegalStateException ise = new IllegalStateException(e.getMessage());
        ise.initCause(e);
        throw ise;
    }

    private void cleanup() {
        block32: {
            block31: {
                block30: {
                    block29: {
                        block28: {
                            if (operationsLogger.isLoggable(Level.FINER)) {
                                operationsLogger.entering(TxnManagerImpl.class.getName(), "cleanup");
                            }
                            if (this.serverStub != null) {
                                try {
                                    if (initLogger.isLoggable(Level.FINEST)) {
                                        initLogger.log(Level.FINEST, "Unexporting service");
                                    }
                                    this.exporter.unexport(true);
                                }
                                catch (Throwable t) {
                                    if (!initLogger.isLoggable(Levels.HANDLED)) break block28;
                                    initLogger.log(Levels.HANDLED, "Trouble unexporting service", t);
                                }
                            }
                        }
                        if (this.settlerpool != null) {
                            if (initLogger.isLoggable(Level.FINEST)) {
                                initLogger.log(Level.FINEST, "Terminating settlerpool.");
                            }
                            try {
                                this.settlerpool.terminate();
                                if (this.settlerWakeupMgr != null) {
                                    if (initLogger.isLoggable(Level.FINEST)) {
                                        initLogger.log(Level.FINEST, "Terminating settlerWakeupMgr.");
                                    }
                                    this.settlerWakeupMgr.stop();
                                    this.settlerWakeupMgr.cancelAll();
                                }
                            }
                            catch (Throwable t) {
                                if (!initLogger.isLoggable(Levels.HANDLED)) break block29;
                                initLogger.log(Levels.HANDLED, "Trouble terminating settlerpool", t);
                            }
                        }
                    }
                    if (this.taskpool != null) {
                        if (initLogger.isLoggable(Level.FINEST)) {
                            initLogger.log(Level.FINEST, "Terminating taskpool.");
                        }
                        try {
                            this.taskpool.terminate();
                            if (this.taskWakeupMgr != null) {
                                if (initLogger.isLoggable(Level.FINEST)) {
                                    initLogger.log(Level.FINEST, "Terminating taskWakeupMgr.");
                                }
                                this.taskWakeupMgr.stop();
                                this.taskWakeupMgr.cancelAll();
                            }
                        }
                        catch (Throwable t) {
                            if (!initLogger.isLoggable(Levels.HANDLED)) break block30;
                            initLogger.log(Levels.HANDLED, "Trouble terminating taskpool", t);
                        }
                    }
                }
                if (this.settleThread != null) {
                    if (initLogger.isLoggable(Level.FINEST)) {
                        initLogger.log(Level.FINEST, "Interrupting settleThread.");
                    }
                    try {
                        this.settleThread.interrupt();
                    }
                    catch (Throwable t) {
                        if (!initLogger.isLoggable(Levels.HANDLED)) break block31;
                        initLogger.log(Levels.HANDLED, "Trouble terminating settleThread", t);
                    }
                }
            }
            if (this.expMgr != null) {
                if (initLogger.isLoggable(Level.FINEST)) {
                    initLogger.log(Level.FINEST, "Terminating lease expiration manager.");
                }
                this.expMgr.terminate();
            }
            if (initLogger.isLoggable(Level.FINEST)) {
                initLogger.log(Level.FINEST, "Destroying JoinStateManager.");
            }
            try {
                if (this.joinStateManager != null) {
                    this.joinStateManager.stop();
                }
            }
            catch (Exception t) {
                if (!initLogger.isLoggable(Levels.HANDLED)) break block32;
                initLogger.log(Levels.HANDLED, "Problem destroying JoinStateManager", t);
            }
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "cleanup");
        }
    }

    public TrustVerifier getProxyVerifier() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "getProxyVerifier");
        }
        this.readyState.check();
        if (!(this.txnMgrProxy instanceof RemoteMethodControl)) {
            throw new UnsupportedOperationException();
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "getProxyVerifier");
        }
        return new ProxyVerifier(this.serverStub, this.topUuid);
    }

    private static boolean ensureCurrent(LeasedResource resource) {
        return resource.getExpiration() > SystemTime.timeMillis();
    }

    private Uuid createLeaseUuid(long txnId) {
        return new Uuid(this.topUuid.getLeastSignificantBits(), txnId);
    }

    private void verifyLeaseUuid(Uuid uuid) throws UnknownLeaseException {
        if (uuid.getMostSignificantBits() != this.topUuid.getLeastSignificantBits()) {
            throw new UnknownLeaseException();
        }
    }

    private Long getLeaseTid(Uuid uuid) {
        return new Long(uuid.getLeastSignificantBits());
    }

    public boolean needParticipantsJoin() throws RemoteException {
        return true;
    }

    public Uuid getTransactionManagerId() throws RemoteException {
        return this.topUuid;
    }

    private static class NullLandlord
    implements Landlord,
    Serializable {
        private static final long serialVersionUID = 1L;

        private NullLandlord() {
        }

        public void cancel(Uuid cookie) throws UnknownLeaseException, RemoteException {
            throw new UnsupportedOperationException();
        }

        public Map cancelAll(Uuid[] cookies) throws RemoteException {
            throw new UnsupportedOperationException();
        }

        public long renew(Uuid cookie, long duration) throws LeaseDeniedException, UnknownLeaseException, RemoteException {
            throw new UnsupportedOperationException();
        }

        public Landlord.RenewResults renewAll(Uuid[] cookies, long[] durations) throws RemoteException {
            throw new UnsupportedOperationException();
        }
    }

    private class DestroyThread
    extends Thread {
        public DestroyThread() {
            super("DestroyThread");
            this.setDaemon(false);
        }

        @Override
        public void run() {
            block49: {
                block48: {
                    block47: {
                        block46: {
                            block45: {
                                long endTime;
                                block44: {
                                    if (operationsLogger.isLoggable(Level.FINER)) {
                                        operationsLogger.entering(DestroyThread.class.getName(), "run");
                                    }
                                    Object failed = null;
                                    if (TxnManagerImpl.this.activationPrepared) {
                                        try {
                                            if (destroyLogger.isLoggable(Level.FINEST)) {
                                                destroyLogger.log(Level.FINEST, "Unregistering object.");
                                            }
                                            if (TxnManagerImpl.this.activationID != null) {
                                                TxnManagerImpl.this.activationSystem.unregisterObject(TxnManagerImpl.this.activationID);
                                            }
                                        }
                                        catch (RemoteException e) {
                                            if (destroyLogger.isLoggable(Level.WARNING)) {
                                                destroyLogger.log(Level.WARNING, "Trouble unregistering object -- aborting.", e);
                                            }
                                            return;
                                        }
                                        catch (ActivationException e) {
                                            if (!destroyLogger.isLoggable(Levels.HANDLED)) break block44;
                                            destroyLogger.log(Levels.HANDLED, "Trouble unregistering object -- ignoring.", e);
                                        }
                                    }
                                }
                                if (destroyLogger.isLoggable(Level.FINEST)) {
                                    destroyLogger.log(Level.FINEST, "Attempting unforced unexport.");
                                }
                                if ((endTime = SystemTime.timeMillis() + 120000L) < 0L) {
                                    endTime = Long.MAX_VALUE;
                                }
                                boolean unexported = false;
                                while (!unexported && SystemTime.timeMillis() < endTime) {
                                    unexported = TxnManagerImpl.this.exporter.unexport(false);
                                    if (!unexported) {
                                        if (destroyLogger.isLoggable(Level.FINEST)) {
                                            destroyLogger.log(Level.FINEST, "Waiting for in-progress calls to complete");
                                        }
                                        try {
                                            DestroyThread.sleep(1000L);
                                            continue;
                                        }
                                        catch (InterruptedException ie) {
                                            if (!destroyLogger.isLoggable(Levels.HANDLED)) break;
                                            destroyLogger.log(Levels.HANDLED, "problem unexporting nicely", ie);
                                            break;
                                        }
                                    }
                                    if (!destroyLogger.isLoggable(Level.FINEST)) continue;
                                    destroyLogger.log(Level.FINEST, "Unexport completed");
                                }
                                if (!unexported) {
                                    if (destroyLogger.isLoggable(Level.FINEST)) {
                                        destroyLogger.log(Level.FINEST, "Attempting forced unexport.");
                                    }
                                    unexported = TxnManagerImpl.this.exporter.unexport(true);
                                }
                                if (destroyLogger.isLoggable(Level.FINEST)) {
                                    destroyLogger.log(Level.FINEST, "Destroying JoinStateManager.");
                                }
                                try {
                                    TxnManagerImpl.this.joinStateManager.destroy();
                                }
                                catch (Exception t) {
                                    if (!destroyLogger.isLoggable(Levels.HANDLED)) break block45;
                                    destroyLogger.log(Levels.HANDLED, "Problem destroying JoinStateManager", t);
                                }
                            }
                            if (destroyLogger.isLoggable(Level.FINEST)) {
                                destroyLogger.log(Level.FINEST, "Terminating lease expiration manager.");
                            }
                            TxnManagerImpl.this.expMgr.terminate();
                            if (destroyLogger.isLoggable(Level.FINEST)) {
                                destroyLogger.log(Level.FINEST, "Interrupting settleThread.");
                            }
                            TxnManagerImpl.this.settleThread.interrupt();
                            try {
                                TxnManagerImpl.this.settleThread.join();
                            }
                            catch (InterruptedException ie) {
                                if (!destroyLogger.isLoggable(Levels.HANDLED)) break block46;
                                destroyLogger.log(Levels.HANDLED, "Problem stopping settleThread", ie);
                            }
                        }
                        if (destroyLogger.isLoggable(Level.FINEST)) {
                            destroyLogger.log(Level.FINEST, "Terminating settlerpool.");
                        }
                        TxnManagerImpl.this.settlerpool.terminate();
                        TxnManagerImpl.this.settlerWakeupMgr.stop();
                        TxnManagerImpl.this.settlerWakeupMgr.cancelAll();
                        if (destroyLogger.isLoggable(Level.FINEST)) {
                            destroyLogger.log(Level.FINEST, "Terminating taskpool.");
                        }
                        TxnManagerImpl.this.taskpool.terminate();
                        TxnManagerImpl.this.taskWakeupMgr.stop();
                        TxnManagerImpl.this.taskWakeupMgr.cancelAll();
                        if (destroyLogger.isLoggable(Level.FINEST)) {
                            destroyLogger.log(Level.FINEST, "Destroying transaction logs.");
                        }
                        MultiLogManagerAdmin logadmin = (MultiLogManagerAdmin)TxnManagerImpl.this.logmgr.getAdmin();
                        logadmin.destroy();
                        if (TxnManagerImpl.this.persistent) {
                            if (destroyLogger.isLoggable(Level.FINEST)) {
                                destroyLogger.log(Level.FINEST, "Destroying persistence directory.");
                            }
                            try {
                                FileSystem.destroy(new File(TxnManagerImpl.this.persistenceDirectory), true);
                            }
                            catch (IOException e) {
                                if (!destroyLogger.isLoggable(Levels.HANDLED)) break block47;
                                destroyLogger.log(Levels.HANDLED, "Problem destroying persistence directory", e);
                            }
                        }
                    }
                    if (TxnManagerImpl.this.activationID != null) {
                        if (destroyLogger.isLoggable(Level.FINEST)) {
                            destroyLogger.log(Level.FINEST, "Calling Activatable.inactive.");
                        }
                        try {
                            Activatable.inactive((ActivationID)TxnManagerImpl.this.activationID);
                        }
                        catch (RemoteException e) {
                            if (destroyLogger.isLoggable(Levels.HANDLED)) {
                                destroyLogger.log(Levels.HANDLED, "Problem inactivating service", e);
                            }
                        }
                        catch (ActivationException e) {
                            if (!destroyLogger.isLoggable(Levels.HANDLED)) break block48;
                            destroyLogger.log(Levels.HANDLED, "Problem inactivating service", e);
                        }
                    }
                }
                if (TxnManagerImpl.this.lifeCycle != null) {
                    if (destroyLogger.isLoggable(Level.FINEST)) {
                        destroyLogger.log(Level.FINEST, "Unregistering with LifeCycle.");
                    }
                    TxnManagerImpl.this.lifeCycle.unregister((Object)TxnManagerImpl.this);
                }
                if (TxnManagerImpl.this.loginContext != null) {
                    try {
                        if (destroyLogger.isLoggable(Level.FINEST)) {
                            destroyLogger.log(Level.FINEST, "Logging out");
                        }
                        TxnManagerImpl.this.loginContext.logout();
                    }
                    catch (Exception e) {
                        if (!destroyLogger.isLoggable(Levels.HANDLED)) break block49;
                        destroyLogger.log(Levels.HANDLED, "Exception while logging out", e);
                    }
                }
            }
            TxnManagerImpl.this.readyState.shutdown();
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(DestroyThread.class.getName(), "run");
            }
        }
    }

    public static class IdGenT {
        private static long _seed = 1L;
        private static final Object _lockObj = new Object();
        private static final int QUOTA = 1000;
        private long _myNum = 0L;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized long getNum() {
            long l;
            long mod = this._myNum % 1000L;
            if (this._myNum == 0L || mod == 1L || mod == -1L) {
                Object object = _lockObj;
                synchronized (object) {
                    boolean positive = _seed > 0L;
                    this._myNum = _seed;
                    long l2 = _seed = positive ? _seed + 1000L : _seed - 1000L;
                    if (positive && _seed < 0L || !positive && _seed < 0L) {
                        if (positive) {
                            _seed = -1L;
                            this._myNum = -1L;
                            _seed -= 1000L;
                        } else {
                            _seed = 1L;
                            this._myNum = 1L;
                            _seed += 1000L;
                        }
                    }
                }
            }
            if (this._myNum > 0L) {
                long l3 = this._myNum;
                l = l3;
                this._myNum = l3 + 1L;
            } else {
                long l4 = this._myNum;
                l = l4;
                this._myNum = l4 - 1L;
            }
            long res = l;
            return res;
        }
    }
}

