/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.gigaspaces.client.transaction.xa.GSServerTransaction;
import com.gigaspaces.internal.client.spaceproxy.IDirectSpaceProxy;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.gigaspaces.internal.utils.concurrent.UncheckedAtomicIntegerFieldUpdater;
import com.gigaspaces.lrmi.ILRMIProxy;
import com.gigaspaces.time.SystemTime;
import com.sun.jini.constants.TimeConstants;
import com.sun.jini.constants.TxnConstants;
import com.sun.jini.landlord.LeasedResource;
import com.sun.jini.logging.Levels;
import com.sun.jini.mahalo.AbortJob;
import com.sun.jini.mahalo.AbortRecord;
import com.sun.jini.mahalo.CommitJob;
import com.sun.jini.mahalo.CommitRecord;
import com.sun.jini.mahalo.ExtendedPrepareResult;
import com.sun.jini.mahalo.InternalManagerException;
import com.sun.jini.mahalo.Job;
import com.sun.jini.mahalo.JobException;
import com.sun.jini.mahalo.JobNotStartedException;
import com.sun.jini.mahalo.ParticipantHandle;
import com.sun.jini.mahalo.PrepareAndCommitJob;
import com.sun.jini.mahalo.PrepareJob;
import com.sun.jini.mahalo.ResultNotReadyException;
import com.sun.jini.mahalo.TxnManagerImpl;
import com.sun.jini.mahalo.TxnMgrProxy;
import com.sun.jini.mahalo.TxnSettler;
import com.sun.jini.mahalo.log.ClientLog;
import com.sun.jini.mahalo.log.LogException;
import com.sun.jini.mahalo.log.LogManager;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.transaction.CannotAbortException;
import net.jini.core.transaction.CannotCommitDistributedException;
import net.jini.core.transaction.CannotCommitException;
import net.jini.core.transaction.CannotJoinException;
import net.jini.core.transaction.TimeoutExpiredException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.CrashCountException;
import net.jini.core.transaction.server.ExtendedTransactionManager;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionConstants;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.core.transaction.server.TransactionParticipant;
import net.jini.id.Uuid;
import net.jini.security.ProxyPreparer;

class TxnManagerTransaction
implements TransactionConstants,
TimeConstants,
LeasedResource {
    static final long serialVersionUID = -2088463193687796098L;
    private static final boolean _disableNewSpaceProxyRouter = Boolean.getBoolean("com.gigaspaces.client.router.disableNewRouter");
    private static final boolean[][] states = new boolean[][]{{false, false, false, false, false, false, false}, {false, true, true, false, false, false, true}, {false, false, true, false, false, true, true}, {false, false, false, false, false, false, false}, {false, false, false, false, false, false, false}, {false, false, false, false, false, true, false}, {false, false, false, false, false, false, true}};
    private static final boolean[][] subManagerStates = new boolean[][]{{false, false, false, false, false, false, false}, {false, true, true, false, false, false, true}, {false, false, true, true, false, true, true}, {false, false, false, true, false, true, true}, {false, false, false, false, false, false, false}, {false, false, false, false, false, true, false}, {false, false, false, false, false, false, true}};
    private static final int INITIAL_CAPACITY = 8;
    private static final float LOAD_FACTOR = 0.75f;
    private static final int SEGMENTS = 4;
    private HashMap<ParticipantHandle, ParticipantHandle> _parts = null;
    private ParticipantHandle _singleHandle;
    private final ServerTransaction str;
    private volatile int _trState = 1;
    private static final AtomicIntegerFieldUpdater<TxnManagerTransaction> _stateUpdater = UncheckedAtomicIntegerFieldUpdater.newUpdater(TxnManagerTransaction.class, "_trState");
    private long expires;
    private boolean _leaseForEver;
    private final LogManager logmgr;
    private final TaskManager threadpool;
    private final WakeupManager wm;
    private final TxnSettler settler;
    private Job job;
    private final Uuid uuid;
    private final Object leaseLock = new Object();
    private Object jobLock;
    private final boolean _persistent;
    private static final Logger operationsLogger = TxnManagerImpl.operationsLogger;
    private static final Logger transactionsLogger = TxnManagerImpl.transactionsLogger;
    private final boolean finer_op_logger;
    private final boolean finest_tr_logger;
    private final Object _externalXid;
    private volatile boolean _reenteredPreparedXid;
    private boolean _leaseRenewed;
    private long _leaseRenewedExtension;
    private final ConcurrentMap<String, IDirectSpaceProxy> _proxiesMap;

    TxnManagerTransaction(TransactionManager mgr, LogManager logmgr, long id, TaskManager threadpool, WakeupManager wm, TxnSettler settler, Uuid uuid, long lease, boolean persistent, Object externalXid, ConcurrentMap<String, IDirectSpaceProxy> proxiesMap) {
        if (logmgr == null) {
            throw new IllegalArgumentException("TxnManagerTransaction: log manager must be non-null");
        }
        if (mgr == null) {
            throw new IllegalArgumentException("TxnManagerTransaction: transaction manager must be non-null");
        }
        if (threadpool == null) {
            throw new IllegalArgumentException("TxnManagerTransaction: threadpool must be non-null");
        }
        if (wm == null) {
            throw new IllegalArgumentException("TxnManagerTransaction: wakeup manager must be non-null");
        }
        if (settler == null) {
            throw new IllegalArgumentException("TxnManagerTransaction: settler must be non-null");
        }
        if (uuid == null) {
            throw new IllegalArgumentException("TxnManagerTransaction: uuid must be non-null");
        }
        this.threadpool = threadpool;
        this.wm = wm;
        this.logmgr = logmgr;
        if (externalXid != null) {
            this._externalXid = externalXid;
            this.str = new GSServerTransaction(mgr, externalXid, lease);
            this.str.id = id;
        } else {
            this._externalXid = null;
            this.str = new ServerTransaction(mgr, id, lease);
        }
        this.settler = settler;
        this.uuid = uuid;
        this._persistent = persistent;
        this._proxiesMap = proxiesMap;
        this.finer_op_logger = operationsLogger.isLoggable(Level.FINER);
        this.finest_tr_logger = transactionsLogger.isLoggable(Level.FINEST);
    }

    TxnManagerTransaction(TransactionManager mgr, LogManager logmgr, long id, TaskManager threadpool, WakeupManager wm, TxnSettler settler, Uuid uuid, long lease, boolean persistent) {
        this(mgr, logmgr, id, threadpool, wm, settler, uuid, lease, persistent, null, null);
    }

    synchronized void add(ParticipantHandle handle) throws InternalManagerException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "add", handle);
        }
        if (handle == null) {
            throw new NullPointerException("ParticipantHolder: add: cannot add null handle");
        }
        try {
            if (transactionsLogger.isLoggable(Level.FINEST)) {
                transactionsLogger.log(Level.FINEST, "Adding ParticipantHandle: {0}", handle);
            }
            this._parts.put(handle, handle);
        }
        catch (Exception e) {
            if (transactionsLogger.isLoggable(Level.SEVERE)) {
                transactionsLogger.log(Level.SEVERE, "Unable to add ParticipantHandle", e);
            }
            throw new InternalManagerException("TxnManagerTransaction: add: " + e.getMessage());
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "add");
        }
    }

    synchronized void modifyParticipant(ParticipantHandle handle, int state) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "modifyParticipant", new Object[]{handle, new Integer(state)});
        }
        ParticipantHandle ph = null;
        if (handle == null) {
            throw new NullPointerException("ParticipantHolder: modifyParticipant: cannot modify null handle");
        }
        ph = handle.equals(this._singleHandle) ? this._singleHandle : this._parts.get(this._parts.get(handle));
        if (ph == null) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(TxnManagerTransaction.class.getName(), "modifyParticipant");
            }
            return;
        }
        ph.setPrepState(state);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "modifyParticipant");
        }
    }

    boolean modifyTxnState(int state) {
        int curState;
        if (this.finer_op_logger) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "modifyTxnState", new Integer(state));
        }
        if (state != 1 && state != 2 && state != 5 && state != 6 && (state != 3 || this._externalXid == null)) {
            throw new IllegalArgumentException("TxnManagerTransaction: modifyTxnState: invalid state");
        }
        boolean result = false;
        do {
            curState = this._trState;
            boolean bl = result = this._externalXid != null ? subManagerStates[curState][state] : states[curState][state];
        } while (result && !_stateUpdater.compareAndSet(this, curState, state));
        if (this.finer_op_logger) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "modifyTxnState", result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(TransactionParticipant part, long crashCount, ServerTransaction userXtnObject, int partitionId, String clusterName, IDirectSpaceProxy clusterProxy) throws CannotJoinException, CrashCountException, RemoteException {
        int state;
        if (this.finer_op_logger) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "join", new Object[]{part, new Long(crashCount)});
        }
        if ((state = this.getState()) != 1 && !this._reenteredPreparedXid) {
            throw new CannotJoinException("not active");
        }
        if (state == 1 && !this._leaseForEver && !this.ensureCurrent()) {
            this.doAbort(0L);
            throw new CannotJoinException("Lease expired");
        }
        ParticipantHandle ph = null;
        try {
            TxnManagerTransaction txnManagerTransaction = this;
            synchronized (txnManagerTransaction) {
                ParticipantHandle cur;
                ILRMIProxy stub;
                if (userXtnObject != null && this._leaseRenewed) {
                    this.updateLeaseInUserXtnIfNeeded(userXtnObject);
                }
                if (this._singleHandle != null && this._singleHandle.getParticipant() == part) {
                    this._singleHandle.setDisableDisjoin();
                    return;
                }
                ph = new ParticipantHandle(part, crashCount, null, this._persistent, partitionId, clusterName, clusterProxy);
                if (this._singleHandle == null) {
                    this._singleHandle = ph;
                    return;
                }
                if (this._parts == null) {
                    this._parts = new HashMap(2);
                    if (this._singleHandle.getStubId() == null && this._singleHandle.getParticipant() instanceof ILRMIProxy) {
                        stub = (ILRMIProxy)this._singleHandle.getParticipant();
                        this._singleHandle.setStubId(stub.getStubId());
                    }
                    this._parts.put(this._singleHandle, this._singleHandle);
                }
                if (part instanceof ILRMIProxy) {
                    stub = (ILRMIProxy)part;
                    ph.setStubId(stub.getStubId());
                }
                if ((cur = this._parts.get(ph)) == null) {
                    this._parts.put(ph, ph);
                } else {
                    cur.setDisableDisjoin();
                }
            }
        }
        catch (InternalManagerException ime) {
            if (transactionsLogger.isLoggable(Level.SEVERE)) {
                transactionsLogger.log(Level.SEVERE, "TransactionParticipant unable to join", ime);
            }
            throw ime;
        }
        catch (RemoteException re) {
            if (transactionsLogger.isLoggable(Level.FINEST)) {
                transactionsLogger.log(Level.FINEST, "TransactionParticipant unable to be stored", re);
            }
            throw re;
        }
        if (this.finer_op_logger) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "join");
        }
    }

    private void updateLeaseInUserXtnIfNeeded(ServerTransaction userXtnObject) {
        this._leaseRenewed = false;
        userXtnObject.setLease(this._leaseRenewedExtension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disJoin(TransactionParticipant part) throws RemoteException {
        int state;
        if (this.finer_op_logger) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "disjoin", part);
        }
        if ((state = this.getState()) != 1) {
            throw new RuntimeException("not active");
        }
        TxnManagerTransaction txnManagerTransaction = this;
        synchronized (txnManagerTransaction) {
            ParticipantHandle ph = new ParticipantHandle(part, 0L, null, this._persistent);
            ParticipantHandle[] ps = this.parthandles();
            if (ps == null) {
                return false;
            }
            ILRMIProxy stub = (ILRMIProxy)part;
            ph.setStubId(stub.getStubId());
            for (ParticipantHandle p : ps) {
                if (!p.equals(ph)) continue;
                if (p.isDisableDisjoin()) {
                    return false;
                }
                if (this._parts != null) {
                    this._parts.remove(p);
                    if (this._parts.size() == 0) {
                        this._parts = null;
                    }
                }
                if (this._singleHandle != null && this._singleHandle.equals(ph)) {
                    this._singleHandle = null;
                    ParticipantHandle[] psAfter = this.parthandles();
                    if (psAfter != null && psAfter.length > 0) {
                        this._singleHandle = psAfter[0];
                    }
                }
                return true;
            }
            return false;
        }
    }

    public int getState() {
        return this._trState;
    }

    void commit(long waitFor) throws CannotCommitException, TimeoutExpiredException, RemoteException {
        this.commitImpl(waitFor, false);
    }

    int prepare(long waitFor) throws CannotCommitException, UnknownTransactionException, RemoteException {
        try {
            return this.commitImpl(waitFor, true);
        }
        catch (TimeoutExpiredException ex) {
            throw new CannotCommitException(this.getExternalXid().toString() + " " + ex.toString(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int commitImpl(long waitFor, boolean prepareOnly) throws CannotCommitException, TimeoutExpiredException, RemoteException {
        if (this.finer_op_logger) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "commit", new Long(waitFor));
        }
        if (prepareOnly && waitFor != Long.MAX_VALUE) {
            throw new UnsupportedOperationException();
        }
        int curstate = this.getState();
        if (curstate == 1 && !this._leaseForEver && !this.ensureCurrent()) {
            this.doAbort(0L);
            throw new CannotCommitException("Lease expired [ID=" + this.getTransaction().id + "]");
        }
        if (curstate == 6) {
            throw new CannotCommitException("attempt to commit ABORTED transaction [ID=" + this.getTransaction().id + "]");
        }
        if (curstate == 3 && prepareOnly) {
            return 3;
        }
        boolean use_light_prepareAndCommit = false;
        boolean use_light_Commit = false;
        if (!prepareOnly) {
            TxnManagerTransaction txnManagerTransaction = this;
            synchronized (txnManagerTransaction) {
                if (this._parts == null && this._singleHandle != null && !_disableNewSpaceProxyRouter && this.splitPrepareAndCommit(this._singleHandle) && this._proxiesMap.containsKey(this._singleHandle.getClusterName())) {
                    this._singleHandle.setClusterProxy((IDirectSpaceProxy)this._proxiesMap.get(this._singleHandle.getClusterName()));
                }
                if (this._parts == null && this._singleHandle != null && (_disableNewSpaceProxyRouter || !this.splitPrepareAndCommit(this._singleHandle))) {
                    if (this._externalXid == null || curstate == 1) {
                        use_light_prepareAndCommit = true;
                    } else {
                        use_light_Commit = curstate == 3 && waitFor == Long.MAX_VALUE;
                    }
                } else if (this._parts == null && this._singleHandle != null) {
                    this._parts = new HashMap(1);
                    this._parts.put(this._singleHandle, this._singleHandle);
                }
            }
        }
        if (use_light_prepareAndCommit) {
            this.lightPrepareAndCommit(this._singleHandle);
            return 5;
        }
        if (use_light_Commit) {
            this.lightCommit(this._singleHandle);
            return 5;
        }
        boolean use_light_prepare = false;
        if (prepareOnly) {
            TxnManagerTransaction txnManagerTransaction = this;
            synchronized (txnManagerTransaction) {
                if (this._parts == null && this._singleHandle != null) {
                    use_light_prepare = true;
                }
            }
        }
        if (use_light_prepare) {
            return this.lightPrepare(this._singleHandle);
        }
        long starttime = SystemTime.timeMillis();
        ParticipantHandle[] phs = this.parthandles();
        if (phs == null) {
            if (!this.modifyTxnState(2)) {
                throw new CannotCommitException("attempt to commit ABORTED transaction [ID=" + this.getTransaction().id + "]");
            }
            if (!this.modifyTxnState(5)) throw new CannotCommitException("attempt to commit/prepare ABORTED transaction [ID=" + this.getTransaction().id + "]");
            return 5;
        }
        boolean directPrepareAndCommit = false;
        if (this.jobLock == null) {
            this.setJobLockIfNeed();
        }
        try {
            Object object;
            long now = starttime;
            long transpired = 0L;
            long remainder = 0L;
            ClientLog log = this.logmgr.logFor(this.str.id);
            if (transactionsLogger.isLoggable(Level.FINEST)) {
                transactionsLogger.log(Level.FINEST, "{0} TransactionParticipants have joined", new Integer(phs.length));
            }
            int oldstate = this.getState();
            Integer result = new Integer(6);
            Exception alternateException = null;
            if (this.modifyTxnState(2)) {
                if (oldstate == 1) {
                    log.write(new CommitRecord(phs));
                }
                object = this.jobLock;
                synchronized (object) {
                    boolean bl = directPrepareAndCommit = waitFor == Long.MAX_VALUE && phs.length == 1 && !this.isExternalXid() && !prepareOnly;
                    if (this.job == null) {
                        ParticipantHandle singleHandle;
                        if (phs.length == 1 && !this.isExternalXid() && !prepareOnly && !_disableNewSpaceProxyRouter && this.splitPrepareAndCommit(phs[0]) && this._proxiesMap.containsKey((singleHandle = phs[0]).getClusterName())) {
                            singleHandle.setClusterProxy((IDirectSpaceProxy)this._proxiesMap.get(singleHandle.getClusterName()));
                        }
                        if (!(phs.length != 1 || this.isExternalXid() || prepareOnly || !_disableNewSpaceProxyRouter && this.splitPrepareAndCommit(phs[0]))) {
                            this.job = new PrepareAndCommitJob((Transaction)this.str, this.threadpool, this.wm, log, phs[0], directPrepareAndCommit, this._externalXid);
                        } else {
                            directPrepareAndCommit = false;
                            this.job = new PrepareJob((Transaction)this.str, this.threadpool, this.wm, log, phs, this._externalXid, this._proxiesMap);
                        }
                        if (directPrepareAndCommit) {
                            PrepareAndCommitJob pcj = (PrepareAndCommitJob)this.job;
                            pcj.doWork(null, phs[0]);
                        } else {
                            this.job.scheduleTasks();
                        }
                    }
                }
                object = this.jobLock;
                synchronized (object) {
                    if (this.job instanceof PrepareJob || this.job instanceof PrepareAndCommitJob) {
                        try {
                            if (this.job.isCompleted(Long.MAX_VALUE)) {
                                result = (Integer)this.job.computeResult();
                                if (result == 6 && this.job instanceof PrepareAndCommitJob) {
                                    PrepareAndCommitJob pj = (PrepareAndCommitJob)this.job;
                                    alternateException = pj.getAlternateException();
                                }
                                if (prepareOnly && (result == 3 || result == 4)) {
                                    this.modifyTxnState(result);
                                    return result;
                                }
                            }
                        }
                        catch (JobNotStartedException jnse) {
                            result = new Integer(4);
                        }
                        catch (ResultNotReadyException resultNotReadyException) {
                        }
                        catch (JobException jobException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (this.getState() == 6) {
                throw new CannotCommitException("transaction ABORTED [ID=" + this.getTransaction().id + "]");
            }
            if (this.getState() == 5) {
                result = new Integer(5);
            }
            if (this._externalXid != null && this.getState() == 3) {
                result = new Integer(3);
            }
            if (transactionsLogger.isLoggable(Level.FINEST)) {
                transactionsLogger.log(Level.FINEST, "Voting result: {0}", TxnConstants.getName(result));
            }
            switch (result) {
                case 4: {
                    break;
                }
                case 6: {
                    now = SystemTime.timeMillis();
                    transpired = now - starttime;
                    remainder = waitFor - transpired;
                    if (remainder >= 0L) {
                        this.doAbort(remainder);
                    } else {
                        this.doAbort(0L);
                    }
                    if (alternateException != null) throw new RemoteException("Problem communicating with participant", alternateException);
                    throw new CannotCommitException("Unable to commit transaction [ID=" + this.getTransaction().id + "]: " + this.getParticipantInfo(), this.getCommitExceptionCause(phs));
                }
                case 3: {
                    if (prepareOnly) {
                        this.modifyTxnState(3);
                        return 3;
                    }
                    if (!this.modifyTxnState(5)) throw new CannotCommitException("attempt to commit ABORTED transaction [ID=" + this.getTransaction().id + "]");
                    object = this.jobLock;
                    synchronized (object) {
                        this.job = new CommitJob((Transaction)this.str, this.threadpool, this.wm, log, phs, this._externalXid);
                        this.job.scheduleTasks();
                    }
                }
                case 5: {
                    object = this.jobLock;
                    synchronized (object) {
                        if (this.job instanceof PrepareAndCommitJob) {
                            if (!this.modifyTxnState(5)) {
                                throw new CannotCommitException("transaction ABORTED [ID=" + this.getTransaction().id + "]");
                            }
                            break;
                        }
                        if (this.job instanceof AbortJob) {
                            throw new CannotCommitException("transaction ABORTED [ID=" + this.getTransaction().id + "]");
                        }
                    }
                    if (this.getState() != 5) {
                        throw new InternalManagerException("TxnManagerTransaction: commit: " + this.job + " got bad state: " + TxnConstants.getName(result));
                    }
                    now = SystemTime.timeMillis();
                    transpired = now - starttime;
                    boolean committed = false;
                    try {
                        remainder = waitFor - transpired;
                        Object object2 = this.jobLock;
                        synchronized (object2) {
                            if (remainder <= 0L || !this.job.isCompleted(remainder)) {
                                if (this._externalXid != null) {
                                    this.settler.noteUnsettledTxn(this._externalXid);
                                } else {
                                    this.settler.noteUnsettledTxn(this.str.id);
                                }
                                this.throwCannotCommitExceptionIfNeeded(phs);
                                throw new TimeoutExpiredException("timeout expired", true);
                            }
                            result = (Integer)this.job.computeResult();
                            committed = true;
                            this.throwCannotCommitExceptionIfNeeded(phs);
                        }
                    }
                    catch (ResultNotReadyException resultNotReadyException) {
                    }
                    catch (JobNotStartedException jobNotStartedException) {
                    }
                    catch (JobException jobException) {
                        // empty catch block
                    }
                    if (committed) break;
                }
                default: {
                    throw new InternalManagerException("TxnManagerTransaction: commit: " + this.job + " got bad state: " + TxnConstants.getName(result));
                }
            }
            log.invalidate();
        }
        catch (RuntimeException rte) {
            if (!transactionsLogger.isLoggable(Level.FINEST)) throw rte;
            transactionsLogger.log(Level.FINEST, "Problem committing transaction", rte);
            throw rte;
        }
        catch (LogException le) {
            if (!transactionsLogger.isLoggable(Level.FINEST)) throw new CannotCommitException("Unable to log [ID=" + this.getTransaction().id + "]");
            transactionsLogger.log(Level.FINEST, "Problem persisting transaction", le);
            throw new CannotCommitException("Unable to log [ID=" + this.getTransaction().id + "]");
        }
        if (!operationsLogger.isLoggable(Level.FINER)) return 5;
        operationsLogger.exiting(TxnManagerTransaction.class.getName(), "commit");
        return 5;
    }

    private void throwCannotCommitExceptionIfNeeded(ParticipantHandle[] phs) throws CannotCommitException {
        HashMap<Integer, Exception> participantsExceptions = new HashMap<Integer, Exception>();
        for (ParticipantHandle ph : phs) {
            if (ph.getCommitException() == null) continue;
            participantsExceptions.put(ph.getPartionId(), (Exception)((Object)ph.getCommitException()));
        }
        if (!participantsExceptions.isEmpty()) {
            throw new CannotCommitDistributedException("some participants failed in commit after prepare [ID=" + this.getTransaction().id + "]: - risk of partial transaction", participantsExceptions);
        }
    }

    private Throwable getCommitExceptionCause(ParticipantHandle[] phs) {
        for (ParticipantHandle participantHandle : phs) {
            if (participantHandle.getCommitException() == null) continue;
            return participantHandle.getCommitException();
        }
        return null;
    }

    private boolean splitPrepareAndCommit(ParticipantHandle participantHandle) {
        return participantHandle.getPartionId() >= 0 && participantHandle.getClusterProxy() == null;
    }

    private void lightPrepareAndCommit(ParticipantHandle singleHandle) throws CannotCommitException, TimeoutExpiredException, RemoteException {
        block7: {
            try {
                if (this.modifyTxnState(2)) {
                    if (singleHandle.isSuitableForFailover()) {
                        this.prepareAndCommitPartitionWithEnabledFailover(singleHandle);
                    } else {
                        TxnMgrProxy cur = (TxnMgrProxy)this.str.mgr;
                        int res = this._externalXid == null ? singleHandle.getParticipant().prepareAndCommit((TransactionManager)cur.createLightProxy(), this.str.id) : ((IRemoteSpace)singleHandle.getParticipant()).prepareAndCommit((TransactionManager)cur.createLightProxy(), this._externalXid);
                        if (res != 5) {
                            throw new CannotCommitException("Unable to commit transaction: " + this.getParticipantInfo(), (Throwable)singleHandle.getCommitException());
                        }
                        this.modifyTxnState(res);
                    }
                    break block7;
                }
                if (this.getState() == 5) {
                    return;
                }
                throw new CannotCommitException();
            }
            catch (UnknownTransactionException e) {
                throw new CannotCommitException(" reason=" + (Object)((Object)e), (Throwable)e);
            }
        }
    }

    private void prepareAndCommitPartitionWithEnabledFailover(ParticipantHandle singleHandle) throws CannotCommitException {
        TxnMgrProxy cur = (TxnMgrProxy)this.str.mgr;
        int res = PrepareAndCommitJob.commitAndPreparePartitionWithEnabledFailover(singleHandle, (TransactionManager)cur, this.str.id, this._externalXid);
        if (res != 5) {
            throw new CannotCommitException("Unable to commit transaction: " + this.getParticipantInfo(), (Throwable)singleHandle.getCommitException());
        }
        this.modifyTxnState(5);
    }

    private void lightCommit(ParticipantHandle singleHandle) throws CannotCommitException, TimeoutExpiredException, RemoteException {
        try {
            if (singleHandle.isSuitableForCommitFailover()) {
                this.commitPartitionWithEnabledFailover(singleHandle);
            } else {
                TxnMgrProxy cur = (TxnMgrProxy)this.str.mgr;
                if (this._externalXid == null) {
                    singleHandle.getParticipant().commit((TransactionManager)cur.createLightProxy(), this.str.id);
                } else {
                    ((IRemoteSpace)singleHandle.getParticipant()).commit((TransactionManager)cur.createLightProxy(), this._externalXid);
                }
                this.modifyTxnState(5);
            }
        }
        catch (UnknownTransactionException e) {
            throw new CannotCommitException("[ID=" + this.str.id + "]: reason=" + (Object)((Object)e), (Throwable)e);
        }
    }

    private void commitPartitionWithEnabledFailover(ParticipantHandle singleHandle) throws CannotCommitException, TimeoutExpiredException, RemoteException {
        TxnMgrProxy cur = (TxnMgrProxy)this.str.mgr;
        CommitJob.commitPartitionWithEnabledFailover(singleHandle, (ExtendedTransactionManager)cur.createLightProxy(), this.str.id, this._externalXid, 1);
        this.modifyTxnState(5);
        if (singleHandle.getCommitException() != null) {
            throw singleHandle.getCommitException();
        }
    }

    private int lightPrepare(ParticipantHandle singleHandle) throws CannotCommitException, TimeoutExpiredException, RemoteException {
        TxnMgrProxy cur = (TxnMgrProxy)this.str.mgr;
        try {
            if (this.modifyTxnState(2)) {
                int res;
                singleHandle.setPrepared();
                boolean proxyExists = false;
                if (_disableNewSpaceProxyRouter) {
                    singleHandle.setClusterProxy(null);
                    singleHandle.setClusterName(null);
                    singleHandle.setPartitionId(-1);
                }
                if (singleHandle.isNeedProxyInCommit() && this._proxiesMap.containsKey(singleHandle.getClusterName())) {
                    singleHandle.setClusterProxy((IDirectSpaceProxy)this._proxiesMap.get(singleHandle.getClusterName()));
                    proxyExists = true;
                }
                if (singleHandle.isSuitableForCommitFailover() && !proxyExists && !this._proxiesMap.containsKey(singleHandle.getClusterName())) {
                    this._proxiesMap.putIfAbsent(singleHandle.getClusterName(), singleHandle.getClusterProxy());
                }
                if (!_disableNewSpaceProxyRouter) {
                    ExtendedPrepareResult eres = null;
                    eres = this._externalXid == null ? (ExtendedPrepareResult)((IRemoteSpace)singleHandle.getParticipant()).prepare((TransactionManager)cur.createLightProxy(), this.str.id, singleHandle.isNeedProxyInCommit()) : (ExtendedPrepareResult)((IRemoteSpace)singleHandle.getParticipant()).prepare((TransactionManager)cur.createLightProxy(), this._externalXid, singleHandle.isNeedProxyInCommit());
                    res = eres.getVote();
                    if (eres.getProxy() != null && singleHandle.isNeedProxyInCommit()) {
                        singleHandle.setClusterProxy(eres.getProxy());
                        if (!this._proxiesMap.containsKey(singleHandle.getClusterName())) {
                            this._proxiesMap.putIfAbsent(singleHandle.getClusterName(), singleHandle.getClusterProxy());
                        }
                    }
                } else {
                    res = this._externalXid == null ? singleHandle.getParticipant().prepare((TransactionManager)cur.createLightProxy(), this.str.id) : ((IRemoteSpace)singleHandle.getParticipant()).prepare((TransactionManager)cur.createLightProxy(), this._externalXid);
                }
                this.modifyTxnState(res);
                return res;
            }
            if (this.getState() == 5 || this.getState() == 3) {
                return this.getState();
            }
            throw new CannotCommitException();
        }
        catch (UnknownTransactionException e) {
            throw new CannotCommitException(" reason=" + (Object)((Object)e), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort(long waitFor) throws CannotAbortException, TimeoutExpiredException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "abort", new Long(waitFor));
        }
        boolean use_light_abort = false;
        if (waitFor == Long.MAX_VALUE) {
            TxnManagerTransaction txnManagerTransaction = this;
            synchronized (txnManagerTransaction) {
                if (this._parts == null && this._singleHandle != null) {
                    use_light_abort = true;
                }
            }
        }
        if (use_light_abort) {
            this.lightAbort(this._singleHandle);
            return;
        }
        if (this.jobLock == null) {
            this.setJobLockIfNeed();
        }
        long starttime = SystemTime.timeMillis();
        boolean directAbortCall = false;
        try {
            ParticipantHandle[] phs = this.parthandles();
            if (phs == null) {
                if (this.modifyTxnState(6)) {
                    return;
                }
                throw new CannotAbortException("Transaction already COMMITTED");
            }
            ClientLog log = this.logmgr.logFor(this.str.id);
            if (this.modifyTxnState(6)) {
                log.write(new AbortRecord(phs));
                Object object = this.jobLock;
                synchronized (object) {
                    boolean bl = directAbortCall = waitFor == Long.MAX_VALUE && phs.length == 1;
                    if (!(this.job instanceof AbortJob)) {
                        if (this.job != null) {
                            if (this.job.isDirectCall()) {
                                throw new CannotAbortException("direct call  on Transaction in progress");
                            }
                            this.job.stop();
                        }
                        this.job = new AbortJob((Transaction)this.str, this.threadpool, this.wm, log, phs, directAbortCall, this._externalXid);
                        if (this.job.isDirectCall()) {
                            AbortJob aj = (AbortJob)this.job;
                            aj.doWork(null, phs[0]);
                        } else {
                            this.job.scheduleTasks();
                        }
                    }
                }
            } else {
                throw new CannotAbortException("Transaction already COMMITTED");
            }
            long now = SystemTime.timeMillis();
            long transpired = now - starttime;
            Integer result = new Integer(1);
            boolean aborted = false;
            long remainder = waitFor - transpired;
            try {
                Object object = this.jobLock;
                synchronized (object) {
                    if (remainder <= 0L || !this.job.isCompleted(remainder)) {
                        if (this._externalXid != null) {
                            this.settler.noteUnsettledTxn(this._externalXid);
                        } else {
                            this.settler.noteUnsettledTxn(this.str.id);
                        }
                        throw new TimeoutExpiredException("timeout expired", false);
                    }
                    result = (Integer)this.job.computeResult();
                    aborted = true;
                    for (ParticipantHandle ph : phs) {
                        if (ph.getAbortException() == null) continue;
                        throw ph.getAbortException();
                    }
                }
            }
            catch (ResultNotReadyException resultNotReadyException) {
            }
            catch (JobNotStartedException jobNotStartedException) {
            }
            catch (JobException je) {
                if (this._externalXid != null) {
                    this.settler.noteUnsettledTxn(this._externalXid);
                } else {
                    this.settler.noteUnsettledTxn(this.str.id);
                }
                throw new TimeoutExpiredException("timeout expired", false);
            }
            if (!aborted) {
                throw new InternalManagerException("TxnManagerTransaction: abort: AbortJob got bad state: " + TxnConstants.getName(result));
            }
            log.invalidate();
        }
        catch (RuntimeException rte) {
            if (transactionsLogger.isLoggable(Level.SEVERE)) {
                transactionsLogger.log(Level.SEVERE, "Problem aborting transaction", rte);
            }
            throw new InternalManagerException("TxnManagerTransaction: abort: fatal error");
        }
        catch (LogException le) {
            if (transactionsLogger.isLoggable(Level.FINEST)) {
                transactionsLogger.log(Level.FINEST, "Problem persisting transaction", le);
            }
            throw new CannotAbortException("Unable to log");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "abort");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setJobLockIfNeed() {
        TxnManagerTransaction txnManagerTransaction = this;
        synchronized (txnManagerTransaction) {
            if (this.jobLock == null) {
                this.jobLock = new Object();
            }
        }
    }

    private void lightAbort(ParticipantHandle singleHandle) throws CannotAbortException, TimeoutExpiredException {
        block10: {
            TxnMgrProxy cur = (TxnMgrProxy)this.str.mgr;
            try {
                if (this.getState() == 6) {
                    return;
                }
                if (this.modifyTxnState(6)) {
                    if (singleHandle.isSuitableForCommitFailover()) {
                        AbortJob.abortPartitionWithEnabledFailover(singleHandle, (ExtendedTransactionManager)cur.createLightProxy(), this.str.id, this._externalXid);
                    } else if (this._externalXid == null) {
                        singleHandle.getParticipant().abort((TransactionManager)cur.createLightProxy(), this.str.id);
                    } else {
                        ((IRemoteSpace)singleHandle.getParticipant()).abort((TransactionManager)cur.createLightProxy(), this._externalXid);
                    }
                    if (singleHandle.getAbortException() != null) {
                        throw singleHandle.getAbortException();
                    }
                    break block10;
                }
                throw new CannotAbortException("Transaction already COMMITTED");
            }
            catch (UnknownTransactionException e) {
                throw new CannotAbortException(" reason=" + (Object)((Object)e));
            }
            catch (RemoteException e) {
                throw new CannotAbortException(" reason=" + e);
            }
        }
    }

    public ServerTransaction getTransaction() {
        return this.str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getExpiration() {
        if (this.finer_op_logger) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "getExpiration");
        }
        Object object = this.leaseLock;
        synchronized (object) {
            if (this.finer_op_logger) {
                operationsLogger.exiting(TxnManagerTransaction.class.getName(), "getExpiration", new Date(this.expires));
            }
            return this.expires;
        }
    }

    public long getExpirationUnderThisLock() {
        return this.expires;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExpiration(long newExpiration) {
        if (this.finer_op_logger) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "setExpiration", new Date(newExpiration));
        }
        Object object = this.leaseLock;
        synchronized (object) {
            this.setExpirationUnsafe(newExpiration);
            if (this.finer_op_logger) {
                operationsLogger.exiting(TxnManagerTransaction.class.getName(), "setExpiration");
            }
        }
    }

    public void setExpirationUnsafe(long newExpiration) {
        this.expires = newExpiration;
        this._leaseForEver = this.expires == Long.MAX_VALUE;
    }

    @Override
    public Uuid getCookie() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "getCookie");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "getCookie", this.uuid);
        }
        return this.uuid;
    }

    private void doAbort(long timeout) {
        block8: {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.entering(TxnManagerTransaction.class.getName(), "doAbort", new Long(timeout));
            }
            try {
                this.str.abort(timeout);
            }
            catch (RemoteException re) {
                if (transactionsLogger.isLoggable(Levels.HANDLED)) {
                    transactionsLogger.log(Levels.HANDLED, "Trouble aborting  transaction", re);
                }
            }
            catch (TimeoutExpiredException te) {
                if (transactionsLogger.isLoggable(Levels.HANDLED)) {
                    transactionsLogger.log(Levels.HANDLED, "Trouble aborting  transaction", te);
                }
            }
            catch (TransactionException bte) {
                if (!transactionsLogger.isLoggable(Levels.HANDLED)) break block8;
                transactionsLogger.log(Levels.HANDLED, "Trouble aborting  transaction", bte);
            }
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "doAbort");
        }
    }

    synchronized boolean ensureCurrent() {
        long useby;
        if (this.finer_op_logger) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "ensureCurrent");
        }
        if ((useby = this.getExpiration()) == Long.MAX_VALUE) {
            return true;
        }
        long cur = SystemTime.timeMillis();
        boolean result = false;
        if (useby > cur) {
            result = true;
        }
        if (this.finer_op_logger) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "ensureCurrent", result);
        }
        return result;
    }

    private synchronized ParticipantHandle[] parthandles() {
        if (this._singleHandle != null && this._parts == null) {
            return new ParticipantHandle[]{this._singleHandle};
        }
        if (this._parts == null) {
            return null;
        }
        ArrayList vect = null;
        HashMap<ParticipantHandle, ParticipantHandle> map = this._parts;
        for (Map.Entry entry : map.entrySet()) {
            if (vect == null) {
                vect = new ArrayList();
            }
            vect.add(entry.getValue());
        }
        if (vect == null && transactionsLogger.isLoggable(Level.FINEST)) {
            transactionsLogger.log(Level.FINEST, "Retrieved {0} participants", new Integer(0));
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "parthandles");
        }
        return vect == null ? null : vect.toArray(new ParticipantHandle[vect.size()]);
    }

    private String getParticipantInfo() {
        ParticipantHandle[] phs;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "getParticipantInfo");
        }
        if ((phs = this.parthandles()) == null) {
            return "No participants";
        }
        if (transactionsLogger.isLoggable(Level.FINEST)) {
            transactionsLogger.log(Level.FINEST, "{0} participants joined", new Integer(phs.length));
        }
        StringBuilder sb = new StringBuilder(phs.length + " Participants: ");
        int i = 0;
        for (ParticipantHandle ph : phs) {
            sb.append("{" + ++i + ", " + ph.getParticipant().toString() + ", " + TxnConstants.getName(ph.getPrepState()) + "} ");
        }
        return sb.toString();
    }

    void restoreTransientState(ProxyPreparer preparer) throws RemoteException {
        ParticipantHandle[] phs;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerTransaction.class.getName(), "restoreTransientState");
        }
        if ((phs = this.parthandles()) == null) {
            return;
        }
        int size = phs.length;
        ParticipantHandle[] handles = new ParticipantHandle[size];
        int j = 0;
        for (ParticipantHandle ph : phs) {
            handles[++j] = ph;
        }
        for (int i = 0; i < handles.length; ++i) {
            handles[i].restoreTransientState(preparer);
            if (!transactionsLogger.isLoggable(Level.FINEST)) continue;
            transactionsLogger.log(Level.FINEST, "Restored transient state for {0}", handles[i]);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerTransaction.class.getName(), "restoreTransientState");
        }
    }

    public void renew(long extension) throws LeaseDeniedException, UnknownLeaseException {
        this._leaseRenewed = true;
        this._leaseRenewedExtension = extension;
        this.str.setLease(extension);
        ParticipantHandle[] phs = this.parthandles();
        if (phs == null) {
            return;
        }
        for (ParticipantHandle ph : phs) {
            this.renewParticipantLease(ph, extension);
        }
    }

    private void renewParticipantLease(ParticipantHandle participant, long extension) {
        TransactionParticipant preParedParticipant = participant.getParticipant();
        try {
            preParedParticipant.renewLease((TransactionManager)this.str.mgr, this.str.id, extension);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isExternalXid() {
        return this._externalXid != null;
    }

    public Object getExternalXid() {
        return this._externalXid;
    }

    public void setReenteredPreparedXid() throws CannotCommitException {
        if (this._externalXid == null) {
            throw new UnsupportedOperationException();
        }
        if (this.getState() == 6) {
            throw new CannotCommitException(" xtn is aborted");
        }
        this._reenteredPreparedXid = true;
        this.modifyTxnState(2);
        this.modifyTxnState(3);
    }
}

