/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo.log;

import com.gigaspaces.api.InternalApi;
import com.sun.jini.mahalo.log.Log;
import com.sun.jini.mahalo.log.LogException;
import com.sun.jini.mahalo.log.LogRecord;
import com.sun.jini.mahalo.log.LogRecovery;
import com.sun.jini.mahalo.log.MultiLogManager;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class TransientLogFile
implements Log {
    private final long cookie;
    private final MultiLogManager.LogRemovalManager logMgr;
    private static final Logger persistenceLogger = Logger.getLogger("com.sun.jini.mahalo.persistence");
    private static final Logger operationsLogger = Logger.getLogger("com.sun.jini.mahalo.operations");

    public TransientLogFile(long id, MultiLogManager.LogRemovalManager lrm) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TransientLogFile.class.getName(), "TransientLogFile", new Object[]{new Long(id), lrm});
        }
        this.cookie = id;
        this.logMgr = lrm;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TransientLogFile.class.getName(), "TransientLogFile");
        }
    }

    @Override
    public long cookie() {
        return this.cookie;
    }

    @Override
    public void write(LogRecord rec) throws LogException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TransientLogFile.class.getName(), "write", rec);
        }
        if (persistenceLogger.isLoggable(Level.FINEST)) {
            persistenceLogger.log(Level.FINEST, "(ignored) write called for cookie: {0}", new Long(this.cookie));
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TransientLogFile.class.getName(), "write");
        }
    }

    @Override
    public void invalidate() throws LogException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TransientLogFile.class.getName(), "invalidate");
        }
        if (persistenceLogger.isLoggable(Level.FINEST)) {
            persistenceLogger.log(Level.FINEST, "Calling logMgr to release cookie: {0}", new Long(this.cookie));
        }
        this.logMgr.release(this.cookie);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TransientLogFile.class.getName(), "invalidate");
        }
    }

    @Override
    public void recover(LogRecovery client) throws LogException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(MultiLogManager.class.getName(), "recover", client);
        }
        if (persistenceLogger.isLoggable(Level.FINEST)) {
            persistenceLogger.log(Level.FINEST, "(ignored) Recovering for: {0}", new Long(this.cookie));
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(MultiLogManager.class.getName(), "recover");
        }
    }
}

