/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.proxy;

import com.gigaspaces.api.InternalApi;
import com.sun.jini.proxy.MarshalPivotProvider;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import net.jini.io.MarshalledInstance;
import net.jini.io.ObjectStreamContext;
import net.jini.io.context.IntegrityEnforcement;

@InternalApi
public class MarshalledWrapper
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final boolean AVOID_MARSH_PIVOT = Boolean.getBoolean("com.gs.proxy.avoidPivotMarsh");
    private final MarshalledInstance instance;
    private transient boolean integrity = false;

    public static boolean integrityEnforced(ObjectInputStream stream) {
        if (stream instanceof ObjectStreamContext) {
            Collection ctx = ((ObjectStreamContext)stream).getObjectStreamContext();
            for (Object obj : ctx) {
                if (!(obj instanceof IntegrityEnforcement)) continue;
                return ((IntegrityEnforcement)obj).integrityEnforced();
            }
        }
        return false;
    }

    public MarshalledWrapper(Object obj) throws IOException {
        Object service = obj;
        if (!AVOID_MARSH_PIVOT && obj instanceof MarshalPivotProvider) {
            service = ((MarshalPivotProvider)obj).getMarshalPivot();
        }
        this.instance = new MarshalledInstance(service);
    }

    public Object get() throws IOException, ClassNotFoundException {
        return this.instance.get(this.integrity);
    }

    public boolean getIntegrity() {
        return this.integrity;
    }

    public int hashCode() {
        return MarshalledWrapper.class.hashCode() ^ this.instance.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == this.getClass() && this.instance.equals((Object)((MarshalledWrapper)obj).instance);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.instance == null) {
            throw new InvalidObjectException("null instance");
        }
        this.integrity = MarshalledWrapper.integrityEnforced(in);
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("no data");
    }
}

