/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.proxy.ConstrainableProxyUtil;
import com.sun.jini.reggie.ConstrainableRegistrarLeaseMap;
import com.sun.jini.reggie.EventLease;
import com.sun.jini.reggie.Registrar;
import com.sun.jini.reggie.Util;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseMap;
import net.jini.core.lookup.ServiceID;
import net.jini.id.Uuid;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;

public final class ConstrainableEventLease
extends EventLease
implements RemoteMethodControl {
    private static final long serialVersionUID = 2L;
    private static final Method[] methodMappings = new Method[]{Util.getMethod(Lease.class, "cancel", new Class[0]), Util.getMethod(Registrar.class, "cancelEventLease", new Class[]{Long.TYPE, Uuid.class}), Util.getMethod(Lease.class, "renew", new Class[]{Long.TYPE}), Util.getMethod(Registrar.class, "renewEventLease", new Class[]{Long.TYPE, Uuid.class, Long.TYPE})};
    private final MethodConstraints constraints;

    ConstrainableEventLease(Registrar server, ServiceID registrarID, long eventID, Uuid leaseID, long expiration, MethodConstraints constraints) {
        super((Registrar)((RemoteMethodControl)server).setConstraints(ConstrainableProxyUtil.translateConstraints(constraints, methodMappings)), registrarID, eventID, leaseID, expiration);
        this.constraints = constraints;
    }

    @Override
    public LeaseMap createLeaseMap(long duration) {
        return new ConstrainableRegistrarLeaseMap(this, duration);
    }

    @Override
    public boolean canBatch(Lease lease) {
        if (!super.canBatch(lease) || !(lease instanceof RemoteMethodControl)) {
            return false;
        }
        return ConstrainableProxyUtil.equivalentConstraints(((RemoteMethodControl)lease).getConstraints(), ConstrainableProxyUtil.translateConstraints(this.constraints, ConstrainableRegistrarLeaseMap.methodMappings), ConstrainableRegistrarLeaseMap.methodMappings);
    }

    public RemoteMethodControl setConstraints(MethodConstraints constraints) {
        return new ConstrainableEventLease(this.server, this.registrarID, this.eventID, this.leaseID, this.expiration, constraints);
    }

    public MethodConstraints getConstraints() {
        return this.constraints;
    }

    private ProxyTrustIterator getProxyTrustIterator() {
        return new SingletonProxyTrustIterator((Object)this.server);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        ConstrainableProxyUtil.verifyConsistentConstraints(this.constraints, this.server, methodMappings);
    }
}

