/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.gigaspaces.admin.cli.RuntimeInfo;
import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.backport.java.util.concurrent.FastConcurrentSkipListMap;
import com.gigaspaces.internal.client.spaceproxy.SpaceProxyImpl;
import com.gigaspaces.internal.jmx.JMXUtilities;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.jvm.JVMHelper;
import com.gigaspaces.internal.jvm.JVMInfoProvider;
import com.gigaspaces.internal.jvm.JVMStatistics;
import com.gigaspaces.internal.log.InternalLogHelper;
import com.gigaspaces.internal.log.InternalLogProvider;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.internal.os.OSHelper;
import com.gigaspaces.internal.os.OSInfoProvider;
import com.gigaspaces.internal.os.OSStatistics;
import com.gigaspaces.log.LogEntries;
import com.gigaspaces.log.LogEntryMatcher;
import com.gigaspaces.log.LogProcessType;
import com.gigaspaces.logger.LogHelper;
import com.gigaspaces.lrmi.ILRMIProxy;
import com.gigaspaces.lrmi.LRMIMonitoringDetails;
import com.gigaspaces.lrmi.nio.info.NIODetails;
import com.gigaspaces.lrmi.nio.info.NIOInfoHelper;
import com.gigaspaces.lrmi.nio.info.NIOInfoProvider;
import com.gigaspaces.lrmi.nio.info.NIOStatistics;
import com.gigaspaces.management.entry.JMXConnection;
import com.gigaspaces.metrics.Gauge;
import com.gigaspaces.metrics.LongCounter;
import com.gigaspaces.metrics.MetricManager;
import com.gigaspaces.metrics.MetricRegistrator;
import com.gigaspaces.metrics.MetricUtils;
import com.gigaspaces.start.SystemInfo;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.service.Service;
import com.j_spaces.kernel.SizeConcurrentHashMap;
import com.j_spaces.kernel.threadpool.DynamicExecutors;
import com.j_spaces.kernel.threadpool.DynamicThreadPoolExecutor;
import com.sun.jini.config.Config;
import com.sun.jini.constants.ThrowableConstants;
import com.sun.jini.discovery.ClientSubjectChecker;
import com.sun.jini.discovery.Discovery;
import com.sun.jini.discovery.DiscoveryConstraints;
import com.sun.jini.discovery.DiscoveryProtocolException;
import com.sun.jini.discovery.EncodeIterator;
import com.sun.jini.discovery.MulticastAnnouncement;
import com.sun.jini.discovery.MulticastRequest;
import com.sun.jini.discovery.UnicastResponse;
import com.sun.jini.logging.Levels;
import com.sun.jini.lookup.entry.BasicServiceType;
import com.sun.jini.proxy.MarshalledWrapper;
import com.sun.jini.reggie.AdminProxy;
import com.sun.jini.reggie.ClassMapper;
import com.sun.jini.reggie.EntryClass;
import com.sun.jini.reggie.EntryClassBase;
import com.sun.jini.reggie.EntryRep;
import com.sun.jini.reggie.EventLease;
import com.sun.jini.reggie.Item;
import com.sun.jini.reggie.Matches;
import com.sun.jini.reggie.ProxyVerifier;
import com.sun.jini.reggie.Registrar;
import com.sun.jini.reggie.RegistrarEvent;
import com.sun.jini.reggie.RegistrarProxy;
import com.sun.jini.reggie.Registration;
import com.sun.jini.reggie.RenewResults;
import com.sun.jini.reggie.ServiceLease;
import com.sun.jini.reggie.ServiceType;
import com.sun.jini.reggie.ServiceTypeBase;
import com.sun.jini.reggie.Template;
import com.sun.jini.reggie.Util;
import com.sun.jini.reggie.UuidGenerator;
import com.sun.jini.start.LifeCycle;
import com.sun.jini.thread.InterruptedStatusThread;
import com.sun.jini.thread.ReadersWriter;
import com.sun.jini.thread.ReadyState;
import com.sun.jini.thread.TaskManager;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.rmi.MarshalException;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.config.NoSuchEntryException;
import net.jini.constraint.BasicMethodConstraints;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.Lease;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.lookup.RegistrarEventRegistration;
import net.jini.core.lookup.ServiceDetails;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceMatchesWrapper;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceRegistration;
import net.jini.discovery.Constants;
import net.jini.discovery.ConstrainableLookupLocator;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.discovery.LookupGroups;
import net.jini.discovery.dynamic.DynamicLookupLocatorDiscovery;
import net.jini.export.Exporter;
import net.jini.export.ProxyAccessor;
import net.jini.id.ReferentUuid;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.io.MarshalOutputStream;
import net.jini.io.MarshalledInstance;
import net.jini.io.OptimizedByteArrayOutputStream;
import net.jini.io.UnsupportedConstraintException;
import net.jini.lookup.JoinManager;
import net.jini.lookup.entry.Name;
import net.jini.lookup.entry.ServiceInfo;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;
import org.jini.rio.boot.BootUtil;

@InternalApi
public class GigaRegistrar
implements Registrar,
ProxyAccessor,
ServerProxyTrust,
NIOInfoProvider,
OSInfoProvider,
JVMInfoProvider,
InternalLogProvider {
    private static final long MAX_LEASE = 31536000000000L;
    private static final long MAX_RENEW = 31536000000L;
    private static final int DEFAULT_MAX_PACKET_SIZE = 512;
    private static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    private static final String COMPONENT = "com.sun.jini.reggie";
    private static final Uuid myLeaseID = UuidFactory.create((long)0L, (long)0L);
    private static final Logger logger = Logger.getLogger(GigaRegistrar.class.getName());
    private static final Logger loggerCache = Logger.getLogger(logger.getName() + ".cache");
    private static final Logger loggerStats = Logger.getLogger(logger.getName() + ".stats");
    private static final Logger loggerServiceExpire = Logger.getLogger("com.sun.jini.reggie.expire.service");
    private static final Logger loggerEventExpire = Logger.getLogger("com.sun.jini.reggie.expire.event");
    private static final Object _lock = new Object();
    private static boolean isActive;
    private static final Entry[] baseAttrs;
    private static final EntryRep[] emptyAttrs;
    private RegistrarProxy proxy;
    private MarshalledObject proxyMarshalledObject;
    private byte[] proxyRegistrarBytes;
    private Exporter serverExporter;
    private Registrar myRef;
    private ServiceID myServiceID;
    private volatile LookupLocator myLocator;
    private LoginContext loginContext;
    private LifeCycle lifeCycle;
    private final Map<ServiceID, SvcReg> serviceByID = new ConcurrentHashMap<ServiceID, SvcReg>(80);
    private final Gauge<Integer> serviceByIdGauge = MetricUtils.sizeGauge(this.serviceByID);
    private final ConcurrentNavigableMap<SvcRegExpirationKey, SvcReg> serviceByTime = new FastConcurrentSkipListMap<SvcRegExpirationKey, SvcReg>();
    private final Gauge<Integer> serviceByTimeGauge = MetricUtils.sizeGauge(this.serviceByTime);
    private final HashMap<String, Map> serviceByTypeName = new HashMap(80);
    private final Gauge<Integer> serviceByTypeNameGauge = MetricUtils.sizeGauge(this.serviceByTypeName);
    private final HashMap<EntryClass, HashMap[]> serviceByAttr = new HashMap(200);
    private final Gauge<Integer> serviceByAttrGauge = MetricUtils.sizeGauge(this.serviceByAttr);
    private final HashMap<EntryClass, ArrayList> serviceByEmptyAttr = new HashMap(50);
    private final Gauge<Integer> serviceByEmptyAttrGauge = MetricUtils.sizeGauge(this.serviceByEmptyAttr);
    private final ArrayList<EntryClass> entryClasses = new ArrayList();
    private final Gauge<Integer> entryClassesGauge = MetricUtils.sizeGauge(this.entryClasses);
    private final Map<Long, EventReg> eventByID = new ConcurrentHashMap<Long, EventReg>(100);
    private final Gauge<Integer> eventByIDGauge = MetricUtils.sizeGauge(this.eventByID);
    private final ConcurrentNavigableMap eventByTime = new FastConcurrentSkipListMap();
    private final Gauge<Integer> eventByTimeGauge = MetricUtils.sizeGauge(this.eventByTime);
    private final Map<ServiceID, Object> subEventByService = new ConcurrentHashMap<ServiceID, Object>(100);
    private final Gauge<Integer> subEventByServiceGauge = MetricUtils.sizeGauge(this.subEventByService);
    private final Map<Long, EventReg> subEventByID = new ConcurrentHashMap<Long, EventReg>(100);
    private final Gauge<Integer> subEventByIDGauge = MetricUtils.sizeGauge(this.subEventByID);
    private final ConcurrentHashMap<Template, ConcurrentHashMap<ServiceID, Item>> lookupServiceCache = new ConcurrentHashMap(500);
    private final Gauge<Integer> lookupServiceCacheGauge = MetricUtils.sizeGauge(this.lookupServiceCache);
    private boolean useCacheForSpaceMiss = true;
    private UuidGenerator resourceIdGenerator;
    private UuidGenerator serviceIdGenerator = this.resourceIdGenerator = new UuidGenerator();
    private long eventID = 0L;
    private final Random random = new Random();
    private ProxyPreparer listenerPreparer;
    private ProxyPreparer locatorPreparer = this.listenerPreparer = new BasicProxyPreparer();
    private int maxEventsPerEventReg;
    private Map<EventReg, List<RegistrarEvent>> pendingQ;
    private Map<EventReg, List<RegistrarEvent>> eventsQ;
    private volatile long maxServiceLease;
    private volatile long maxEventLease;
    private DiscoveryManagement discoer;
    private JoinManager joiner;
    private TaskManager taskerEvent;
    private ExecutorService taskerComm;
    private Thread serviceExpirer;
    private Thread eventExpirer;
    private UnicastThread unicaster;
    private Thread multicaster;
    private Thread announcer;
    private final ReadersWriter concurrentObj = new ReadersWriter();
    private ServiceType objectServiceType;
    private final boolean recoveredSnapshot = false;
    private long minMaxServiceLease = 60000L;
    private long minMaxEventLease = 1800000L;
    private long minRenewalInterval = 100L;
    private int unicastPort = 0;
    private final ReadWriteLock unicastPortRWL = new ReentrantReadWriteLock();
    private volatile String[] memberGroups = BootUtil.toArray((String)SystemInfo.singleton().lookup().groups());
    private final ReadWriteLock memberGroupRWL = new ReentrantReadWriteLock();
    private String[] lookupGroups = LookupGroups.none();
    private final ReadWriteLock lookupGroupsRWL = new ReentrantReadWriteLock();
    private LookupLocator[] lookupLocators = BootUtil.toLookupLocators((String)SystemInfo.singleton().lookup().locators());
    private final ReadWriteLock lookupLocatorsRWL = new ReentrantReadWriteLock();
    private Entry[] lookupAttrs;
    private long multicastAnnouncementInterval = 120000L;
    private volatile long announcementSeqNo = 0L;
    private NetworkInterface[] multicastInterfaces;
    private boolean multicastInterfacesSpecified;
    private int multicastInterfaceRetryInterval = 300000;
    private Discovery protocol2;
    private InvocationConstraints rawUnicastDiscoveryConstraints;
    private DiscoveryConstraints multicastRequestConstraints;
    private DiscoveryConstraints multicastAnnouncementConstraints;
    private DiscoveryConstraints unicastDiscoveryConstraints;
    private ClientSubjectChecker multicastRequestSubjectChecker;
    private volatile long unexportTimeout = 120000L;
    private volatile long unexportWait = 1000L;
    private ClientSubjectChecker unicastDiscoverySubjectChecker;
    private final ReadyState ready = new ReadyState();
    private final LongCounter items = new LongCounter();
    private final LongCounter listeners = new LongCounter();
    private final LongCounter pendingEvents = new LongCounter();
    private MetricManager metricManager;
    private MetricRegistrator metricRegistrator;
    private final InetAddress host;
    private static final float LOAD_FACTOR = 1.75f;
    private volatile long registerMaxDuration = 0L;
    private volatile long lookupMaxDuration = 0L;
    private volatile long lookupMaxMatchesMaxDuration = 0L;
    private volatile long notifyMaxDuration = 0L;
    private volatile long getEntryClassesMaxDuration = 0L;
    private volatile long getFieldValuesMaxDuration = 0L;
    private volatile long getServiceTypesMaxDuration = 0L;
    private volatile long getLocatorMaxDuration = 0L;
    private volatile long addAttributesMaxDuration = 0L;
    private volatile long modifyAttributesMaxDuration = 0L;
    private volatile long setAttributesMaxDuration = 0L;
    private volatile long cacncelServiceLeaseMaxDuration = 0L;
    private volatile long renewServiceLeaseMaxDuration = 0L;
    private volatile long cancelEventLeaseMaxDuration = 0L;
    private volatile long renewEventLeaseMaxDuration = 0L;
    private volatile long renewLeasesMaxDuration = 0L;
    private volatile long cancelLeasesMaxDuration = 0L;
    private volatile long getLookupAttributesMaxDuration = 0L;
    private volatile long addLookupAttributesMaxDuration = 0L;
    private volatile long modifyLookupAttributesMaxDuration = 0L;
    private volatile long getLookupGroupsMaxDuration = 0L;
    private volatile long addLookupGroupsMaxDuration = 0L;
    private volatile long removeLookupGroupsMaxDuration = 0L;
    private volatile long setLookupGroupsMaxDuration = 0L;
    private volatile long getLookupLocatorMaxDuration = 0L;
    private volatile long addLookupLocatorMaxDuration = 0L;
    private volatile long removeLookupLocatorMaxDuration = 0L;
    private volatile long setLookupLocatorMaxDuration = 0L;
    private volatile long addMembersGroupsMaxDuration = 0L;
    private volatile long removeMembersGroupsMaxDuration = 0L;
    private volatile long getMembersGroupsMaxDuration = 0L;
    private volatile long setMembersGroupsMaxDuration = 0L;
    private volatile long getUnicastPortMaxDuration = 0L;
    private volatile long setUnicastPortMaxDuration = 0L;
    private static final String CLUSTED_PROXY_CLASSNAME;
    private static final String CONTAINER_PROXY_CLASSNAME = "com.j_spaces.core.JSpaceContainerProxy";
    private static final String SERVICE_CLASSNAME;
    private static ServiceType SERVICE_SERVICE_TYPE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isActive() {
        Object object = _lock;
        synchronized (object) {
            return isActive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void activate() {
        Object object = _lock;
        synchronized (object) {
            if (isActive) {
                throw new UnsupportedOperationException("Another Lookup Service is already active");
            }
            isActive = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deactivate() {
        Object object = _lock;
        synchronized (object) {
            isActive = false;
        }
    }

    public GigaRegistrar(String[] configArgs, final LifeCycle lifeCycle) throws Exception {
        try {
            GigaRegistrar.activate();
            this.metricManager = MetricManager.acquire();
            this.metricRegistrator = this.metricManager.createRegistrator("lus");
            final Configuration config = ConfigurationProvider.getInstance((String[])configArgs, (ClassLoader)this.getClass().getClassLoader());
            this.loginContext = (LoginContext)config.getEntry(COMPONENT, "loginContext", LoginContext.class, null);
            this.host = SystemInfo.singleton().network().getHost();
            PrivilegedExceptionAction init = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    GigaRegistrar.this.init(config, lifeCycle);
                    return null;
                }
            };
            if (this.loginContext != null) {
                this.loginContext.login();
                try {
                    Subject.doAsPrivileged(this.loginContext.getSubject(), init, null);
                }
                catch (PrivilegedActionException e) {
                    throw e.getCause();
                }
            } else {
                init.run();
            }
            this.registerMetrics(this.metricRegistrator);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Reggie initialization failed", t);
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw (Error)t;
        }
    }

    private void registerMetrics(MetricRegistrator registrator) {
        registrator.register("listeners", this.listeners);
        registrator.register("pendingEvents", this.pendingEvents);
        registrator.register("items", this.items);
        registrator.register("serviceById", this.serviceByIdGauge);
        registrator.register("serviceByTime", this.serviceByTimeGauge);
        registrator.register("serviceByTypeName", this.serviceByTypeNameGauge);
        registrator.register("serviceByAttr", this.serviceByAttrGauge);
        registrator.register("serviceByEmptyAttr", this.serviceByEmptyAttrGauge);
        registrator.register("entryClasses", this.entryClassesGauge);
        registrator.register("eventByID", this.eventByIDGauge);
        registrator.register("eventByTime", this.eventByTimeGauge);
        registrator.register("subEventByService", this.subEventByServiceGauge);
        registrator.register("subEventByID", this.subEventByIDGauge);
        registrator.register("lookupServiceCache", this.lookupServiceCacheGauge);
        MetricManager.registerThreadPoolMetrics(registrator.extend("comm-task-pool"), (DynamicThreadPoolExecutor)this.taskerComm);
        MetricManager.registerTaskManagerMetrics(registrator.extend("event-task-pool"), this.taskerEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpEventQueueState(PrintWriter writer) {
        try {
            this.concurrentObj.readLock();
        }
        catch (ReadersWriter.ConcurrentLockException e) {
            return;
        }
        try {
            boolean hasElements = false;
            writer.append("\nEvents Queue:");
            writer.append("\n- registered listeners: " + this.listeners.getCount());
            writer.append("\n- event listeners: " + this.eventsQ.size());
            writer.append("\n- listeners with pending events:");
            int max = 0;
            double avg = 0.0;
            for (Map.Entry<EventReg, List<RegistrarEvent>> entry : this.eventsQ.entrySet()) {
                int size = entry.getValue().size();
                if (size == 0) continue;
                writer.append("\n--- " + entry.getKey() + "\t has (" + size + ") pending events");
                hasElements = true;
                max = Math.max(max, size);
                avg += (double)size;
            }
            if (hasElements) {
                writer.append("\n--- max=(" + max + "), avg=(" + String.format("%.2f", avg / (double)this.eventsQ.size()) + ") pending events");
            } else {
                writer.append(" 0");
            }
            writer.println();
            writer.append("\nTask Manager:");
            writer.append("\n- threads: " + this.taskerEvent.getThreadCount() + ", max: " + this.taskerEvent.getMaxThreads() + ", running: " + this.taskerEvent.getRunningThreadCount());
            writer.append("\n- total tasks: " + this.taskerEvent.getTotalTasks());
            List<TaskManager.Task> pending = this.taskerEvent.getPending();
            if (!pending.isEmpty()) {
                writer.append("\n- tasks pending execution:");
                for (TaskManager.Task task : pending) {
                    EventReg reg = ((EventTask)task).reg;
                    writer.append("\n--- " + reg);
                }
            }
            writer.println();
        }
        finally {
            this.concurrentObj.readUnlock();
        }
    }

    private void destroyImpl() {
        long now = SystemTime.timeMillis();
        long endTime = now + this.unexportTimeout;
        if (endTime < 0L) {
            endTime = Long.MAX_VALUE;
        }
        boolean unexported = false;
        while (!unexported && now < endTime) {
            unexported = this.serverExporter.unexport(false);
            if (unexported) continue;
            try {
                long sleepTime = Math.min(this.unexportWait, endTime - now);
                Thread.sleep(sleepTime);
                now = SystemTime.timeMillis();
            }
            catch (InterruptedException e) {
                logger.log(Levels.HANDLED, "exception during unexport wait", e);
            }
        }
        if (!unexported) {
            this.serverExporter.unexport(true);
        }
        this.serviceExpirer.interrupt();
        this.eventExpirer.interrupt();
        this.unicaster.interrupt();
        if (this.multicaster != null) {
            this.multicaster.interrupt();
        }
        if (this.announcer != null) {
            this.announcer.interrupt();
        }
        List<Runnable> pending = this.taskerComm.shutdownNow();
        this.taskerEvent.terminate();
        this.joiner.terminate();
        this.discoer.terminate();
        try {
            this.serviceExpirer.join();
            this.eventExpirer.join();
            this.unicaster.join();
            if (this.multicaster != null) {
                this.multicaster.join();
            }
            if (this.announcer != null) {
                this.announcer.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.closeRequestSockets(pending);
        if (this.lifeCycle != null) {
            this.lifeCycle.unregister((Object)this);
        }
        if (this.loginContext != null) {
            try {
                this.loginContext.logout();
            }
            catch (LoginException e) {
                logger.log(Level.INFO, "logout failed", e);
            }
        }
        GigaRegistrar.deactivate();
        logger.info("Reggie shutdown completed");
    }

    public Object getServiceProxy() throws NoSuchObjectException {
        this.ready.check();
        return this.proxy;
    }

    public Object getProxy() {
        return this.myRef;
    }

    public TrustVerifier getProxyVerifier() throws NoSuchObjectException {
        this.ready.check();
        return new ProxyVerifier(this.myRef, this.myServiceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceRegistration register(Item nitem, long leaseDuration) throws NoSuchObjectException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        this.concurrentObj.writeLock();
        try {
            this.ready.check();
            ServiceRegistration reg = this.registerDo(nitem, leaseDuration);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "registered instance of {0} as {1} with lease of {2} ms", new Object[]{nitem.serviceType.getName(), reg.getServiceID(), reg.getLease().getExpiration() - SystemTime.timeMillis()});
            }
            ServiceRegistration serviceRegistration = reg;
            return serviceRegistration;
        }
        finally {
            this.concurrentObj.writeUnlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.registerMaxDuration) {
                    this.registerMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.registerMaxDuration + "]");
            }
        }
    }

    @Override
    public ServiceDetails serviceDetails(ServiceID serviceID) throws RemoteException {
        SvcReg svcReg = this.serviceByID.get(serviceID);
        if (svcReg == null) {
            return new ServiceDetails(this.myServiceID, false, -1L);
        }
        return new ServiceDetails(this.myServiceID, true, svcReg.registrationTime);
    }

    @Override
    public MarshalledWrapper lookup(Template tmpl) throws NoSuchObjectException {
        Item item;
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        if ((item = this.lookupItem(tmpl)) == null) {
            return null;
        }
        if (loggerStats.isLoggable(Level.FINEST)) {
            long duration = SystemTime.timeMillis() - startTime;
            if (duration > this.lookupMaxDuration) {
                this.lookupMaxDuration = duration;
            }
            loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.lookupMaxDuration + "]");
        }
        return item.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Item lookupItem(Template tmpl) throws NoSuchObjectException {
        Item item;
        ConcurrentHashMap<ServiceID, Item> items;
        block24: {
            if (loggerCache.isLoggable(Level.FINEST)) {
                loggerCache.finest("Lookup item for template: " + tmpl);
            }
            if ((items = this.lookupServiceCache.get(tmpl)) != null) {
                Item retVal = null;
                try {
                    Collection<Item> values = items.values();
                    int size = values.size();
                    if (size > 0) {
                        int index = this.random.nextInt(size);
                        Iterator<Item> it = values.iterator();
                        int i = 0;
                        while (it.hasNext()) {
                            retVal = it.next();
                            if (i == index) {
                                if (loggerCache.isLoggable(Level.FINEST)) {
                                    loggerCache.finest("Cache hit for template: " + tmpl + ", index [" + index + "] out of [" + size + "]");
                                }
                                return retVal;
                            }
                            ++i;
                        }
                        if (retVal != null) {
                            if (loggerCache.isLoggable(Level.FINEST)) {
                                loggerCache.finest("Cache hit for template: " + tmpl + ", index [0] out of [" + size + "]");
                            }
                            return retVal;
                        }
                    }
                }
                catch (NoSuchElementException e) {
                    if (retVal == null) break block24;
                    return retVal;
                }
            }
        }
        if (this.useCacheForSpaceMiss && tmpl.serviceTypes != null && tmpl.serviceTypes.length == 1 && tmpl.serviceTypes[0].getName().equals(SERVICE_CLASSNAME) && tmpl.attributeSetTemplates != null && tmpl.attributeSetTemplates.length < 5) {
            if (loggerCache.isLoggable(Level.FINEST)) {
                loggerCache.finest("Cache hit (null) for template: " + tmpl);
            }
            return null;
        }
        this.concurrentObj.readLock();
        try {
            items = this.lookupServiceCache.get(tmpl);
            if (items != null && !items.isEmpty()) {
                if (loggerCache.isLoggable(Level.FINEST)) {
                    loggerCache.finest("Cache hit for template: " + tmpl);
                }
                try {
                    Iterator<Item> it = items.values().iterator();
                    if (it.hasNext()) {
                        Item item2 = it.next();
                        return item2;
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            this.ready.check();
            item = this.lookupDo(tmpl);
            if (item != null) {
                if (loggerCache.isLoggable(Level.FINEST)) {
                    loggerCache.finest("Adding to cache template (on miss): " + tmpl + "\n   ---- > " + item.serviceID + " " + item.serviceType);
                }
                if ((items = this.lookupServiceCache.get(tmpl)) == null) {
                    items = new SizeConcurrentHashMap<ServiceID, Item>(1);
                    this.lookupServiceCache.put(tmpl, items);
                }
                items.put(item.serviceID, item);
            }
        }
        finally {
            this.concurrentObj.readUnlock();
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Matches lookup(Template tmpl, int maxMatches) throws NoSuchObjectException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        if (maxMatches == 1) {
            ArrayList<Item> items = new ArrayList<Item>();
            Item item = this.lookupItem(tmpl);
            if (item != null) {
                items.add(item);
            }
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.lookupMaxMatchesMaxDuration) {
                    this.lookupMaxMatchesMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.lookupMaxMatchesMaxDuration + "]\t\tMAX MATCHES [1]");
            }
            return new Matches(items, items.size());
        }
        this.concurrentObj.readLock();
        try {
            this.ready.check();
            Matches matches = this.lookupDo(tmpl, maxMatches);
            return matches;
        }
        finally {
            this.concurrentObj.readUnlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.lookupMaxMatchesMaxDuration) {
                    this.lookupMaxMatchesMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.lookupMaxMatchesMaxDuration + "]\t\tMAX MATCHES [" + maxMatches + "]");
            }
        }
    }

    @Override
    public RegistrarEventRegistration notify(Template tmpl, int transitions, RemoteEventListener listener, MarshalledObject handback, long leaseDuration) throws RemoteException {
        return this.notify(tmpl, transitions, listener, handback, leaseDuration, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegistrarEventRegistration notify(Template tmpl, int transitions, RemoteEventListener listener, MarshalledObject handback, long leaseDuration, int notifyType) throws RemoteException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        this.concurrentObj.writeLock();
        try {
            this.ready.check();
            RegistrarEventRegistration reg = this.notifyDo(tmpl, transitions, listener, handback, leaseDuration, notifyType);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "registered event listener {0} as {1}", new Object[]{listener, ((ReferentUuid)reg.getLease()).getReferentUuid()});
            }
            RegistrarEventRegistration registrarEventRegistration = reg;
            return registrarEventRegistration;
        }
        finally {
            this.concurrentObj.writeUnlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.notifyMaxDuration) {
                    this.notifyMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.notifyMaxDuration + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntryClassBase[] getEntryClasses(Template tmpl) throws NoSuchObjectException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        this.concurrentObj.readLock();
        try {
            this.ready.check();
            EntryClassBase[] entryClassBaseArray = this.getEntryClassesDo(tmpl);
            return entryClassBaseArray;
        }
        finally {
            this.concurrentObj.readUnlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.getEntryClassesMaxDuration) {
                    this.getEntryClassesMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.getEntryClassesMaxDuration + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getFieldValues(Template tmpl, int setIndex, int field) throws NoSuchObjectException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        this.concurrentObj.readLock();
        try {
            this.ready.check();
            Object[] objectArray = this.getFieldValuesDo(tmpl, setIndex, field);
            return objectArray;
        }
        finally {
            this.concurrentObj.readUnlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.getFieldValuesMaxDuration) {
                    this.getFieldValuesMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.getFieldValuesMaxDuration + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceTypeBase[] getServiceTypes(Template tmpl, String prefix) throws NoSuchObjectException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        this.concurrentObj.readLock();
        try {
            this.ready.check();
            ServiceTypeBase[] serviceTypeBaseArray = this.getServiceTypesDo(tmpl, prefix);
            return serviceTypeBaseArray;
        }
        finally {
            this.concurrentObj.readUnlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.getServiceTypesMaxDuration) {
                    this.getServiceTypesMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.getServiceTypesMaxDuration + "]");
            }
        }
    }

    @Override
    public LookupLocator getLocator() throws NoSuchObjectException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        this.ready.check();
        if (loggerStats.isLoggable(Level.FINEST)) {
            long duration = SystemTime.timeMillis() - startTime;
            if (duration > this.getLocatorMaxDuration) {
                this.getLocatorMaxDuration = duration;
            }
            loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.getLocatorMaxDuration + "]");
        }
        return this.myLocator;
    }

    public Object getAdmin() throws NoSuchObjectException {
        this.ready.check();
        return AdminProxy.getInstance(this.myRef, this.myServiceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAttributes(ServiceID serviceID, Uuid leaseID, EntryRep[] attrSets) throws NoSuchObjectException, UnknownLeaseException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        try {
            this.concurrentObj.writeLock();
        }
        catch (ReadersWriter.ConcurrentLockException e) {
            return;
        }
        try {
            this.ready.check();
            if (serviceID.equals((Object)this.myServiceID)) {
                throw new SecurityException("privileged service id");
            }
            this.addAttributesDo(serviceID, leaseID, attrSets);
            this.queueEvents();
        }
        finally {
            this.concurrentObj.writeUnlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.addAttributesMaxDuration) {
                    this.addAttributesMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.addAttributesMaxDuration + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyAttributes(ServiceID serviceID, Uuid leaseID, EntryRep[] attrSetTmpls, EntryRep[] attrSets) throws NoSuchObjectException, UnknownLeaseException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        try {
            this.concurrentObj.writeLock();
        }
        catch (ReadersWriter.ConcurrentLockException e) {
            return;
        }
        try {
            this.ready.check();
            if (serviceID.equals((Object)this.myServiceID)) {
                throw new SecurityException("privileged service id");
            }
            this.modifyAttributesDo(serviceID, leaseID, attrSetTmpls, attrSets);
            this.queueEvents();
        }
        finally {
            this.concurrentObj.writeUnlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.modifyAttributesMaxDuration) {
                    this.modifyAttributesMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.modifyAttributesMaxDuration + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttributes(ServiceID serviceID, Uuid leaseID, EntryRep[] attrSets) throws NoSuchObjectException, UnknownLeaseException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        try {
            this.concurrentObj.writeLock();
        }
        catch (ReadersWriter.ConcurrentLockException e) {
            return;
        }
        try {
            this.ready.check();
            if (serviceID.equals((Object)this.myServiceID)) {
                throw new SecurityException("privileged service id");
            }
            this.setAttributesDo(serviceID, leaseID, attrSets);
            this.queueEvents();
        }
        finally {
            this.concurrentObj.writeUnlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.setAttributesMaxDuration) {
                    this.setAttributesMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.setAttributesMaxDuration + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelServiceLease(ServiceID serviceID, Uuid leaseID) throws NoSuchObjectException, UnknownLeaseException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        try {
            this.concurrentObj.writeLock();
        }
        catch (ReadersWriter.ConcurrentLockException e) {
            return;
        }
        try {
            this.ready.check();
            this.cancelServiceLeaseDo(serviceID, leaseID);
            this.queueEvents();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "cancelled service registration {0}", new Object[]{serviceID});
            }
        }
        finally {
            this.concurrentObj.writeUnlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.cacncelServiceLeaseMaxDuration) {
                    this.cacncelServiceLeaseMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.cacncelServiceLeaseMaxDuration + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long renewServiceLease(ServiceID serviceID, Uuid leaseID, long renewDuration) throws NoSuchObjectException, UnknownLeaseException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        try {
            this.ready.check();
            long l = this.renewServiceLeaseDo(serviceID, leaseID, renewDuration);
            return l;
        }
        finally {
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.renewServiceLeaseMaxDuration) {
                    this.renewServiceLeaseMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.renewServiceLeaseMaxDuration + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelEventLease(long eventID, Uuid leaseID) throws NoSuchObjectException, UnknownLeaseException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        try {
            this.concurrentObj.writeLock();
        }
        catch (ReadersWriter.ConcurrentLockException e) {
            return;
        }
        try {
            this.ready.check();
            this.cancelEventLeaseDo(eventID, leaseID);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "cancelled event registration {0}", new Object[]{leaseID});
            }
        }
        finally {
            this.concurrentObj.writeUnlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.cancelEventLeaseMaxDuration) {
                    this.cancelEventLeaseMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.cancelEventLeaseMaxDuration + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long renewEventLease(long eventID, Uuid leaseID, long renewDuration) throws NoSuchObjectException, UnknownLeaseException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        try {
            this.ready.check();
            long l = this.renewEventLeaseDo(eventID, leaseID, renewDuration);
            return l;
        }
        finally {
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.renewEventLeaseMaxDuration) {
                    this.renewEventLeaseMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.renewEventLeaseMaxDuration + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RenewResults renewLeases(Object[] regIDs, Uuid[] leaseIDs, long[] renewDurations) throws NoSuchObjectException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        try {
            this.ready.check();
            RenewResults renewResults = this.renewLeasesDo(regIDs, leaseIDs, renewDurations);
            return renewResults;
        }
        finally {
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.renewLeasesMaxDuration) {
                    this.renewLeasesMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.renewLeasesMaxDuration + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Exception[] cancelLeases(Object[] regIDs, Uuid[] leaseIDs) throws NoSuchObjectException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        this.concurrentObj.writeLock();
        try {
            this.ready.check();
            Exception[] exceptions = this.cancelLeasesDo(regIDs, leaseIDs);
            this.queueEvents();
            if (logger.isLoggable(Level.FINE)) {
                for (int i = 0; i < regIDs.length; ++i) {
                    if (exceptions != null && exceptions[i] != null) continue;
                    if (regIDs[i] instanceof ServiceID) {
                        logger.log(Level.FINE, "cancelled service registration {0}", new Object[]{regIDs[i]});
                        continue;
                    }
                    logger.log(Level.FINE, "cancelled event registration {0}", new Object[]{leaseIDs[i]});
                }
            }
            Exception[] exceptionArray = exceptions;
            return exceptionArray;
        }
        finally {
            this.concurrentObj.writeUnlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.cancelLeasesMaxDuration) {
                    this.cancelLeasesMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.cancelLeasesMaxDuration + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry[] getLookupAttributes() throws NoSuchObjectException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        this.concurrentObj.readLock();
        try {
            this.ready.check();
            Entry[] entryArray = this.lookupAttrs;
            return entryArray;
        }
        finally {
            this.concurrentObj.readUnlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.getLookupAttributesMaxDuration) {
                    this.getLookupAttributesMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.getLookupAttributesMaxDuration + "]");
            }
        }
    }

    public void addLookupAttributes(Entry[] attrSets) throws RemoteException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        try {
            this.concurrentObj.writeLock();
        }
        catch (ReadersWriter.ConcurrentLockException e) {
            return;
        }
        try {
            this.ready.check();
            EntryRep[] attrs = EntryRep.toEntryRep(attrSets, true);
            this.addAttributesDo(this.myServiceID, myLeaseID, attrs);
            this.joiner.addAttributes(attrSets);
            this.lookupAttrs = this.joiner.getAttributes();
            this.queueEvents();
        }
        catch (UnknownLeaseException e) {
            throw new AssertionError((Object)"Self-registration never expires");
        }
        finally {
            this.concurrentObj.writeUnlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.addLookupAttributesMaxDuration) {
                    this.addLookupAttributesMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.addLookupAttributesMaxDuration + "]");
            }
        }
    }

    public void modifyLookupAttributes(Entry[] attrSetTemplates, Entry[] attrSets) throws RemoteException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        try {
            this.concurrentObj.writeLock();
        }
        catch (ReadersWriter.ConcurrentLockException e) {
            return;
        }
        try {
            this.ready.check();
            EntryRep[] tmpls = EntryRep.toEntryRep(attrSetTemplates, false);
            EntryRep[] attrs = EntryRep.toEntryRep(attrSets, false);
            this.modifyAttributesDo(this.myServiceID, myLeaseID, tmpls, attrs);
            this.joiner.modifyAttributes(attrSetTemplates, attrSets, true);
            this.lookupAttrs = this.joiner.getAttributes();
            this.queueEvents();
        }
        catch (UnknownLeaseException e) {
            throw new AssertionError((Object)"Self-registration never expires");
        }
        finally {
            this.concurrentObj.writeUnlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.modifyLookupAttributesMaxDuration) {
                    this.modifyLookupAttributesMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.modifyLookupAttributesMaxDuration + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLookupGroups() throws NoSuchObjectException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        this.lookupGroupsRWL.readLock().lock();
        try {
            this.ready.check();
            String[] stringArray = this.lookupGroups;
            return stringArray;
        }
        finally {
            this.lookupGroupsRWL.readLock().unlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.getLookupGroupsMaxDuration) {
                    this.getLookupGroupsMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.getLookupGroupsMaxDuration + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLookupGroups(String[] groups) throws NoSuchObjectException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        this.lookupGroupsRWL.writeLock().lock();
        try {
            this.ready.check();
            DiscoveryGroupManagement dgm = (DiscoveryGroupManagement)((Object)this.discoer);
            try {
                dgm.addGroups(groups);
            }
            catch (IOException e) {
                throw new RuntimeException(e.toString());
            }
            this.lookupGroups = dgm.getGroups();
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "added lookup groups {0}", new Object[]{Arrays.asList(groups)});
            }
        }
        finally {
            this.lookupGroupsRWL.writeLock().unlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.addLookupGroupsMaxDuration) {
                    this.addLookupGroupsMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.addLookupGroupsMaxDuration + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLookupGroups(String[] groups) throws NoSuchObjectException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        this.lookupGroupsRWL.writeLock().lock();
        try {
            this.ready.check();
            DiscoveryGroupManagement dgm = (DiscoveryGroupManagement)((Object)this.discoer);
            dgm.removeGroups(groups);
            this.lookupGroups = dgm.getGroups();
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "removed lookup groups {0}", new Object[]{Arrays.asList(groups)});
            }
        }
        finally {
            this.lookupGroupsRWL.writeLock().unlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.removeLookupGroupsMaxDuration) {
                    this.removeLookupGroupsMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.removeLookupGroupsMaxDuration + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLookupGroups(String[] groups) throws NoSuchObjectException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        this.lookupGroupsRWL.writeLock().lock();
        try {
            this.ready.check();
            DiscoveryGroupManagement dgm = (DiscoveryGroupManagement)((Object)this.discoer);
            try {
                dgm.setGroups(groups);
            }
            catch (IOException e) {
                throw new RuntimeException(e.toString());
            }
            this.lookupGroups = dgm.getGroups();
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "set lookup groups {0}", new Object[]{groups != null ? Arrays.asList(groups) : null});
            }
        }
        finally {
            this.lookupGroupsRWL.writeLock().unlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.setLookupGroupsMaxDuration) {
                    this.setLookupGroupsMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.setLookupGroupsMaxDuration + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LookupLocator[] getLookupLocators() throws NoSuchObjectException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        this.lookupLocatorsRWL.readLock().lock();
        try {
            this.ready.check();
            LookupLocator[] lookupLocatorArray = this.lookupLocators;
            return lookupLocatorArray;
        }
        finally {
            this.lookupLocatorsRWL.readLock().unlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.getLookupLocatorMaxDuration) {
                    this.getLookupLocatorMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.getLookupLocatorMaxDuration + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLookupLocators(LookupLocator[] locators) throws RemoteException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        this.ready.check();
        locators = GigaRegistrar.prepareLocators(locators, this.locatorPreparer, false);
        this.lookupLocatorsRWL.writeLock().lock();
        try {
            this.ready.check();
            DiscoveryLocatorManagement dlm = (DiscoveryLocatorManagement)((Object)this.discoer);
            dlm.addLocators(locators);
            this.lookupLocators = dlm.getLocators();
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "added lookup locators {0}", new Object[]{Arrays.asList(locators)});
            }
        }
        finally {
            this.lookupLocatorsRWL.writeLock().unlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.addLookupLocatorMaxDuration) {
                    this.addLookupLocatorMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.addLookupLocatorMaxDuration + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLookupLocators(LookupLocator[] locators) throws RemoteException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        this.ready.check();
        locators = GigaRegistrar.prepareLocators(locators, this.locatorPreparer, false);
        this.lookupLocatorsRWL.writeLock().lock();
        try {
            this.ready.check();
            DiscoveryLocatorManagement dlm = (DiscoveryLocatorManagement)((Object)this.discoer);
            dlm.removeLocators(locators);
            this.lookupLocators = dlm.getLocators();
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "removed lookup locators {0}", new Object[]{Arrays.asList(locators)});
            }
        }
        finally {
            this.lookupLocatorsRWL.writeLock().unlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.removeLookupLocatorMaxDuration) {
                    this.removeLookupLocatorMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.removeLookupLocatorMaxDuration + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLookupLocators(LookupLocator[] locators) throws RemoteException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        this.ready.check();
        locators = GigaRegistrar.prepareLocators(locators, this.locatorPreparer, false);
        this.lookupLocatorsRWL.writeLock().lock();
        try {
            this.ready.check();
            DiscoveryLocatorManagement dlm = (DiscoveryLocatorManagement)((Object)this.discoer);
            dlm.setLocators(locators);
            this.lookupLocators = dlm.getLocators();
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "set lookup locators {0}", new Object[]{Arrays.asList(locators)});
            }
        }
        finally {
            this.lookupLocatorsRWL.writeLock().unlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.setLookupLocatorMaxDuration) {
                    this.setLookupLocatorMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.setLookupLocatorMaxDuration + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMemberGroups(String[] groups) throws NoSuchObjectException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        this.memberGroupRWL.writeLock().lock();
        try {
            this.ready.check();
            for (String group : groups) {
                if (GigaRegistrar.indexOf(this.memberGroups, group) >= 0) continue;
                this.memberGroups = (String[])GigaRegistrar.arrayAdd(this.memberGroups, group);
            }
            if (this.announcer != null) {
                Thread thread = this.announcer;
                synchronized (thread) {
                    this.announcer.notify();
                }
            }
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "added member groups {0}", new Object[]{Arrays.asList(groups)});
            }
        }
        finally {
            this.memberGroupRWL.writeLock().unlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long l = SystemTime.timeMillis() - startTime;
                if (l > this.addMembersGroupsMaxDuration) {
                    this.addMembersGroupsMaxDuration = l;
                }
                loggerStats.finest("DURATION [" + l + "]\t\tMAX [" + this.addMembersGroupsMaxDuration + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMemberGroups(String[] groups) throws NoSuchObjectException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        this.memberGroupRWL.writeLock().lock();
        try {
            this.ready.check();
            for (String group : groups) {
                int j = GigaRegistrar.indexOf(this.memberGroups, group);
                if (j < 0) continue;
                this.memberGroups = (String[])GigaRegistrar.arrayDel(this.memberGroups, j);
            }
            if (this.announcer != null) {
                Thread thread = this.announcer;
                synchronized (thread) {
                    this.announcer.notify();
                }
            }
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "removed member groups {0}", new Object[]{Arrays.asList(groups)});
            }
        }
        finally {
            this.memberGroupRWL.writeLock().unlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long l = SystemTime.timeMillis() - startTime;
                if (l > this.removeMembersGroupsMaxDuration) {
                    this.removeMembersGroupsMaxDuration = l;
                }
                loggerStats.finest("DURATION [" + l + "]\t\tMAX [" + this.removeMembersGroupsMaxDuration + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getMemberGroups() throws NoSuchObjectException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        this.memberGroupRWL.readLock().lock();
        try {
            this.ready.check();
            String[] stringArray = this.memberGroups;
            return stringArray;
        }
        finally {
            this.memberGroupRWL.readLock().unlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.getMembersGroupsMaxDuration) {
                    this.getMembersGroupsMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.getMembersGroupsMaxDuration + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMemberGroups(String[] groups) throws NoSuchObjectException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        this.memberGroupRWL.writeLock().lock();
        try {
            this.ready.check();
            this.memberGroups = (String[])GigaRegistrar.removeDups(groups);
            if (this.announcer != null) {
                Thread thread = this.announcer;
                synchronized (thread) {
                    this.announcer.notify();
                }
            }
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "set member groups {0}", new Object[]{Arrays.asList(groups)});
            }
        }
        finally {
            this.memberGroupRWL.writeLock().unlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.setMembersGroupsMaxDuration) {
                    this.setMembersGroupsMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.setMembersGroupsMaxDuration + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUnicastPort() throws NoSuchObjectException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        this.unicastPortRWL.readLock().lock();
        try {
            this.ready.check();
            int n = this.unicastPort;
            return n;
        }
        finally {
            this.unicastPortRWL.readLock().unlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.getUnicastPortMaxDuration) {
                    this.getUnicastPortMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.getUnicastPortMaxDuration + "]");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUnicastPort(int port) throws IOException {
        long startTime = 0L;
        if (loggerStats.isLoggable(Level.FINEST)) {
            startTime = SystemTime.timeMillis();
        }
        this.unicastPortRWL.writeLock().lock();
        try {
            this.ready.check();
            if (port == this.unicastPort) {
                return;
            }
            if (port == 0 && this.unicaster.port == Constants.getDiscoveryPort() || port == this.unicaster.port) {
                this.unicastPort = port;
                return;
            }
            UnicastThread newUnicaster = new UnicastThread(this.host, port);
            this.unicaster.interrupt();
            try {
                this.unicaster.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.unicaster = newUnicaster;
            this.unicaster.start();
            this.unicastPort = port;
            Object object = this.myLocator = this.proxy instanceof RemoteMethodControl ? new ConstrainableLookupLocator(this.myLocator.getHost(), this.unicaster.port, null) : new LookupLocator(this.myLocator.getHost(), this.unicaster.port);
            if (this.announcer != null) {
                Thread thread = this.announcer;
                synchronized (thread) {
                    this.announcer.notify();
                }
            }
            if (logger.isLoggable(Level.CONFIG)) {
                logger.log(Level.CONFIG, "changed unicast discovery port to {0}", new Object[]{this.unicaster.port});
            }
        }
        finally {
            this.unicastPortRWL.writeLock().unlock();
            if (loggerStats.isLoggable(Level.FINEST)) {
                long duration = SystemTime.timeMillis() - startTime;
                if (duration > this.setUnicastPortMaxDuration) {
                    this.setUnicastPortMaxDuration = duration;
                }
                loggerStats.finest("DURATION [" + duration + "]\t\tMAX [" + this.setUnicastPortMaxDuration + "]");
            }
        }
    }

    public void destroy() throws RemoteException {
        this.metricRegistrator.clear();
        this.metricManager.close();
        try {
            this.concurrentObj.priorityWriteLock();
        }
        catch (ReadersWriter.ConcurrentLockException e) {
            return;
        }
        try {
            this.ready.check();
            logger.info("starting Reggie shutdown");
            this.ready.shutdown();
            Thread destroyThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    GigaRegistrar.this.destroyImpl();
                }
            });
            destroyThread.setName("destroy");
            destroyThread.setDaemon(false);
            destroyThread.start();
        }
        finally {
            this.concurrentObj.writeUnlock();
        }
    }

    private static Object[] arrayAdd(Object[] array, Object elt) {
        int len = array.length;
        Object[] narray = (Object[])Array.newInstance(array.getClass().getComponentType(), len + 1);
        System.arraycopy(array, 0, narray, 0, len);
        narray[len] = elt;
        return narray;
    }

    private static Object[] arrayDel(Object[] array, int i) {
        int len = array.length - 1;
        Object[] narray = (Object[])Array.newInstance(array.getClass().getComponentType(), len);
        System.arraycopy(array, 0, narray, 0, i);
        System.arraycopy(array, i + 1, narray, i, len - i);
        return narray;
    }

    private static int indexOf(Object[] array, Object elt) {
        return GigaRegistrar.indexOf(array, array.length, elt);
    }

    private static int indexOf(Object[] array, int len, Object elt) {
        for (int i = 0; i < len; ++i) {
            if (!elt.equals(array[i])) continue;
            return i;
        }
        return -1;
    }

    private static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    private static boolean overlap(Object[] arr1, Object[] arr2) {
        int i = arr1.length;
        while (--i >= 0) {
            if (GigaRegistrar.indexOf(arr2, arr1[i]) < 0) continue;
            return true;
        }
        return false;
    }

    private static boolean allNull(Object[] array) {
        int i = array.length;
        while (--i >= 0) {
            if (array[i] == null) continue;
            return false;
        }
        return true;
    }

    private static Object[] removeDups(Object[] arr) {
        int i = arr.length;
        while (--i >= 0) {
            if (GigaRegistrar.indexOf(arr, i, arr[i]) < 0) continue;
            arr = GigaRegistrar.arrayDel(arr, i);
        }
        return arr;
    }

    private static EntryRep[] deleteSet(Item item, int i) {
        item.attributeSets = (EntryRep[])GigaRegistrar.arrayDel(item.attributeSets, i);
        return item.attributeSets;
    }

    private static Item copyItem(Item item) {
        item = (Item)item.clone();
        item.serviceType = null;
        item.codebase = null;
        EntryRep[] attrSets = item.attributeSets;
        int i = attrSets.length;
        while (--i >= 0) {
            attrSets[i].eclass = attrSets[i].eclass.getReplacement();
        }
        return item;
    }

    private static EntryClass getDefiningClass(EntryClass eclass, int fldidx) {
        EntryClass sup;
        while ((sup = eclass.getSuperclass()).getNumFields() > fldidx) {
            eclass = sup;
        }
        return eclass;
    }

    private void addServiceByTypes(ServiceType type, SvcReg reg) {
        HashMap<ServiceID, SvcReg> map = this.serviceByTypeName.get(type.getName());
        if (map == null) {
            map = new HashMap<ServiceID, SvcReg>();
            this.serviceByTypeName.put(type.getName(), map);
        }
        map.put(reg.item.serviceID, reg);
        ServiceType[] ifaces = type.getInterfaces();
        int i = ifaces.length;
        while (--i >= 0) {
            this.addServiceByTypes(ifaces[i], reg);
        }
        ServiceType sup = type.getSuperclass();
        if (sup != null) {
            this.addServiceByTypes(sup, reg);
        }
    }

    private void deleteServiceFromTypes(ServiceType type, SvcReg reg) {
        Map map = this.serviceByTypeName.get(type.getName());
        if (map != null) {
            map.remove(reg.item.serviceID);
            if (map.isEmpty() && !type.equals(this.objectServiceType)) {
                this.serviceByTypeName.remove(type.getName());
            }
            ServiceType[] ifaces = type.getInterfaces();
            int j = ifaces.length;
            while (--j >= 0) {
                this.deleteServiceFromTypes(ifaces[j], reg);
            }
            ServiceType sup = type.getSuperclass();
            if (sup != null) {
                this.deleteServiceFromTypes(sup, reg);
            }
        }
    }

    private static boolean matchItem(Template tmpl, Item item) {
        return (tmpl.serviceID == null || tmpl.serviceID.equals((Object)item.serviceID)) && GigaRegistrar.matchType(tmpl.serviceTypes, item.serviceType) && GigaRegistrar.matchAttributes(tmpl, item);
    }

    private static boolean matchType(ServiceType[] types, ServiceType type) {
        if (types != null) {
            int i = types.length;
            while (--i >= 0) {
                if (types[i].isAssignableFrom(type)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean matchEntry(EntryRep tmpl, EntryRep entry) {
        if (!tmpl.eclass.isAssignableFrom(entry.eclass) || tmpl.fields.length > entry.fields.length) {
            return false;
        }
        int i = tmpl.fields.length;
        while (--i >= 0) {
            if (tmpl.fields[i] == null || tmpl.fields[i].equals(entry.fields[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean matchAttributes(Template tmpl, Item item) {
        EntryRep[] tmpls = tmpl.attributeSetTemplates;
        if (tmpls != null) {
            EntryRep[] entries = item.attributeSets;
            int i = tmpls.length;
            block0: while (--i >= 0) {
                EntryRep etmpl = tmpls[i];
                int j = entries.length;
                while (--j >= 0) {
                    if (!GigaRegistrar.matchEntry(etmpl, entries[j])) continue;
                    continue block0;
                }
                return false;
            }
        }
        return true;
    }

    private static boolean attrMatch(EntryRep[] tmpls, EntryRep attrSet) {
        boolean good = true;
        if (tmpls != null) {
            int i = tmpls.length;
            while (--i >= 0) {
                EntryRep tmpl = tmpls[i];
                if (!GigaRegistrar.matchEntry(tmpl, attrSet)) continue;
                if (tmpl.eclass.isAssignableFrom(attrSet.eclass) && !tmpl.eclass.equals(attrSet.eclass)) {
                    return true;
                }
                good = false;
            }
        }
        return good;
    }

    private static boolean hasAttr(SvcReg reg, EntryClass eclass, int fldidx, Object value) {
        EntryRep[] sets = reg.item.attributeSets;
        int i = sets.length;
        while (--i >= 0) {
            EntryRep set = sets[i];
            if (!eclass.isAssignableFrom(set.eclass) || (value != null || set.fields[fldidx] != null) && (value == null || !value.equals(set.fields[fldidx]))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasEmptyAttr(SvcReg reg, EntryClass eclass) {
        EntryRep[] sets = reg.item.attributeSets;
        int i = sets.length;
        while (--i >= 0) {
            if (!eclass.equals(sets[i].eclass)) continue;
            return true;
        }
        return false;
    }

    private static void addTypes(ArrayList<ServiceType> types, ArrayList<String> codebases, ServiceType[] bases, String prefix, ServiceType type, String codebase) {
        if (types.contains(type)) {
            return;
        }
        if (bases != null) {
            int i = bases.length;
            while (--i >= 0) {
                if (!type.isAssignableFrom(bases[i])) continue;
                return;
            }
        }
        if (prefix == null || type.getName().startsWith(prefix)) {
            types.add(type);
            codebases.add(codebase);
            return;
        }
        ServiceType[] ifs = type.getInterfaces();
        int i = ifs.length;
        while (--i >= 0) {
            GigaRegistrar.addTypes(types, codebases, bases, prefix, ifs[i], codebase);
        }
        ServiceType sup = type.getSuperclass();
        if (sup != null) {
            GigaRegistrar.addTypes(types, codebases, bases, prefix, sup, codebase);
        }
    }

    private static long limitDuration(long leaseDuration, long limit) {
        if (leaseDuration == -1L || leaseDuration > limit) {
            leaseDuration = limit;
        } else if (leaseDuration < 0L) {
            throw new IllegalArgumentException("negative lease duration");
        }
        return leaseDuration;
    }

    private static LookupLocator[] prepareLocators(LookupLocator[] locators, ProxyPreparer preparer, boolean tolerateFailures) throws RemoteException {
        ArrayList<LookupLocator> l = new ArrayList<LookupLocator>();
        for (LookupLocator locator : locators) {
            try {
                l.add((LookupLocator)preparer.prepareProxy((Object)locator));
            }
            catch (Exception e) {
                if (!tolerateFailures) {
                    if (e instanceof RemoteException) {
                        throw (RemoteException)e;
                    }
                    throw (RuntimeException)e;
                }
                if (!logger.isLoggable(Level.WARNING)) continue;
                GigaRegistrar.logThrow(Level.WARNING, GigaRegistrar.class.getName(), "prepareLocators", "failed to prepare lookup locator {0}", new Object[]{locator}, e);
            }
        }
        return l.toArray(new LookupLocator[l.size()]);
    }

    private static void logThrow(Level level, String className, String methodName, String message, Object[] args, Throwable thrown) {
        LogRecord lr = new LogRecord(level, message);
        lr.setLoggerName(logger.getName());
        lr.setSourceClassName(className);
        lr.setSourceMethodName(methodName);
        lr.setParameters(args);
        lr.setThrown(thrown);
        logger.log(lr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addService(SvcReg reg) {
        this.items.inc();
        SvcReg svcReg = reg;
        synchronized (svcReg) {
            this.serviceByID.put(reg.item.serviceID, reg);
            if (loggerServiceExpire.isLoggable(Level.FINE)) {
                loggerServiceExpire.fine("[" + System.identityHashCode(reg) + "]: Service [" + reg.item.serviceID + "]: Registered with lease [" + reg.leaseID + "/" + reg.leaseExpiration + "], type [" + reg.item.serviceType.getName());
            }
            this.serviceByTime.put(new SvcRegExpirationKey(reg, reg.leaseExpiration), reg);
            this.addServiceByTypes(reg.item.serviceType, reg);
            EntryRep[] entries = reg.item.attributeSets;
            int i = entries.length;
            while (--i >= 0) {
                this.addAttrs(reg, entries[i]);
            }
            this.refreshServiceFromLookupCache(reg.item, false);
            this.computeMaxLeases();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteService(SvcRegExpirationKey regExpKey, SvcReg reg, long now) {
        this.items.dec();
        SvcReg svcReg = reg;
        synchronized (svcReg) {
            Item item = reg.item;
            this.generateEvents(item, null, now);
            this.serviceByID.remove(item.serviceID);
            if (loggerServiceExpire.isLoggable(Level.FINE)) {
                loggerServiceExpire.fine("[" + System.identityHashCode(reg) + "]: Service [" + reg.item.serviceID + "]: Deleting with lease [" + reg.leaseID + "/" + reg.leaseExpiration + "]");
            }
            if (regExpKey != null) {
                this.serviceByTime.remove(regExpKey);
            } else {
                this.serviceByTime.remove(new SvcRegExpirationKey(reg, reg.leaseExpiration));
            }
            this.deleteServiceFromTypes(item.serviceType, reg);
            EntryRep[] entries = item.attributeSets;
            int i = entries.length;
            while (--i >= 0) {
                this.deleteAttrs(reg, entries[i], false);
            }
            this.refreshServiceFromLookupCache(item, true);
            this.computeMaxLeases();
        }
    }

    private void refreshServiceFromLookupCache(Item item, boolean delete) {
        Template tmpl;
        EntryRep[] attrsSetTemplate;
        if (loggerCache.isLoggable(Level.FINEST)) {
            if (delete) {
                loggerCache.finest("Delete item: " + item.serviceID + ", " + item.serviceType + ", " + this.asList(item.attributeSets));
            } else {
                loggerCache.finest("Refresh item: " + item.serviceID + ", " + item.serviceType + ", " + this.asList(item.attributeSets));
            }
        }
        for (ConcurrentHashMap<ServiceID, Item> items : this.lookupServiceCache.values()) {
            Item oldItem = items.remove(item.serviceID);
            if (oldItem == null || !loggerCache.isLoggable(Level.FINEST)) continue;
            loggerCache.finest("Removing from cache template (explicitly): " + item.serviceID + ", " + item.serviceType);
        }
        if (item.serviceType.getName().equals(CLUSTED_PROXY_CLASSNAME)) {
            attrsSetTemplate = new EntryRep[]{item.attributeSets[3], item.attributeSets[0], (EntryRep)item.attributeSets[6].clone()};
            attrsSetTemplate[2].fields[0] = null;
            attrsSetTemplate[2].fields[1] = null;
            tmpl = new Template(null, new ServiceType[]{SERVICE_SERVICE_TYPE}, attrsSetTemplate);
            this.deleteOrReplaceTemplate(item, delete, tmpl);
            attrsSetTemplate = new EntryRep[]{item.attributeSets[3], item.attributeSets[0]};
            tmpl = new Template(null, new ServiceType[]{SERVICE_SERVICE_TYPE}, attrsSetTemplate);
            this.deleteOrReplaceTemplate(item, delete, tmpl);
            attrsSetTemplate = new EntryRep[]{item.attributeSets[0], (EntryRep)item.attributeSets[6].clone()};
            attrsSetTemplate[1].fields[0] = null;
            attrsSetTemplate[1].fields[1] = null;
            tmpl = new Template(null, new ServiceType[]{SERVICE_SERVICE_TYPE}, attrsSetTemplate);
            this.deleteOrReplaceTemplate(item, delete, tmpl);
            attrsSetTemplate = new EntryRep[]{item.attributeSets[1], (EntryRep)item.attributeSets[6].clone()};
            attrsSetTemplate[1].fields[0] = null;
            attrsSetTemplate[1].fields[1] = null;
            tmpl = new Template(null, new ServiceType[]{SERVICE_SERVICE_TYPE}, attrsSetTemplate);
            this.deleteOrReplaceTemplate(item, delete, tmpl);
            attrsSetTemplate = new EntryRep[3];
            attrsSetTemplate[0] = (EntryRep)item.attributeSets[2].clone();
            attrsSetTemplate[0].fields[0] = null;
            attrsSetTemplate[0].fields[1] = null;
            attrsSetTemplate[1] = item.attributeSets[1];
            attrsSetTemplate[2] = (EntryRep)item.attributeSets[6].clone();
            attrsSetTemplate[2].fields[0] = null;
            attrsSetTemplate[2].fields[1] = null;
            tmpl = new Template(null, new ServiceType[]{SERVICE_SERVICE_TYPE}, attrsSetTemplate);
            this.deleteOrReplaceTemplate(item, delete, tmpl);
            attrsSetTemplate = new EntryRep[]{item.attributeSets[3], item.attributeSets[0], (EntryRep)item.attributeSets[6].clone()};
            attrsSetTemplate[2].fields[0] = null;
            attrsSetTemplate[2].fields[2] = null;
            tmpl = new Template(null, new ServiceType[]{SERVICE_SERVICE_TYPE}, attrsSetTemplate);
            this.deleteOrReplaceTemplate(item, delete, tmpl);
            attrsSetTemplate = new EntryRep[]{item.attributeSets[0], (EntryRep)item.attributeSets[6].clone()};
            attrsSetTemplate[1].fields[0] = null;
            attrsSetTemplate[1].fields[2] = null;
            tmpl = new Template(null, new ServiceType[]{SERVICE_SERVICE_TYPE}, attrsSetTemplate);
            this.deleteOrReplaceTemplate(item, delete, tmpl);
            if (item.attributeSets.length > 7) {
                attrsSetTemplate = new EntryRep[]{item.attributeSets[7]};
                tmpl = new Template(item.serviceID, new ServiceType[]{SERVICE_SERVICE_TYPE}, attrsSetTemplate);
                this.deleteOrReplaceTemplate(item, delete, tmpl);
                attrsSetTemplate = new EntryRep[]{item.attributeSets[7], item.attributeSets[2], item.attributeSets[1], (EntryRep)item.attributeSets[6].clone()};
                attrsSetTemplate[3].fields[1] = null;
                attrsSetTemplate[3].fields[2] = null;
                tmpl = new Template(null, new ServiceType[]{SERVICE_SERVICE_TYPE}, attrsSetTemplate);
                this.deleteOrReplaceTemplate(item, delete, tmpl);
                attrsSetTemplate = new EntryRep[]{item.attributeSets[7], item.attributeSets[3], item.attributeSets[0], (EntryRep)item.attributeSets[6].clone()};
                attrsSetTemplate[3].fields[0] = null;
                attrsSetTemplate[3].fields[1] = null;
                tmpl = new Template(null, new ServiceType[]{SERVICE_SERVICE_TYPE}, attrsSetTemplate);
                this.deleteOrReplaceTemplate(item, delete, tmpl);
            }
        } else if (item.serviceType.getName().equals(CONTAINER_PROXY_CLASSNAME)) {
            attrsSetTemplate = new EntryRep[]{item.attributeSets[1], item.attributeSets[0]};
            tmpl = new Template(null, new ServiceType[]{SERVICE_SERVICE_TYPE}, attrsSetTemplate);
            this.deleteOrReplaceTemplate(item, delete, tmpl);
        }
    }

    private void deleteOrReplaceTemplate(Item item, boolean delete, Template tmpl) {
        ConcurrentHashMap<ServiceID, Item> items = this.lookupServiceCache.get(tmpl);
        if (delete) {
            if (items != null) {
                items.remove(item.serviceID);
                if (items.isEmpty()) {
                    this.lookupServiceCache.remove(tmpl);
                }
                if (loggerCache.isLoggable(Level.FINEST)) {
                    loggerCache.finest("Removing cache template (explicitly): " + tmpl + "\n   ---- > id: " + item.serviceID + " , type: " + item.serviceType + " , items left: " + items.size());
                }
            }
        } else {
            if (items == null) {
                items = new SizeConcurrentHashMap<ServiceID, Item>(1);
                this.lookupServiceCache.put(tmpl, items);
            }
            items.put(item.serviceID, item);
            if (loggerCache.isLoggable(Level.FINEST)) {
                loggerCache.finest("Adding to cache template (explicitly): " + tmpl + "\n   ---- > " + item.serviceID + " " + item.serviceType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEvent(EventReg reg) {
        EventReg eventReg = reg;
        synchronized (eventReg) {
            if (reg.listener == null) {
                return;
            }
            EntryRep[] tmpls = reg.tmpl.attributeSetTemplates;
            if (tmpls != null) {
                int i = tmpls.length;
                while (--i >= 0) {
                    EntryClass eclass = tmpls[i].eclass;
                    eclass.setNumTemplates(eclass.getNumTemplates() + 1);
                }
            }
            Long id = reg.eventID;
            this.listeners.inc();
            this.eventByID.put(id, reg);
            EventRegKeyExpiration regExpirationKey = new EventRegKeyExpiration(reg, reg.leaseExpiration);
            if (loggerEventExpire.isLoggable(Level.FINE)) {
                loggerEventExpire.fine("[" + System.identityHashCode(regExpirationKey) + "]: Event [" + regExpirationKey.reg.eventID + "]: Registered with lease [" + regExpirationKey.leaseExpiration + "] and listener [" + reg.listener);
            }
            this.eventByTime.put(regExpirationKey, reg);
            if (reg.tmpl.serviceID != null) {
                Object val = this.subEventByService.get(reg.tmpl.serviceID);
                val = val == null ? reg : (val instanceof EventReg ? new EventReg[]{(EventReg)val, reg} : GigaRegistrar.arrayAdd((EventReg[])val, reg));
                this.subEventByService.put(reg.tmpl.serviceID, val);
            } else {
                this.subEventByID.put(id, reg);
            }
            this.computeMaxLeases();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteEvent(EventRegKeyExpiration regExpiration, EventReg reg) {
        EventReg eventReg = reg;
        synchronized (eventReg) {
            EntryRep[] tmpls = reg.tmpl.attributeSetTemplates;
            if (tmpls != null) {
                int i = tmpls.length;
                while (--i >= 0) {
                    EntryClass eclass = tmpls[i].eclass;
                    eclass.setNumTemplates(eclass.getNumTemplates() - 1);
                }
            }
            this.listeners.dec();
            Long id = reg.eventID;
            this.eventByID.remove(id);
            List<RegistrarEvent> removedEvents = this.eventsQ.remove(reg);
            List<RegistrarEvent> removedPending = this.pendingQ.remove(reg);
            if (removedEvents != null) {
                this.pendingEvents.dec(removedEvents.size());
                removedEvents.clear();
            }
            if (removedPending != null) {
                removedPending.clear();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Removed event registration for: " + reg);
            }
            if (regExpiration != null) {
                this.eventByTime.remove(regExpiration);
            } else {
                this.eventByTime.remove(new EventRegKeyExpiration(reg, reg.leaseExpiration));
            }
            if (reg.tmpl.serviceID != null) {
                Object val = this.subEventByService.get(reg.tmpl.serviceID);
                if (val == reg) {
                    this.subEventByService.remove(reg.tmpl.serviceID);
                } else {
                    Object[] array = (EventReg[])val;
                    val = (array = GigaRegistrar.arrayDel(array, GigaRegistrar.indexOf(array, reg))).length == 1 ? array[0] : array;
                    this.subEventByService.put(reg.tmpl.serviceID, val);
                }
            } else {
                this.subEventByID.remove(id);
            }
            this.computeMaxLeases();
        }
    }

    private void addAttrs(SvcReg reg, EntryRep entry) {
        EntryClass eclass = entry.eclass;
        this.addInstance(eclass);
        Object[] fields = entry.fields;
        if (fields.length > 0) {
            int i = fields.length;
            while (--i >= 0) {
                eclass = GigaRegistrar.getDefiningClass(eclass, i);
                this.addAttr(reg, eclass, i, fields[i]);
            }
            return;
        }
        ArrayList<SvcReg> regs = this.serviceByEmptyAttr.get(eclass);
        if (regs == null) {
            regs = new ArrayList<SvcReg>(2);
            regs.add(reg);
            this.serviceByEmptyAttr.put(eclass, regs);
        } else if (!regs.contains(reg)) {
            regs.add(reg);
        }
    }

    private void deleteAttrs(SvcReg reg, EntryRep entry, boolean checkDups) {
        EntryClass eclass = entry.eclass;
        this.deleteInstance(eclass);
        Object[] fields = entry.fields;
        if (fields.length == 0) {
            ArrayList regs = this.serviceByEmptyAttr.get(eclass);
            if (regs == null || checkDups && GigaRegistrar.hasEmptyAttr(reg, eclass)) {
                return;
            }
            int idx = regs.indexOf(reg);
            if (idx >= 0) {
                regs.remove(idx);
                if (regs.isEmpty()) {
                    this.serviceByEmptyAttr.remove(eclass);
                }
            }
            return;
        }
        int fldidx = fields.length;
        while (--fldidx >= 0) {
            int idx;
            Object value;
            HashMap map;
            ArrayList regs;
            Object[] attrMaps = this.serviceByAttr.get(eclass = GigaRegistrar.getDefiningClass(eclass, fldidx));
            if (attrMaps == null || attrMaps[fldidx] == null || checkDups && GigaRegistrar.hasAttr(reg, eclass, fldidx, fields[fldidx]) || (regs = (ArrayList)(map = attrMaps[fldidx]).get(value = fields[fldidx])) == null || (idx = regs.indexOf(reg)) < 0) continue;
            regs.remove(idx);
            if (!regs.isEmpty()) continue;
            map.remove(value);
            if (!map.isEmpty()) continue;
            attrMaps[fldidx] = null;
            if (!GigaRegistrar.allNull(attrMaps)) continue;
            this.serviceByAttr.remove(eclass);
        }
    }

    private void updateAttrs(SvcReg reg, EntryRep entry, Object[] values) {
        EntryClass eclass = entry.eclass;
        int fldidx = values.length;
        while (--fldidx >= 0) {
            Object oval = entry.fields[fldidx];
            Object nval = values[fldidx];
            if (nval == null || nval.equals(oval)) continue;
            eclass = GigaRegistrar.getDefiningClass(eclass, fldidx);
            HashMap map = this.addAttr(reg, eclass, fldidx, nval);
            entry.fields[fldidx] = nval;
            if (GigaRegistrar.hasAttr(reg, eclass, fldidx, oval)) continue;
            ArrayList regs = (ArrayList)map.get(oval);
            regs.remove(regs.indexOf(reg));
            if (!regs.isEmpty()) continue;
            map.remove(oval);
        }
    }

    private HashMap addAttr(SvcReg reg, EntryClass eclass, int fldidx, Object value) {
        ArrayList<SvcReg> regs;
        HashMap map;
        HashMap[] attrMaps = this.serviceByAttr.get(eclass);
        if (attrMaps == null) {
            attrMaps = new HashMap[eclass.getNumFields()];
            this.serviceByAttr.put(eclass, attrMaps);
        }
        if ((map = attrMaps[fldidx]) == null) {
            attrMaps[fldidx] = map = new HashMap(11);
        }
        if ((regs = (ArrayList<SvcReg>)map.get(value)) == null) {
            regs = new ArrayList<SvcReg>(3);
            map.put(value, regs);
        } else if (regs.contains(reg)) {
            return map;
        }
        regs.add(reg);
        return map;
    }

    private void addInstance(EntryClass eclass) {
        int idx = this.entryClasses.indexOf(eclass);
        if (idx < 0) {
            this.entryClasses.add(eclass);
            idx = this.entryClasses.size() - 1;
        }
        eclass = this.entryClasses.get(idx);
        eclass.setNumInstances(eclass.getNumInstances() + 1);
    }

    private void deleteInstance(EntryClass eclass) {
        int idx = this.entryClasses.indexOf(eclass);
        if (idx < 0) {
            return;
        }
        eclass = this.entryClasses.get(idx);
        int num = eclass.getNumInstances() - 1;
        if (num == 0) {
            this.entryClasses.remove(idx);
        }
        eclass.setNumInstances(num);
    }

    private ItemIter matchingItems(Template tmpl) {
        if (tmpl.serviceID != null) {
            return new IDItemIter(tmpl);
        }
        if (!GigaRegistrar.isEmpty(tmpl.serviceTypes)) {
            return new SvcIterator(tmpl);
        }
        Object[] sets = tmpl.attributeSetTemplates;
        if (GigaRegistrar.isEmpty(sets)) {
            return new AllItemIter();
        }
        int i = sets.length;
        while (--i >= 0) {
            Object[] fields = ((EntryRep)sets[i]).fields;
            if (fields.length == 0) {
                EntryClass eclass = this.getEmptyEntryClass(((EntryRep)sets[i]).eclass);
                if (eclass == null) continue;
                return new EmptyAttrItemIter(tmpl, eclass);
            }
            int j = fields.length;
            while (--j >= 0) {
                if (fields[j] == null) continue;
                return new AttrItemIter(tmpl, i, j);
            }
        }
        return new ClassItemIter(tmpl);
    }

    private EntryClass getEmptyEntryClass(EntryClass eclass) {
        EntryClass match = null;
        int i = this.entryClasses.size();
        while (--i >= 0) {
            EntryClass cand = this.entryClasses.get(i);
            if (!eclass.isAssignableFrom(cand)) continue;
            if (cand.getNumFields() != 0 || match != null) {
                return null;
            }
            match = cand;
        }
        return match;
    }

    private ArrayList matchingServices(ServiceType[] types) {
        ArrayList matches = new ArrayList();
        if (GigaRegistrar.isEmpty(types)) {
            Map map = this.serviceByTypeName.get(this.objectServiceType.getName());
            matches.addAll(map.values());
        } else {
            Map map = this.serviceByTypeName.get(types[0].getName());
            if (map != null) {
                matches.addAll(map.values());
            }
            if (types.length > 1) {
                Iterator it = matches.iterator();
                while (it.hasNext()) {
                    SvcReg reg = (SvcReg)it.next();
                    if (GigaRegistrar.matchType(types, reg.item.serviceType)) continue;
                    it.remove();
                }
            }
        }
        return matches;
    }

    private String pickCodebase(EntryClass eclass, long now) throws ClassNotFoundException {
        if (eclass.getNumFields() == 0) {
            return this.pickCodebase(eclass, this.serviceByEmptyAttr.get(eclass), now);
        }
        int fldidx = eclass.getNumFields() - 1;
        HashMap[] attrMaps = this.serviceByAttr.get(GigaRegistrar.getDefiningClass(eclass, fldidx));
        for (Object o : attrMaps[fldidx].values()) {
            try {
                return this.pickCodebase(eclass, (ArrayList)o, now);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException();
    }

    private String pickCodebase(EntryClass eclass, ArrayList svcs, long now) throws ClassNotFoundException {
        int i = svcs.size();
        while (--i >= 0) {
            SvcReg reg = (SvcReg)svcs.get(i);
            if (reg.leaseExpiration <= now) continue;
            EntryRep[] sets = reg.item.attributeSets;
            int j = sets.length;
            while (--j >= 0) {
                if (!eclass.equals(sets[j].eclass)) continue;
                return sets[j].codebase;
            }
        }
        throw new ClassNotFoundException();
    }

    private void computeMaxLeases() {
        this.maxServiceLease = Math.max(this.minMaxServiceLease, this.minRenewalInterval * ((long)this.serviceByID.size() + (long)this.eventByID.size() * this.minMaxServiceLease / this.minMaxEventLease));
        this.maxEventLease = Math.max(this.minMaxEventLease, this.maxServiceLease * this.minMaxEventLease / this.minMaxServiceLease);
    }

    private void respond(Socket socket) throws Exception {
        try {
            block11: {
                try {
                    if (Constants.useSocketTcpNoDelay()) {
                        socket.setTcpNoDelay(true);
                    }
                    if (Constants.useSocketKeepAlive()) {
                        socket.setKeepAlive(true);
                    }
                }
                catch (SocketException e) {
                    if (!logger.isLoggable(Levels.HANDLED)) break block11;
                    logger.log(Levels.HANDLED, "problem setting socket options", e);
                }
            }
            socket.setSoTimeout(this.unicastDiscoveryConstraints.getUnicastSocketTimeout(60000));
            int pv = new DataInputStream(socket.getInputStream()).readInt();
            this.unicastDiscoveryConstraints.checkProtocolVersion(pv);
            this.getDiscovery(pv).handleUnicastDiscovery(new UnicastResponse(this.myLocator.getHost(), this.myLocator.getPort(), this.memberGroups, (ServiceRegistrar)this.proxy, this.proxyMarshalledObject, this.proxyRegistrarBytes), socket, this.unicastDiscoveryConstraints.getUnfulfilledConstraints(), this.unicastDiscoverySubjectChecker, (Collection)Collections.EMPTY_LIST);
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException e) {
                logger.log(Levels.HANDLED, "exception closing socket", e);
            }
        }
    }

    private Discovery getDiscovery(int version) throws DiscoveryProtocolException {
        switch (version) {
            case 1: {
                return Discovery.getProtocol1();
            }
            case 2: {
                return this.protocol2;
            }
        }
        throw new DiscoveryProtocolException("unsupported protocol version: " + version);
    }

    private void closeRequestSockets(List tasks) {
        int i = tasks.size();
        while (--i >= 0) {
            Object obj = tasks.get(i);
            if (!(obj instanceof SocketTask)) continue;
            try {
                ((SocketTask)obj).socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void init(Configuration config, LifeCycle lifeCycle) throws IOException, ConfigurationException, ActivationException {
        Object unicastDiscoveryHost;
        long startTime = System.currentTimeMillis();
        RuntimeInfo.logRuntimeInfo(logger, "Starting Lookup Service...");
        if (this.myServiceID == null) {
            this.myServiceID = this.newServiceID();
        }
        this.lifeCycle = lifeCycle;
        this.serverExporter = (Exporter)Config.getNonNullEntry((Configuration)config, (String)COMPONENT, (String)"serverExporter", Exporter.class);
        List<Entry> defaultEntries = this.loadInitialLookupAttributes();
        Object defaultValue = defaultEntries.toArray(new Entry[defaultEntries.size()]);
        Entry[] initialLookupAttributes = (Entry[])config.getEntry(COMPONENT, "initialLookupAttributes", Entry[].class, defaultValue);
        this.lookupGroups = (String[])config.getEntry(COMPONENT, "initialLookupGroups", String[].class, (Object)this.lookupGroups);
        this.lookupLocators = (LookupLocator[])config.getEntry(COMPONENT, "initialLookupLocators", LookupLocator[].class, (Object)this.lookupLocators);
        this.memberGroups = (String[])config.getEntry(COMPONENT, "initialMemberGroups", String[].class, (Object)this.memberGroups);
        if (this.memberGroups == null) {
            throw new ConfigurationException("member groups cannot be ALL_GROUPS (null)");
        }
        this.memberGroups = (String[])GigaRegistrar.removeDups(this.memberGroups);
        this.unicastPort = Config.getIntEntry((Configuration)config, (String)COMPONENT, (String)"initialUnicastDiscoveryPort", (int)Integer.getInteger("com.sun.jini.reggie.initialUnicastDiscoveryPort", this.unicastPort), (int)0, (int)65535);
        if (initialLookupAttributes != null && initialLookupAttributes.length > 0) {
            ArrayList<Entry> l = new ArrayList<Entry>(Arrays.asList(baseAttrs));
            l.addAll(Arrays.asList(initialLookupAttributes));
            this.lookupAttrs = l.toArray(new Entry[l.size()]);
        } else {
            this.lookupAttrs = baseAttrs;
        }
        MethodConstraints discoveryConstraints = (MethodConstraints)config.getEntry(COMPONENT, "discoveryConstraints", MethodConstraints.class, null);
        if (discoveryConstraints == null) {
            discoveryConstraints = new BasicMethodConstraints(InvocationConstraints.EMPTY);
        }
        try {
            this.discoer = (DiscoveryManagement)config.getEntry(COMPONENT, "discoveryManager", DiscoveryManagement.class);
        }
        catch (NoSuchEntryException e) {
            this.discoer = new LookupDiscoveryManager(LookupGroups.none(), null, null, config, true);
        }
        this.listenerPreparer = (ProxyPreparer)Config.getNonNullEntry((Configuration)config, (String)COMPONENT, (String)"listenerPreparer", ProxyPreparer.class, (Object)this.listenerPreparer);
        this.locatorPreparer = (ProxyPreparer)Config.getNonNullEntry((Configuration)config, (String)COMPONENT, (String)"locatorPreparer", ProxyPreparer.class, (Object)this.locatorPreparer);
        this.minMaxEventLease = Config.getLongEntry((Configuration)config, (String)COMPONENT, (String)"minMaxEventLease", (long)this.minMaxEventLease, (long)1L, (long)31536000000000L);
        this.minMaxServiceLease = Config.getLongEntry((Configuration)config, (String)COMPONENT, (String)"minMaxServiceLease", (long)this.minMaxServiceLease, (long)1L, (long)31536000000000L);
        this.minRenewalInterval = Config.getLongEntry((Configuration)config, (String)COMPONENT, (String)"minRenewalInterval", (long)this.minRenewalInterval, (long)0L, (long)31536000000L);
        this.multicastAnnouncementInterval = Config.getLongEntry((Configuration)config, (String)COMPONENT, (String)"multicastAnnouncementInterval", (long)this.multicastAnnouncementInterval, (long)1L, (long)Long.MAX_VALUE);
        this.multicastInterfaceRetryInterval = Config.getIntEntry((Configuration)config, (String)COMPONENT, (String)"multicastInterfaceRetryInterval", (int)this.multicastInterfaceRetryInterval, (int)1, (int)Integer.MAX_VALUE);
        try {
            this.multicastInterfaces = (NetworkInterface[])config.getEntry(COMPONENT, "multicastInterfaces", NetworkInterface[].class);
            this.multicastInterfacesSpecified = true;
        }
        catch (NoSuchEntryException e) {
            this.multicastInterfaces = BootUtil.getNetworkInterfaces();
            this.multicastInterfacesSpecified = false;
        }
        if (this.multicastInterfaces == null) {
            logger.config("using system default interface for multicast");
        } else if (this.multicastInterfaces.length == 0) {
            if (this.multicastInterfacesSpecified) {
                logger.config("multicast disabled");
            } else {
                logger.severe("no network interfaces detected");
            }
        } else if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "multicasting on interfaces {0}", new Object[]{Arrays.asList(this.multicastInterfaces)});
        }
        try {
            this.multicastRequestSubjectChecker = (ClientSubjectChecker)Config.getNonNullEntry((Configuration)config, (String)COMPONENT, (String)"multicastRequestSubjectChecker", ClientSubjectChecker.class);
        }
        catch (NoSuchEntryException e) {
            // empty catch block
        }
        this.resourceIdGenerator = (UuidGenerator)Config.getNonNullEntry((Configuration)config, (String)COMPONENT, (String)"resourceIdGenerator", UuidGenerator.class, (Object)this.resourceIdGenerator);
        this.serviceIdGenerator = (UuidGenerator)Config.getNonNullEntry((Configuration)config, (String)COMPONENT, (String)"serviceIdGenerator", UuidGenerator.class, (Object)this.serviceIdGenerator);
        this.useCacheForSpaceMiss = (Boolean)Config.getNonNullEntry((Configuration)config, (String)COMPONENT, (String)"useCacheForSpaceMiss", Boolean.class, (Object)Boolean.TRUE);
        this.taskerComm = DynamicExecutors.newBlockingThreadPool(Integer.getInteger("com.sun.jini.reggie.commTaskManager.minThreads", 10), Integer.getInteger("com.sun.jini.reggie.commTaskManager.maxThreads", 80), Long.getLong("com.sun.jini.reggie.commTaskManager.keepAlive", 10000L), Integer.getInteger("com.sun.jini.reggie.commTaskManager.capacity", 200), Long.getLong("com.sun.jini.reggie.commTaskManager.waitTime", 180000L), 7, "Reggie Comm Task", true);
        this.taskerEvent = (TaskManager)Config.getNonNullEntry((Configuration)config, (String)COMPONENT, (String)"eventTaskManager", TaskManager.class, (Object)new TaskManager(Integer.getInteger("com.sun.jini.reggie.eventTaskManager.maxThreads", 40), Long.getLong("com.sun.jini.reggie.eventTaskManager.timeout", 15000L), 2.0f, "Reggie Event Task", Integer.getInteger("com.sun.jini.reggie.eventTaskManager.retriesOnIdle", 10)));
        this.maxEventsPerEventReg = Config.getIntEntry((Configuration)config, (String)COMPONENT, (String)"maxEventsPerEventReg", (int)1500, (int)10, (int)Integer.MAX_VALUE);
        this.pendingQ = new HashMap<EventReg, List<RegistrarEvent>>();
        this.eventsQ = new ConcurrentHashMap<EventReg, List<RegistrarEvent>>();
        this.unexportTimeout = Config.getLongEntry((Configuration)config, (String)COMPONENT, (String)"unexportTimeout", (long)this.unexportTimeout, (long)0L, (long)Long.MAX_VALUE);
        this.unexportWait = Config.getLongEntry((Configuration)config, (String)COMPONENT, (String)"unexportWait", (long)this.unexportWait, (long)0L, (long)Long.MAX_VALUE);
        defaultValue = SystemInfo.singleton().network().getPublicHostId();
        try {
            unicastDiscoveryHost = (String)Config.getNonNullEntry((Configuration)config, (String)COMPONENT, (String)"unicastDiscoveryHost", String.class, (Object)defaultValue);
        }
        catch (NoSuchEntryException e) {
            unicastDiscoveryHost = defaultValue;
        }
        try {
            this.unicastDiscoverySubjectChecker = (ClientSubjectChecker)Config.getNonNullEntry((Configuration)config, (String)COMPONENT, (String)"unicastDiscoverySubjectChecker", ClientSubjectChecker.class);
        }
        catch (NoSuchEntryException e) {
            // empty catch block
        }
        this.objectServiceType = new ServiceType(Object.class, null, null);
        this.computeMaxLeases();
        this.protocol2 = Discovery.getProtocol2(null);
        this.rawUnicastDiscoveryConstraints = discoveryConstraints.getConstraints(DiscoveryConstraints.unicastDiscoveryMethod);
        this.multicastRequestConstraints = DiscoveryConstraints.process((InvocationConstraints)discoveryConstraints.getConstraints(DiscoveryConstraints.multicastRequestMethod));
        this.multicastAnnouncementConstraints = DiscoveryConstraints.process((InvocationConstraints)discoveryConstraints.getConstraints(DiscoveryConstraints.multicastAnnouncementMethod));
        this.unicastDiscoveryConstraints = DiscoveryConstraints.process((InvocationConstraints)this.rawUnicastDiscoveryConstraints);
        this.serviceExpirer = new ServiceExpireThread();
        this.eventExpirer = new EventExpireThread();
        this.unicaster = new UnicastThread(this.host, this.unicastPort);
        if (Constants.isMulticastEnabled()) {
            this.multicaster = new MulticastThread();
            this.announcer = new AnnounceThread();
        }
        this.myRef = (Registrar)this.serverExporter.export((Remote)this);
        this.proxy = RegistrarProxy.getInstance(this.myRef, this.myServiceID);
        MarshalledInstance proxyMarshalledInstance = new MarshalledInstance((Object)this.proxy);
        this.proxyMarshalledObject = proxyMarshalledInstance.convertToMarshalledObject();
        OptimizedByteArrayOutputStream os = new OptimizedByteArrayOutputStream();
        MarshalOutputStream oos = new MarshalOutputStream((OutputStream)os, (Collection)Collections.EMPTY_SET);
        oos.writeObject((Object)this.proxy);
        oos.close();
        this.proxyRegistrarBytes = os.toByteArray();
        this.myLocator = this.proxy instanceof RemoteMethodControl ? new ConstrainableLookupLocator((String)unicastDiscoveryHost, this.unicaster.port, null) : new LookupLocator((String)unicastDiscoveryHost, this.unicaster.port);
        Item item = new Item(new ServiceItem(this.myServiceID, (Object)this.proxy, this.lookupAttrs));
        SvcReg reg = new SvcReg(item, myLeaseID, SystemTime.timeMillis(), Long.MAX_VALUE);
        this.addService(reg);
        try {
            DiscoveryGroupManagement dgm = (DiscoveryGroupManagement)((Object)this.discoer);
            String[] groups = dgm.getGroups();
            if (groups == null || groups.length > 0) {
                throw new ConfigurationException("discoveryManager must be initially configured with no groups");
            }
            DiscoveryLocatorManagement dlm = (DiscoveryLocatorManagement)((Object)this.discoer);
            if (dlm.getLocators().length > 0) {
                throw new ConfigurationException("discoveryManager must be initially configured with no locators");
            }
            dgm.setGroups(this.lookupGroups);
            dlm.setLocators(this.lookupLocators);
            if (DynamicLookupLocatorDiscovery.dynamicLocatorsEnabled() && this.discoer instanceof LookupDiscoveryManager) {
                LookupDiscoveryManager ldm = (LookupDiscoveryManager)this.discoer;
                ldm.getDynamicLocatorDiscovery().init(this.myServiceID);
            }
        }
        catch (ClassCastException e) {
            throw new ConfigurationException(null, (Throwable)e);
        }
        this.joiner = new JoinManager((Object)this.proxy, this.lookupAttrs, this.myServiceID, this.discoer, null, config);
        this.serviceExpirer.start();
        this.eventExpirer.start();
        this.unicaster.start();
        if (this.multicaster != null) {
            this.multicaster.start();
        }
        if (this.announcer != null) {
            this.announcer.start();
        }
        if (logger.isLoggable(Level.INFO)) {
            long duration = System.currentTimeMillis() - startTime;
            logger.log(Level.INFO, "Started Lookup Service [duration=" + BootUtil.formatDuration((long)duration) + ", groups=" + Arrays.asList(this.memberGroups) + ", service-id=" + this.myServiceID + ", locator=" + this.myLocator + "]");
        }
        this.ready.ready();
    }

    protected List<Entry> loadInitialLookupAttributes() {
        ArrayList<Entry> result = new ArrayList<Entry>();
        result.add((Entry)new Name("Lookup"));
        JMXConnection jmxConnection = JMXUtilities.createJMXConnectionAttribute((String)"LUS");
        if (jmxConnection != null) {
            result.add((Entry)jmxConnection);
        }
        if (DynamicLookupLocatorDiscovery.dynamicLocatorsEnabled()) {
            result.add((Entry)DynamicLookupLocatorDiscovery.DYNAMIC_LOCATORS_ENABLED_LOOKUP_ATTRIBUTE);
        }
        return result;
    }

    private ServiceRegistration registerDo(Item nitem, long leaseDuration) {
        SvcReg reg;
        if (nitem.service == null) {
            throw new NullPointerException("null service");
        }
        if (this.myServiceID.equals((Object)nitem.serviceID)) {
            throw new IllegalArgumentException("reserved service id");
        }
        nitem.attributeSets = nitem.attributeSets == null ? emptyAttrs : (EntryRep[])GigaRegistrar.removeDups(nitem.attributeSets);
        leaseDuration = GigaRegistrar.limitDuration(leaseDuration, this.maxServiceLease);
        long now = SystemTime.timeMillis();
        if (nitem.serviceID == null) {
            Map svcs = this.serviceByTypeName.get(nitem.serviceType.getName());
            if (svcs != null) {
                for (Object o : svcs.values()) {
                    SvcReg reg2 = (SvcReg)o;
                    if (!nitem.service.equals(reg2.item.service)) continue;
                    nitem.serviceID = reg2.item.serviceID;
                    this.deleteService(null, reg2, now);
                    break;
                }
            }
            if (nitem.serviceID == null) {
                nitem.serviceID = this.newServiceID();
            }
        } else {
            reg = this.serviceByID.get(nitem.serviceID);
            if (reg != null) {
                this.deleteService(null, reg, now);
            }
        }
        Util.checkRegistrantServiceID(nitem.serviceID, logger, Level.FINE);
        reg = new SvcReg(nitem, this.newLeaseID(), now, now + leaseDuration);
        this.addService(reg);
        this.generateEvents(null, nitem, now);
        this.queueEvents();
        return Registration.getInstance(this.myRef, ServiceLease.getInstance(this.myRef, this.myServiceID, nitem.serviceID, reg.leaseID, reg.leaseExpiration));
    }

    private Item lookupDo(Template tmpl) {
        if (GigaRegistrar.isEmpty(tmpl.serviceTypes) || tmpl.serviceID != null) {
            ItemIter iter = this.matchingItems(tmpl);
            if (iter.hasNext()) {
                return iter.next();
            }
            return null;
        }
        ArrayList services = this.matchingServices(tmpl.serviceTypes);
        long now = SystemTime.timeMillis();
        int slen = services.size();
        if (slen == 0) {
            return null;
        }
        int srand = this.random.nextInt(Integer.MAX_VALUE) % slen;
        for (int i = 0; i < slen; ++i) {
            SvcReg reg = (SvcReg)services.get((i + srand) % slen);
            if (reg.leaseExpiration <= now || !GigaRegistrar.matchAttributes(tmpl, reg.item)) continue;
            return reg.item;
        }
        return null;
    }

    private Matches lookupDo(Template tmpl, int maxMatches) {
        if (maxMatches < 0) {
            throw new IllegalArgumentException("negative maxMatches");
        }
        int totalMatches = 0;
        ArrayList<Item> matches = null;
        ItemIter iter = this.matchingItems(tmpl);
        if (maxMatches > 0 || iter.dupsPossible) {
            int suggestedSize = iter.suggestedSize();
            suggestedSize = maxMatches < suggestedSize ? maxMatches : suggestedSize;
            matches = new ArrayList<Item>(suggestedSize);
        }
        if (iter.dupsPossible) {
            while (iter.hasNext()) {
                Item item = iter.next();
                if (matches.contains(item)) continue;
                matches.add(item);
            }
            totalMatches = matches.size();
            if (maxMatches > 0) {
                int i = matches.size();
                while (--i >= maxMatches) {
                    matches.remove(i);
                }
                i = matches.size();
                while (--i >= 0) {
                    matches.set(i, GigaRegistrar.copyItem((Item)matches.get(i)));
                }
            } else {
                matches = null;
            }
        } else {
            while (iter.hasNext()) {
                Item item = iter.next();
                ++totalMatches;
                if (--maxMatches < 0) continue;
                matches.add(GigaRegistrar.copyItem(item));
            }
        }
        return new Matches(matches, totalMatches);
    }

    private RegistrarEventRegistration notifyDo(Template tmpl, int transitions, RemoteEventListener listener, MarshalledObject handback, long leaseDuration, int notifyType) throws RemoteException {
        if (transitions == 0 || transitions != (transitions & 7)) {
            throw new IllegalArgumentException("invalid transitions");
        }
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        listener = (RemoteEventListener)this.listenerPreparer.prepareProxy((Object)listener);
        leaseDuration = GigaRegistrar.limitDuration(leaseDuration, this.maxEventLease);
        long now = SystemTime.timeMillis();
        EventReg reg = new EventReg(this.eventID, this.newLeaseID(), tmpl, transitions, listener, handback, now + leaseDuration);
        ++this.eventID;
        this.addEvent(reg);
        RegistrarEventRegistration retVal = new RegistrarEventRegistration(reg.eventID, (Object)this.proxy, (Lease)EventLease.getInstance(this.myRef, this.myServiceID, reg.eventID, reg.leaseID, reg.leaseExpiration), reg.seqNo, null);
        Matches matches = null;
        if (notifyType == 1) {
            matches = this.lookupDo(tmpl, Integer.MAX_VALUE);
        } else if (notifyType == 2) {
            matches = new Matches(new ArrayList(), 0);
            Matches itemMatches = this.lookupDo(tmpl, Integer.MAX_VALUE);
            for (int i = 0; i < itemMatches.items.size(); ++i) {
                Item item = (Item)itemMatches.items.get(i);
                this.generateEvents(null, item, now);
            }
            this.queueEvents();
        }
        retVal.setMatches((ServiceMatchesWrapper)matches);
        return retVal;
    }

    private EntryClassBase[] getEntryClassesDo(Template tmpl) {
        int i;
        ArrayList<EntryClass> classes = new ArrayList<EntryClass>();
        ArrayList<String> codebases = new ArrayList<String>();
        if (tmpl.serviceID == null && GigaRegistrar.isEmpty(tmpl.serviceTypes) && GigaRegistrar.isEmpty(tmpl.attributeSetTemplates)) {
            long now = SystemTime.timeMillis();
            i = this.entryClasses.size();
            while (--i >= 0) {
                EntryClass eclass = this.entryClasses.get(i);
                try {
                    codebases.add(this.pickCodebase(eclass, now));
                    classes.add(eclass);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        } else {
            ItemIter iter = this.matchingItems(tmpl);
            while (iter.hasNext()) {
                Item item = iter.next();
                i = item.attributeSets.length;
                while (--i >= 0) {
                    EntryRep attrSet = item.attributeSets[i];
                    if (!GigaRegistrar.attrMatch(tmpl.attributeSetTemplates, attrSet) || classes.contains(attrSet.eclass)) continue;
                    classes.add(attrSet.eclass);
                    codebases.add(attrSet.codebase);
                }
            }
        }
        if (classes.isEmpty()) {
            return null;
        }
        EntryClassBase[] vals = new EntryClassBase[classes.size()];
        int i2 = vals.length;
        while (--i2 >= 0) {
            vals[i2] = new EntryClassBase(((EntryClass)classes.get(i2)).getReplacement(), (String)codebases.get(i2));
        }
        return vals;
    }

    private Object[] getFieldValuesDo(Template tmpl, int setidx, int fldidx) {
        ArrayList<Object> values = new ArrayList<Object>();
        EntryRep etmpl = tmpl.attributeSetTemplates[setidx];
        if (tmpl.serviceID == null && GigaRegistrar.isEmpty(tmpl.serviceTypes) && tmpl.attributeSetTemplates.length == 1 && GigaRegistrar.allNull(etmpl.fields)) {
            long now = SystemTime.timeMillis();
            EntryClass eclass = GigaRegistrar.getDefiningClass(etmpl.eclass, fldidx);
            boolean checkAttr = !eclass.equals(etmpl.eclass);
            HashMap[] attrMaps = this.serviceByAttr.get(eclass);
            if (attrMaps != null && attrMaps[fldidx] != null) {
                Iterator iterator = attrMaps[fldidx].entrySet().iterator();
                block0: while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry ent = o = iterator.next();
                    ArrayList regs = (ArrayList)ent.getValue();
                    Object value = ent.getKey();
                    int i = regs.size();
                    while (--i >= 0) {
                        SvcReg reg = (SvcReg)regs.get(i);
                        if (reg.leaseExpiration <= now || checkAttr && !GigaRegistrar.hasAttr(reg, etmpl.eclass, fldidx, value)) continue;
                        values.add(value);
                        continue block0;
                    }
                }
            }
        } else {
            ItemIter iter = this.matchingItems(tmpl);
            while (iter.hasNext()) {
                Item item = iter.next();
                int j = item.attributeSets.length;
                while (--j >= 0) {
                    Object value;
                    if (!GigaRegistrar.matchEntry(etmpl, item.attributeSets[j]) || values.contains(value = item.attributeSets[j].fields[fldidx])) continue;
                    values.add(value);
                }
            }
        }
        if (values.isEmpty()) {
            return null;
        }
        return values.toArray();
    }

    private ServiceTypeBase[] getServiceTypesDo(Template tmpl, String prefix) {
        ArrayList<ServiceType> classes = new ArrayList<ServiceType>();
        ArrayList<String> codebases = new ArrayList<String>();
        if (tmpl.serviceID == null && GigaRegistrar.isEmpty(tmpl.attributeSetTemplates)) {
            ArrayList services = this.matchingServices(tmpl.serviceTypes);
            for (Object service : services) {
                Item item = ((SvcReg)service).item;
                GigaRegistrar.addTypes(classes, codebases, tmpl.serviceTypes, prefix, item.serviceType, item.codebase);
            }
        } else {
            ItemIter iter = this.matchingItems(tmpl);
            while (iter.hasNext()) {
                Item item = iter.next();
                GigaRegistrar.addTypes(classes, codebases, tmpl.serviceTypes, prefix, item.serviceType, item.codebase);
            }
        }
        if (classes.isEmpty()) {
            return null;
        }
        ServiceTypeBase[] vals = new ServiceTypeBase[classes.size()];
        int i = vals.length;
        while (--i >= 0) {
            vals[i] = new ServiceTypeBase(classes.get(i).getReplacement(), codebases.get(i));
        }
        return vals;
    }

    private void addAttributesDo(ServiceID serviceID, Uuid leaseID, EntryRep[] attrSets) throws UnknownLeaseException {
        long now = SystemTime.timeMillis();
        SvcReg reg = this.serviceByID.get(serviceID);
        if (reg == null || !reg.leaseID.equals((Object)leaseID) || reg.leaseExpiration <= now) {
            throw new UnknownLeaseException();
        }
        Item pre = (Item)reg.item.clone();
        Object[] sets = reg.item.attributeSets;
        int i = 0;
        for (int j = 0; j < attrSets.length; ++j) {
            EntryRep set = attrSets[j];
            if (GigaRegistrar.indexOf(sets, set) >= 0 || GigaRegistrar.indexOf(attrSets, j, set) >= 0) continue;
            attrSets[i++] = set;
            this.addAttrs(reg, set);
        }
        if (i > 0) {
            int len = sets.length;
            EntryRep[] nsets = new EntryRep[len + i];
            System.arraycopy(sets, 0, nsets, 0, len);
            System.arraycopy(attrSets, 0, nsets, len, i);
            reg.item.attributeSets = nsets;
        }
        this.refreshServiceFromLookupCache(reg.item, false);
        this.generateEvents(pre, reg.item, now);
    }

    private void modifyAttributesDo(ServiceID serviceID, Uuid leaseID, EntryRep[] attrSetTmpls, EntryRep[] attrSets) throws UnknownLeaseException {
        if (attrSetTmpls.length != attrSets.length) {
            throw new IllegalArgumentException("attribute set length mismatch");
        }
        int i = attrSets.length;
        while (--i >= 0) {
            if (attrSets[i] == null || attrSets[i].eclass.isAssignableFrom(attrSetTmpls[i].eclass)) continue;
            throw new IllegalArgumentException("attribute set type mismatch");
        }
        long now = SystemTime.timeMillis();
        SvcReg reg = this.serviceByID.get(serviceID);
        if (reg == null || !reg.leaseID.equals((Object)leaseID) || reg.leaseExpiration <= now) {
            throw new UnknownLeaseException();
        }
        Item pre = (Item)reg.item.clone();
        EntryRep[] preSets = pre.attributeSets;
        Object[] sets = reg.item.attributeSets;
        int i2 = preSets.length;
        block1: while (--i2 >= 0) {
            EntryRep preSet = preSets[i2];
            EntryRep set = sets[i2];
            int j = attrSetTmpls.length;
            while (--j >= 0) {
                if (!GigaRegistrar.matchEntry(attrSetTmpls[j], preSet)) continue;
                EntryRep attrs = attrSets[j];
                if (attrs == null) {
                    sets = GigaRegistrar.deleteSet(reg.item, i2);
                    this.deleteAttrs(reg, set, true);
                    continue block1;
                }
                this.updateAttrs(reg, set, attrs.fields);
            }
        }
        i2 = sets.length;
        while (--i2 >= 0) {
            EntryRep set = sets[i2];
            if (GigaRegistrar.indexOf(sets, i2, set) < 0) continue;
            sets = GigaRegistrar.deleteSet(reg.item, i2);
            this.deleteInstance(set.eclass);
        }
        reg.item.attributeSets = sets;
        this.refreshServiceFromLookupCache(reg.item, false);
        this.generateEvents(pre, reg.item, now);
    }

    private void setAttributesDo(ServiceID serviceID, Uuid leaseID, EntryRep[] attrSets) throws UnknownLeaseException {
        attrSets = attrSets == null ? emptyAttrs : (EntryRep[])GigaRegistrar.removeDups(attrSets);
        long now = SystemTime.timeMillis();
        SvcReg reg = this.serviceByID.get(serviceID);
        if (reg == null || !reg.leaseID.equals((Object)leaseID) || reg.leaseExpiration <= now) {
            throw new UnknownLeaseException();
        }
        Item pre = (Item)reg.item.clone();
        EntryRep[] entries = reg.item.attributeSets;
        int i = entries.length;
        while (--i >= 0) {
            this.deleteAttrs(reg, entries[i], false);
        }
        reg.item.attributeSets = attrSets;
        i = attrSets.length;
        while (--i >= 0) {
            this.addAttrs(reg, attrSets[i]);
        }
        this.refreshServiceFromLookupCache(reg.item, false);
        this.generateEvents(pre, reg.item, now);
    }

    private void cancelServiceLeaseDo(ServiceID serviceID, Uuid leaseID) throws UnknownLeaseException {
        if (serviceID.equals((Object)this.myServiceID)) {
            throw new SecurityException("privileged service id");
        }
        long now = SystemTime.timeMillis();
        SvcReg reg = this.serviceByID.get(serviceID);
        if (reg == null || !reg.leaseID.equals((Object)leaseID) || reg.leaseExpiration <= now) {
            throw new UnknownLeaseException();
        }
        this.deleteService(null, reg, now);
    }

    private long renewServiceLeaseDo(ServiceID serviceID, Uuid leaseID, long renewDuration) throws UnknownLeaseException {
        long now = SystemTime.timeMillis();
        long renewExpiration = this.renewServiceLeaseInt(serviceID, leaseID, renewDuration, now);
        return renewExpiration - now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long renewServiceLeaseInt(ServiceID serviceID, Uuid leaseID, long renewDuration, long now) throws UnknownLeaseException {
        long maxServiceLease = this.maxServiceLease;
        if (serviceID.equals((Object)this.myServiceID)) {
            throw new SecurityException("privileged service id");
        }
        if (renewDuration == -1L) {
            renewDuration = maxServiceLease;
        } else if (renewDuration < 0L) {
            throw new IllegalArgumentException("negative lease duration");
        }
        SvcReg reg = this.serviceByID.get(serviceID);
        if (reg == null || !reg.leaseID.equals((Object)leaseID) || reg.leaseExpiration <= now) {
            throw new UnknownLeaseException();
        }
        SvcReg svcReg = reg;
        synchronized (svcReg) {
            if (renewDuration > maxServiceLease && renewDuration > reg.leaseExpiration - now) {
                renewDuration = Math.max(reg.leaseExpiration - now, maxServiceLease);
            }
            long renewExpiration = now + renewDuration;
            if (loggerServiceExpire.isLoggable(Level.FINEST)) {
                loggerServiceExpire.finest("[" + System.identityHashCode(reg) + "]: Service [" + reg.item.serviceID + "]: Renew lease [" + reg.leaseID + "/" + renewExpiration + "], old lease [" + reg.leaseExpiration + "]");
            }
            this.serviceByTime.remove(new SvcRegExpirationKey(reg, reg.leaseExpiration));
            reg.leaseExpiration = renewExpiration;
            this.serviceByTime.put(new SvcRegExpirationKey(reg, reg.leaseExpiration), reg);
            return renewExpiration;
        }
    }

    private void cancelEventLeaseDo(long eventID, Uuid leaseID) throws UnknownLeaseException {
        long now = SystemTime.timeMillis();
        EventReg reg = this.eventByID.get(eventID);
        if (reg == null || reg.leaseExpiration <= now) {
            throw new UnknownLeaseException();
        }
        this.deleteEvent(null, reg);
    }

    private long renewEventLeaseDo(long eventID, Uuid leaseID, long renewDuration) throws UnknownLeaseException {
        long now = SystemTime.timeMillis();
        long renewExpiration = this.renewEventLeaseInt(eventID, leaseID, renewDuration, now);
        return renewExpiration - now;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long renewEventLeaseInt(long eventID, Uuid leaseID, long renewDuration, long now) throws UnknownLeaseException {
        long maxEventLease = this.maxEventLease;
        if (renewDuration == -1L) {
            renewDuration = maxEventLease;
        } else if (renewDuration < 0L) {
            throw new IllegalArgumentException("negative lease duration");
        }
        EventReg reg = this.eventByID.get(eventID);
        if (reg == null) {
            throw new UnknownLeaseException("trying to renew unknown lease,  event id: " + eventID);
        }
        if (!reg.leaseID.equals((Object)leaseID)) {
            throw new UnknownLeaseException("Lease id: " + leaseID + " does not match event: " + eventID + " lease id: " + reg.leaseID);
        }
        if (reg.leaseExpiration <= now) {
            throw new UnknownLeaseException("Lease id: " + leaseID + " for event: " + eventID + " already expired");
        }
        EventReg eventReg = reg;
        synchronized (eventReg) {
            if (renewDuration > maxEventLease && renewDuration > reg.leaseExpiration - now) {
                renewDuration = Math.max(reg.leaseExpiration - now, maxEventLease);
            }
            long renewExpiration = now + renewDuration;
            this.eventByTime.remove(new EventRegKeyExpiration(reg, reg.leaseExpiration));
            reg.leaseExpiration = renewExpiration;
            this.eventByTime.put(new EventRegKeyExpiration(reg, reg.leaseExpiration), reg);
            return renewExpiration;
        }
    }

    private RenewResults renewLeasesDo(Object[] regIDs, Uuid[] leaseIDs, long[] renewals) {
        int i;
        long now = SystemTime.timeMillis();
        Exception[] exceptions = null;
        for (i = 0; i < regIDs.length; ++i) {
            Object id = regIDs[i];
            try {
                if (id instanceof ServiceID) {
                    renewals[i] = this.renewServiceLeaseInt((ServiceID)id, leaseIDs[i], renewals[i], now);
                    continue;
                }
                renewals[i] = this.renewEventLeaseInt((Long)id, leaseIDs[i], renewals[i], now);
                continue;
            }
            catch (Exception e) {
                renewals[i] = -1L;
                exceptions = exceptions == null ? new Exception[]{e} : (Exception[])GigaRegistrar.arrayAdd(exceptions, e);
            }
        }
        i = regIDs.length;
        while (--i >= 0) {
            if (renewals[i] < 0L) continue;
            int n = i;
            renewals[n] = renewals[n] - now;
        }
        return new RenewResults(renewals, exceptions);
    }

    private Exception[] cancelLeasesDo(Object[] regIDs, Uuid[] leaseIDs) {
        Exception[] exceptions = null;
        int i = regIDs.length;
        while (--i >= 0) {
            Object id = regIDs[i];
            try {
                if (id instanceof ServiceID) {
                    this.cancelServiceLeaseDo((ServiceID)id, leaseIDs[i]);
                    continue;
                }
                this.cancelEventLeaseDo((Long)id, leaseIDs[i]);
            }
            catch (Exception e) {
                if (exceptions == null) {
                    exceptions = new Exception[regIDs.length];
                }
                exceptions[i] = e;
            }
        }
        return exceptions;
    }

    private void generateEvents(Item pre, Item post, long now) {
        ServiceID sid = pre != null ? pre.serviceID : post.serviceID;
        Object val = this.subEventByService.get(sid);
        if (val instanceof EventReg) {
            this.generateEvent((EventReg)val, pre, post, sid, now);
        } else if (val != null) {
            EventReg[] regs = (EventReg[])val;
            int i = regs.length;
            while (--i >= 0) {
                this.generateEvent(regs[i], pre, post, sid, now);
            }
        }
        for (EventReg eventReg : this.subEventByID.values()) {
            this.generateEvent(eventReg, pre, post, sid, now);
        }
    }

    private void generateEvent(EventReg reg, Item pre, Item post, ServiceID sid, long now) {
        if (reg.leaseExpiration <= now) {
            return;
        }
        if ((reg.transitions & 2) != 0 && (pre == null || !GigaRegistrar.matchItem(reg.tmpl, pre)) && post != null && GigaRegistrar.matchItem(reg.tmpl, post)) {
            this.pendingEvent(reg, sid, post, 2);
        } else if ((reg.transitions & 1) != 0 && pre != null && GigaRegistrar.matchItem(reg.tmpl, pre) && (post == null || !GigaRegistrar.matchItem(reg.tmpl, post))) {
            this.pendingEvent(reg, sid, post, 1);
        } else if ((reg.transitions & 4) != 0 && pre != null && GigaRegistrar.matchItem(reg.tmpl, pre) && post != null && GigaRegistrar.matchItem(reg.tmpl, post)) {
            this.pendingEvent(reg, sid, post, 4);
        }
    }

    private void pendingEvent(EventReg reg, ServiceID sid, Item item, int transition) {
        this.pendingEvent(reg, sid, item, transition, true);
    }

    private void pendingEvent(EventReg reg, ServiceID sid, Item item, int transition, boolean copyItem) {
        if (item != null && copyItem) {
            item = GigaRegistrar.copyItem(item);
        }
        if (!this.eventByID.containsKey(reg.eventID)) {
            return;
        }
        List<RegistrarEvent> registrarEvents = this.pendingQ.get(reg);
        if (registrarEvents == null) {
            registrarEvents = Collections.synchronizedList(new ArrayList());
            this.pendingQ.put(reg, registrarEvents);
        }
        registrarEvents.add(new RegistrarEvent(this.proxy, reg.eventID, ++reg.seqNo, reg.handback, sid, transition, item));
    }

    private void queueEvents() {
        for (Map.Entry<EventReg, List<RegistrarEvent>> pending : this.pendingQ.entrySet()) {
            if (pending.getValue().isEmpty()) continue;
            List<RegistrarEvent> registrarEvents = this.eventsQ.get(pending.getKey());
            if (registrarEvents == null) {
                registrarEvents = Collections.synchronizedList(new ArrayList());
                registrarEvents.addAll((Collection<RegistrarEvent>)pending.getValue());
                this.eventsQ.put(pending.getKey(), registrarEvents);
            } else {
                registrarEvents.addAll((Collection<RegistrarEvent>)pending.getValue());
            }
            this.pendingEvents.inc(pending.getValue().size());
            pending.getValue().clear();
        }
        for (Map.Entry<EventReg, List<RegistrarEvent>> next : this.eventsQ.entrySet()) {
            EventReg reg;
            if (next.getValue().isEmpty() || next.getKey().isLocked() || !(reg = next.getKey()).acquireLock()) continue;
            this.taskerEvent.add(new EventTask(reg));
        }
    }

    private ServiceID newServiceID() {
        Uuid uuid = this.serviceIdGenerator.generate();
        return new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
    }

    private Uuid newLeaseID() {
        return this.resourceIdGenerator.generate();
    }

    private String asList(Object[] a) {
        if (a == null) {
            return "null";
        }
        return Arrays.asList(a).toString();
    }

    @Override
    public NIODetails getNIODetails() throws RemoteException {
        return NIOInfoHelper.getDetails();
    }

    @Override
    public NIOStatistics getNIOStatistics() throws RemoteException {
        return NIOInfoHelper.getNIOStatistics();
    }

    @Override
    public void enableLRMIMonitoring() throws RemoteException {
        NIOInfoHelper.enableMonitoring();
    }

    @Override
    public void disableLRMIMonitoring() throws RemoteException {
        NIOInfoHelper.disableMonitoring();
    }

    @Override
    public LRMIMonitoringDetails fetchLRMIMonitoringDetails() throws RemoteException {
        return NIOInfoHelper.fetchMonitoringDetails();
    }

    @Override
    public long getCurrentTimestamp() throws RemoteException {
        return System.currentTimeMillis();
    }

    @Override
    public OSDetails getOSDetails() throws RemoteException {
        return OSHelper.getDetails();
    }

    @Override
    public OSStatistics getOSStatistics() throws RemoteException {
        return OSHelper.getStatistics();
    }

    @Override
    public JVMDetails getJVMDetails() throws RemoteException {
        return JVMHelper.getDetails();
    }

    @Override
    public JVMStatistics getJVMStatistics() throws RemoteException {
        return JVMHelper.getStatistics();
    }

    @Override
    public void runGc() throws RemoteException {
        System.gc();
    }

    @Override
    public LogEntries logEntriesDirect(LogEntryMatcher matcher) throws RemoteException, IOException {
        return InternalLogHelper.logEntriesDirect(LogProcessType.LUS, matcher);
    }

    static /* synthetic */ ConcurrentNavigableMap access$2700(GigaRegistrar x0) {
        return x0.serviceByTime;
    }

    static /* synthetic */ Logger access$2800() {
        return loggerServiceExpire;
    }

    static /* synthetic */ ReadersWriter access$2900(GigaRegistrar x0) {
        return x0.concurrentObj;
    }

    static /* synthetic */ void access$3000(GigaRegistrar x0, SvcRegExpirationKey x1, SvcReg x2, long x3) {
        x0.deleteService(x1, x2, x3);
    }

    static /* synthetic */ void access$3100(GigaRegistrar x0) {
        x0.queueEvents();
    }

    static /* synthetic */ ConcurrentNavigableMap access$3200(GigaRegistrar x0) {
        return x0.eventByTime;
    }

    static /* synthetic */ Logger access$3300() {
        return loggerEventExpire;
    }

    static /* synthetic */ Map access$3400(GigaRegistrar x0) {
        return x0.eventByID;
    }

    static /* synthetic */ void access$3500(GigaRegistrar x0, EventRegKeyExpiration x1, EventReg x2) {
        x0.deleteEvent(x1, x2);
    }

    static {
        baseAttrs = new Entry[]{new ServiceInfo("Lookup", "Sun Microsystems, Inc.", "Sun Microsystems, Inc.", "2.1", "", ""), new BasicServiceType("Lookup")};
        emptyAttrs = new EntryRep[0];
        CLUSTED_PROXY_CLASSNAME = SpaceProxyImpl.class.getName();
        SERVICE_CLASSNAME = Service.class.getName();
        try {
            SERVICE_SERVICE_TYPE = ClassMapper.toServiceType(Service.class);
        }
        catch (MarshalException e) {
            logger.log(Level.SEVERE, "Failed to convert", e);
        }
    }

    private class AnnounceThread
    extends InterruptedStatusThread {
        private final MulticastSocket socket;
        private DatagramPacket[] dataPackets;
        private LookupLocator lastLocator;
        private String[] lastGroups;

        AnnounceThread() throws IOException {
            super("discovery announcement");
            this.dataPackets = null;
            this.setDaemon(true);
            if (GigaRegistrar.this.multicastInterfaces == null || GigaRegistrar.this.multicastInterfaces.length > 0) {
                this.socket = new MulticastSocket();
                this.socket.setTimeToLive(GigaRegistrar.this.multicastAnnouncementConstraints.getMulticastTimeToLive(Constants.getTtl()));
            } else {
                this.socket = null;
            }
        }

        public synchronized void run() {
            if (GigaRegistrar.this.multicastInterfaces != null && GigaRegistrar.this.multicastInterfaces.length == 0) {
                return;
            }
            try {
                while (!this.hasBeenInterrupted() && this.announce(GigaRegistrar.this.memberGroups)) {
                    ((Object)((Object)this)).wait(GigaRegistrar.this.multicastAnnouncementInterval);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (GigaRegistrar.this.memberGroups.length > 0) {
                this.announce(new String[0]);
            }
            this.socket.close();
        }

        private boolean announce(String[] groups) {
            if (this.dataPackets == null || !this.lastLocator.equals((Object)GigaRegistrar.this.myLocator) || !Arrays.equals(this.lastGroups, groups)) {
                Discovery disco;
                ArrayList<DatagramPacket> packets = new ArrayList<DatagramPacket>();
                try {
                    disco = GigaRegistrar.this.getDiscovery(GigaRegistrar.this.multicastAnnouncementConstraints.chooseProtocolVersion());
                }
                catch (DiscoveryProtocolException e) {
                    throw new AssertionError((Object)e);
                }
                EncodeIterator ei = disco.encodeMulticastAnnouncement(new MulticastAnnouncement(GigaRegistrar.this.announcementSeqNo++, GigaRegistrar.this.myLocator.getHost(), GigaRegistrar.this.myLocator.getPort(), groups, GigaRegistrar.this.myServiceID), GigaRegistrar.this.multicastAnnouncementConstraints.getMulticastMaxPacketSize(512), GigaRegistrar.this.multicastAnnouncementConstraints.getUnfulfilledConstraints());
                while (ei.hasNext()) {
                    try {
                        packets.addAll(Arrays.asList(ei.next()));
                    }
                    catch (Exception e) {
                        logger.log(e instanceof UnsupportedConstraintException ? Levels.HANDLED : Level.INFO, "exception encoding multicast announcement", e);
                    }
                }
                this.lastLocator = GigaRegistrar.this.myLocator;
                this.lastGroups = groups;
                this.dataPackets = packets.toArray(new DatagramPacket[packets.size()]);
            }
            try {
                this.send(this.dataPackets);
            }
            catch (InterruptedIOException e) {
                return false;
            }
            return true;
        }

        private void send(DatagramPacket[] packets) throws InterruptedIOException {
            if (GigaRegistrar.this.multicastInterfaces != null) {
                Level failureLogLevel = GigaRegistrar.this.multicastInterfacesSpecified ? Level.WARNING : Levels.HANDLED;
                long startTime = LogHelper.getCurrTimeIfNeeded((Logger)logger, (Level)Level.FINE);
                for (NetworkInterface multicastInterface : GigaRegistrar.this.multicastInterfaces) {
                    this.send(packets, multicastInterface, failureLogLevel);
                }
                if (logger.isLoggable(Level.FINE)) {
                    LogHelper.logDuration((Logger)logger, (Level)Level.FINE, (long)startTime, (String)(Thread.currentThread().getName() + ".send()"));
                }
            } else {
                this.send(packets, null, Level.WARNING);
            }
        }

        private void send(DatagramPacket[] packets, NetworkInterface nic, Level failureLogLevel) throws InterruptedIOException {
            if (nic != null) {
                long startTime = LogHelper.getCurrTimeIfNeeded((Logger)logger, (Level)Level.FINEST);
                try {
                    this.socket.setNetworkInterface(nic);
                    if (logger.isLoggable(Level.FINEST)) {
                        LogHelper.logDuration((Logger)logger, (Level)Level.FINEST, (long)startTime, (String)("send() - setNetworkInterface() for nic " + nic));
                    }
                }
                catch (SocketException e) {
                    if (logger.isLoggable(failureLogLevel)) {
                        GigaRegistrar.logThrow(failureLogLevel, ((Object)((Object)this)).getClass().getName(), "send", "exception setting {0}", new Object[]{nic}, e);
                    }
                    if (logger.isLoggable(Level.FINEST)) {
                        LogHelper.logDuration((Logger)logger, (Level)Level.FINEST, (long)startTime, (String)("send() - setNetworkInterface() failed for nic " + nic));
                    }
                    return;
                }
            }
            for (DatagramPacket packet : packets) {
                try {
                    this.socket.send(packet);
                }
                catch (InterruptedIOException e) {
                    throw e;
                }
                catch (IOException e) {
                    if (nic != null) {
                        if (!logger.isLoggable(failureLogLevel)) continue;
                        GigaRegistrar.logThrow(failureLogLevel, ((Object)((Object)this)).getClass().getName(), "send", "exception sending packet on {0}", new Object[]{nic}, e);
                        continue;
                    }
                    logger.log(failureLogLevel, "exception sending packet on default interface", e);
                }
            }
        }
    }

    private class UnicastThread
    extends InterruptedStatusThread {
        private ServerSocket listen;
        public int port;
        public final InetAddress host;

        UnicastThread(InetAddress host, int port) throws IOException {
            super("unicast request");
            this.setDaemon(true);
            int backlog = Integer.getInteger("com.gs.transport_protocol.lrmi.accpet-backlog", 1024);
            this.host = host;
            if (port == 0) {
                try {
                    this.listen = new ServerSocket(Constants.getDiscoveryPort(), backlog, host);
                }
                catch (IOException e) {
                    logger.log(Levels.HANDLED, "failed to bind to default port", e);
                }
            }
            if (this.listen == null) {
                this.listen = new ServerSocket(port, backlog, host);
            }
            this.port = this.listen.getLocalPort();
        }

        public void run() {
            while (!this.hasBeenInterrupted()) {
                try {
                    Socket socket = this.listen.accept();
                    if (this.hasBeenInterrupted()) {
                        try {
                            socket.close();
                        }
                        catch (IOException e) {
                            logger.log(Levels.HANDLED, "exception closing socket", e);
                        }
                        break;
                    }
                    SocketTask task = new SocketTask(socket);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Unicast task [" + System.identityHashCode(task) + "] added");
                    }
                    try {
                        GigaRegistrar.this.taskerComm.execute(task);
                    }
                    catch (RejectedExecutionException e) {
                        logger.warning("Rejected task because of overflow in backlog, please consider increasing either the commTaskManager number of threads, or its backlog");
                        try {
                            socket.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (InterruptedIOException e) {
                    break;
                }
                catch (Exception e) {
                    logger.log(Levels.HANDLED, "exception listening on socket", e);
                }
            }
            try {
                this.listen.close();
            }
            catch (IOException e) {
                logger.log(Levels.HANDLED, "exception closing server socket", e);
            }
        }

        @Override
        public synchronized void interrupt() {
            try {
                new Socket(this.host, this.port).close();
            }
            catch (IOException iOException) {
            }
            finally {
                super.interrupt();
            }
        }
    }

    private class MulticastThread
    extends InterruptedStatusThread {
        private final InetAddress requestAddr;
        private final MulticastSocket socket;
        private final List<NetworkInterface> failedInterfaces;

        MulticastThread() throws IOException {
            super("multicast request");
            this.failedInterfaces = new ArrayList<NetworkInterface>();
            this.setDaemon(true);
            if (GigaRegistrar.this.multicastInterfaces != null && GigaRegistrar.this.multicastInterfaces.length == 0) {
                this.requestAddr = null;
                this.socket = null;
                return;
            }
            this.requestAddr = Constants.getRequestAddress();
            this.socket = new MulticastSocket(Constants.getDiscoveryPort());
            if (GigaRegistrar.this.multicastInterfaces != null) {
                long startTime = LogHelper.getCurrTimeIfNeeded((Logger)logger, (Level)Level.FINE);
                Level failureLogLevel = GigaRegistrar.this.multicastInterfacesSpecified ? Level.WARNING : Levels.HANDLED;
                for (NetworkInterface nic : GigaRegistrar.this.multicastInterfaces) {
                    try {
                        long nicStartTime = LogHelper.getCurrTimeIfNeeded((Logger)logger, (Level)Level.FINEST);
                        this.socket.setNetworkInterface(nic);
                        if (logger.isLoggable(Level.FINEST)) {
                            LogHelper.logDuration((Logger)logger, (Level)Level.FINEST, (long)nicStartTime, (String)("MulticastThread() - setNetworkInterface() for nic " + nic));
                        }
                        this.socket.joinGroup(this.requestAddr);
                    }
                    catch (IOException e) {
                        this.failedInterfaces.add(nic);
                        if (!logger.isLoggable(failureLogLevel)) continue;
                        GigaRegistrar.logThrow(failureLogLevel, ((Object)((Object)this)).getClass().getName(), "<init>", "exception enabling {0}", new Object[]{nic}, e);
                    }
                }
                if (logger.isLoggable(Level.FINE)) {
                    LogHelper.logDuration((Logger)logger, (Level)Level.FINE, (long)startTime, (String)("MulticastThread() processed " + GigaRegistrar.this.multicastInterfaces.length + " network interfaces"));
                }
            } else {
                try {
                    this.socket.joinGroup(this.requestAddr);
                }
                catch (IOException e) {
                    this.failedInterfaces.add(null);
                    logger.log(Level.WARNING, "exception enabling default interface", e);
                }
            }
        }

        public void run() {
            if (GigaRegistrar.this.multicastInterfaces != null && GigaRegistrar.this.multicastInterfaces.length == 0) {
                return;
            }
            byte[] buf = new byte[GigaRegistrar.this.multicastRequestConstraints.getMulticastMaxPacketSize(512)];
            DatagramPacket dgram = new DatagramPacket(buf, buf.length);
            long retryTime = SystemTime.timeMillis() + (long)GigaRegistrar.this.multicastInterfaceRetryInterval;
            while (!this.hasBeenInterrupted()) {
                try {
                    int pv;
                    int timeout = 0;
                    if (!this.failedInterfaces.isEmpty() && (timeout = (int)(retryTime - SystemTime.timeMillis())) <= 0) {
                        this.retryFailedInterfaces();
                        if (this.failedInterfaces.isEmpty()) {
                            timeout = 0;
                        } else {
                            timeout = GigaRegistrar.this.multicastInterfaceRetryInterval;
                            retryTime = SystemTime.timeMillis() + (long)timeout;
                        }
                    }
                    this.socket.setSoTimeout(timeout);
                    dgram.setLength(buf.length);
                    try {
                        this.socket.receive(dgram);
                    }
                    catch (NullPointerException e) {
                        break;
                    }
                    try {
                        pv = ByteBuffer.wrap(dgram.getData(), dgram.getOffset(), dgram.getLength()).getInt();
                    }
                    catch (BufferUnderflowException e) {
                        throw new DiscoveryProtocolException(null, (Throwable)e);
                    }
                    GigaRegistrar.this.multicastRequestConstraints.checkProtocolVersion(pv);
                    GigaRegistrar.this.taskerComm.execute(new DecodeRequestTask(dgram, GigaRegistrar.this.getDiscovery(pv)));
                    buf = new byte[buf.length];
                    dgram = new DatagramPacket(buf, buf.length);
                }
                catch (SocketTimeoutException timeout) {
                }
                catch (InterruptedIOException e) {
                    break;
                }
                catch (Exception e) {
                    if (this.hasBeenInterrupted()) break;
                    logger.log(Levels.HANDLED, "exception receiving multicast request", e);
                }
            }
            this.socket.close();
        }

        @Override
        public synchronized void interrupt() {
            this.socket.close();
            super.interrupt();
        }

        private void retryFailedInterfaces() {
            Level level;
            Level level2 = level = GigaRegistrar.this.multicastInterfacesSpecified ? Level.INFO : Level.FINE;
            if (logger.isLoggable(level)) {
                logger.log(level, "retryFailedInterfaces() will attempt to enable " + this.failedInterfaces.size() + " interfaces...");
            }
            Iterator<NetworkInterface> i = this.failedInterfaces.iterator();
            while (i.hasNext()) {
                NetworkInterface nic = i.next();
                long startTime = LogHelper.getCurrTimeIfNeeded((Logger)logger, (Level)level);
                try {
                    if (nic != null) {
                        this.socket.setNetworkInterface(nic);
                    }
                    this.socket.joinGroup(this.requestAddr);
                    i.remove();
                    if (!logger.isLoggable(level)) continue;
                    String message = nic == null ? "Enabled default interface" : "Enabled " + nic;
                    LogHelper.logDuration((Logger)logger, (Level)level, (long)startTime, (String)message);
                }
                catch (IOException e) {
                    if (!logger.isLoggable(level)) continue;
                    String message = nic == null ? "Failed to enabled default interface" : "Failed to enabled " + nic;
                    LogHelper.logDuration((Logger)logger, (Level)level, (long)startTime, (String)message);
                }
            }
        }
    }

    private class EventExpireThread
    extends InterruptedStatusThread {
        EventExpireThread() {
            super("event expire");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            while (this.hasBeenInterrupted() == false) {
                while (true) lbl-1000:
                // 5 sources

                {
                    block27: {
                        now = SystemTime.timeMillis();
                        try {
                            regExpirationKey = (EventRegKeyExpiration)GigaRegistrar.access$3200(GigaRegistrar.this).firstKey();
                        }
                        catch (NoSuchElementException e) {
                            if (!GigaRegistrar.access$3300().isLoggable(Level.FINEST)) ** break;
                            GigaRegistrar.access$3300().finest("No events to check");
                            ** break;
                        }
                        if (regExpirationKey.leaseExpiration > now) {
                            if (!GigaRegistrar.access$3300().isLoggable(Level.FINEST)) ** break;
                            GigaRegistrar.access$3300().finest("[" + System.identityHashCode(regExpirationKey) + "]: Event [" + regExpirationKey.reg.eventID + "]: lease [" + regExpirationKey.leaseExpiration + "] is higher than [" + now + "], bail");
                            ** break;
                        }
                        if (GigaRegistrar.access$3300().isLoggable(Level.FINER)) {
                            GigaRegistrar.access$3300().finer("[" + System.identityHashCode(regExpirationKey) + "]: Event [" + regExpirationKey.reg.eventID + "]: lease [" + regExpirationKey.leaseExpiration + "] is lower than [" + now + "], try and expire...");
                        }
                        try {
                            GigaRegistrar.access$2900(GigaRegistrar.this).writeLock();
                        }
                        catch (ReadersWriter.ConcurrentLockException e) {
                            return;
                        }
                        var4_4 = regExpirationKey;
                        // MONITORENTER : var4_4
                        tmpReg = (EventReg)GigaRegistrar.access$3400(GigaRegistrar.this).get(regExpirationKey.reg.eventID);
                        if (tmpReg != null && tmpReg.leaseID.equals((Object)regExpirationKey.reg.leaseID)) break block27;
                        removed = GigaRegistrar.access$3200(GigaRegistrar.this).remove(regExpirationKey);
                        if (GigaRegistrar.access$3300().isLoggable(Level.FINER)) {
                            GigaRegistrar.access$3300().finer("[" + System.identityHashCode(regExpirationKey) + "]: Event [" + regExpirationKey.reg.eventID + "]: Not found, removing (" + (removed != null) + ")");
                        }
                        // MONITOREXIT : var4_4
                        GigaRegistrar.access$2900(GigaRegistrar.this).writeUnlock();
                    }
                    try {
                        otherFirstKey = (EventRegKeyExpiration)GigaRegistrar.access$3200(GigaRegistrar.this).firstKey();
                    }
                    catch (NoSuchElementException e) {
                        if (GigaRegistrar.access$3300().isLoggable(Level.FINEST)) {
                            GigaRegistrar.access$3300().finest("No events to check");
                        }
                        // MONITOREXIT : var4_4
                        GigaRegistrar.access$2900(GigaRegistrar.this).writeUnlock();
                        ** break;
                    }
                    if (!otherFirstKey.equals(regExpirationKey)) {
                        if (GigaRegistrar.access$3300().isLoggable(Level.FINEST)) {
                            GigaRegistrar.access$3300().finest("[" + System.identityHashCode(regExpirationKey) + "]: Event [" + regExpirationKey.reg.eventID + "]: Renew happened until lock acquired, continue");
                        }
                        // MONITOREXIT : var4_4
                        GigaRegistrar.access$2900(GigaRegistrar.this).writeUnlock();
                        continue;
                    }
                    try {
                        if (GigaRegistrar.access$3300().isLoggable(Level.FINE)) {
                            GigaRegistrar.access$3300().fine("[" + System.identityHashCode(regExpirationKey) + "]: Event [" + regExpirationKey.reg.eventID + "]: Expired, deleting ....");
                        }
                        GigaRegistrar.access$3500(GigaRegistrar.this, regExpirationKey, regExpirationKey.reg);
                        // MONITOREXIT : var4_4
                    }
                    finally {
                        GigaRegistrar.access$2900(GigaRegistrar.this).writeUnlock();
                        continue;
                    }
                    break;
                }
                ** GOTO lbl-1000
lbl61:
                // 5 sources

                try {
                    if (GigaRegistrar.access$3300().isLoggable(Level.FINEST)) {
                        GigaRegistrar.access$3300().finest("Sleeping for 500 millis");
                    }
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    private class ServiceExpireThread
    extends InterruptedStatusThread {
        ServiceExpireThread() {
            super("service expire");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            while (this.hasBeenInterrupted() == false) {
                while (true) lbl-1000:
                // 5 sources

                {
                    block27: {
                        now = SystemTime.timeMillis();
                        try {
                            regExpirationKey = (SvcRegExpirationKey)GigaRegistrar.access$2700(GigaRegistrar.this).firstKey();
                        }
                        catch (NoSuchElementException e) {
                            if (!GigaRegistrar.access$2800().isLoggable(Level.FINEST)) ** break;
                            GigaRegistrar.access$2800().finest("No services to check");
                            ** break;
                        }
                        if (regExpirationKey.leaseExpiration > now) {
                            if (!GigaRegistrar.access$2800().isLoggable(Level.FINEST)) ** break;
                            GigaRegistrar.access$2800().finest("[" + System.identityHashCode(regExpirationKey) + "]: Service [" + regExpirationKey.svcReg.item.serviceID + "]: lease [" + regExpirationKey.svcReg.leaseID + "/" + regExpirationKey.leaseExpiration + "] is higher than [" + now + "], bail");
                            ** break;
                        }
                        if (GigaRegistrar.access$2800().isLoggable(Level.FINER)) {
                            GigaRegistrar.access$2800().finer("[" + System.identityHashCode(regExpirationKey) + "]: Service [" + regExpirationKey.svcReg.item.serviceID + "]: lease [" + regExpirationKey.svcReg.leaseID + "/" + regExpirationKey.leaseExpiration + "] is lower than [" + now + "], try and expire...");
                        }
                        try {
                            GigaRegistrar.access$2900(GigaRegistrar.this).writeLock();
                        }
                        catch (ReadersWriter.ConcurrentLockException e) {
                            return;
                        }
                        var4_4 = regExpirationKey;
                        // MONITORENTER : var4_4
                        tmpReg = (SvcReg)GigaRegistrar.access$200(GigaRegistrar.this).get(regExpirationKey.svcReg.item.serviceID);
                        if (tmpReg != null && tmpReg.leaseID.equals((Object)regExpirationKey.svcReg.leaseID)) break block27;
                        removed = GigaRegistrar.access$2700(GigaRegistrar.this).remove(regExpirationKey);
                        if (GigaRegistrar.access$2800().isLoggable(Level.FINER)) {
                            GigaRegistrar.access$2800().finer("[" + System.identityHashCode(regExpirationKey) + "]: Service [" + regExpirationKey.svcReg.item.serviceID + "]: Not found, removing (" + (removed != null) + ")");
                        }
                        // MONITOREXIT : var4_4
                        GigaRegistrar.access$2900(GigaRegistrar.this).writeUnlock();
                    }
                    try {
                        otherExpirationKey = (SvcRegExpirationKey)GigaRegistrar.access$2700(GigaRegistrar.this).firstKey();
                    }
                    catch (NoSuchElementException e) {
                        if (GigaRegistrar.access$2800().isLoggable(Level.FINEST)) {
                            GigaRegistrar.access$2800().finest("No services to check");
                        }
                        // MONITOREXIT : var4_4
                        GigaRegistrar.access$2900(GigaRegistrar.this).writeUnlock();
                        ** break;
                    }
                    if (!otherExpirationKey.equals(regExpirationKey)) {
                        if (GigaRegistrar.access$2800().isLoggable(Level.FINEST)) {
                            GigaRegistrar.access$2800().finer("[" + System.identityHashCode(regExpirationKey) + "]: Service [" + regExpirationKey.svcReg.item.serviceID + "]: Renew happened until lock acquired, continue");
                        }
                        // MONITOREXIT : var4_4
                        GigaRegistrar.access$2900(GigaRegistrar.this).writeUnlock();
                        continue;
                    }
                    try {
                        if (GigaRegistrar.access$2800().isLoggable(Level.FINE)) {
                            GigaRegistrar.access$2800().fine("[" + System.identityHashCode(regExpirationKey) + "]: Service [" + regExpirationKey.svcReg.item.serviceID + "]: Expired, deleting ....");
                        }
                        GigaRegistrar.access$3000(GigaRegistrar.this, regExpirationKey, regExpirationKey.svcReg, now);
                        GigaRegistrar.access$3100(GigaRegistrar.this);
                        // MONITOREXIT : var4_4
                    }
                    finally {
                        GigaRegistrar.access$2900(GigaRegistrar.this).writeUnlock();
                        continue;
                    }
                    break;
                }
                ** GOTO lbl-1000
lbl62:
                // 5 sources

                try {
                    if (GigaRegistrar.access$2800().isLoggable(Level.FINEST)) {
                        GigaRegistrar.access$2800().finest("Sleeping for 200 millis");
                    }
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    private final class SocketTask
    implements Runnable {
        public final Socket socket;

        SocketTask(Socket socket) {
            this.socket = socket;
        }

        @Override
        public void run() {
            block4: {
                try {
                    long time = 0L;
                    if (logger.isLoggable(Level.FINEST)) {
                        time = SystemTime.timeMillis();
                    }
                    GigaRegistrar.this.respond(this.socket);
                    if (logger.isLoggable(Level.FINEST)) {
                        long took = SystemTime.timeMillis() - time;
                        logger.log(Level.FINEST, "Unicast task [" + System.identityHashCode(this) + "] executed, took [" + took + "ms]");
                    }
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Levels.HANDLED)) break block4;
                    GigaRegistrar.logThrow(Levels.HANDLED, this.getClass().getName(), "run", "exception handling unicast discovery from {0}:{1}", new Object[]{this.socket.getInetAddress(), this.socket.getPort()}, e);
                }
            }
        }

        public boolean runAfter(List tasks, int size) {
            return false;
        }
    }

    private final class AddressTask
    implements TaskManager.Task {
        public final String host;
        public final int port;

        AddressTask(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public int hashCode() {
            return this.host.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AddressTask)) {
                return false;
            }
            AddressTask ua = (AddressTask)obj;
            return this.host.equals(ua.host) && this.port == ua.port;
        }

        @Override
        public void run() {
            block12: {
                InetAddress[] addr = new InetAddress[]{};
                try {
                    int timeout;
                    block11: {
                        try {
                            InetAddress[] addrByName = InetAddress.getAllByName(this.host);
                            if (addrByName != null) {
                                addr = addrByName;
                            }
                        }
                        catch (UnknownHostException e) {
                            if (!logger.isLoggable(Level.INFO)) break block11;
                            GigaRegistrar.logThrow(Level.INFO, this.getClass().getName(), "run", "failed to resolve host {0}; connection will still be attempted", new Object[]{this.host}, e);
                        }
                    }
                    long deadline = DiscoveryConstraints.process((InvocationConstraints)GigaRegistrar.this.rawUnicastDiscoveryConstraints).getConnectionDeadline(Long.MAX_VALUE);
                    long now = System.currentTimeMillis();
                    if (deadline <= now) {
                        throw new SocketTimeoutException("timeout expired before connection attempt");
                    }
                    long timeLeft = deadline - now;
                    int n = timeout = timeLeft >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)timeLeft;
                    if (addr.length == 0) {
                        this.attemptResponse(new InetSocketAddress(this.host, this.port), timeout);
                        return;
                    }
                    for (InetAddress anAddr : addr) {
                        try {
                            this.attemptResponse(new InetSocketAddress(anAddr, this.port), timeout);
                            return;
                        }
                        catch (Exception e) {
                            if (logger.isLoggable(Levels.HANDLED)) {
                                GigaRegistrar.logThrow(Levels.HANDLED, this.getClass().getName(), "run", "exception responding to {0}:{1}", new Object[]{anAddr, this.port}, e);
                            }
                            int n2 = timeout = (timeLeft = deadline - System.currentTimeMillis()) >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)timeLeft;
                            if (timeLeft > 0L) continue;
                            throw new SocketTimeoutException("timeout expired before successful response");
                        }
                    }
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.INFO)) break block12;
                    GigaRegistrar.logThrow(Level.INFO, this.getClass().getName(), "run", "failed to respond to {0} on port {1}", new Object[]{Arrays.asList(addr), this.port}, e);
                }
            }
        }

        @Override
        public boolean runAfter(List tasks, int size) {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void attemptResponse(InetSocketAddress addr, int timeout) throws Exception {
            Socket s = new Socket();
            try {
                s.connect(addr, timeout);
                GigaRegistrar.this.respond(s);
            }
            finally {
                try {
                    s.close();
                }
                catch (IOException e) {
                    logger.log(Levels.HANDLED, "exception closing socket", e);
                }
            }
        }
    }

    private final class DecodeRequestTask
    implements Runnable {
        private final DatagramPacket datagram;
        private final Discovery decoder;

        DecodeRequestTask(DatagramPacket datagram, Discovery decoder) {
            this.datagram = datagram;
            this.decoder = decoder;
        }

        @Override
        public void run() {
            MulticastRequest req;
            try {
                req = this.decoder.decodeMulticastRequest(this.datagram, GigaRegistrar.this.multicastRequestConstraints.getUnfulfilledConstraints(), GigaRegistrar.this.multicastRequestSubjectChecker, true);
            }
            catch (Exception e) {
                if (!(e instanceof InterruptedIOException) && logger.isLoggable(Levels.HANDLED)) {
                    GigaRegistrar.logThrow(Levels.HANDLED, this.getClass().getName(), "run", "exception decoding multicast request from {0}:{1}", new Object[]{this.datagram.getAddress(), this.datagram.getPort()}, e);
                }
                return;
            }
            Object[] groups = req.getGroups();
            if ((groups.length == 0 || GigaRegistrar.overlap(GigaRegistrar.this.memberGroups, groups)) && GigaRegistrar.indexOf(req.getServiceIDs(), GigaRegistrar.this.myServiceID) < 0) {
                try {
                    req.checkConstraints();
                }
                catch (Exception e) {
                    if (!(e instanceof InterruptedIOException) && logger.isLoggable(Levels.HANDLED)) {
                        GigaRegistrar.logThrow(Levels.HANDLED, this.getClass().getName(), "run", "exception decoding multicast request from {0}:{1}", new Object[]{this.datagram.getAddress(), this.datagram.getPort()}, e);
                    }
                    return;
                }
                GigaRegistrar.this.taskerComm.execute(new AddressTask(req.getHost(), req.getPort()));
            }
        }

        public boolean runAfter(List tasks, int size) {
            return false;
        }
    }

    private final class EventTask
    implements TaskManager.Task {
        public final EventReg reg;

        EventTask(EventReg reg) {
            this.reg = reg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Notifying listener {0} of event {1}", new Object[]{this.reg.listener, this.reg.eventID});
            }
            boolean requeue = false;
            try {
                List registrarEvents = (List)GigaRegistrar.this.eventsQ.get(this.reg);
                if (registrarEvents == null) {
                    return;
                }
                int limit = this.calcSizeWithLoadFactor(registrarEvents);
                for (int i = 0; i < limit; ++i) {
                    if (this.isEventDeleted() || this.isProxyClosed()) {
                        return;
                    }
                    if (registrarEvents.isEmpty()) {
                        return;
                    }
                    if (!GigaRegistrar.this.eventsQ.containsKey(this.reg)) {
                        return;
                    }
                    if (this.exceededMaximumEventsAllowedPerRegistration(registrarEvents)) {
                        return;
                    }
                    RegistrarEvent theEvent = (RegistrarEvent)((Object)registrarEvents.remove(0));
                    if (theEvent == null) {
                        return;
                    }
                    if (this.sendEvent(theEvent)) continue;
                    return;
                }
                if (registrarEvents.size() != 0) {
                    requeue = true;
                }
            }
            finally {
                if (requeue) {
                    GigaRegistrar.this.taskerEvent.add(new EventTask(this.reg));
                } else {
                    this.reg.releaseLock();
                }
            }
        }

        private int calcSizeWithLoadFactor(List<RegistrarEvent> registrarEvents) {
            return (int)((float)(registrarEvents.size() + 1) * 1.75f);
        }

        private boolean exceededMaximumEventsAllowedPerRegistration(List<RegistrarEvent> events) {
            boolean exceededBounds;
            int size = events.size();
            boolean bl = exceededBounds = size > GigaRegistrar.this.maxEventsPerEventReg;
            if (exceededBounds) {
                try {
                    logger.log(Level.WARNING, "Cancelling registered listener: " + this.reg + " - its events queue size (" + size + ") exceeded the maximum of " + GigaRegistrar.this.maxEventsPerEventReg + ".");
                    GigaRegistrar.this.cancelEventLease(this.reg.eventID, this.reg.leaseID);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to cancel registered listener: " + this.reg, e);
                }
            }
            return exceededBounds;
        }

        private boolean sendEvent(RegistrarEvent theEvent) {
            try {
                GigaRegistrar.this.pendingEvents.dec();
                this.reg.listener.notify((RemoteEvent)theEvent);
                return true;
            }
            catch (Throwable e) {
                if (this.isEventDeleted() || this.isProxyClosed()) {
                    return false;
                }
                switch (ThrowableConstants.retryable(e)) {
                    case 2: {
                        if (e instanceof Error) {
                            logger.log(Levels.HANDLED, "Exception sending event to [" + this.reg.listener + "], serviceID [" + theEvent.getServiceID() + "], eventID [" + this.reg.eventID + "], " + this.reg.tmpl, e);
                            throw (Error)e;
                        }
                    }
                    case 1: 
                    case 3: {
                        if (logger.isLoggable(Levels.HANDLED)) {
                            logger.log(Levels.HANDLED, "Exception sending event to [" + this.reg.listener + "], ServiceID [" + theEvent.getServiceID() + "], eventID [" + this.reg.eventID + "], " + this.reg.tmpl + " canceling lease [" + this.reg.leaseID + "]", e);
                        }
                        try {
                            GigaRegistrar.this.cancelEventLease(this.reg.eventID, this.reg.leaseID);
                            break;
                        }
                        catch (UnknownLeaseException ee) {
                            logger.log(Levels.HANDLED, "Exception canceling event lease", e);
                            break;
                        }
                        catch (RemoteException ee) {
                            logger.log(Levels.HANDLED, "The server has been shutdown", e);
                        }
                    }
                }
                return false;
            }
        }

        private boolean isEventDeleted() {
            if (this.reg.tmpl.serviceID != null) {
                return !GigaRegistrar.this.subEventByService.containsKey(this.reg.tmpl.serviceID);
            }
            return !GigaRegistrar.this.subEventByID.containsKey(this.reg.eventID);
        }

        private boolean isProxyClosed() {
            ILRMIProxy ilrmiProxy = (ILRMIProxy)this.reg.listener;
            return ilrmiProxy.isClosed();
        }

        @Override
        public boolean runAfter(List tasks, int size) {
            return false;
        }
    }

    private class IDItemIter
    extends ItemIter {
        IDItemIter(Template tmpl) {
            super(tmpl);
            this.reg = (SvcReg)GigaRegistrar.this.serviceByID.get(tmpl.serviceID);
            if (!(this.reg == null || this.reg.leaseExpiration > this.now && GigaRegistrar.matchItem(tmpl, this.reg.item))) {
                this.reg = null;
            }
        }

        @Override
        protected void step() {
            this.reg = null;
        }
    }

    private class ClassItemIter
    extends ItemIter {
        private final EntryClass eclass;
        private int classidx;
        private Iterator iter;
        private ArrayList svcs;
        private int svcidx;

        ClassItemIter(Template tmpl) {
            super(tmpl);
            this.svcidx = 0;
            this.dupsPossible = true;
            this.eclass = tmpl.attributeSetTemplates[0].eclass;
            this.classidx = GigaRegistrar.this.entryClasses.size();
            this.step();
        }

        @Override
        protected void step() {
            while (true) {
                if (--this.svcidx >= 0) {
                    this.reg = (SvcReg)this.svcs.get(this.svcidx);
                    if (this.reg.leaseExpiration <= this.now || !GigaRegistrar.matchAttributes(this.tmpl, this.reg.item)) continue;
                    return;
                }
                if (!this.stepValue()) break;
            }
            this.reg = null;
        }

        private boolean stepValue() {
            do {
                if (this.iter != null && this.iter.hasNext()) {
                    this.svcs = (ArrayList)this.iter.next();
                    this.svcidx = this.svcs.size();
                    return true;
                }
                if (this.stepClass()) continue;
                return false;
            } while (this.iter != null);
            return true;
        }

        private boolean stepClass() {
            while (--this.classidx >= 0) {
                EntryClass cand = (EntryClass)GigaRegistrar.this.entryClasses.get(this.classidx);
                if (!this.eclass.isAssignableFrom(cand)) continue;
                if (cand.getNumFields() > 0) {
                    cand = GigaRegistrar.getDefiningClass(cand, cand.getNumFields() - 1);
                    HashMap[] attrMaps = (HashMap[])GigaRegistrar.this.serviceByAttr.get(cand);
                    this.iter = attrMaps[attrMaps.length - 1].values().iterator();
                } else {
                    this.iter = null;
                    this.svcs = (ArrayList)GigaRegistrar.this.serviceByEmptyAttr.get(cand);
                    this.svcidx = this.svcs.size();
                }
                return true;
            }
            return false;
        }
    }

    private class EmptyAttrItemIter
    extends AttrItemIter {
        EmptyAttrItemIter(Template tmpl, EntryClass eclass) {
            super(tmpl);
            this.svcs = (ArrayList)GigaRegistrar.this.serviceByEmptyAttr.get(eclass);
            if (this.svcs != null) {
                this.svcidx = this.svcs.size();
                this.step();
            }
        }
    }

    private class AttrItemIter
    extends ItemIter {
        protected ArrayList svcs;
        protected int svcidx;

        AttrItemIter(Template tmpl, int setidx, int fldidx) {
            super(tmpl);
            EntryRep set = tmpl.attributeSetTemplates[setidx];
            HashMap[] attrMaps = (HashMap[])GigaRegistrar.this.serviceByAttr.get(GigaRegistrar.getDefiningClass(set.eclass, fldidx));
            if (attrMaps != null && attrMaps[fldidx] != null) {
                this.svcs = (ArrayList)attrMaps[fldidx].get(set.fields[fldidx]);
                if (this.svcs != null) {
                    this.svcidx = this.svcs.size();
                    this.step();
                }
            }
        }

        AttrItemIter(Template tmpl) {
            super(tmpl);
        }

        @Override
        protected void step() {
            while (--this.svcidx >= 0) {
                this.reg = (SvcReg)this.svcs.get(this.svcidx);
                if (this.reg.leaseExpiration <= this.now || !GigaRegistrar.matchAttributes(this.tmpl, this.reg.item)) continue;
                return;
            }
            this.reg = null;
        }
    }

    private class SvcIterator
    extends ItemIter {
        private final Iterator services;

        SvcIterator(Template tmpl) {
            super(tmpl);
            Map map = (Map)GigaRegistrar.this.serviceByTypeName.get(tmpl.serviceTypes[0].getName());
            this.services = map != null ? map.values().iterator() : Collections.EMPTY_LIST.iterator();
            this.step();
        }

        @Override
        protected void step() {
            if (this.tmpl.serviceTypes.length > 1) {
                while (this.services.hasNext()) {
                    this.reg = (SvcReg)this.services.next();
                    if (this.reg.leaseExpiration <= this.now || !GigaRegistrar.matchType(this.tmpl.serviceTypes, this.reg.item.serviceType) || !GigaRegistrar.matchAttributes(this.tmpl, this.reg.item)) continue;
                    return;
                }
            } else {
                while (this.services.hasNext()) {
                    this.reg = (SvcReg)this.services.next();
                    if (this.reg.leaseExpiration <= this.now || !GigaRegistrar.matchAttributes(this.tmpl, this.reg.item)) continue;
                    return;
                }
            }
            this.reg = null;
        }
    }

    private class AllItemIter
    extends ItemIter {
        private final Iterator<SvcReg> iter;

        AllItemIter() {
            super(null);
            this.iter = GigaRegistrar.this.serviceByID.values().iterator();
            this.step();
        }

        @Override
        protected void step() {
            while (this.iter.hasNext()) {
                this.reg = this.iter.next();
                if (this.reg.leaseExpiration <= this.now) continue;
                return;
            }
            this.reg = null;
        }

        @Override
        public int suggestedSize() {
            return GigaRegistrar.this.serviceByID.size();
        }
    }

    private abstract class ItemIter {
        public final long now = SystemTime.timeMillis();
        public boolean dupsPossible = false;
        protected final Template tmpl;
        protected SvcReg reg;

        protected ItemIter(Template tmpl) {
            this.tmpl = tmpl;
        }

        public boolean hasNext() {
            return this.reg != null;
        }

        public Item next() {
            if (this.reg == null) {
                throw new NoSuchElementException();
            }
            Item item = this.reg.item;
            this.step();
            return item;
        }

        public SvcReg nextReg() {
            if (this.reg == null) {
                throw new NoSuchElementException();
            }
            SvcReg cur = this.reg;
            this.step();
            return cur;
        }

        protected abstract void step();

        public int suggestedSize() {
            return 10;
        }
    }

    private static final class EventReg
    implements Comparable<EventReg>,
    Serializable {
        private static final long serialVersionUID = 4L;
        public final long eventID;
        public final Uuid leaseID;
        public final Template tmpl;
        public final int transitions;
        public long seqNo;
        public transient RemoteEventListener listener;
        public final MarshalledObject handback;
        public volatile long leaseExpiration;
        private transient AtomicBoolean locked = new AtomicBoolean(false);

        EventReg(long eventID, Uuid leaseID, Template tmpl, int transitions, RemoteEventListener listener, MarshalledObject handback, long leaseExpiration) {
            this.eventID = eventID;
            this.leaseID = leaseID;
            this.tmpl = tmpl;
            this.transitions = transitions;
            this.seqNo = 0L;
            this.listener = listener;
            this.handback = handback;
            this.leaseExpiration = leaseExpiration;
        }

        @Override
        public int compareTo(EventReg reg) {
            if (this == reg) {
                return 0;
            }
            if (this.leaseExpiration < reg.leaseExpiration || this.leaseExpiration == reg.leaseExpiration && this.eventID < reg.eventID) {
                return -1;
            }
            return 1;
        }

        public int hashCode() {
            return this.leaseID.hashCode() + (int)(this.eventID ^ this.eventID >>> 32);
        }

        public boolean isLocked() {
            return this.locked.get();
        }

        public boolean acquireLock() {
            return this.locked.compareAndSet(false, true);
        }

        public void releaseLock() {
            this.locked.set(false);
        }

        public String toString() {
            return this.listenerToString(this.listener) + " - reg.#" + this.eventID;
        }

        private String listenerToString(RemoteEventListener r) {
            String ref = r.toString();
            int start = ref.indexOf("//");
            if (start != -1) {
                int end = ref.indexOf("]/", start);
                return ref.substring(start + 2, end + 2);
            }
            return ref;
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
            stream.writeObject(new MarshalledInstance((Object)this.listener));
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            MarshalledInstance mi = (MarshalledInstance)stream.readObject();
            try {
                this.listener = (RemoteEventListener)mi.get(false);
            }
            catch (Throwable e) {
                if (e instanceof Error && ThrowableConstants.retryable(e) == 2) {
                    throw (Error)e;
                }
                logger.log(Level.WARNING, "failed to recover event listener", e);
            }
        }
    }

    private static final class EventRegKeyExpiration
    implements Comparable<EventRegKeyExpiration> {
        public final EventReg reg;
        public final long leaseExpiration;

        private EventRegKeyExpiration(EventReg reg, long leaseExpiration) {
            this.reg = reg;
            this.leaseExpiration = leaseExpiration;
        }

        @Override
        public int compareTo(EventRegKeyExpiration reg) {
            if (this == reg) {
                return 0;
            }
            int delta = (int)(this.leaseExpiration - reg.leaseExpiration);
            if (delta != 0) {
                return delta;
            }
            return (int)(this.reg.eventID - reg.reg.eventID);
        }
    }

    private static final class SvcReg
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = 2L;
        public final Item item;
        public final Uuid leaseID;
        public final long registrationTime;
        public volatile long leaseExpiration;

        public SvcReg(Item item, Uuid leaseID, long registrationTime, long leaseExpiration) {
            this.item = item;
            this.leaseID = leaseID;
            this.registrationTime = registrationTime;
            this.leaseExpiration = leaseExpiration;
        }

        public int compareTo(Object obj) {
            if (obj == null) {
                return -1;
            }
            SvcReg reg = (SvcReg)obj;
            if (this == reg) {
                return 0;
            }
            int i = SvcReg.compare(this.leaseExpiration, reg.leaseExpiration);
            if (i != 0) {
                return i;
            }
            i = SvcReg.compare(this.leaseID.getMostSignificantBits(), reg.leaseID.getMostSignificantBits());
            if (i != 0) {
                return i;
            }
            return SvcReg.compare(this.leaseID.getLeastSignificantBits(), reg.leaseID.getLeastSignificantBits());
        }

        private static int compare(long l1, long l2) {
            return l1 < l2 ? -1 : (l1 > l2 ? 1 : 0);
        }
    }

    private static final class SvcRegExpirationKey
    implements Comparable {
        public final SvcReg svcReg;
        public final long leaseExpiration;

        private SvcRegExpirationKey(SvcReg svcReg, long leaseExpiration) {
            this.svcReg = svcReg;
            this.leaseExpiration = leaseExpiration;
        }

        public int compareTo(Object obj) {
            SvcRegExpirationKey reg = (SvcRegExpirationKey)obj;
            if (this == reg) {
                return 0;
            }
            int i = SvcRegExpirationKey.compare(this.leaseExpiration, reg.leaseExpiration);
            if (i != 0) {
                return i;
            }
            i = SvcRegExpirationKey.compare(this.svcReg.leaseID.getMostSignificantBits(), reg.svcReg.leaseID.getMostSignificantBits());
            if (i != 0) {
                return i;
            }
            return SvcRegExpirationKey.compare(this.svcReg.leaseID.getLeastSignificantBits(), reg.svcReg.leaseID.getLeastSignificantBits());
        }

        private static int compare(long l1, long l2) {
            return l1 < l2 ? -1 : (l1 > l2 ? 1 : 0);
        }
    }
}

