/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.gigaspaces.time.SystemTime;
import com.sun.jini.lease.AbstractLeaseMap;
import com.sun.jini.reggie.Registrar;
import com.sun.jini.reggie.RegistrarLease;
import com.sun.jini.reggie.RenewResults;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseMapException;
import net.jini.core.lookup.ServiceID;
import net.jini.id.Uuid;

class RegistrarLeaseMap
extends AbstractLeaseMap {
    private static final long serialVersionUID = 2L;
    final Registrar server;
    final ServiceID registrarID;

    RegistrarLeaseMap(RegistrarLease lease, long duration) {
        this(lease.getRegistrar(), lease, duration);
    }

    RegistrarLeaseMap(Registrar server, RegistrarLease lease, long duration) {
        super((Lease)lease, duration);
        this.server = server;
        this.registrarID = lease.getRegistrarID();
    }

    public boolean canContainKey(Object key) {
        return key instanceof RegistrarLease && this.registrarID.equals((Object)((RegistrarLease)((Object)key)).getRegistrarID());
    }

    public void renewAll() throws LeaseMapException, RemoteException {
        int size = this.map.size();
        if (size == 0) {
            return;
        }
        Object[] regIDs = new Object[size];
        Uuid[] leaseIDs = new Uuid[size];
        long[] durations = new long[size];
        int i = 0;
        for (Map.Entry e : this.map.entrySet()) {
            RegistrarLease ls = (RegistrarLease)((Object)e.getKey());
            regIDs[i] = ls.getRegID();
            leaseIDs[i] = ls.getReferentUuid();
            durations[i] = (Long)e.getValue();
            ++i;
        }
        RenewResults results = this.server.renewLeases(regIDs, leaseIDs, durations);
        long now = SystemTime.timeMillis();
        HashMap emap = results.exceptions != null ? new HashMap(2 * results.exceptions.length + 1) : null;
        i = 0;
        int j = 0;
        Iterator iter = this.map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            long duration = results.durations[i];
            if (duration >= 0L) {
                ((RegistrarLease)((Object)e.getKey())).setExpiration(duration + now);
            } else {
                emap.put(e.getKey(), results.exceptions[j++]);
                iter.remove();
            }
            ++i;
        }
        if (emap != null) {
            throw new LeaseMapException("lease renewal failures", emap);
        }
    }

    public void cancelAll() throws LeaseMapException, RemoteException {
        int size = this.map.size();
        if (size == 0) {
            return;
        }
        Object[] regIDs = new Object[size];
        Uuid[] leaseIDs = new Uuid[size];
        int i = 0;
        for (RegistrarLease ls : this.map.keySet()) {
            regIDs[i] = ls.getRegID();
            leaseIDs[i] = ls.getReferentUuid();
            ++i;
        }
        Exception[] exceptions = this.server.cancelLeases(regIDs, leaseIDs);
        if (exceptions == null) {
            return;
        }
        i = 0;
        HashMap<RegistrarLease, Exception> emap = new HashMap<RegistrarLease, Exception>(13);
        Iterator iter = this.map.keySet().iterator();
        while (iter.hasNext()) {
            RegistrarLease ls = (RegistrarLease)((Object)iter.next());
            Exception ex = exceptions[i];
            if (ex != null) {
                emap.put(ls, ex);
                iter.remove();
            }
            ++i;
        }
        throw new LeaseMapException("lease cancellation failures", emap);
    }
}

