/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.reggie.ConstrainableRegistration;
import com.sun.jini.reggie.EntryRep;
import com.sun.jini.reggie.Registrar;
import com.sun.jini.reggie.ServiceLease;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.rmi.RemoteException;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.entry.Entry;
import net.jini.core.lease.Lease;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceRegistration;
import net.jini.id.ReferentUuid;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;

class Registration
implements ServiceRegistration,
ReferentUuid,
Serializable {
    private static final long serialVersionUID = 2L;
    final Registrar server;
    final ServiceLease lease;

    static Registration getInstance(Registrar server, ServiceLease lease) {
        return server instanceof RemoteMethodControl ? new ConstrainableRegistration(server, lease, null) : new Registration(server, lease);
    }

    Registration(Registrar server, ServiceLease lease) {
        this.server = server;
        this.lease = lease;
    }

    public ServiceID getServiceID() {
        return this.lease.getServiceID();
    }

    public Lease getLease() {
        return this.lease;
    }

    public void addAttributes(Entry[] attrSets) throws UnknownLeaseException, RemoteException {
        this.server.addAttributes(this.lease.getServiceID(), this.lease.getReferentUuid(), EntryRep.toEntryRep(attrSets, true));
    }

    public void modifyAttributes(Entry[] attrSetTmpls, Entry[] attrSets) throws UnknownLeaseException, RemoteException {
        this.server.modifyAttributes(this.lease.getServiceID(), this.lease.getReferentUuid(), EntryRep.toEntryRep(attrSetTmpls, false), EntryRep.toEntryRep(attrSets, false));
    }

    public void setAttributes(Entry[] attrSets) throws UnknownLeaseException, RemoteException {
        this.server.setAttributes(this.lease.getServiceID(), this.lease.getReferentUuid(), EntryRep.toEntryRep(attrSets, true));
    }

    public Uuid getReferentUuid() {
        return this.lease.getReferentUuid();
    }

    public int hashCode() {
        return this.lease.getReferentUuid().hashCode();
    }

    public boolean equals(Object obj) {
        return ReferentUuids.compare((Object)this, (Object)obj);
    }

    public String toString() {
        return this.getClass().getName() + "[" + (Object)((Object)this.lease) + "]";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.server == null) {
            throw new InvalidObjectException("null server");
        }
        if (this.lease == null) {
            throw new InvalidObjectException("null lease");
        }
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("no data");
    }
}

