/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.gigaspaces.api.InternalApi;
import com.sun.jini.reggie.ClassMapper;
import com.sun.jini.reggie.EntryRep;
import com.sun.jini.reggie.ServiceType;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Arrays;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceTemplate;

@InternalApi
public class Template
implements Serializable {
    private static final long serialVersionUID = 2L;
    public ServiceID serviceID;
    public ServiceType[] serviceTypes;
    public EntryRep[] attributeSetTemplates;

    Template(ServiceID serviceID, ServiceType[] serviceTypes, EntryRep[] attributeSetTemplates) {
        this.serviceID = serviceID;
        this.serviceTypes = serviceTypes;
        this.attributeSetTemplates = attributeSetTemplates;
    }

    public Template(ServiceTemplate tmpl) throws RemoteException {
        this.serviceID = tmpl.serviceID;
        this.serviceTypes = ClassMapper.toServiceType(tmpl.serviceTypes);
        this.attributeSetTemplates = EntryRep.toEntryRep(tmpl.attributeSetTemplates, false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Template template = (Template)o;
        if (this.serviceID != null ? !this.serviceID.equals((Object)template.serviceID) : template.serviceID != null) {
            return false;
        }
        if (!Arrays.equals(this.attributeSetTemplates, template.attributeSetTemplates)) {
            return false;
        }
        return Arrays.equals(this.serviceTypes, template.serviceTypes);
    }

    public int hashCode() {
        int result = this.serviceID != null ? this.serviceID.hashCode() : 0;
        result = 31 * result + (this.serviceTypes != null ? Template.arrayHash(this.serviceTypes, false) : 0);
        result = 31 * result + (this.attributeSetTemplates != null ? Template.arrayHash(this.attributeSetTemplates, true) : 0);
        return result;
    }

    private static int arrayHash(Object[] a, boolean useIndexFactor) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (int i = 0; i < a.length; ++i) {
            result = 31 * result * (useIndexFactor ? i + 1 : 1) + (a[i] == null ? 0 : a[i].hashCode());
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Template [").append(this.hashCode()).append("] {");
        sb.append(this.serviceID).append(",").append("[");
        this.asList(this.serviceTypes, sb);
        sb.append("], [");
        this.asList(this.attributeSetTemplates, sb);
        sb.append("]}");
        return sb.toString();
    }

    private void asList(Object[] a, StringBuffer sb) {
        if (a == null) {
            sb.append("null");
            return;
        }
        for (int i = 0; i < a.length; ++i) {
            sb.append(a[i]).append(",");
        }
    }
}

