/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie.sender;

import com.gigaspaces.api.InternalApi;
import com.sun.jini.reggie.RegistrarEvent;
import java.util.List;
import net.jini.core.lookup.ServiceID;

@InternalApi
public class EventsCompressor {
    /*
     * Enabled aggressive block sorting
     */
    public static void compress(List<RegistrarEvent> events, RegistrarEvent event) {
        if (events.isEmpty()) {
            events.add(event);
            return;
        }
        int index = EventsCompressor.findEventWithServiceId(event.getServiceID(), events);
        if (-1 >= index) return;
        RegistrarEvent old = events.get(index);
        int oldTransition = old.getTransition();
        int currentTransition = event.getTransition();
        if (oldTransition == 1) {
            if (currentTransition == 1) {
                throw new IllegalStateException("compressing event " + (Object)((Object)event) + " onto " + events);
            }
            if (currentTransition == 2) {
                events.remove(index);
                return;
            }
            if (currentTransition != 4) throw new IllegalStateException("compressing event " + (Object)((Object)event) + " onto " + events);
            throw new IllegalStateException("compressing event " + (Object)((Object)event) + " onto " + events);
        }
        if (oldTransition == 2) {
            if (currentTransition == 1) {
                events.remove(index);
                return;
            }
            if (currentTransition == 2) {
                throw new IllegalStateException("compressing event " + (Object)((Object)event) + " onto " + events);
            }
            if (currentTransition != 4) throw new IllegalStateException("compressing event " + (Object)((Object)event) + " onto " + events);
            event.setTransition(4);
            events.set(index, event);
            return;
        }
        if (oldTransition != 4) throw new IllegalStateException("compressing event " + (Object)((Object)event) + " onto " + events);
        if (currentTransition == 1) {
            events.set(index, event);
            return;
        }
        if (currentTransition == 2) {
            throw new IllegalStateException("compressing event " + (Object)((Object)event) + " onto " + events);
        }
        if (currentTransition != 4) throw new IllegalStateException("compressing event " + (Object)((Object)event) + " onto " + events);
        events.set(index, event);
    }

    private static int findEventWithServiceId(ServiceID serviceID, List<RegistrarEvent> events) {
        int size = events.size();
        for (int i = size - 1; -1 < i; --i) {
            RegistrarEvent candidate = events.get(i);
            if (!candidate.getServiceID().equals((Object)serviceID)) continue;
            return i;
        }
        return -1;
    }
}

