/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.thread;

import com.gigaspaces.api.InternalApi;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;

@InternalApi
public class ReadyState {
    private static final int INITIALIZE = 0;
    private static final int READY = 1;
    private static final int SHUTDOWN = 2;
    private volatile int state = 0;

    public boolean isReady() {
        return this.state == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check() {
        block9: while (true) {
            switch (this.state) {
                case 0: {
                    try {
                        ReadyState readyState = this;
                        synchronized (readyState) {
                            if (this.state == 1) {
                                return;
                            }
                            this.wait(1000L);
                            continue block9;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue block9;
                    }
                }
                case 1: {
                    return;
                }
            }
            break;
        }
        throw new RemoteExceptionWrapper(new NoSuchObjectException("service is unavailable"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ready() {
        switch (this.state) {
            case 0: {
                this.state = 1;
                ReadyState readyState = this;
                synchronized (readyState) {
                    this.notifyAll();
                    break;
                }
            }
            default: {
                throw new AssertionError((Object)"ready is only called when the service is in the INITIALIZE state");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.check();
        this.state = 2;
        ReadyState readyState = this;
        synchronized (readyState) {
            this.notifyAll();
        }
    }

    private static class RemoteExceptionWrapper
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final RemoteException wrapped;

        public RemoteExceptionWrapper(RemoteException wrapped) {
            this.wrapped = wrapped;
        }

        private Object writeReplace() {
            return this.wrapped;
        }

        @Override
        public String toString() {
            return this.wrapped == null ? "" : this.wrapped.toString();
        }
    }
}

