/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.thread;

import com.gigaspaces.api.InternalApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class TaskManager {
    protected static final Logger logger = Logger.getLogger("com.sun.jini.thread.TaskManager");
    protected final ArrayList<Task> tasks = new ArrayList();
    protected int firstPending = 0;
    protected final List roTasks = Collections.unmodifiableList(this.tasks);
    protected final List<TaskThread> threads = new ArrayList<TaskThread>();
    protected final int maxThreads;
    protected final long timeout;
    protected final float loadFactor;
    protected boolean terminated = false;
    private ClassLoader contextClassLoader;
    private String threadName = "task";
    private int retriesOnIdle = 1;
    private int threadPriority = 5;
    private StackTraceElement[] creationStackTrace;

    public TaskManager() {
        this(10, 15000L, 3.0f);
    }

    public TaskManager(int maxThreads, long timeout, float loadFactor) {
        this(maxThreads, timeout, loadFactor, "task", 1);
    }

    public TaskManager(int maxThreads, long timeout, float loadFactor, String threadName, int retriesOnIdle) {
        this(maxThreads, timeout, loadFactor, threadName, retriesOnIdle, 5);
    }

    public TaskManager(int maxThreads, long timeout, float loadFactor, String threadName, int retriesOnIdle, int threadPriority) {
        if (logger.isLoggable(Level.FINEST)) {
            this.creationStackTrace = new Exception().getStackTrace();
        }
        this.maxThreads = maxThreads;
        this.timeout = timeout;
        this.loadFactor = loadFactor;
        this.threadName = "GS-" + threadName;
        this.retriesOnIdle = retriesOnIdle;
        this.threadPriority = threadPriority;
        this.contextClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public synchronized void addIfNew(Task t) {
        if (!this.tasks.contains(t)) {
            this.addInternal(t);
        }
    }

    public synchronized void add(Task t) {
        this.addInternal(t);
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public String getThreadName() {
        return this.threadName;
    }

    private void addInternal(Task t) {
        this.tasks.add(t);
        if (logger.isLoggable(Level.FINEST) && this.tasks.size() > 50) {
            StringBuffer sb = new StringBuffer();
            if (this.creationStackTrace != null) {
                for (int i = 0; i < this.creationStackTrace.length; ++i) {
                    sb.append(this.creationStackTrace[i]).append("\n");
                }
            }
            logger.warning("Task [" + this.threadName + "] has more than 50 tasks, consider reconfiguring it. Creation Stack Trace: \n" + sb.toString());
        }
        boolean poke = true;
        while (this.threads.size() < this.maxThreads && this.needThread()) {
            TaskThread th;
            try {
                th = new TaskThread();
                th.setPriority(this.threadPriority);
                th.setContextClassLoader(this.contextClassLoader);
                th.start();
            }
            catch (Throwable tt) {
                try {
                    logger.log(this.threads.isEmpty() ? Level.SEVERE : Level.WARNING, "thread creation exception", tt);
                }
                catch (Throwable throwable) {}
                break;
            }
            this.threads.add(th);
            poke = false;
        }
        if (poke && this.threads.size() > this.firstPending && !this.runAfter(t, this.tasks.size() - 1)) {
            this.notify();
        }
    }

    public synchronized void addAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            this.addInternal((Task)iter.next());
        }
    }

    protected boolean needThread() {
        int bound = (int)(this.loadFactor * (float)this.threads.size());
        int max = this.tasks.size();
        if (max < bound) {
            return false;
        }
        if (this.runAfter(this.tasks.get(--max), max)) {
            return false;
        }
        int ready = this.firstPending + 1;
        if (ready > bound) {
            return true;
        }
        for (int i = this.firstPending; i < max; ++i) {
            if (this.runAfter(this.tasks.get(i), i) || ++ready <= bound) continue;
            return true;
        }
        return false;
    }

    private boolean runAfter(Task t, int i) {
        try {
            return t.runAfter(this.roTasks, i);
        }
        catch (Throwable tt) {
            try {
                logger.log(Level.WARNING, "Task.runAfter exception", tt);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }
    }

    public synchronized boolean removeIfPending(Task t) {
        return this.removeTask(t, this.firstPending);
    }

    public synchronized boolean remove(Task t) {
        return this.removeTask(t, 0);
    }

    private boolean removeTask(Task t, int min) {
        int i = this.tasks.size();
        while (--i >= min) {
            if (this.tasks.get(i) != t) continue;
            this.tasks.remove(i);
            if (i < this.firstPending) {
                --this.firstPending;
                int j = this.threads.size();
                while (--j >= 0) {
                    TaskThread thread = this.threads.get(j);
                    if (thread.task != t) continue;
                    if (thread == Thread.currentThread()) break;
                    thread.interrupt();
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public synchronized void terminate() {
        if (this.terminated) {
            return;
        }
        this.terminated = true;
        Thread currentThread = Thread.currentThread();
        for (Thread thread : this.threads) {
            if (thread.equals(currentThread)) continue;
            thread.interrupt();
        }
    }

    public synchronized boolean isTerminated() {
        return this.terminated;
    }

    public synchronized List<Task> getPending() {
        List tc = (List)this.tasks.clone();
        int i = this.firstPending;
        while (--i >= 0) {
            tc.remove(0);
        }
        return tc;
    }

    public synchronized int getTotalTasks() {
        return this.tasks.size();
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public synchronized int getThreadCount() {
        return this.threads.size();
    }

    public synchronized int getRunningThreadCount() {
        int count = 0;
        for (int i = 0; i < this.threads.size(); ++i) {
            if (this.threads.get((int)i).task == null) continue;
            ++count;
        }
        return count;
    }

    private class TaskThread
    extends Thread {
        public Task task;
        private int currentRetries;

        public TaskThread() {
            super(TaskManager.this.threadName);
            this.task = null;
            this.currentRetries = TaskManager.this.retriesOnIdle;
            this.setDaemon(true);
        }

        private boolean takeTask() {
            int size = TaskManager.this.tasks.size();
            for (int i = TaskManager.this.firstPending; i < size; ++i) {
                Task t = TaskManager.this.tasks.get(i);
                if (TaskManager.this.runAfter(t, i)) continue;
                if (i > TaskManager.this.firstPending) {
                    TaskManager.this.tasks.remove(i);
                    TaskManager.this.tasks.add(TaskManager.this.firstPending, t);
                }
                ++TaskManager.this.firstPending;
                this.task = t;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                TaskManager taskManager = TaskManager.this;
                synchronized (taskManager) {
                    if (TaskManager.this.terminated) {
                        return;
                    }
                    if (this.task != null) {
                        int i = TaskManager.this.firstPending;
                        while (--i >= 0) {
                            if (TaskManager.this.tasks.get(i) != this.task) continue;
                            TaskManager.this.tasks.remove(i);
                            --TaskManager.this.firstPending;
                            break;
                        }
                        this.task = null;
                        TaskThread.interrupted();
                    }
                    if (!this.takeTask()) {
                        try {
                            TaskManager.this.wait(TaskManager.this.timeout);
                        }
                        catch (InterruptedException i) {
                            // empty catch block
                        }
                        if (TaskManager.this.terminated || !this.takeTask()) {
                            if (--this.currentRetries <= 0) {
                                TaskManager.this.threads.remove(this);
                                return;
                            }
                            continue;
                        }
                    }
                }
                this.currentRetries = TaskManager.this.retriesOnIdle;
                try {
                    this.task.run();
                    continue;
                }
                catch (Throwable t) {
                    try {
                        if (Thread.currentThread().isInterrupted() || t instanceof InterruptedException) {
                            boolean isTerminated = false;
                            TaskManager taskManager2 = TaskManager.this;
                            synchronized (taskManager2) {
                                isTerminated = TaskManager.this.terminated;
                            }
                            logger.log(Level.FINER, (isTerminated ? "TaskManager was terminated - all tasks interrupted. " : "") + TaskManager.this.threadName + " ran [" + this.task + "] but was interrupted. ", t);
                            continue;
                        }
                        logger.log(Level.WARNING, TaskManager.this.threadName + " ran [" + this.task + "] and caught an exception.", t);
                        continue;
                    }
                    catch (Throwable logException) {
                        logger.log(Level.SEVERE, "Ran [" + this.task + "] but caught exception: " + t + "\nAttempt to log caused: ", logException);
                        continue;
                    }
                }
                break;
            }
        }
    }

    public static interface Task
    extends Runnable {
        public boolean runAfter(List var1, int var2);
    }
}

