/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.exception.lrmi.ProxyClosedException;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.gigaspaces.time.SystemTime;
import com.sun.jini.config.Config;
import com.sun.jini.constants.ThrowableConstants;
import com.sun.jini.discovery.Discovery;
import com.sun.jini.discovery.DiscoveryConstraints;
import com.sun.jini.discovery.UnicastResponse;
import com.sun.jini.discovery.internal.MultiIPDiscovery;
import com.sun.jini.logging.Levels;
import com.sun.jini.thread.RetryTask;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.EmptyConfiguration;
import net.jini.config.NoSuchEntryException;
import net.jini.core.constraint.ConnectionAbsoluteTime;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;

@InternalApi
public class LookupLocatorDiscovery
implements DiscoveryManagement,
DiscoveryLocatorManagement {
    private static final String COMPONENT_NAME = "net.jini.discovery.LookupLocatorDiscovery";
    private static final Logger logger = Logger.getLogger("net.jini.discovery.LookupLocatorDiscovery");
    private static final Logger loggerStats = Logger.getLogger("net.jini.discovery.LookupLocatorDiscovery.stats");
    private static final int MAX_N_TASKS = 15;
    private static final int DEFAULT_SOCKET_TIMEOUT = 60000;
    private static final Method getRegistrarMethod;
    private TaskManager discoveryTaskMgr;
    private WakeupManager discoveryWakeupMgr;
    private final HashSet undiscoveredLocators = new HashSet(11);
    private final ArrayList discoveredLocators = new ArrayList(11);
    private Notifier notifierThread;
    private final LinkedList pendingNotifies = new LinkedList();
    private final ArrayList listeners = new ArrayList(1);
    private boolean terminated = false;
    private ProxyPreparer registrarPreparer;
    private final Discovery protocol2 = Discovery.getProtocol2(null);
    private long initialUnicastDelayRange = 0L;
    private boolean discoverLocatorsCalled = false;
    private final List lookupAliveTasks = new ArrayList();
    private final int MAX_LOOKUP_ALIVE_TASKS_PER_LOCATOR = 5;
    private final Map<String, Set<LookupAliveTask>> lookupAliveTasksMap = new HashMap<String, Set<LookupAliveTask>>();

    public LookupLocatorDiscovery(LookupLocator[] locators) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created tunable LookupLocatorDiscovery");
        }
        try {
            this.beginDiscovery(locators, (Configuration)EmptyConfiguration.INSTANCE);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public LookupLocatorDiscovery(LookupLocator[] locators, Configuration config) throws ConfigurationException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Created tunable LookupLocatorDiscovery");
        }
        this.beginDiscovery(locators, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDiscoveryListener(DiscoveryListener l) {
        if (l == null) {
            throw new NullPointerException("can't add null listener");
        }
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (this.listeners.contains(l)) {
                return;
            }
            this.listeners.add(l);
            if (!this.discoveredLocators.isEmpty()) {
                HashMap<ServiceRegistrar, String[]> groupsMap = new HashMap<ServiceRegistrar, String[]>(this.discoveredLocators.size());
                Iterator iter = this.discoveredLocators.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    LocatorReg reg = (LocatorReg)iter.next();
                    groupsMap.put(reg.proxy, reg.memberGroups);
                    ++i;
                }
                ArrayList<DiscoveryListener> list = new ArrayList<DiscoveryListener>(1);
                list.add(l);
                this.addNotify(list, groupsMap, false);
            }
        }
    }

    @Override
    public synchronized void removeDiscoveryListener(DiscoveryListener l) {
        if (this.terminated) {
            throw new IllegalStateException("discovery terminated");
        }
        int index = this.listeners.indexOf(l);
        if (index != -1) {
            this.listeners.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceRegistrar[] getRegistrars() {
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (this.discoveredLocators == null || this.discoveredLocators.isEmpty()) {
                return new ServiceRegistrar[0];
            }
            return this.buildServiceRegistrar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discard(ServiceRegistrar proxy) {
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            if (proxy == null) {
                return;
            }
            LookupLocator lct = this.findRegFromProxy(proxy);
            if (lct == null) {
                return;
            }
            LocatorReg reg = this.removeDiscoveredLocator(lct);
            HashMap<ServiceRegistrar, String[]> groupsMap = new HashMap<ServiceRegistrar, String[]>(1);
            groupsMap.put(reg.proxy, reg.memberGroups);
            reg.proxy = null;
            reg.memberGroups = null;
            reg.fixupNextTryTime();
            this.addToMap(reg);
            if (!this.listeners.isEmpty()) {
                this.addNotify((ArrayList)this.listeners.clone(), groupsMap, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void terminate() {
        if (this.terminated) {
            return;
        }
        this.terminated = true;
        this.terminateTaskMgr();
        List list = this.pendingNotifies;
        synchronized (list) {
            this.pendingNotifies.clear();
        }
        list = this.lookupAliveTasks;
        synchronized (list) {
            LookupAliveTask[] lats = this.lookupAliveTasks.toArray(new LookupAliveTask[this.lookupAliveTasks.size()]);
            for (int i = 0; i < lats.length; ++i) {
                lats[i].interrupt();
            }
        }
    }

    @Override
    public synchronized LookupLocator[] getLocators() {
        if (this.terminated) {
            throw new IllegalStateException("discovery terminated");
        }
        int size = this.discoveredLocators.size() + this.undiscoveredLocators.size();
        LookupLocator[] ret = new LookupLocator[size];
        int k = 0;
        Iterator iter = this.discoveredLocators.iterator();
        while (iter.hasNext()) {
            ret[k++] = ((LocatorReg)iter.next()).l;
        }
        iter = this.undiscoveredLocators.iterator();
        while (iter.hasNext()) {
            ret[k++] = ((LocatorReg)iter.next()).l;
        }
        return ret;
    }

    @Override
    public synchronized void addLocators(LookupLocator[] locators) {
        this.testSetForNull(locators);
        if (this.terminated) {
            throw new IllegalStateException("discovery terminated");
        }
        this.discoverLocators(locators);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLocators(LookupLocator[] locators) {
        this.testSetForNull(locators);
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            LocatorReg reg;
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            HashMap<ServiceRegistrar, String[]> groupsMap = new HashMap<ServiceRegistrar, String[]>(1);
            Iterator iter = this.discoveredLocators.iterator();
            while (iter.hasNext()) {
                reg = (LocatorReg)iter.next();
                if (this.isArrayContains(locators, reg.l)) continue;
                iter.remove();
                groupsMap.put(reg.proxy, reg.memberGroups);
            }
            iter = this.undiscoveredLocators.iterator();
            while (iter.hasNext()) {
                reg = (LocatorReg)iter.next();
                if (this.isArrayContains(locators, reg.l)) continue;
                iter.remove();
            }
            this.discoverLocators(locators);
            if (!groupsMap.isEmpty() && !this.listeners.isEmpty()) {
                this.addNotify((ArrayList)this.listeners.clone(), groupsMap, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLocators(LookupLocator[] locators) {
        this.testSetForNull(locators);
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            if (this.terminated) {
                throw new IllegalStateException("discovery terminated");
            }
            HashMap<ServiceRegistrar, String[]> groupsMap = new HashMap<ServiceRegistrar, String[]>(1);
            for (int i = 0; i < locators.length; ++i) {
                LocatorReg reg = this.removeDiscoveredLocator(locators[i]);
                if (reg != null) {
                    groupsMap.put(reg.proxy, reg.memberGroups);
                    continue;
                }
                reg = this.findReg(locators[i]);
                if (reg == null) continue;
                this.undiscoveredLocators.remove(reg);
            }
            if (!groupsMap.isEmpty() && !this.listeners.isEmpty()) {
                this.addNotify((ArrayList)this.listeners.clone(), groupsMap, true);
            }
        }
    }

    public synchronized LookupLocator[] getDiscoveredLocators() {
        if (this.terminated) {
            throw new IllegalStateException("discovery terminated");
        }
        int size = this.discoveredLocators.size();
        LookupLocator[] ret = new LookupLocator[size];
        int k = 0;
        Iterator iter = this.discoveredLocators.iterator();
        while (iter.hasNext()) {
            ret[k++] = ((LocatorReg)iter.next()).l;
        }
        return ret;
    }

    public synchronized LookupLocator[] getUndiscoveredLocators() {
        if (this.terminated) {
            throw new IllegalStateException("discovery terminated");
        }
        LookupLocator[] locs = new LookupLocator[this.undiscoveredLocators.size()];
        Iterator iter = this.undiscoveredLocators.iterator();
        int i = 0;
        while (iter.hasNext()) {
            locs[i] = ((LocatorReg)iter.next()).l;
            ++i;
        }
        return locs;
    }

    private void discoverLocators(LookupLocator[] lcts) {
        assert (Thread.holdsLock(this));
        this.discoverLocatorsCalled = true;
        if (lcts == null) {
            return;
        }
        for (int i = 0; i < lcts.length; ++i) {
            LocatorReg reg;
            boolean discovered = this.isDiscovered(lcts[i]);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("discoverLocators " + lcts[i].getHost() + ":" + lcts[i].getPort() + " discovered=" + discovered);
            }
            if (discovered || (reg = this.findReg(lcts[i])) != null) continue;
            reg = new LocatorReg(lcts[i]);
            this.addToMap(reg);
        }
    }

    private LocatorReg findReg(LookupLocator lct) {
        for (LocatorReg reg : this.undiscoveredLocators) {
            if (!reg.l.equals((Object)lct)) continue;
            return reg;
        }
        return null;
    }

    private LookupLocator findRegFromProxy(ServiceRegistrar proxy) {
        for (LocatorReg reg : this.discoveredLocators) {
            if (!reg.proxy.equals(proxy)) continue;
            return reg.l;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean regTryGetProxy(LocatorReg reg) {
        boolean b = reg.tryGetProxy();
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            if (!this.undiscoveredLocators.contains(reg)) {
                return true;
            }
            if (!b) {
                return false;
            }
            this.undiscoveredLocators.remove(reg);
            this.discoveredLocators.add(reg);
            if (!this.listeners.isEmpty()) {
                this.addNotify((ArrayList)this.listeners.clone(), this.mapRegToGroups(reg.proxy, reg.memberGroups), false);
            }
            return true;
        }
    }

    private ServiceRegistrar[] buildServiceRegistrar() {
        int k = 0;
        ServiceRegistrar[] proxys = new ServiceRegistrar[this.discoveredLocators.size()];
        for (LocatorReg reg : this.discoveredLocators) {
            proxys[k++] = reg.proxy;
        }
        return proxys;
    }

    private void addToMap(LocatorReg reg) {
        this.undiscoveredLocators.add(reg);
        this.queueDiscoveryTask(reg);
    }

    private void queueDiscoveryTask(LocatorReg reg) {
        this.discoveryTaskMgr.add(new DiscoveryTask(reg, this.discoveryTaskMgr, this.discoveryWakeupMgr));
    }

    private boolean isDiscovered(LookupLocator lct) {
        for (LocatorReg reg : this.discoveredLocators) {
            if (!reg.l.equals((Object)lct)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNotify(ArrayList notifies, Map groupsMap, boolean discard) {
        LinkedList linkedList = this.pendingNotifies;
        synchronized (linkedList) {
            this.pendingNotifies.addLast(new NotifyTask(notifies, groupsMap, discard));
            if (this.notifierThread == null) {
                this.notifierThread = new Notifier();
                this.notifierThread.start();
            }
        }
    }

    private LocatorReg removeDiscoveredLocator(LookupLocator lct) {
        Iterator iter = this.discoveredLocators.iterator();
        while (iter.hasNext()) {
            LocatorReg reg = (LocatorReg)iter.next();
            if (!reg.l.equals((Object)lct)) continue;
            iter.remove();
            return reg;
        }
        return null;
    }

    private void terminateTaskMgr() {
        if (this.discoveryWakeupMgr != null) {
            this.discoveryWakeupMgr.stop();
            this.discoveryWakeupMgr.cancelAll();
        }
        if (this.discoveryTaskMgr != null) {
            List<TaskManager.Task> pendingTasks = this.discoveryTaskMgr.getPending();
            for (int i = 0; i < pendingTasks.size(); ++i) {
                RetryTask pendingTask = (RetryTask)pendingTasks.get(i);
                pendingTask.cancel();
                this.discoveryTaskMgr.remove(pendingTask);
            }
            this.discoveryTaskMgr.terminate();
            this.discoveryTaskMgr = null;
            this.discoveryWakeupMgr = null;
        }
    }

    private boolean isArrayContains(Object[] a, Object obj) {
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].equals(obj)) continue;
            return true;
        }
        return false;
    }

    private void printMap() {
        for (LocatorReg reg : this.undiscoveredLocators) {
            System.out.println("printMap reg:" + reg.id);
        }
    }

    private void testSetForNull(LookupLocator[] locatorSet) {
        if (locatorSet == null) {
            throw new NullPointerException("null locator array");
        }
        for (int i = 0; i < locatorSet.length; ++i) {
            if (locatorSet[i] != null) continue;
            throw new NullPointerException("null element in locator array");
        }
    }

    private Map deepCopy(HashMap groupsMap) {
        HashMap newMap = (HashMap)groupsMap.clone();
        Set eSet = newMap.entrySet();
        for (Map.Entry entry : eSet) {
            entry.setValue(((String[])entry.getValue()).clone());
        }
        return newMap;
    }

    private Map mapRegToGroups(ServiceRegistrar reg, String[] curGroups) {
        HashMap<ServiceRegistrar, String[]> groupsMap = new HashMap<ServiceRegistrar, String[]>(1);
        groupsMap.put(reg, curGroups);
        return groupsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginDiscovery(final LookupLocator[] locators, Configuration config) throws ConfigurationException {
        LookupLocatorDiscovery lookupLocatorDiscovery = this;
        synchronized (lookupLocatorDiscovery) {
            this.init(config);
            if (locators == null) {
                return;
            }
            this.addDiscoveryListener(new InternalDiscoverylListener());
            this.testSetForNull(locators);
            if (this.initialUnicastDelayRange > 0L) {
                this.discoveryWakeupMgr.schedule(SystemTime.timeMillis() + (long)(Math.random() * (double)this.initialUnicastDelayRange), new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        LookupLocatorDiscovery lookupLocatorDiscovery = LookupLocatorDiscovery.this;
                        synchronized (lookupLocatorDiscovery) {
                            if (LookupLocatorDiscovery.this.terminated || LookupLocatorDiscovery.this.discoverLocatorsCalled) {
                                return;
                            }
                            LookupLocatorDiscovery.this.discoverLocators(locators);
                        }
                    }
                });
            } else {
                this.discoverLocators(locators);
            }
        }
    }

    private void init(Configuration config) throws ConfigurationException {
        if (config == null) {
            throw new NullPointerException("config is null");
        }
        this.registrarPreparer = (ProxyPreparer)config.getEntry(COMPONENT_NAME, "registrarPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
        try {
            this.discoveryTaskMgr = (TaskManager)config.getEntry(COMPONENT_NAME, "taskManager", TaskManager.class);
        }
        catch (NoSuchEntryException e) {
            this.discoveryTaskMgr = new TaskManager(15, 30000L, 3.0f, "LookupLocatorDiscovery Task", 10);
        }
        try {
            this.discoveryWakeupMgr = (WakeupManager)config.getEntry(COMPONENT_NAME, "wakeupManager", WakeupManager.class);
        }
        catch (NoSuchEntryException e) {
            this.discoveryWakeupMgr = new WakeupManager(new WakeupManager.ThreadDesc(null, true));
        }
        this.initialUnicastDelayRange = Config.getLongEntry((Configuration)config, (String)COMPONENT_NAME, (String)"initialUnicastDelayRange", (long)0L, (long)0L, (long)Long.MAX_VALUE);
    }

    static {
        try {
            getRegistrarMethod = LookupLocator.class.getDeclaredMethod("getRegistrar", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    class LookupAliveTask
    extends Thread {
        boolean keepAlive = true;
        final ServiceRegistrar proxy;
        static final int DEFAULT_INVOCATION_DELAY = 60000;
        private long invocationDelay = 60000L;
        final String locatorString;

        LookupAliveTask(ServiceRegistrar proxy) throws RemoteException {
            this.proxy = proxy;
            String s = System.getProperty("com.gigaspaces.unicast.ping");
            if (s != null) {
                try {
                    this.invocationDelay = Long.parseLong(s);
                }
                catch (NumberFormatException e) {
                    logger.log(Level.INFO, "Value [" + s + "] is illegal for property com.gigaspaces.unicast.ping, ignoring");
                }
                if (logger.isLoggable(Level.CONFIG)) {
                    logger.log(Level.CONFIG, "Set unicast ping to [" + this.invocationDelay + "]");
                }
            }
            LookupLocator locator = proxy.getLocator();
            this.locatorString = "jini://" + locator.getHost() + ":" + locator.getPort();
        }

        @Override
        public void interrupt() {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Terminating LookupAliveTask Thread for " + this.locatorString);
            }
            this.keepAlive = false;
            super.interrupt();
        }

        @Override
        public void run() {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Started LookupAliveTask for " + this.locatorString);
            }
            while (!LookupAliveTask.interrupted()) {
                if (!this.keepAlive) {
                    return;
                }
                try {
                    LookupAliveTask.sleep(this.invocationDelay);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (IllegalArgumentException iae) {
                    logger.warning("LookupAliveTask: sleep time is off : " + this.invocationDelay);
                }
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("invoke getLocator() on : " + this.locatorString);
                    }
                    this.proxy.getLocator();
                }
                catch (ConnectException e) {
                    this.hardStop();
                }
                catch (Exception e) {
                    int category = ThrowableConstants.retryable(e);
                    if (category != 1 && category != 2) continue;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Unrecoverable Exception invoking getLocator()", e);
                    }
                    this.hardStop();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void hardStop() {
            Object object = LookupLocatorDiscovery.this;
            synchronized (object) {
                if (LookupLocatorDiscovery.this.terminated) {
                    return;
                }
            }
            LookupLocatorDiscovery.this.discard(this.proxy);
            object = LookupLocatorDiscovery.this.lookupAliveTasks;
            synchronized (object) {
                LookupLocatorDiscovery.this.lookupAliveTasks.remove(this);
                if (LookupLocatorDiscovery.this.lookupAliveTasksMap.containsKey(this.locatorString)) {
                    ((Set)LookupLocatorDiscovery.this.lookupAliveTasksMap.get(this.locatorString)).remove(this);
                }
            }
            this.interrupt();
        }
    }

    class InternalDiscoverylListener
    implements DiscoveryListener {
        InternalDiscoverylListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void discovered(DiscoveryEvent discoveryEvent) {
            ServiceRegistrar[] sr = discoveryEvent.getRegistrars();
            for (int i = 0; i < sr.length; ++i) {
                LookupAliveTask lat = null;
                try {
                    lat = new LookupAliveTask(sr[i]);
                    List list = LookupLocatorDiscovery.this.lookupAliveTasks;
                    synchronized (list) {
                        String key = lat.locatorString;
                        if (LookupLocatorDiscovery.this.lookupAliveTasksMap.containsKey(key)) {
                            Set aliveTasks = (Set)LookupLocatorDiscovery.this.lookupAliveTasksMap.get(key);
                            if (aliveTasks.size() == 5) {
                                Iterator iterator = aliveTasks.iterator();
                                while (iterator.hasNext()) {
                                    LookupAliveTask task = (LookupAliveTask)iterator.next();
                                    if (task.isAlive() && task.keepAlive) continue;
                                    iterator.remove();
                                }
                                if (aliveTasks.size() == 5) {
                                    continue;
                                }
                            }
                        } else {
                            LookupLocatorDiscovery.this.lookupAliveTasksMap.put(key, new HashSet());
                        }
                        ((Set)LookupLocatorDiscovery.this.lookupAliveTasksMap.get(key)).add(lat);
                        LookupLocatorDiscovery.this.lookupAliveTasks.add(lat);
                        lat.start();
                        continue;
                    }
                }
                catch (RemoteException e) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, "Exception in InternalDiscoveryListener.discovered() going to discard the discoveryEvent: " + discoveryEvent.toString(), e);
                    }
                    LookupLocatorDiscovery.this.discard(sr[i]);
                    if (!(e instanceof ProxyClosedException)) continue;
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public void discarded(DiscoveryEvent discoveryEvent) {
        }
    }

    private class DiscoveryTask
    extends RetryTask {
        private final LocatorReg reg;

        public DiscoveryTask(LocatorReg reg, TaskManager taskMgr, WakeupManager wakeupMgr) {
            super(taskMgr, wakeupMgr);
            this.reg = reg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryOnce() {
            logger.finest("LookupLocatorDiscovery - DiscoveryTask started");
            LookupLocatorDiscovery lookupLocatorDiscovery = LookupLocatorDiscovery.this;
            synchronized (lookupLocatorDiscovery) {
                if (LookupLocatorDiscovery.this.terminated) {
                    return true;
                }
                if (LookupLocatorDiscovery.this.undiscoveredLocators.isEmpty()) {
                    logger.finest("LookupLocatorDiscovery - DiscoveryTask completed");
                    return true;
                }
                if (!LookupLocatorDiscovery.this.undiscoveredLocators.contains(this.reg)) {
                    logger.finest("LookupLocatorDiscovery - DiscoveryTask completed");
                    return true;
                }
            }
            boolean noRetry = LookupLocatorDiscovery.this.regTryGetProxy(this.reg);
            LookupLocatorDiscovery lookupLocatorDiscovery2 = LookupLocatorDiscovery.this;
            synchronized (lookupLocatorDiscovery2) {
                if (LookupLocatorDiscovery.this.terminated) {
                    return true;
                }
                if (noRetry) {
                    logger.finest("LookupLocatorDiscovery - DiscoveryTask completed. locator: " + this.reg.l);
                } else {
                    logger.finest("LookupLocatorDiscovery - DiscoveryTask failed, will retry later. locator: " + this.reg.l);
                }
                return noRetry;
            }
        }

        @Override
        public long retryTime() {
            return this.reg.getNextTryTime();
        }

        @Override
        public boolean runAfter(List tasks, int size) {
            return false;
        }
    }

    private class Notifier
    extends GSThread {
        public Notifier() {
            super("event notifier");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            logger.finest("LookupLocatorDiscovery - Notifier thread started");
            block5: while (true) {
                NotifyTask task;
                LinkedList linkedList = LookupLocatorDiscovery.this.pendingNotifies;
                synchronized (linkedList) {
                    if (LookupLocatorDiscovery.this.pendingNotifies.isEmpty()) {
                        LookupLocatorDiscovery.this.notifierThread = null;
                        return;
                    }
                    task = (NotifyTask)LookupLocatorDiscovery.this.pendingNotifies.removeFirst();
                }
                boolean firstListener = true;
                Iterator iter = task.listeners.iterator();
                while (true) {
                    if (!iter.hasNext()) continue block5;
                    DiscoveryListener l = (DiscoveryListener)iter.next();
                    DiscoveryEvent e = new DiscoveryEvent((Object)LookupLocatorDiscovery.this, LookupLocatorDiscovery.this.deepCopy((HashMap)task.groupsMap));
                    if (firstListener && logger.isLoggable(Level.FINEST)) {
                        String eType = task.discard ? "discarded" : "discovered";
                        ServiceRegistrar[] regs = e.getRegistrars();
                        logger.finest(eType + " event  -- " + regs.length + " lookup(s)");
                        Map groupsMap = e.getGroups();
                        for (int i = 0; i < regs.length; ++i) {
                            LookupLocator loc = null;
                            try {
                                loc = regs[i].getLocator();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            String[] groups = (String[])groupsMap.get(regs[i]);
                            logger.finest("    " + eType + " locator  = " + loc);
                            if (groups.length == 0) {
                                logger.finest("    " + eType + " group    = NO_GROUPS");
                                continue;
                            }
                            for (int j = 0; j < groups.length; ++j) {
                                logger.finest("    " + eType + " group[" + j + "] = " + groups[j]);
                            }
                        }
                    }
                    if (task.discard) {
                        l.discarded(e);
                        continue;
                    }
                    l.discovered(e);
                }
                break;
            }
        }
    }

    private static class NotifyTask {
        public final ArrayList listeners;
        public final Map groupsMap;
        public final boolean discard;

        public NotifyTask(ArrayList listeners, Map groupsMap, boolean discard) {
            this.listeners = listeners;
            this.groupsMap = groupsMap;
            this.discard = discard;
        }
    }

    private class LocatorReg {
        public ServiceRegistrar proxy = null;
        public final LookupLocator l;
        public String[] memberGroups = null;
        private int cnt = 0;
        private static final long MIN_RETRY = 15000L;
        private long[] sleepTime = new long[]{1000L, 5000L, 10000L, 15000L, 20000L, 30000L, 60000L};
        private int tryIndx = 0;
        private long nextTryTime;
        private final int id = this.cnt++;
        private long time = 0L;

        public LocatorReg(LookupLocator l) {
            this.l = l;
            this.nextTryTime = SystemTime.timeMillis();
            String s = System.getProperty("com.gigaspaces.unicast.interval");
            if (s != null) {
                StringBuffer buff = new StringBuffer();
                StringTokenizer st = new StringTokenizer(s, " \t\n\r\f,");
                ArrayList<Long> list = new ArrayList<Long>();
                int i = 0;
                while (st.hasMoreTokens()) {
                    String value = st.nextToken();
                    try {
                        if (list.size() > 0) {
                            buff.append(", ");
                        }
                        list.add(Long.valueOf(value));
                        buff.append(value);
                    }
                    catch (NumberFormatException e) {
                        logger.log(Level.INFO, "Value [" + value + "] is illegal for property com.gigaspaces.unicast.interval, ignoring");
                    }
                    ++i;
                }
                this.sleepTime = new long[list.size()];
                for (i = 0; i < this.sleepTime.length; ++i) {
                    this.sleepTime[i] = (Long)list.get(i);
                }
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "Set unicast interval to [" + buff.toString() + "]");
                }
            }
        }

        public synchronized long getNextTryTime() {
            return this.nextTryTime;
        }

        public void setNextTryTime() {
            this.nextTryTime = SystemTime.timeMillis() + this.sleepTime[this.tryIndx];
            if (this.tryIndx < this.sleepTime.length - 1) {
                ++this.tryIndx;
            }
        }

        public void fixupNextTryTime() {
            long curTime = SystemTime.timeMillis();
            if (curTime - this.time > 15000L) {
                this.tryIndx = 0;
                this.nextTryTime = curTime;
            } else {
                this.setNextTryTime();
            }
        }

        private InvocationConstraints createInvocationConstraints() {
            if (15000L >= this.sleepTime[this.tryIndx]) {
                return new InvocationConstraints((InvocationConstraint)new ConnectionAbsoluteTime(System.currentTimeMillis() + this.sleepTime[this.tryIndx]), null);
            }
            return InvocationConstraints.EMPTY;
        }

        public boolean tryGetProxy() {
            MethodConstraints mc;
            if (this.proxy != null) {
                throw new IllegalArgumentException("LookupLocator has been discovered already");
            }
            InvocationConstraints ic = this.createInvocationConstraints();
            if (this.l instanceof RemoteMethodControl && (mc = ((RemoteMethodControl)this.l).getConstraints()) != null) {
                ic = mc.getConstraints(getRegistrarMethod);
            }
            try {
                long startTime = 0L;
                if (loggerStats.isLoggable(Level.FINEST)) {
                    startTime = SystemTime.timeMillis();
                }
                this.doUnicastDiscovery(this.l, ic);
                if (loggerStats.isLoggable(Level.FINEST)) {
                    loggerStats.finest("Unicast Lookup took [" + (SystemTime.timeMillis() - startTime) + "ms]");
                }
                this.time = SystemTime.timeMillis();
                logger.log(Level.INFO, "Connected to LUS using locator {0}:{1,number,#}", new Object[]{this.l.getHost(), this.l.getPort()});
                return true;
            }
            catch (Throwable throwable) {
                int currTryIndx = this.tryIndx;
                this.setNextTryTime();
                logger.log(Level.WARNING, "{0} - using unicast locator {1}:{2,number,#} - delay next lookup by {3} ms", new Object[]{throwable, this.l.getHost(), this.l.getPort(), this.sleepTime[currTryIndx]});
                return false;
            }
        }

        private void doUnicastDiscovery(LookupLocator locator, InvocationConstraints ic) throws IOException, ClassNotFoundException {
            UnicastResponse resp = new MultiIPDiscovery(){

                protected UnicastResponse performDiscovery(Discovery disco, DiscoveryConstraints dc, Socket s) throws IOException, ClassNotFoundException {
                    return disco.doUnicastDiscovery(s, dc.getUnfulfilledConstraints(), null, null, null);
                }

                protected void socketCloseException(IOException e) {
                    logger.log(Level.FINEST, "IOException on socket close upon completion of unicast discovery", e);
                }

                protected void singleResponseException(Exception e, InetAddress addr, int port) {
                    logger.log(Levels.HANDLED, "Exception occurred during unicast discovery " + addr + ":" + port, e);
                }
            }.getResponse(locator.getHost(), locator.getPort(), ic);
            this.proxy = (ServiceRegistrar)LookupLocatorDiscovery.this.registrarPreparer.prepareProxy((Object)resp.getRegistrar());
            logger.log(Level.FINEST, "LookupLocatorDiscovery - prepared lookup service proxy: {0}", this.proxy);
            this.memberGroups = resp.getGroups();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LocatorReg)) {
                return false;
            }
            return this.l.equals((Object)((LocatorReg)obj).l);
        }

        public int hashCode() {
            return this.l.hashCode();
        }
    }
}

