/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery.dynamic;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.core.jini.SharedDiscoveryManagement;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.admin.Administrable;
import net.jini.admin.JoinAdmin;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.discovery.dynamic.DynamicLookupLocatorDiscoveryException;
import net.jini.discovery.dynamic.LookupLocatorsChangeListener;
import net.jini.discovery.dynamic.ServiceRegistrarServiceDiscoveryListener;
import net.jini.lookup.LookupCache;
import net.jini.lookup.entry.Comment;
import org.jini.rio.boot.BootUtil;

@InternalApi
public class DynamicLookupLocatorDiscovery
implements DiscoveryListener {
    public static final Comment DYNAMIC_LOCATORS_ENABLED_LOOKUP_ATTRIBUTE = new Comment("DynamicLocatorsEnabled");
    private static final ServiceTemplate LOOKUP_CACHE_TEMPLATE = new ServiceTemplate(null, new Class[]{ServiceRegistrar.class}, null);
    private final Logger _logger = Logger.getLogger("com.gs.locator.dynamic.manager");
    private final Object _lock = new Object();
    private final Object _initialServiceRegistrarsLock = new Object();
    private final CountDownLatch _initializedIndicator = new CountDownLatch(1);
    private final List<ServiceRegistrar> _initialRegistrars = new ArrayList<ServiceRegistrar>();
    private CountDownLatch _initialRegistrarsDiscoveredLatch;
    private final LookupDiscoveryManager _ldm;
    private boolean _terminated = false;
    private SharedDiscoveryManagement.SharedServiceDiscoveryManager _sdm;
    private LookupCache _lookupCache;
    private boolean _isSdmManaged;
    private ServiceRegistrarServiceDiscoveryListener _listener;
    private volatile Exception _initException;

    public static boolean dynamicLocatorsEnabled() {
        return Boolean.getBoolean("com.gs.jini_lus.locators.dynamic.enabled");
    }

    public DynamicLookupLocatorDiscovery(LookupDiscoveryManager ldm, boolean runningWithinRegistrar) {
        this._ldm = ldm;
        if (!runningWithinRegistrar) {
            this.init(null);
        }
    }

    public void init(final ServiceID serviceID) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = DynamicLookupLocatorDiscovery.this._lock;
                synchronized (object) {
                    try {
                        if (!DynamicLookupLocatorDiscovery.this._terminated) {
                            DynamicLookupLocatorDiscovery.this.addDisoveryListenerAndWaitForInitialRegistrars();
                            if (!DynamicLookupLocatorDiscovery.dynamicLocatorsEnabled() && !DynamicLookupLocatorDiscovery.this.isDynamicLocatorsEnabledAtRegistrar()) {
                                if (DynamicLookupLocatorDiscovery.this._logger.isLoggable(Level.FINE)) {
                                    DynamicLookupLocatorDiscovery.this._logger.fine("Dynamic locators discovery is not enabled at discovered registrars");
                                }
                                DynamicLookupLocatorDiscovery.this._terminated = true;
                                return;
                            }
                            Map initialLocatorsMap = DynamicLookupLocatorDiscovery.this.getInitialLookupLocatorsMap();
                            ServiceRegistrar registrar = DynamicLookupLocatorDiscovery.this.getOurRegistrarInNeeded(serviceID, initialLocatorsMap);
                            DynamicLookupLocatorDiscovery.this.getServiceDiscoveryManager(initialLocatorsMap);
                            DynamicLookupLocatorDiscovery.this.getAndRegisterInLookupCache(initialLocatorsMap, registrar, serviceID);
                            if (DynamicLookupLocatorDiscovery.this._logger.isLoggable(Level.FINE)) {
                                DynamicLookupLocatorDiscovery.this._logger.fine("DynamicLookupLocatorDiscovery initialized");
                            }
                            DynamicLookupLocatorDiscovery.this._initializedIndicator.countDown();
                        }
                    }
                    catch (Exception e) {
                        if (DynamicLookupLocatorDiscovery.this._logger.isLoggable(Level.SEVERE)) {
                            DynamicLookupLocatorDiscovery.this._logger.log(Level.SEVERE, "Failed initializing DynamicLookupLocatorDiscovery. Dynamic lookup locators will not work for this service", e);
                        }
                        DynamicLookupLocatorDiscovery.this._initException = e;
                        DynamicLookupLocatorDiscovery.this.terminate();
                    }
                    finally {
                        DynamicLookupLocatorDiscovery.this._ldm.removeDiscoveryListener(DynamicLookupLocatorDiscovery.this);
                    }
                }
            }
        }).start();
    }

    private void addDisoveryListenerAndWaitForInitialRegistrars() {
        int numberOfLocators = this._ldm.getLocators().length;
        if (numberOfLocators == 0) {
            return;
        }
        long initDelay = Long.getLong("com.gs.jini_lus.locators.dynamic.max_delay_before_discovery", 10000L);
        this._initialRegistrarsDiscoveredLatch = new CountDownLatch(numberOfLocators);
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.log(Level.FINER, "Waiting for registrars at " + BootUtil.arrayToCommaDelimitedString((Object[])this._ldm.getLocators()) + " to be discovered, for at most " + initDelay + "ms");
        }
        this._ldm.addDiscoveryListener(this);
        try {
            this._initialRegistrarsDiscoveredLatch.await(initDelay, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean isDynamicLocatorsEnabledAtRegistrar() {
        List<ServiceRegistrar> registrars = this.getRegistrars();
        for (ServiceRegistrar registrar : registrars) {
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.finer("Checking if registrar with service id: " + registrar.getServiceID() + " supports dynamic locators");
            }
            try {
                Administrable administrable = (Administrable)registrar;
                JoinAdmin joinAdmin = (JoinAdmin)administrable.getAdmin();
                for (Entry entry : joinAdmin.getLookupAttributes()) {
                    if (!DYNAMIC_LOCATORS_ENABLED_LOOKUP_ATTRIBUTE.equals(entry)) continue;
                    if (this._logger.isLoggable(Level.FINER)) {
                        this._logger.finer("Registrar with service id: " + registrar.getServiceID() + " supports dynamic locators");
                    }
                    return true;
                }
                if (!this._logger.isLoggable(Level.FINER)) continue;
                this._logger.finer("Registrar with service id: " + registrar.getServiceID() + " does not support dynamic locators");
            }
            catch (RemoteException e) {
                if (!this._logger.isLoggable(Level.WARNING)) continue;
                this._logger.log(Level.WARNING, "Failed getting lookup attributes from registrar: " + registrar.getServiceID(), e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ServiceRegistrar> getRegistrars() {
        Object object = this._initialServiceRegistrarsLock;
        synchronized (object) {
            return new ArrayList<ServiceRegistrar>(this._initialRegistrars);
        }
    }

    private void getServiceDiscoveryManager(Map<ServiceID, LookupLocator> initialLocatorsMap) {
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.finer("Getting ServiceDiscoveryManager with initial service ids: " + initialLocatorsMap.keySet() + ", locators: " + BootUtil.arrayToCommaDelimitedString((Object[])this._ldm.getLocators()) + ", groups: " + BootUtil.arrayToCommaDelimitedString((Object[])this._ldm.getGroups()));
        }
        try {
            SharedDiscoveryManagement.SharedServiceDiscoveryManagerResult result = SharedDiscoveryManagement.getServiceDiscoveryManagerResult(this._ldm, this._ldm.getGroups(), this._ldm.getLocators(), null);
            this._sdm = result.sdm;
            this._isSdmManaged = result.isManaged;
            if (this._logger.isLoggable(Level.FINEST)) {
                this._logger.finest("Number of shared SDM after creation: " + this._sdm.getRefCounter() + ", Is sdm managed: " + this._isSdmManaged);
            }
        }
        catch (IOException e) {
            throw new DynamicLookupLocatorDiscoveryException("Failed getting service discovery manager", e);
        }
    }

    private LookupCache getAndRegisterInLookupCache(Map<ServiceID, LookupLocator> initialLocatorsMap, ServiceRegistrar registrar, ServiceID serviceID) {
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.finer("Creating lookup cache for ServiceRegistrar services and adding listener");
        }
        try {
            this._lookupCache = this._sdm.createLookupCache(LOOKUP_CACHE_TEMPLATE, null, null);
            this._listener = new ServiceRegistrarServiceDiscoveryListener(this._ldm, initialLocatorsMap, registrar, serviceID);
            this._lookupCache.addListener(this._listener);
            return this._lookupCache;
        }
        catch (Exception e) {
            throw new DynamicLookupLocatorDiscoveryException("Failed creating lookup cache", e);
        }
    }

    private ServiceRegistrar getOurRegistrarInNeeded(ServiceID serviceID, Map<ServiceID, LookupLocator> initialLocatorsMap) {
        if (serviceID == null) {
            return null;
        }
        ServiceRegistrar registrar = null;
        List<ServiceRegistrar> registrars = this.getRegistrars();
        for (ServiceRegistrar reg : registrars) {
            if (!reg.getServiceID().equals((Object)serviceID)) continue;
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.finer("Found registrar with service id: " + serviceID);
            }
            registrar = reg;
            break;
        }
        if (registrar == null && this._logger.isLoggable(Level.WARNING)) {
            this._logger.warning("Could not find registrar with service id: " + serviceID + ", this lookup service will not update its state properly");
        }
        return registrar;
    }

    private Map<ServiceID, LookupLocator> getInitialLookupLocatorsMap() {
        List<ServiceRegistrar> registrars = this.getRegistrars();
        HashMap<ServiceID, LookupLocator> initialLocatorsMap = new HashMap<ServiceID, LookupLocator>();
        for (ServiceRegistrar registrar : registrars) {
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.finer("Trying to get locator from registrar with service id: " + registrar.getServiceID());
            }
            try {
                initialLocatorsMap.put(registrar.getServiceID(), registrar.getLocator());
            }
            catch (RemoteException e) {
                if (!this._logger.isLoggable(Level.WARNING)) continue;
                this._logger.log(Level.WARNING, "Failed getting initial locator for registrar with service id: " + registrar.getServiceID(), e);
            }
        }
        return initialLocatorsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Object object = this._lock;
        synchronized (object) {
            if (this._terminated) {
                return;
            }
            if (this._sdm != null) {
                if (this._listener != null) {
                    this._listener.terminate();
                }
                if (this._lookupCache != null) {
                    this._lookupCache.terminate();
                }
                this._sdm.terminate();
                int sdmRefCounter = this._sdm.getRefCounter();
                this._sdm = null;
                if (this._logger.isLoggable(Level.FINEST)) {
                    this._logger.finest("Number of shared SDM after termination: " + sdmRefCounter);
                }
            }
            this._terminated = true;
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("DynamicLookupLocatorDiscovery terminated");
        }
    }

    public boolean awaitInitialization(long timeout, TimeUnit unit) throws InterruptedException {
        return this._initializedIndicator.await(timeout, unit);
    }

    public boolean isInitialized() {
        try {
            return this.awaitInitialization(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public Exception getInitializationException() {
        return this._initException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discovered(DiscoveryEvent e) {
        Object object = this._initialServiceRegistrarsLock;
        synchronized (object) {
            for (ServiceRegistrar registrar : e.getRegistrars()) {
                if (this._logger.isLoggable(Level.FINER)) {
                    this._logger.finer("Discovery event for registrar with service id: " + registrar.getServiceID() + " (discovered via initial seed locators)");
                }
                this._initialRegistrars.add(registrar);
                this._initialRegistrarsDiscoveredLatch.countDown();
            }
        }
    }

    @Override
    public void discarded(DiscoveryEvent e) {
        for (ServiceRegistrar registrar : e.getRegistrars()) {
            if (!this._logger.isLoggable(Level.FINER)) continue;
            this._logger.finer("Discarded event for registrar with service id: " + registrar.getServiceID() + " (discovered via initial seed locators)");
        }
    }

    public void addLookupLocatorsChangeListener(LookupLocatorsChangeListener listener) {
        this._listener.addLookupLocatorsChangeListener(listener);
    }

    public void removeLookupLocatorsChangeListener(LookupLocatorsChangeListener listener) {
        this._listener.removeLookupLocatorsChangeListener(listener);
    }
}

