/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery.dynamic;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.collections.ConcurrentHashSet;
import com.gigaspaces.internal.utils.concurrent.AsyncCallable;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandler;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import com.gigaspaces.internal.utils.concurrent.SharedHandlerProviderCache;
import com.gigaspaces.time.SystemTime;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.admin.Administrable;
import net.jini.admin.JoinAdmin;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.dynamic.LocatorsChangedEvent;
import net.jini.discovery.dynamic.LookupLocatorsChangeListener;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryListener;
import org.jini.rio.boot.BootUtil;

@InternalApi
public class ServiceRegistrarServiceDiscoveryListener
implements ServiceDiscoveryListener {
    public static final String LOCATORS_CLEANUP_TASK_INTERVAL_PROP = "com.gs.jini_lus.locators.dynamic.cleanup_task_interval";
    public static final long LOCATORS_CLEANUP_TASK_INTERVAL_DEFAUL = 30000L;
    public static final String LOCATORS_REMOVAL_THRESHOLD_PROP = "com.gs.jini_lus.locators.dynamic.locator_removal_threshold";
    public static final long LOCATORS_REMOVAL_THRESHOLD_DEFULT = 120000L;
    public static final String GET_REGISTRAR_PROXY_TIMEOUT_PROP = "com.gs.jini_lus.locators.dynamic.registrar_proxy_timeout";
    public static final int GET_REGISTRAR_PROXY_TIMEOUT_DEFAULT = 1000;
    public static final String DYNAMIC_LOCATORS_REMOVE_SEEDS_ENABELD_PROP = "com.gs.jini_lus.locators.dynamic.remove_seeds_enabled";
    public static final boolean DYNAMIC_LOCATORS_REMOVE_SEEDS_ENABELD_DEFAULT = true;
    private final Logger _logger = Logger.getLogger("com.gs.locator.dynamic.listener");
    private final Object _lock = new Object();
    private final long _locatorRemovalThreshold;
    private final long _locatorRemovalTaskInterval;
    private final int _getRegistrarProxyTimeout;
    private final boolean _enabledSeedRemoval;
    private final Set<LookupLocatorsChangeListener> _listeners = new ConcurrentHashSet<LookupLocatorsChangeListener>();
    private final IAsyncHandlerProvider _asyncHanlderProvider;
    private final Map<ServiceID, Set<LookupLocator>> _locatorsPendingRemovalServiceIDs = new HashMap<ServiceID, Set<LookupLocator>>();
    private final Map<LookupLocator, Long> _locatorsPendingRemovalEventTime = new HashMap<LookupLocator, Long>();
    private final DiscoveryLocatorManagement _dlm;
    private final Map<ServiceID, Set<LookupLocator>> _locators;
    private final LookupLocator[] _initialSeedLocators;
    private final IAsyncHandler _asyncHandler;
    private final ServiceID _ourRegistrarServiceID;
    private ServiceRegistrar _ourRegistrar;
    private LookupLocator _ourRegistrarLocator;

    public ServiceRegistrarServiceDiscoveryListener(DiscoveryLocatorManagement dlm, Map<ServiceID, LookupLocator> initialLocatorsMap, ServiceRegistrar registrar, ServiceID registrarServiceID) throws RemoteException {
        this._dlm = dlm;
        this._ourRegistrar = registrar;
        this._ourRegistrarServiceID = registrarServiceID;
        this._ourRegistrarLocator = this._ourRegistrar != null ? this._ourRegistrar.getLocator() : null;
        this._locatorRemovalThreshold = Long.getLong(LOCATORS_REMOVAL_THRESHOLD_PROP, 120000L);
        this._locatorRemovalTaskInterval = Long.getLong(LOCATORS_CLEANUP_TASK_INTERVAL_PROP, 30000L);
        this._getRegistrarProxyTimeout = Integer.getInteger(GET_REGISTRAR_PROXY_TIMEOUT_PROP, 1000);
        this._enabledSeedRemoval = Boolean.parseBoolean(System.getProperty(DYNAMIC_LOCATORS_REMOVE_SEEDS_ENABELD_PROP, Boolean.toString(true)));
        this._locators = new HashMap<ServiceID, Set<LookupLocator>>();
        for (Map.Entry<ServiceID, LookupLocator> entry : initialLocatorsMap.entrySet()) {
            HashSet<LookupLocator> locatorSet = new HashSet<LookupLocator>();
            locatorSet.add(entry.getValue());
            this._locators.put(entry.getKey(), locatorSet);
        }
        for (LookupLocator locator : this._initialSeedLocators = this._dlm.getLocators()) {
            if (initialLocatorsMap.values().contains(locator)) continue;
            try {
                ServiceID serviceID;
                Set<LookupLocator> set;
                if (this._logger.isLoggable(Level.FINER)) {
                    this._logger.finer("Trying to find find registrar with initial seed locator: " + locator);
                }
                if ((set = this._locators.get(serviceID = locator.getRegistrar(this._getRegistrarProxyTimeout).getServiceID())) == null) {
                    set = new HashSet<LookupLocator>();
                }
                set.add(locator);
                this._locators.put(serviceID, set);
            }
            catch (IOException e) {
                if (!this._logger.isLoggable(Level.FINER)) continue;
                this._logger.log(Level.FINER, "Could not get proxy to registrar at " + locator, e);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
        this._asyncHanlderProvider = SharedHandlerProviderCache.getSharedThreadPoolProviderCache().getProvider();
        this._asyncHandler = this._asyncHanlderProvider.start(new RemovePendingRemovalLocatorsTaskAsyncCallable(), this._locatorRemovalTaskInterval, "GS-Locators-Cleanup", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serviceAdded(ServiceDiscoveryEvent event) {
        block18: {
            try {
                Object service = event.getPostEventServiceItem().getService();
                ServiceRegistrar registrar = (ServiceRegistrar)service;
                if (this._logger.isLoggable(Level.FINER)) {
                    this._logger.finer("ServiceRegistrar service added with serviceID: " + registrar.getServiceID() + ", Current locators: " + BootUtil.arrayToCommaDelimitedString((Object[])this._dlm.getLocators()));
                }
                Object object = this._lock;
                synchronized (object) {
                    if (this._locatorsPendingRemovalServiceIDs.containsKey(registrar.getServiceID())) {
                        Set<LookupLocator> locators = this._locatorsPendingRemovalServiceIDs.remove(registrar.getServiceID());
                        for (LookupLocator locator : locators) {
                            this._locatorsPendingRemovalEventTime.remove(locator);
                        }
                        if (this._logger.isLoggable(Level.FINE)) {
                            this._logger.fine("locators " + locators + " removed from pending removal locators");
                        }
                        return;
                    }
                    if (this._locators.containsKey(registrar.getServiceID())) {
                        if (this._logger.isLoggable(Level.FINE)) {
                            this._logger.fine("ServiceRegistrar with locators " + this._locators.get(registrar.getServiceID()) + " already registered");
                        }
                        return;
                    }
                    LookupLocator[] locators = new LookupLocator[]{registrar.getLocator()};
                    if (registrar.getServiceID().equals((Object)this._ourRegistrarServiceID) && this._ourRegistrar == null) {
                        if (this._logger.isLoggable(Level.INFO)) {
                            this._logger.info("Found previously missing registrar with service id: " + registrar.getServiceID() + ", This lookup service will now update its state properly");
                        }
                        this._ourRegistrar = registrar;
                        this._ourRegistrarLocator = locators[0];
                    }
                    if (this._ourRegistrar != null) {
                        if (this._logger.isLoggable(Level.INFO)) {
                            this._logger.info("Adding locator " + locators[0] + " to ServiceRegistrar at " + this._ourRegistrarLocator);
                        }
                        Administrable administrable = (Administrable)this._ourRegistrar;
                        JoinAdmin joinAdmin = (JoinAdmin)administrable.getAdmin();
                        joinAdmin.addLookupLocators(locators);
                    } else {
                        if (this._logger.isLoggable(Level.INFO)) {
                            this._logger.info("Adding locator " + locators[0] + " to DiscoveryLocatorManagement");
                        }
                        this._dlm.addLocators(locators);
                        this.notifyListeners(this._dlm.getLocators());
                    }
                    HashSet<LookupLocator> locatorSet = new HashSet<LookupLocator>();
                    locatorSet.add(locators[0]);
                    this._locators.put(registrar.getServiceID(), locatorSet);
                    if (this._logger.isLoggable(Level.FINER)) {
                        this._logger.finer("After addition, current locators are: " + BootUtil.arrayToCommaDelimitedString((Object[])this._dlm.getLocators()));
                    }
                }
            }
            catch (RemoteException e) {
                if (!this._logger.isLoggable(Level.WARNING)) break block18;
                this._logger.log(Level.WARNING, "Failed adding lookup locator", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serviceRemoved(ServiceDiscoveryEvent event) {
        Object service = event.getPreEventServiceItem().getService();
        ServiceRegistrar registrar = (ServiceRegistrar)service;
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.finer("ServiceRegistrar service removed with serviceID: " + registrar.getServiceID() + ", Current locators: " + BootUtil.arrayToCommaDelimitedString((Object[])this._dlm.getLocators()));
        }
        Object object = this._lock;
        synchronized (object) {
            Set<LookupLocator> locators = this._locators.get(registrar.getServiceID());
            if (locators != null) {
                if (!this._enabledSeedRemoval && this.anySeedLocator(locators)) {
                    if (this._logger.isLoggable(Level.FINE)) {
                        this._logger.fine("Not removing locators of registrar with service id: " + registrar.getServiceID() + ", as seed removal is disabled");
                    }
                } else if (!this._locatorsPendingRemovalServiceIDs.containsKey(registrar.getServiceID())) {
                    if (this._logger.isLoggable(Level.FINE)) {
                        this._logger.fine("Adding locators " + locators + " to pending removal locators");
                    }
                    this._locatorsPendingRemovalServiceIDs.put(registrar.getServiceID(), locators);
                    long eventTime = SystemTime.timeMillis();
                    for (LookupLocator locator : locators) {
                        this._locatorsPendingRemovalEventTime.put(locator, eventTime);
                    }
                } else if (this._logger.isLoggable(Level.FINER)) {
                    this._logger.finer("locators: " + locators + " already added to pending removal locators");
                }
            } else if (this._logger.isLoggable(Level.FINER)) {
                this._logger.finer("ServiceRegistrar with serviceID " + registrar.getServiceID() + " already removed");
            }
        }
    }

    private boolean anySeedLocator(Set<LookupLocator> locators) {
        for (LookupLocator locator : this._initialSeedLocators) {
            if (!locators.contains(locator)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void serviceChanged(ServiceDiscoveryEvent event) {
    }

    public void terminate() {
        this._asyncHandler.stop(1L, TimeUnit.MILLISECONDS);
        this._asyncHanlderProvider.close();
    }

    private void notifyListeners(final LookupLocator[] locators) {
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.finer("Notifying registered listeners on locators changed event with locators: " + StringUtils.arrayToCommaDelimitedString(locators));
        }
        this._asyncHanlderProvider.start(new AsyncCallable(){

            @Override
            public IAsyncHandlerProvider.CycleResult call() throws Exception {
                for (LookupLocatorsChangeListener listener : ServiceRegistrarServiceDiscoveryListener.this._listeners) {
                    try {
                        LocatorsChangedEvent event = new LocatorsChangedEvent(ServiceRegistrarServiceDiscoveryListener.this, locators);
                        listener.locatorsChanged(event);
                    }
                    catch (Exception e) {
                        if (!ServiceRegistrarServiceDiscoveryListener.this._logger.isLoggable(Level.FINE)) continue;
                        ServiceRegistrarServiceDiscoveryListener.this._logger.log(Level.FINE, "Listener threw exception during notification", e);
                    }
                }
                return IAsyncHandlerProvider.CycleResult.TERMINATE;
            }
        }, 1L, "DynamicLocators-ChangeNotifier", false);
    }

    public void addLookupLocatorsChangeListener(LookupLocatorsChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        this._listeners.add(listener);
    }

    public void removeLookupLocatorsChangeListener(LookupLocatorsChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        this._listeners.remove(listener);
    }

    private class RemovePendingRemovalLocatorsTaskAsyncCallable
    extends AsyncCallable {
        private boolean _loggedPossibleDisconnetion = false;

        private RemovePendingRemovalLocatorsTaskAsyncCallable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IAsyncHandlerProvider.CycleResult call() throws Exception {
            Object object = ServiceRegistrarServiceDiscoveryListener.this._lock;
            synchronized (object) {
                block15: {
                    ArrayList locatorsToRemove = new ArrayList();
                    ArrayList<ServiceID> serviceIDs = new ArrayList<ServiceID>();
                    for (Map.Entry entry : ServiceRegistrarServiceDiscoveryListener.this._locatorsPendingRemovalServiceIDs.entrySet()) {
                        ServiceID serviceID = (ServiceID)entry.getKey();
                        Set locatorSet = (Set)entry.getValue();
                        long serviceRemovedTime = (Long)ServiceRegistrarServiceDiscoveryListener.this._locatorsPendingRemovalEventTime.get(locatorSet.iterator().next());
                        if (serviceRemovedTime + ServiceRegistrarServiceDiscoveryListener.this._locatorRemovalThreshold > SystemTime.timeMillis()) continue;
                        locatorsToRemove.addAll(locatorSet);
                        serviceIDs.add(serviceID);
                    }
                    if (locatorsToRemove.isEmpty()) {
                        return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
                    }
                    if (serviceIDs.size() >= ServiceRegistrarServiceDiscoveryListener.this._locators.size()) {
                        if (ServiceRegistrarServiceDiscoveryListener.this._logger.isLoggable(Level.WARNING) && !this._loggedPossibleDisconnetion) {
                            ServiceRegistrarServiceDiscoveryListener.this._logger.warning("Found that all registered locators were removed, this could mean that this machine has disconnected, so no locator removal will be made");
                            this._loggedPossibleDisconnetion = true;
                        }
                        return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
                    }
                    this._loggedPossibleDisconnetion = false;
                    try {
                        LookupLocator[] locators = locatorsToRemove.toArray(new LookupLocator[locatorsToRemove.size()]);
                        if (ServiceRegistrarServiceDiscoveryListener.this._ourRegistrar != null) {
                            if (ServiceRegistrarServiceDiscoveryListener.this._logger.isLoggable(Level.INFO)) {
                                ServiceRegistrarServiceDiscoveryListener.this._logger.info("Removing locators " + locatorsToRemove + " from ServiceRegistrar at " + ServiceRegistrarServiceDiscoveryListener.this._ourRegistrarLocator);
                            }
                            Administrable administrable = (Administrable)ServiceRegistrarServiceDiscoveryListener.this._ourRegistrar;
                            JoinAdmin joinAdmin = (JoinAdmin)administrable.getAdmin();
                            joinAdmin.removeLookupLocators(locators);
                        } else {
                            if (ServiceRegistrarServiceDiscoveryListener.this._logger.isLoggable(Level.INFO)) {
                                ServiceRegistrarServiceDiscoveryListener.this._logger.info("Removing locators " + locatorsToRemove + " from DiscoveryLocatorManagement");
                            }
                            ServiceRegistrarServiceDiscoveryListener.this._dlm.removeLocators(locators);
                            ServiceRegistrarServiceDiscoveryListener.this.notifyListeners(ServiceRegistrarServiceDiscoveryListener.this._dlm.getLocators());
                        }
                        for (ServiceID serviceID : serviceIDs) {
                            ServiceRegistrarServiceDiscoveryListener.this._locators.remove(serviceID);
                            ServiceRegistrarServiceDiscoveryListener.this._locatorsPendingRemovalServiceIDs.remove(serviceID);
                        }
                        for (LookupLocator locator : locators) {
                            ServiceRegistrarServiceDiscoveryListener.this._locatorsPendingRemovalEventTime.remove(locator);
                        }
                    }
                    catch (RemoteException e) {
                        if (!ServiceRegistrarServiceDiscoveryListener.this._logger.isLoggable(Level.WARNING)) break block15;
                        ServiceRegistrarServiceDiscoveryListener.this._logger.log(Level.WARNING, "Failed removing locators", e);
                    }
                }
                return IAsyncHandlerProvider.CycleResult.IDLE_CONTINUE;
            }
        }
    }
}

