/*
 * Decompiled with CFR 0.152.
 */
package net.jini.lookup;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.exception.internal.InterruptedSpaceException;
import com.sun.jini.config.Config;
import com.sun.jini.logging.Levels;
import com.sun.jini.lookup.entry.LookupAttributes;
import com.sun.jini.proxy.BasicProxyTrustVerifier;
import com.sun.jini.thread.TaskManager;
import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.EmptyConfiguration;
import net.jini.config.NoSuchEntryException;
import net.jini.core.entry.Entry;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.Lease;
import net.jini.core.lookup.RegistrarEventRegistration;
import net.jini.core.lookup.ServiceDetails;
import net.jini.core.lookup.ServiceEvent;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceMatches;
import net.jini.core.lookup.ServiceMatchesMerger;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.export.Exporter;
import net.jini.io.MarshalledInstance;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.LookupCache;
import net.jini.lookup.SameProxyVersionProvider;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryListener;
import net.jini.lookup.ServiceItemFilter;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;

@InternalApi
public class ServiceDiscoveryManager {
    private static final String COMPONENT_NAME = "net.jini.lookup.ServiceDiscoveryManager";
    private static final Logger logger = Logger.getLogger("net.jini.lookup.ServiceDiscoveryManager");
    private static final long DEFAULT_NOTIFICATIONS_LEASE_RENEW_RATE = TimeUnit.SECONDS.toMillis(30L);
    private static final long DEFAULT_REMOVE_SERVICE_IF_ORPHAN_DELAY = TimeUnit.SECONDS.toMillis(60L);
    private DiscoveryManagement discMgr;
    private boolean discMgrInternal = false;
    private final DiscMgrListener discMgrListener = new DiscMgrListener();
    private LeaseRenewalManager leaseRenewalMgr;
    private boolean managingLeaseRenewal = false;
    private final ArrayList proxyRegSet = new ArrayList(1);
    private final ArrayList listeners = new ArrayList(1);
    private final Random random = new Random();
    private final ArrayList caches = new ArrayList(1);
    private boolean bTerminated = false;
    private Configuration thisConfig;
    private ProxyPreparer registrarPreparer;
    private ProxyPreparer eventLeasePreparer;
    private long discardWait = 600000L;
    private long notificationsLeaseRenewDuration;
    private long removeOrphanServicesDelay;

    protected long getDefaultNotificationsLeaseRenewalRate() {
        return DEFAULT_NOTIFICATIONS_LEASE_RENEW_RATE;
    }

    protected long getDefaultRemoveServiceIfOrphanDelay() {
        return DEFAULT_REMOVE_SERVICE_IF_ORPHAN_DELAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheAddProxy(ProxyReg reg) {
        ArrayList arrayList = this.caches;
        synchronized (arrayList) {
            for (LookupCacheImpl cache : this.caches) {
                cache.addProxyReg(reg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropProxy(ProxyReg reg) {
        ArrayList arrayList = this.caches;
        synchronized (arrayList) {
            for (LookupCacheImpl cache : this.caches) {
                cache.removeProxyReg(reg);
            }
        }
    }

    public ServiceDiscoveryManager(DiscoveryManagement discoveryMgr, LeaseRenewalManager leaseMgr) throws IOException {
        try {
            this.init(discoveryMgr, leaseMgr, (Configuration)EmptyConfiguration.INSTANCE);
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public ServiceDiscoveryManager(DiscoveryManagement discoveryMgr, LeaseRenewalManager leaseMgr, Configuration config) throws IOException, ConfigurationException {
        this.init(discoveryMgr, leaseMgr, config);
    }

    private void listenerDropped(ArrayList drops, ArrayList notifies) {
        ServiceRegistrar[] proxys = new ServiceRegistrar[drops.size()];
        drops.toArray(proxys);
        this.listenerDropped(proxys, notifies);
    }

    private void listenerDropped(ServiceRegistrar[] proxys, ArrayList notifies) {
        Iterator iter = notifies.iterator();
        while (iter.hasNext()) {
            DiscoveryEvent evt = new DiscoveryEvent((Object)this, (ServiceRegistrar[])proxys.clone());
            ((DiscoveryListener)iter.next()).discarded(evt);
        }
    }

    private void listenerDiscovered(ServiceRegistrar proxy, ArrayList notifies) {
        Iterator iter = notifies.iterator();
        while (iter.hasNext()) {
            DiscoveryEvent evt = new DiscoveryEvent((Object)this, new ServiceRegistrar[]{proxy});
            ((DiscoveryListener)iter.next()).discovered(evt);
        }
    }

    private ServiceRegistrar[] buildServiceRegistrar() {
        int k = 0;
        ServiceRegistrar[] proxys = new ServiceRegistrar[this.proxyRegSet.size()];
        for (ProxyReg reg : this.proxyRegSet) {
            proxys[k++] = reg.proxy;
        }
        return proxys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceDetails[] serviceDetails(ServiceID serviceID) {
        ServiceRegistrar[] proxys;
        this.checkTerminated();
        ArrayList arrayList = this.proxyRegSet;
        synchronized (arrayList) {
            proxys = this.buildServiceRegistrar();
        }
        int len = proxys.length;
        if (len == 0) {
            return new ServiceDetails[0];
        }
        ArrayList<ServiceDetails> serviceDetails = new ArrayList<ServiceDetails>();
        for (int i = 0; i < len; ++i) {
            ServiceRegistrar proxy = proxys[i];
            try {
                serviceDetails.add(proxy.serviceDetails(serviceID));
                continue;
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Exception occurred during service details, discarding reggie [" + proxy + "]", e);
                this.discard(proxy);
            }
        }
        return serviceDetails.toArray(new ServiceDetails[serviceDetails.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceItem lookup(ServiceTemplate tmpl, ServiceItemFilter filter) {
        ServiceRegistrar[] proxys;
        this.checkTerminated();
        ArrayList arrayList = this.proxyRegSet;
        synchronized (arrayList) {
            proxys = this.buildServiceRegistrar();
        }
        int len = proxys.length;
        if (len == 0) {
            return null;
        }
        int rand = Math.abs(this.random.nextInt() % len);
        for (int i = 0; i < len; ++i) {
            ServiceRegistrar proxy = proxys[(i + rand) % len];
            ServiceItem sItem = null;
            try {
                int maxMatches = filter != null ? Integer.MAX_VALUE : 1;
                ServiceMatches sm = proxy.lookup(tmpl, maxMatches);
                sItem = this.getMatchedServiceItem(sm, filter);
            }
            catch (InterruptedSpaceException e) {
                logger.log(Level.INFO, "Interrupt exception occurred during query", e);
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Exception occurred during query, discarding reggie [" + proxy + "]", e);
                this.discard(proxy);
            }
            if (sItem == null) continue;
            return sItem;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ServiceItem lookup(ServiceTemplate tmpl, ServiceItemFilter filter, long waitDur) throws InterruptedException, RemoteException {
        ServiceItem sm = this.lookup(tmpl, filter);
        if (sm != null) {
            return sm;
        }
        ServiceDiscoveryListenerImpl cacheListener = new ServiceDiscoveryListenerImpl();
        LookupCacheImpl cache = null;
        try {
            ServiceDiscoveryListenerImpl serviceDiscoveryListenerImpl = cacheListener;
            synchronized (serviceDiscoveryListenerImpl) {
                cache = this.createLookupCache(tmpl, filter, cacheListener, waitDur);
                long duration = cache.getLeaseDuration();
                while (duration > 0L) {
                    cacheListener.wait(duration);
                    sm = cache.lookup(null);
                    if (sm != null) {
                        ServiceItem serviceItem = sm;
                        return serviceItem;
                    }
                    duration = cache.getLeaseDuration();
                }
            }
            serviceDiscoveryListenerImpl = sm;
            return serviceDiscoveryListenerImpl;
        }
        finally {
            if (cache != null) {
                cache.terminate();
            }
        }
    }

    public LookupCache createLookupCache(ServiceTemplate tmpl, ServiceItemFilter filter, ServiceDiscoveryListener listener) throws RemoteException {
        this.checkTerminated();
        return this.createLookupCache(tmpl, filter, listener, Long.MAX_VALUE);
    }

    public DiscoveryManagement getDiscoveryManager() {
        this.checkTerminated();
        return this.discMgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        ServiceDiscoveryManager serviceDiscoveryManager = this;
        synchronized (serviceDiscoveryManager) {
            if (this.bTerminated) {
                return;
            }
            this.bTerminated = true;
            this.discMgr.removeDiscoveryListener(this.discMgrListener);
            if (this.discMgrInternal) {
                this.discMgr.terminate();
            }
            if (this.managingLeaseRenewal) {
                this.leaseRenewalMgr.terminate();
            }
        }
        boolean terminateCaches = false;
        ArrayList cachesClone = null;
        ArrayList arrayList = this.caches;
        synchronized (arrayList) {
            if (!this.caches.isEmpty()) {
                terminateCaches = true;
                cachesClone = (ArrayList)this.caches.clone();
            }
        }
        if (terminateCaches) {
            for (LookupCacheImpl cache : cachesClone) {
                cache.terminate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceItem[] lookup(ServiceTemplate tmpl, int maxMatches, ServiceItemFilter filter) {
        ServiceRegistrar[] proxys;
        this.checkTerminated();
        if (maxMatches < 1) {
            throw new IllegalArgumentException("maxMatches must be > 0");
        }
        ArrayList arrayList = this.proxyRegSet;
        synchronized (arrayList) {
            proxys = this.buildServiceRegistrar();
        }
        int len = proxys.length;
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "query {0} lookup service(s) for template: {1} max-matches: {2}", new Object[]{len, tmpl, maxMatches});
        }
        ArrayList<ServiceItem> sItemSet = new ArrayList<ServiceItem>(len);
        if (len > 0) {
            int rand = Math.abs(this.random.nextInt() % len);
            for (int i = 0; i < len; ++i) {
                int max = maxMatches;
                ServiceRegistrar proxy = proxys[(i + rand) % len];
                try {
                    if (filter != null) {
                        max = Integer.MAX_VALUE;
                    }
                    ServiceMatches sm = proxy.lookup(tmpl, max);
                    int nItems = sm.items.length;
                    if (nItems == 0) continue;
                    int r = Math.abs(this.random.nextInt() % nItems);
                    for (int j = 0; j < nItems; ++j) {
                        ServiceItem sItem = sm.items[(j + r) % nItems];
                        if (sItem == null || !this.filterPassFail(sItem, filter)) continue;
                        if (!ServiceDiscoveryManager.isArrayContainsServiceItem(sItemSet, sItem)) {
                            sItemSet.add(sItem);
                        }
                        if (sItemSet.size() < maxMatches) continue;
                        return sItemSet.toArray(new ServiceItem[sItemSet.size()]);
                    }
                    continue;
                }
                catch (Exception e) {
                    logger.log(Level.FINE, "Exception occurred during query, discarding proxy", e);
                    this.discard(proxy);
                }
            }
        }
        return sItemSet.toArray(new ServiceItem[sItemSet.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceItem[] lookup(ServiceTemplate tmpl, int minMatches, int maxMatches, ServiceItemFilter filter, long waitDur) throws InterruptedException, RemoteException {
        this.checkTerminated();
        if (minMatches < 1) {
            throw new IllegalArgumentException("minMatches must be > 0");
        }
        if (maxMatches < minMatches) {
            throw new IllegalArgumentException("maxMatches must be > minMatches");
        }
        ServiceItem[] sItems = this.lookup(tmpl, maxMatches, filter);
        if (sItems.length >= minMatches) {
            return sItems;
        }
        ArrayList<ServiceItem> sItemSet = new ArrayList<ServiceItem>(sItems.length);
        for (int i = 0; i < sItems.length; ++i) {
            sItemSet.add(sItems[i]);
        }
        ServiceDiscoveryListenerImpl cacheListener = new ServiceDiscoveryListenerImpl();
        LookupCacheImpl cache = null;
        ServiceDiscoveryListenerImpl serviceDiscoveryListenerImpl = cacheListener;
        synchronized (serviceDiscoveryListenerImpl) {
            cache = this.createLookupCache(tmpl, filter, cacheListener, waitDur);
            long duration = cache.getLeaseDuration();
            while (duration > 0L) {
                cacheListener.wait(duration);
                ServiceItem[] items = cacheListener.getServiceItem();
                for (int i = 0; i < items.length; ++i) {
                    if (ServiceDiscoveryManager.isArrayContainsServiceItem(sItemSet, items[i])) continue;
                    sItemSet.add(items[i]);
                }
                if (sItemSet.size() >= minMatches) break;
                duration = cache.getLeaseDuration();
            }
        }
        cache.terminate();
        ServiceItem[] r = new ServiceItem[sItemSet.size()];
        sItemSet.toArray(r);
        return r;
    }

    private ServiceItem getMatchedServiceItem(ServiceMatches sm, ServiceItemFilter filter) {
        int len = sm.items.length;
        if (len > 0) {
            int rand = Math.abs(this.random.nextInt() % len);
            for (int i = 0; i < len; ++i) {
                ServiceItem sItem = sm.items[(i + rand) % len];
                if (sItem == null || !this.filterPassFail(sItem, filter)) continue;
                return sItem;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LookupCacheImpl createLookupCache(ServiceTemplate tmpl, ServiceItemFilter filter, ServiceDiscoveryListener listener, long leaseDuration) throws RemoteException {
        if (tmpl == null) {
            tmpl = new ServiceTemplate(null, null, null);
        }
        LookupCacheImpl cache = new LookupCacheImpl(tmpl, filter, listener, leaseDuration);
        ArrayList arrayList = this.caches;
        synchronized (arrayList) {
            this.caches.add(cache);
        }
        logger.finest("ServiceDiscoveryManager - LookupCache created");
        return cache;
    }

    private ProxyReg findReg(ServiceRegistrar proxy) {
        for (ProxyReg reg : this.proxyRegSet) {
            if (!reg.proxy.equals(proxy)) continue;
            return reg;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fail(Throwable e, ServiceRegistrar proxy, String sourceClass, String sourceMethod, String msg, boolean cacheTerminated) {
        block8: {
            Level logLevel = Level.INFO;
            boolean discardProxy = true;
            ServiceDiscoveryManager serviceDiscoveryManager = this;
            synchronized (serviceDiscoveryManager) {
                if (this.bTerminated || cacheTerminated) {
                    logLevel = Levels.HANDLED;
                    discardProxy = false;
                }
            }
            if (e != null && logger.isLoggable(logLevel)) {
                logger.logp(logLevel, sourceClass, sourceMethod, msg, e);
            }
            try {
                if (discardProxy) {
                    this.discard(proxy);
                }
            }
            catch (IllegalStateException e1) {
                if (!logger.isLoggable(logLevel)) break block8;
                logger.logp(logLevel, sourceClass, sourceMethod, "failure discarding lookup service proxy, discovery manager already terminated", e1);
            }
        }
    }

    private void discard(ServiceRegistrar proxy) {
        this.discMgr.discard(proxy);
    }

    private void cancelLease(Lease lease) {
        try {
            this.leaseRenewalMgr.cancel(lease);
        }
        catch (Exception e) {
            logger.log(Level.FINER, "exception occurred while cancelling an event registration lease", e);
        }
    }

    private EventReg registerListener(ServiceRegistrar proxy, ServiceTemplate tmpl, RemoteEventListener listenerProxy, long duration) throws RemoteException {
        RegistrarEventRegistration e = null;
        int transition = 7;
        long initialLeaseDuration = this.notificationsLeaseRenewDuration == Long.MAX_VALUE ? duration : this.notificationsLeaseRenewDuration;
        e = proxy.notify(tmpl, transition, listenerProxy, null, initialLeaseDuration, 1);
        Lease eventLease = e.getLease();
        eventLease = (Lease)this.eventLeasePreparer.prepareProxy((Object)eventLease);
        logger.log(Level.FINEST, "ServiceDiscoveryManager - proxy to event registration lease prepared: {0}", eventLease);
        this.leaseRenewalMgr.renewFor(eventLease, duration, this.notificationsLeaseRenewDuration, new LeaseListenerImpl(proxy));
        return new EventReg(e.getSource(), e.getID(), e.getSequenceNumber(), eventLease, e.getMatches());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTerminated() {
        ServiceDiscoveryManager serviceDiscoveryManager = this;
        synchronized (serviceDiscoveryManager) {
            if (this.bTerminated) {
                throw new IllegalStateException("service discovery manager was terminated");
            }
        }
    }

    private static ServiceTemplate copyServiceTemplate(ServiceTemplate tmpl) {
        int len;
        Class[] serviceTypes = null;
        Entry[] attributeSetTemplates = null;
        if (tmpl.serviceTypes != null) {
            len = tmpl.serviceTypes.length;
            serviceTypes = new Class[len];
            System.arraycopy(tmpl.serviceTypes, 0, serviceTypes, 0, len);
        }
        if (tmpl.attributeSetTemplates != null) {
            len = tmpl.attributeSetTemplates.length;
            attributeSetTemplates = new Entry[len];
            System.arraycopy(tmpl.attributeSetTemplates, 0, attributeSetTemplates, 0, len);
        }
        return new ServiceTemplate(tmpl.serviceID, serviceTypes, attributeSetTemplates);
    }

    private static boolean isArrayContainsServiceItem(ArrayList a, ServiceItem s) {
        for (Object o : a) {
            if (!(o instanceof ServiceItem)) continue;
            ServiceItem sa = (ServiceItem)o;
            if (!sa.serviceID.equals((Object)s.serviceID) || !LookupAttributes.equal(sa.attributeSets, s.attributeSets) || !sa.service.equals(s.service)) continue;
            return true;
        }
        return false;
    }

    private void init(DiscoveryManagement discoveryMgr, LeaseRenewalManager leaseMgr, Configuration config) throws IOException, ConfigurationException {
        if (config == null) {
            throw new NullPointerException("config is null");
        }
        this.thisConfig = config;
        this.registrarPreparer = (ProxyPreparer)this.thisConfig.getEntry(COMPONENT_NAME, "registrarPreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
        this.eventLeasePreparer = (ProxyPreparer)this.thisConfig.getEntry(COMPONENT_NAME, "eventLeasePreparer", ProxyPreparer.class, (Object)new BasicProxyPreparer());
        this.leaseRenewalMgr = leaseMgr;
        if (this.leaseRenewalMgr == null) {
            this.managingLeaseRenewal = true;
            try {
                this.leaseRenewalMgr = (LeaseRenewalManager)this.thisConfig.getEntry(COMPONENT_NAME, "leaseManager", LeaseRenewalManager.class);
            }
            catch (NoSuchEntryException e) {
                this.leaseRenewalMgr = new LeaseRenewalManager(this.thisConfig);
            }
        } else {
            this.managingLeaseRenewal = false;
        }
        this.discardWait = (Long)this.thisConfig.getEntry(COMPONENT_NAME, "discardWait", Long.TYPE, (Object)new Long(this.discardWait));
        this.discMgr = discoveryMgr;
        if (this.discMgr == null) {
            this.discMgrInternal = true;
            try {
                this.discMgr = (DiscoveryManagement)this.thisConfig.getEntry(COMPONENT_NAME, "discoveryManager", DiscoveryManagement.class);
            }
            catch (NoSuchEntryException e) {
                this.discMgr = new LookupDiscoveryManager(new String[]{""}, null, null, this.thisConfig);
            }
        }
        this.discMgr.addDiscoveryListener(this.discMgrListener);
        this.notificationsLeaseRenewDuration = (Long)this.thisConfig.getEntry(COMPONENT_NAME, "notificationsLeaseRenewDuration", Long.class, (Object)this.getDefaultNotificationsLeaseRenewalRate());
        this.removeOrphanServicesDelay = (Long)this.thisConfig.getEntry(COMPONENT_NAME, "removeOrphanServicesDelay", Long.class, (Object)this.getDefaultRemoveServiceIfOrphanDelay());
        if (this.notificationsLeaseRenewDuration == Long.MAX_VALUE && this.removeOrphanServicesDelay != 0L) {
            throw new ConfigurationException("removeOrphanServicesDelay must be zero since notificationsLeaseRenewDuration == Lease.FOREVER");
        }
    }

    private boolean filterPassFail(ServiceItem item, ServiceItemFilter filter) {
        if (item == null || item.service == null) {
            return false;
        }
        if (filter == null) {
            return true;
        }
        boolean pass = filter.check(item);
        return pass && item.service != null;
    }

    private class DiscMgrListener
    implements DiscoveryListener {
        private DiscMgrListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void discovered(DiscoveryEvent e) {
            ServiceRegistrar[] proxys = e.getRegistrars();
            ArrayList<ProxyReg> newProxys = new ArrayList<ProxyReg>(1);
            ArrayList notifies = null;
            for (int i = 0; i < proxys.length; ++i) {
                try {
                    proxys[i] = (ServiceRegistrar)ServiceDiscoveryManager.this.registrarPreparer.prepareProxy((Object)proxys[i]);
                    logger.log(Level.FINEST, "ServiceDiscoveryManager - discovered lookup service proxy prepared: {0}", proxys[i]);
                }
                catch (Exception e1) {
                    logger.log(Level.INFO, "failure preparing discovered ServiceRegistrar proxy, discarding the proxy", e1);
                    ServiceDiscoveryManager.this.discard(proxys[i]);
                    continue;
                }
                ProxyReg reg = new ProxyReg(proxys[i]);
                ArrayList arrayList = ServiceDiscoveryManager.this.proxyRegSet;
                synchronized (arrayList) {
                    ServiceDiscoveryManager.this.proxyRegSet.add(reg);
                    newProxys.add(reg);
                    continue;
                }
            }
            ArrayList i = ServiceDiscoveryManager.this.listeners;
            synchronized (i) {
                if (!ServiceDiscoveryManager.this.listeners.isEmpty()) {
                    notifies = (ArrayList)ServiceDiscoveryManager.this.listeners.clone();
                }
            }
            for (ProxyReg reg : newProxys) {
                ServiceDiscoveryManager.this.cacheAddProxy(reg);
                if (notifies == null) continue;
                ServiceDiscoveryManager.this.listenerDiscovered(reg.proxy, notifies);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void discarded(DiscoveryEvent e) {
            ArrayList notifies;
            ServiceRegistrar[] proxys = e.getRegistrars();
            ArrayList<ProxyReg> drops = new ArrayList<ProxyReg>(1);
            ArrayList arrayList = ServiceDiscoveryManager.this.proxyRegSet;
            synchronized (arrayList) {
                for (int i = 0; i < proxys.length; ++i) {
                    ProxyReg reg = ServiceDiscoveryManager.this.findReg(proxys[i]);
                    if (reg == null) {
                        throw new RuntimeException("discard error");
                    }
                    ServiceDiscoveryManager.this.proxyRegSet.remove(ServiceDiscoveryManager.this.proxyRegSet.indexOf(reg));
                    drops.add(reg);
                }
            }
            Iterator iter = drops.iterator();
            while (iter.hasNext()) {
                ServiceDiscoveryManager.this.dropProxy((ProxyReg)iter.next());
            }
            ArrayList arrayList2 = ServiceDiscoveryManager.this.listeners;
            synchronized (arrayList2) {
                if (ServiceDiscoveryManager.this.listeners.isEmpty()) {
                    return;
                }
                notifies = (ArrayList)ServiceDiscoveryManager.this.listeners.clone();
            }
            ServiceDiscoveryManager.this.listenerDropped(drops, notifies);
        }
    }

    private final class LookupCacheImpl
    implements LookupCache {
        private long RemoveOrphanServicesTaskWakeupTimestamp = 0L;
        private final Object RemoveOrphanServicesTaskWakeupTimestampLock = new Object();
        private static final int ITEM_ADDED = 0;
        private static final int ITEM_REMOVED = 2;
        private static final int ITEM_CHANGED = 3;
        private volatile boolean initialized;
        private final LookupListener lookupListener;
        private Exporter lookupListenerExporter;
        private RemoteEventListener lookupListenerProxy;
        private TaskManager cacheTaskMgr;
        private boolean bCacheTerminated = false;
        private final ArrayList sItemListeners = new ArrayList(1);
        private final HashMap serviceIdMap = new HashMap();
        private final HashMap eventRegMap = new HashMap();
        private final ServiceTemplate tmpl;
        private ServiceItemFilter filter = null;
        private final long leaseDuration;
        private final long startTime = SystemTime.timeMillis();
        private TaskManager serviceDiscardTimerTaskMgr;
        private final Object serviceDiscardMutex = new Object();
        private long taskSeqN = 0L;
        private final ClassLoader lookupCacheClassLoader;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void delayedRemoveOrphanServices(long delay, TimeUnit timeunit) {
            Object object = this.RemoveOrphanServicesTaskWakeupTimestampLock;
            synchronized (object) {
                long newValue = SystemTime.timeMillis() + timeunit.toMillis(delay);
                if (this.RemoveOrphanServicesTaskWakeupTimestamp < newValue) {
                    this.RemoveOrphanServicesTaskWakeupTimestamp = newValue;
                }
            }
            this.cacheTaskMgr.addIfNew(new RemoveOrphanServicesTask(this.lookupCacheClassLoader, this.taskSeqN++));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeOrphanService(ServiceID serviceId, ServiceItemReg itemReg) {
            ServiceItem item = null;
            ServiceItemReg serviceItemReg = itemReg;
            synchronized (serviceItemReg) {
                if (itemReg.hasNoProxys()) {
                    item = itemReg.filteredItem;
                }
            }
            if (item != null) {
                this.removeServiceIdMap(serviceId, item);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LookupCacheImpl(ServiceTemplate tmpl, ServiceItemFilter filter, ServiceDiscoveryListener sListener, long leaseDuration) throws RemoteException {
            ArrayList set;
            this.tmpl = ServiceDiscoveryManager.copyServiceTemplate(tmpl);
            this.leaseDuration = leaseDuration;
            this.lookupCacheClassLoader = Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : sListener.getClass().getClassLoader();
            this.filter = filter;
            this.initCache();
            this.lookupListener = new LookupListener();
            ArrayList arrayList = this.sItemListeners;
            synchronized (arrayList) {
                if (sListener != null) {
                    this.sItemListeners.add(sListener);
                }
            }
            ArrayList arrayList2 = ServiceDiscoveryManager.this.proxyRegSet;
            synchronized (arrayList2) {
                set = (ArrayList)ServiceDiscoveryManager.this.proxyRegSet.clone();
            }
            for (int i = 0; i < set.size(); ++i) {
                ProxyReg reg = (ProxyReg)set.get(i);
                this.addProxyReg(reg);
            }
        }

        @Override
        public boolean isInitialized() {
            return this.initialized;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void terminate() {
            ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.lookupCacheClassLoader);
                Object object = this.serviceIdMap;
                synchronized (object) {
                    block21: {
                        if (!this.bCacheTerminated) break block21;
                        return;
                    }
                    this.bCacheTerminated = true;
                }
                object = ServiceDiscoveryManager.this.caches;
                synchronized (object) {
                    int index = ServiceDiscoveryManager.this.caches.indexOf(this);
                    if (index != -1) {
                        ServiceDiscoveryManager.this.caches.remove(index);
                    }
                }
                this.terminateTaskMgr(this.cacheTaskMgr);
                object = this.serviceDiscardMutex;
                synchronized (object) {
                    this.terminateTaskMgr(this.serviceDiscardTimerTaskMgr);
                }
                object = this.serviceIdMap;
                synchronized (object) {
                    Set set = this.eventRegMap.entrySet();
                    for (Map.Entry e : set) {
                        EventReg eReg = (EventReg)e.getValue();
                        ServiceDiscoveryManager.this.cancelLease(eReg.lease);
                    }
                }
                try {
                    this.lookupListenerExporter.unexport(true);
                }
                catch (IllegalStateException e) {
                    logger.log(Level.FINEST, "IllegalStateException occurred while unexporting the cache's remote event listener", e);
                }
                logger.finest("ServiceDiscoveryManager - LookupCache terminated");
            }
            finally {
                Thread.currentThread().setContextClassLoader(origClassLoader);
            }
        }

        @Override
        public ServiceItem lookup(ServiceItemFilter myFilter) {
            this.checkCacheTerminated();
            ServiceItem[] ret = this.getServiceItems(myFilter);
            if (ret.length == 0) {
                return null;
            }
            int rand = Math.abs(ServiceDiscoveryManager.this.random.nextInt() % ret.length);
            return ret[rand];
        }

        @Override
        public ServiceItem[] lookup(ServiceItemFilter myFilter, int maxMatches) {
            this.checkCacheTerminated();
            if (maxMatches < 1) {
                throw new IllegalArgumentException("maxMatches must be > 0");
            }
            ArrayList<ServiceItem> items = new ArrayList<ServiceItem>(1);
            ServiceItem[] sa = this.getServiceItems(myFilter);
            int len = sa.length;
            if (len == 0) {
                return new ServiceItem[0];
            }
            int rand = Math.abs(ServiceDiscoveryManager.this.random.nextInt() % len);
            for (int i = 0; i < len; ++i) {
                items.add(sa[(i + rand) % len]);
                if (items.size() == maxMatches) break;
            }
            ServiceItem[] ret = new ServiceItem[items.size()];
            items.toArray(ret);
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void discard(Object serviceReference) {
            this.checkCacheTerminated();
            boolean discardIt = false;
            Iterator iter = this.getServiceIdMapEntrySetIterator();
            while (iter.hasNext()) {
                ServiceItemReg itemReg;
                Map.Entry e = (Map.Entry)iter.next();
                ServiceItemReg serviceItemReg = itemReg = (ServiceItemReg)e.getValue();
                synchronized (serviceItemReg) {
                    if (itemReg.filteredItem.service.equals(serviceReference)) {
                        if (itemReg.isDiscarded()) {
                            return;
                        }
                        itemReg.setDiscarded(true);
                        discardIt = true;
                        break;
                    }
                }
            }
            if (discardIt) {
                DiscardServiceTask t = new DiscardServiceTask(this.lookupCacheClassLoader, serviceReference);
                this.cacheTaskMgr.add(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Iterator getServiceIdMapEntrySetIterator() {
            HashMap serviceIdMapCopy;
            HashMap hashMap = this.serviceIdMap;
            synchronized (hashMap) {
                serviceIdMapCopy = (HashMap)this.serviceIdMap.clone();
            }
            Set set = serviceIdMapCopy.entrySet();
            return set.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ServiceItem[] getServiceItems(ServiceItemFilter filter2) {
            ArrayList<ServiceItem> items = new ArrayList<ServiceItem>(1);
            Iterator iter = this.getServiceIdMapEntrySetIterator();
            while (iter.hasNext()) {
                ServiceItem itemToFilter;
                ServiceItemReg itemReg;
                Map.Entry e = (Map.Entry)iter.next();
                ServiceItemReg serviceItemReg = itemReg = (ServiceItemReg)e.getValue();
                synchronized (serviceItemReg) {
                    if (itemReg.isDiscarded() || itemReg.filteredItem == null) {
                        continue;
                    }
                    itemToFilter = new ServiceItem(itemReg.filteredItem.serviceID, itemReg.filteredItem.service, itemReg.filteredItem.attributeSets);
                }
                Object serviceToDiscard = itemToFilter.service;
                boolean pass = filter2 == null || filter2.check(itemToFilter);
                if (!pass) continue;
                if (itemToFilter.service != null) {
                    items.add(itemToFilter);
                    continue;
                }
                this.discard(serviceToDiscard);
            }
            ServiceItem[] ret = new ServiceItem[items.size()];
            items.toArray(ret);
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListener(ServiceDiscoveryListener listener) {
            this.checkCacheTerminated();
            if (listener == null) {
                throw new NullPointerException("can't add null listener");
            }
            ArrayList arrayList = this.sItemListeners;
            synchronized (arrayList) {
                this.sItemListeners.add(listener);
            }
            ServiceItem[] items = this.getServiceItems(null);
            for (int i = 0; i < items.length; ++i) {
                this.addServiceNotify(items[i], listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeListener(ServiceDiscoveryListener listener) {
            this.checkCacheTerminated();
            if (listener == null) {
                return;
            }
            ArrayList arrayList = this.sItemListeners;
            synchronized (arrayList) {
                int index = this.sItemListeners.indexOf(listener);
                if (index != -1) {
                    this.sItemListeners.remove(listener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addProxyReg(ProxyReg reg) {
            RegisterListenerTask treg;
            HashMap hashMap = this.serviceIdMap;
            synchronized (hashMap) {
                treg = new RegisterListenerTask(this.lookupCacheClassLoader, reg, this.taskSeqN++);
            }
            this.cacheTaskMgr.add(treg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeProxyReg(ProxyReg reg) {
            ProxyRegDropTask t;
            HashMap hashMap = this.serviceIdMap;
            synchronized (hashMap) {
                EventReg eReg = (EventReg)this.eventRegMap.get(reg);
                if (eReg != null) {
                    try {
                        ServiceDiscoveryManager.this.leaseRenewalMgr.remove(eReg.lease);
                    }
                    catch (Exception e) {
                        logger.log(Level.FINER, "exception occurred while removing an event registration lease", e);
                    }
                }
                t = new ProxyRegDropTask(this.lookupCacheClassLoader, reg, this.taskSeqN++);
            }
            this.removeUselessTask(reg);
            this.cacheTaskMgr.add(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkCacheTerminated() {
            ServiceDiscoveryManager.this.checkTerminated();
            HashMap hashMap = this.serviceIdMap;
            synchronized (hashMap) {
                if (this.bCacheTerminated) {
                    throw new IllegalStateException("this lookup cache was terminated");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyServiceMap(Object eventSource, long eventID, long seqNo, ServiceID sid, ServiceItem item, int transition) {
            if (eventSource == null) {
                return;
            }
            HashMap hashMap = this.serviceIdMap;
            synchronized (hashMap) {
                CacheTask t;
                ProxyReg reg = null;
                EventReg eReg = null;
                Set set = this.eventRegMap.entrySet();
                for (Map.Entry e : set) {
                    eReg = (EventReg)e.getValue();
                    if (!eventSource.equals(eReg.source) || eventID != eReg.eventID) continue;
                    reg = (ProxyReg)e.getKey();
                    break;
                }
                if (reg == null) {
                    return;
                }
                long prevSeqNo = eReg.seqNo;
                eReg.seqNo = seqNo;
                if (seqNo == prevSeqNo + 1L) {
                    t = new NotifyEventTask(this.lookupCacheClassLoader, reg, sid, item, transition, this.taskSeqN++);
                } else {
                    t = new LookupTask(this.lookupCacheClassLoader, reg, this.taskSeqN++);
                    if (logger.isLoggable(Levels.HANDLED)) {
                        String msg = "notifyServiceMap - GAP in event sequence [serviceRegistrar={0}], [serviceItem={1}, serviceID={2}], [eventSource={3}, eventID={4,number,#}, oldSeqN={5,number,#}, newSeqN={6,number,#}]";
                        Object[] params = new Object[]{reg == null ? null : reg.proxy, item.service, sid, eventSource, new Long(eventID), new Long(prevSeqNo), new Long(seqNo)};
                        logger.log(Levels.HANDLED, msg, params);
                    }
                }
                this.cacheTaskMgr.add(t);
            }
        }

        private void removeUselessTask(ProxyReg reg) {
            List<TaskManager.Task> pendingTasks = this.cacheTaskMgr.getPending();
            for (int i = 0; i < pendingTasks.size(); ++i) {
                CacheTask t = (CacheTask)pendingTasks.get(i);
                if (!t.isFromProxy(reg)) continue;
                this.cacheTaskMgr.remove(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void terminateTaskMgr(TaskManager taskMgr) {
            TaskManager taskManager = taskMgr;
            synchronized (taskManager) {
                List<TaskManager.Task> pendingTasks = taskMgr.getPending();
                for (int i = 0; i < pendingTasks.size(); ++i) {
                    taskMgr.remove(pendingTasks.get(i));
                }
                taskMgr.terminate();
            }
        }

        private void removeServiceIdMap(ServiceID sid, ServiceItem item) {
            this.removeServiceIdMapSendNoEvent(sid);
            this.removeServiceNotify(item);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeServiceIdMapSendNoEvent(ServiceID sid) {
            HashMap hashMap = this.serviceIdMap;
            synchronized (hashMap) {
                this.serviceIdMap.remove(sid);
            }
        }

        private ServiceItem findItem(ServiceID sid, ServiceItem[] items) {
            if (items != null) {
                for (int i = 0; i < items.length; ++i) {
                    if (!items[i].serviceID.equals((Object)sid)) continue;
                    return items[i];
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void itemMatchMatchChange(ServiceRegistrar proxy, ServiceItem newItem, ServiceItemReg itemReg, boolean matchMatchEvent) {
            ServiceItem newFilteredItem;
            ServiceItem oldFilteredItem;
            ServiceItem oldItem;
            ServiceItemReg serviceItemReg = itemReg;
            synchronized (serviceItemReg) {
                oldItem = itemReg.item;
                oldFilteredItem = itemReg.filteredItem;
                if (itemReg.isDiscarded()) {
                    itemReg.item = newItem;
                    itemReg.filteredItem = null;
                    return;
                }
                itemReg.addProxy(proxy);
            }
            boolean attrsChanged = false;
            boolean versionChanged = false;
            if (matchMatchEvent || this.sameVersion(newItem, oldItem)) {
                newItem.service = oldItem.service;
                boolean bl = attrsChanged = !LookupAttributes.equal(newItem.attributeSets, oldItem.attributeSets);
                if (!attrsChanged) {
                    return;
                }
            } else {
                versionChanged = true;
            }
            if ((newFilteredItem = this.filterMaybeDiscard(newItem, proxy, true)) != null) {
                if (attrsChanged) {
                    this.changeServiceNotify(newFilteredItem, oldFilteredItem);
                }
                if (versionChanged) {
                    this.removeServiceNotify(oldFilteredItem);
                    this.addServiceNotify(newFilteredItem);
                }
            }
        }

        private boolean sameVersion(ServiceItem item0, ServiceItem item1) {
            if (item0.service instanceof SameProxyVersionProvider && item1.service instanceof SameProxyVersionProvider) {
                Object version0 = ((SameProxyVersionProvider)item0.service).getVersion();
                Object version1 = ((SameProxyVersionProvider)item1.service).getVersion();
                if (version0 != null && version1 != null) {
                    return version0.equals(version1);
                }
            }
            boolean fullyEqual = false;
            try {
                MarshalledInstance mi0 = new MarshalledInstance(item0.service);
                MarshalledInstance mi1 = new MarshalledInstance(item1.service);
                fullyEqual = mi0.fullyEquals((Object)mi1);
            }
            catch (IOException e) {
                logger.log(Level.INFO, "failure marshalling old and new services for equality check", e);
            }
            return fullyEqual;
        }

        public long getLeaseDuration() {
            if (this.leaseDuration == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            return this.leaseDuration + this.startTime - SystemTime.timeMillis();
        }

        private void addServiceNotify(ServiceItem item) {
            this.serviceNotifyDo(null, item, 0);
        }

        private void addServiceNotify(ServiceItem item, ServiceDiscoveryListener srvcListener) {
            this.serviceNotifyDo(null, item, 0, srvcListener);
        }

        private void removeServiceNotify(ServiceItem item) {
            this.serviceNotifyDo(item, null, 2);
        }

        private void changeServiceNotify(ServiceItem newItem, ServiceItem oldItem) {
            this.serviceNotifyDo(oldItem, newItem, 3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void serviceNotifyDo(ServiceItem oldItem, ServiceItem item, int action) {
            ArrayList notifies;
            ArrayList arrayList = this.sItemListeners;
            synchronized (arrayList) {
                if (this.sItemListeners.isEmpty()) {
                    return;
                }
                notifies = (ArrayList)this.sItemListeners.clone();
            }
            for (ServiceDiscoveryListener sl : notifies) {
                this.serviceNotifyDo(oldItem, item, action, sl);
            }
        }

        private void serviceNotifyDo(ServiceItem oldItem, ServiceItem item, int action, ServiceDiscoveryListener sl) {
            ServiceDiscoveryEvent event = new ServiceDiscoveryEvent(this, oldItem, item);
            switch (action) {
                case 0: {
                    sl.serviceAdded(event);
                    break;
                }
                case 2: {
                    sl.serviceRemoved(event);
                    break;
                }
                case 3: {
                    sl.serviceChanged(event);
                }
            }
        }

        private void initCache() throws RemoteException {
            try {
                this.lookupListenerExporter = (Exporter)Config.getNonNullEntry((Configuration)ServiceDiscoveryManager.this.thisConfig, (String)ServiceDiscoveryManager.COMPONENT_NAME, (String)"eventListenerExporter", Exporter.class);
            }
            catch (ConfigurationException e) {
                ExportException e1 = new ExportException("Configuration exception while retrieving exporter for cache's remote event listener", (Exception)((Object)e));
                throw e1;
            }
            try {
                this.cacheTaskMgr = (TaskManager)ServiceDiscoveryManager.this.thisConfig.getEntry(ServiceDiscoveryManager.COMPONENT_NAME, "cacheTaskManager", TaskManager.class);
            }
            catch (ConfigurationException e) {
                this.cacheTaskMgr = new TaskManager(10, 15000L, 1.0f, "SDM Cache Task", 10);
            }
            try {
                this.serviceDiscardTimerTaskMgr = (TaskManager)ServiceDiscoveryManager.this.thisConfig.getEntry(ServiceDiscoveryManager.COMPONENT_NAME, "discardTaskManager", TaskManager.class);
            }
            catch (ConfigurationException e) {
                this.serviceDiscardTimerTaskMgr = new TaskManager(10, 15000L, 1.0f, "SDM Discard Task", 10);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ServiceItem filterMaybeDiscard(ServiceItem item, ServiceRegistrar proxy, boolean sendEvent) {
            if (item == null || item.service == null) {
                return null;
            }
            if (this.filter == null) {
                this.addFilteredItemToMap(item, item);
                return item;
            }
            ServiceItem filteredItem = new ServiceItem(item.serviceID, item.service, item.attributeSets);
            boolean pass = this.filter.check(filteredItem);
            if (!pass) {
                ServiceID srvcID = item.serviceID;
                ServiceItemReg itemReg = null;
                HashMap hashMap = this.serviceIdMap;
                synchronized (hashMap) {
                    itemReg = (ServiceItemReg)this.serviceIdMap.get(srvcID);
                }
                if (itemReg != null) {
                    if (sendEvent) {
                        ServiceItem oldFilteredItem;
                        ServiceItemReg serviceItemReg = itemReg;
                        synchronized (serviceItemReg) {
                            oldFilteredItem = itemReg.filteredItem;
                        }
                        this.removeServiceIdMap(srvcID, oldFilteredItem);
                    } else {
                        this.removeServiceIdMapSendNoEvent(srvcID);
                    }
                }
                return null;
            }
            if (filteredItem.service != null) {
                this.addFilteredItemToMap(item, filteredItem);
                return filteredItem;
            }
            this.discardRetryLater(item, proxy, sendEvent);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addFilteredItemToMap(ServiceItem item, ServiceItem filteredItem) {
            ServiceItemReg itemReg = null;
            Object object = this.serviceIdMap;
            synchronized (object) {
                itemReg = (ServiceItemReg)this.serviceIdMap.get(item.serviceID);
            }
            if (itemReg == null) {
                return;
            }
            object = itemReg;
            synchronized (object) {
                itemReg.item = item;
                itemReg.filteredItem = filteredItem;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void discardRetryLater(ServiceItem item, ServiceRegistrar proxy, boolean sendEvent) {
            ServiceItem oldFilteredItem;
            ServiceItemReg itemReg = null;
            HashMap hashMap = this.serviceIdMap;
            synchronized (hashMap) {
                itemReg = (ServiceItemReg)this.serviceIdMap.get(item.serviceID);
            }
            if (itemReg == null) {
                return;
            }
            ServiceItemReg serviceItemReg = itemReg;
            synchronized (serviceItemReg) {
                oldFilteredItem = itemReg.filteredItem;
                if (itemReg.item != item) {
                    itemReg.item = item;
                    itemReg.filteredItem = null;
                }
                itemReg.setDiscarded(true);
            }
            if (sendEvent) {
                this.removeServiceNotify(oldFilteredItem);
            }
            this.serviceDiscardTimerTaskMgr.add(new ServiceDiscardTimerTask(item.serviceID));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleMatchNoMatch(ServiceRegistrar proxy, ServiceID srvcID, ServiceItem item) {
            ServiceItemReg itemReg = null;
            HashMap hashMap = this.serviceIdMap;
            synchronized (hashMap) {
                itemReg = (ServiceItemReg)this.serviceIdMap.get(srvcID);
            }
            if (itemReg != null) {
                ServiceItem filteredItem;
                boolean itemRegIsDiscarded;
                boolean itemRegHasNoProxys;
                Object object = itemReg;
                synchronized (object) {
                    itemReg.removeProxy(proxy);
                    itemRegHasNoProxys = itemReg.hasNoProxys();
                    itemRegIsDiscarded = itemReg.isDiscarded();
                    filteredItem = itemReg.filteredItem;
                }
                if (itemRegHasNoProxys) {
                    if (itemRegIsDiscarded) {
                        this.removeServiceIdMapSendNoEvent(srvcID);
                        object = this.serviceDiscardMutex;
                        synchronized (object) {
                            this.serviceDiscardMutex.notifyAll();
                        }
                    } else {
                        this.removeServiceIdMap(srvcID, filteredItem);
                    }
                }
            }
        }

        private final class UnmapProxyTask
        extends ServiceIdTask {
            private final ServiceItemReg itemReg;
            private final long removeOrphanServicesDelayMilliseconds;

            public UnmapProxyTask(ClassLoader classLoader, ProxyReg reg, ServiceItemReg itemReg, ServiceID srvcId, long seqN, long removeOrphanServicesDelayMilliseconds) {
                super(classLoader, srvcId, reg, seqN);
                this.itemReg = itemReg;
                this.removeOrphanServicesDelayMilliseconds = removeOrphanServicesDelayMilliseconds;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runInternal() {
                logger.finest("ServiceDiscoveryManager - UnmapProxyTask started");
                ServiceItemReg serviceItemReg = this.itemReg;
                synchronized (serviceItemReg) {
                    this.itemReg.removeProxy(this.reg.proxy);
                }
                if (this.removeOrphanServicesDelayMilliseconds == 0L) {
                    LookupCacheImpl.this.removeOrphanService(this.thisTaskSid, this.itemReg);
                } else {
                    LookupCacheImpl.this.delayedRemoveOrphanServices(this.removeOrphanServicesDelayMilliseconds, TimeUnit.MILLISECONDS);
                }
                logger.finest("ServiceDiscoveryManager - UnmapProxyTask completed");
            }
        }

        private final class NewOldServiceTask
        extends ServiceIdTask {
            private final ServiceItem srvcItem;
            private final boolean matchMatchEvent;

            public NewOldServiceTask(ClassLoader classLoader, ProxyReg reg, ServiceItem item, boolean matchMatchEvent, long seqN) {
                super(classLoader, item.serviceID, reg, seqN);
                this.srvcItem = item;
                this.matchMatchEvent = matchMatchEvent;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runInternal() {
                ServiceItemReg itemReg;
                logger.finest("ServiceDiscoveryManager - NewOldServiceTask started");
                HashMap hashMap = LookupCacheImpl.this.serviceIdMap;
                synchronized (hashMap) {
                    itemReg = (ServiceItemReg)LookupCacheImpl.this.serviceIdMap.get(this.thisTaskSid);
                }
                if (itemReg != null) {
                    LookupCacheImpl.this.itemMatchMatchChange(this.reg.proxy, this.srvcItem, itemReg, this.matchMatchEvent);
                } else {
                    hashMap = LookupCacheImpl.this.serviceIdMap;
                    synchronized (hashMap) {
                        if (!LookupCacheImpl.this.eventRegMap.containsKey(this.reg)) {
                            logger.finest("ServiceDiscoveryManager - NewOldServiceTask completed");
                            return;
                        }
                        itemReg = new ServiceItemReg(this.reg.proxy, this.srvcItem);
                        LookupCacheImpl.this.serviceIdMap.put(this.thisTaskSid, itemReg);
                    }
                    ServiceItem newFilteredItem = LookupCacheImpl.this.filterMaybeDiscard(this.srvcItem, this.reg.proxy, false);
                    if (newFilteredItem != null) {
                        LookupCacheImpl.this.addServiceNotify(newFilteredItem);
                    }
                }
                logger.finest("ServiceDiscoveryManager - NewOldServiceTask completed");
            }
        }

        private final class ServiceDiscardTimerTask
        implements TaskManager.Task {
            private final ServiceID serviceID;

            public ServiceDiscardTimerTask(ServiceID serviceID) {
                this.serviceID = serviceID;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashMap hashMap;
                logger.finest("ServiceDiscoveryManager - ServiceDiscardTimerTask started");
                HashMap hashMap2 = LookupCacheImpl.this.serviceIdMap;
                synchronized (hashMap2) {
                    if (LookupCacheImpl.this.bCacheTerminated) {
                        return;
                    }
                }
                hashMap2 = LookupCacheImpl.this.serviceIdMap;
                synchronized (hashMap2) {
                    if (!LookupCacheImpl.this.serviceIdMap.containsKey(this.serviceID)) {
                        return;
                    }
                }
                long curDur = ServiceDiscoveryManager.this.discardWait;
                long endTime = curDur + SystemTime.timeMillis();
                Object object = LookupCacheImpl.this.serviceDiscardMutex;
                synchronized (object) {
                    while (curDur > 0L) {
                        try {
                            LookupCacheImpl.this.serviceDiscardMutex.wait(curDur);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        hashMap = LookupCacheImpl.this.serviceIdMap;
                        synchronized (hashMap) {
                            if (LookupCacheImpl.this.bCacheTerminated) {
                                return;
                            }
                        }
                        hashMap = LookupCacheImpl.this.serviceIdMap;
                        synchronized (hashMap) {
                            if (!LookupCacheImpl.this.serviceIdMap.containsKey(this.serviceID)) {
                                return;
                            }
                        }
                        curDur = endTime - SystemTime.timeMillis();
                    }
                }
                ServiceItemReg itemReg = null;
                hashMap = LookupCacheImpl.this.serviceIdMap;
                synchronized (hashMap) {
                    itemReg = (ServiceItemReg)LookupCacheImpl.this.serviceIdMap.get(this.serviceID);
                }
                if (itemReg != null) {
                    ServiceItem itemToSend;
                    ServiceItem item = null;
                    ServiceItem filteredItem = null;
                    ServiceItemReg serviceItemReg = itemReg;
                    synchronized (serviceItemReg) {
                        if (itemReg.filteredItem == null) {
                            item = new ServiceItem(itemReg.item.serviceID, itemReg.item.service, itemReg.item.attributeSets);
                            filteredItem = new ServiceItem(itemReg.item.serviceID, itemReg.item.service, itemReg.item.attributeSets);
                        }
                    }
                    if (filteredItem != null) {
                        if (ServiceDiscoveryManager.this.filterPassFail(filteredItem, LookupCacheImpl.this.filter)) {
                            LookupCacheImpl.this.addFilteredItemToMap(item, filteredItem);
                        } else {
                            LookupCacheImpl.this.removeServiceIdMapSendNoEvent(this.serviceID);
                            return;
                        }
                    }
                    ServiceItemReg serviceItemReg2 = itemReg;
                    synchronized (serviceItemReg2) {
                        itemReg.setDiscarded(false);
                        itemToSend = itemReg.filteredItem;
                    }
                    LookupCacheImpl.this.addServiceNotify(itemToSend);
                }
                logger.finest("ServiceDiscoveryManager - ServiceDiscardTimerTask completed");
            }

            @Override
            public boolean runAfter(List tasks, int size) {
                return false;
            }
        }

        private final class NotifyEventTask
        extends ServiceIdTask {
            private final ServiceID sid;
            private final ServiceItem item;
            private final int transition;

            public NotifyEventTask(ClassLoader classLoader, ProxyReg reg, ServiceID sid, ServiceItem item, int transition, long seqN) {
                super(classLoader, sid, reg, seqN);
                this.sid = sid;
                this.item = item;
                this.transition = transition;
            }

            @Override
            public void runInternal() {
                logger.finest("ServiceDiscoveryManager - NotifyEventTask started");
                if (this.item != null && this.item.service == null) {
                    return;
                }
                if (this.transition == 1) {
                    LookupCacheImpl.this.handleMatchNoMatch(this.reg.proxy, this.sid, this.item);
                } else {
                    new NewOldServiceTask(LookupCacheImpl.this.lookupCacheClassLoader, this.reg, this.item, this.transition == 4, this.thisTaskSeqN).run();
                }
                logger.finest("ServiceDiscoveryManager - NotifyEventTask completed");
            }

            @Override
            public boolean runAfter(List tasks, int size) {
                for (int i = 0; i < size; ++i) {
                    ProxyReg otherReg;
                    CacheTask t = (CacheTask)tasks.get(i);
                    if (!(t instanceof RegisterListenerTask) && !(t instanceof LookupTask) || !this.reg.equals(otherReg = t.getProxyReg()) || this.thisTaskSeqN <= t.getSeqN()) continue;
                    return true;
                }
                return super.runAfter(tasks, size);
            }
        }

        private final class DiscardServiceTask
        extends CacheTask {
            private final Object service;

            public DiscardServiceTask(ClassLoader classLoader, Object service) {
                super(classLoader, null, 0L);
                this.service = service;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runInternal() {
                logger.finest("ServiceDiscoveryManager - DiscardServiceTask started");
                Iterator iter = LookupCacheImpl.this.getServiceIdMapEntrySetIterator();
                while (iter.hasNext()) {
                    ServiceItem item;
                    ServiceItemReg itemReg;
                    Map.Entry e = (Map.Entry)iter.next();
                    ServiceItemReg serviceItemReg = itemReg = (ServiceItemReg)e.getValue();
                    synchronized (serviceItemReg) {
                        item = itemReg.filteredItem;
                    }
                    if (!item.service.equals(this.service)) continue;
                    ServiceID sid = (ServiceID)e.getKey();
                    LookupCacheImpl.this.removeServiceNotify(item);
                    LookupCacheImpl.this.serviceDiscardTimerTaskMgr.add(new ServiceDiscardTimerTask(sid));
                    return;
                }
                logger.finest("ServiceDiscoveryManager - DiscardServiceTask completed");
            }
        }

        private final class RemoveOrphanServicesTask
        extends CacheTask {
            public RemoveOrphanServicesTask(ClassLoader classLoader, long seqN) {
                super(classLoader, null, seqN);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runInternal() {
                HashMap copyServiceIdMap;
                logger.finest("ServiceDiscoveryManager - RemoveOrphanServicesTask started");
                try {
                    this.sleepUntilWakeupTimestamp();
                }
                catch (InterruptedException e) {
                    logger.log(Level.INFO, "ServiceDiscoveryManager - RemoveOrphanServicesTask  interrupted", e);
                    return;
                }
                logger.finest("ServiceDiscoveryManager - RemoveOrphanServicesTask woke up");
                HashMap hashMap = LookupCacheImpl.this.serviceIdMap;
                synchronized (hashMap) {
                    copyServiceIdMap = new HashMap(LookupCacheImpl.this.serviceIdMap);
                }
                for (Map.Entry entry : copyServiceIdMap.entrySet()) {
                    ServiceID serviceId = (ServiceID)entry.getKey();
                    ServiceItemReg itemReg = (ServiceItemReg)entry.getValue();
                    LookupCacheImpl.this.removeOrphanService(serviceId, itemReg);
                }
                logger.finest("ServiceDiscoveryManager - RemoveOrphanServicesTask completed");
            }

            private void sleepUntilWakeupTimestamp() throws InterruptedException {
                long sleepFor = this.calcSleepDuration();
                while (sleepFor > 0L) {
                    Thread.sleep(sleepFor);
                    sleepFor = this.calcSleepDuration();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private long calcSleepDuration() {
                long sleepFor = 0L;
                Object object = LookupCacheImpl.this.RemoveOrphanServicesTaskWakeupTimestampLock;
                synchronized (object) {
                    sleepFor = LookupCacheImpl.this.RemoveOrphanServicesTaskWakeupTimestamp - SystemTime.timeMillis();
                }
                return sleepFor;
            }

            public boolean equals(Object other) {
                return other instanceof RemoveOrphanServicesTask;
            }

            public int hashCode() {
                return this.getClass().hashCode();
            }
        }

        private final class ProxyRegDropTask
        extends CacheTask {
            public ProxyRegDropTask(ClassLoader classLoader, ProxyReg reg, long seqN) {
                super(classLoader, reg, seqN);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runInternal() {
                logger.finest("ServiceDiscoveryManager - ProxyRegDropTask started");
                HashMap hashMap = LookupCacheImpl.this.serviceIdMap;
                synchronized (hashMap) {
                    if (LookupCacheImpl.this.eventRegMap.containsKey(this.reg)) {
                        LookupCacheImpl.this.eventRegMap.remove(this.reg);
                    }
                }
                hashMap = LookupCacheImpl.this.serviceIdMap;
                synchronized (hashMap) {
                    for (Map.Entry e : LookupCacheImpl.this.serviceIdMap.entrySet()) {
                        ServiceID srvcID = (ServiceID)e.getKey();
                        ServiceItemReg itemReg = (ServiceItemReg)e.getValue();
                        long removeOrphanServicesDelayMilliseconds = this.isLookupService(itemReg) ? 0L : ServiceDiscoveryManager.this.removeOrphanServicesDelay;
                        UnmapProxyTask t = new UnmapProxyTask(LookupCacheImpl.this.lookupCacheClassLoader, this.reg, itemReg, srvcID, LookupCacheImpl.this.taskSeqN++, removeOrphanServicesDelayMilliseconds);
                        LookupCacheImpl.this.cacheTaskMgr.add(t);
                    }
                }
                logger.finest("ServiceDiscoveryManager - ProxyRegDropTask completed");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean isLookupService(ServiceItemReg itemReg) {
                boolean isLookupService = false;
                ServiceItemReg serviceItemReg = itemReg;
                synchronized (serviceItemReg) {
                    if (itemReg.item.getService() instanceof ServiceRegistrar) {
                        isLookupService = true;
                    }
                }
                return isLookupService;
            }
        }

        private final class LookupTask
        extends CacheTask {
            private final ServiceMatchesMerger matchesMerger;

            public LookupTask(ClassLoader classLoader, ProxyReg reg, long seqN) {
                this(classLoader, reg, seqN, null);
            }

            public LookupTask(ClassLoader classLoader, ProxyReg reg, long seqN, ServiceMatches matches) {
                super(classLoader, reg, seqN);
                this.matchesMerger = new ServiceMatchesMerger();
                this.matchesMerger.addServiceItems(matches);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runInternal() {
                logger.finest("ServiceDiscoveryManager - LookupTask started");
                ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
                ServiceRegistrar proxy = this.reg.proxy;
                ServiceMatches matches = null;
                try {
                    matches = proxy.lookup(LookupCacheImpl.this.tmpl, Integer.MAX_VALUE);
                }
                catch (Exception e) {
                    boolean cacheTerminated;
                    HashMap hashMap = LookupCacheImpl.this.serviceIdMap;
                    synchronized (hashMap) {
                        cacheTerminated = LookupCacheImpl.this.bCacheTerminated;
                    }
                    ServiceDiscoveryManager.this.fail(e, proxy, this.getClass().getName(), "run", "Exception occurred during call to lookup", cacheTerminated);
                    return;
                }
                if (matches.items == null) {
                    throw new AssertionError((Object)"spec violation in queried lookup service: ServicesMatches instance returned by call to lookup() method contains null 'items' field");
                }
                this.matchesMerger.addServiceItems(matches);
                ServiceMatches serviceMatches = this.matchesMerger.getServiceMatches();
                HashMap hashMap = LookupCacheImpl.this.serviceIdMap;
                synchronized (hashMap) {
                    for (Map.Entry e : LookupCacheImpl.this.serviceIdMap.entrySet()) {
                        ServiceID srvcID = (ServiceID)e.getKey();
                        ServiceItem itemInSnapshot = LookupCacheImpl.this.findItem(srvcID, serviceMatches.items);
                        if (itemInSnapshot != null) continue;
                        ServiceItemReg itemReg = (ServiceItemReg)e.getValue();
                        UnmapProxyTask t = new UnmapProxyTask(LookupCacheImpl.this.lookupCacheClassLoader, this.reg, itemReg, srvcID, LookupCacheImpl.this.taskSeqN++, 0L);
                        LookupCacheImpl.this.cacheTaskMgr.add(t);
                    }
                    for (int i = 0; i < serviceMatches.items.length; ++i) {
                        if (serviceMatches.items[i].service == null) continue;
                        NewOldServiceTask t = new NewOldServiceTask(LookupCacheImpl.this.lookupCacheClassLoader, this.reg, serviceMatches.items[i], false, LookupCacheImpl.this.taskSeqN++);
                        LookupCacheImpl.this.cacheTaskMgr.add(t);
                    }
                }
                logger.finest("ServiceDiscoveryManager - LookupTask completed");
            }

            @Override
            public boolean runAfter(List tasks, int size) {
                for (int i = 0; i < size; ++i) {
                    ProxyReg otherReg;
                    CacheTask t = (CacheTask)tasks.get(i);
                    if (!(t instanceof RegisterListenerTask) && !(t instanceof LookupTask) && !(t instanceof NotifyEventTask) || !this.reg.equals(otherReg = t.getProxyReg()) || this.thisTaskSeqN <= t.getSeqN()) continue;
                    return true;
                }
                return super.runAfter(tasks, size);
            }
        }

        private final class RegisterListenerTask
        extends CacheTask {
            public RegisterListenerTask(ClassLoader classLoader, ProxyReg reg, long seqN) {
                super(classLoader, reg, seqN);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runInternal() {
                logger.finest("ServiceDiscoveryManager - RegisterListenerTask started");
                long duration = LookupCacheImpl.this.getLeaseDuration();
                if (duration < 0L) {
                    return;
                }
                try {
                    EventReg eventReg = ServiceDiscoveryManager.this.registerListener(this.reg.proxy, LookupCacheImpl.this.tmpl, LookupCacheImpl.this.lookupListenerProxy, duration);
                    HashMap hashMap = LookupCacheImpl.this.serviceIdMap;
                    synchronized (hashMap) {
                        if (LookupCacheImpl.this.bCacheTerminated) {
                            ServiceDiscoveryManager.this.cancelLease(eventReg.lease);
                        } else {
                            LookupCacheImpl.this.eventRegMap.put(this.reg, eventReg);
                        }
                    }
                    new LookupTask(LookupCacheImpl.this.lookupCacheClassLoader, this.reg, this.getSeqN(), eventReg.mathces).run();
                    LookupCacheImpl.this.initialized = true;
                }
                catch (Exception e) {
                    boolean cacheTerminated;
                    HashMap hashMap = LookupCacheImpl.this.serviceIdMap;
                    synchronized (hashMap) {
                        cacheTerminated = LookupCacheImpl.this.bCacheTerminated;
                    }
                    ServiceDiscoveryManager.this.fail(e, this.reg.proxy, this.getClass().getName(), "run", "Exception occurred while attempting to register with the lookup service event mechanism", cacheTerminated);
                }
                logger.finest("ServiceDiscoveryManager - RegisterListenerTask completed");
            }
        }

        private final class LookupListener
        implements RemoteEventListener,
        ServerProxyTrust {
            public LookupListener() throws ExportException {
                LookupCacheImpl.this.lookupListenerProxy = (RemoteEventListener)LookupCacheImpl.this.lookupListenerExporter.export((Remote)((Object)this));
            }

            public void notify(RemoteEvent evt) {
                ServiceEvent theEvent = (ServiceEvent)evt;
                LookupCacheImpl.this.notifyServiceMap(theEvent.getSource(), theEvent.getID(), theEvent.getSequenceNumber(), theEvent.getServiceID(), theEvent.getServiceItem(), theEvent.getTransition());
            }

            public TrustVerifier getProxyVerifier() {
                return new BasicProxyTrustVerifier(LookupCacheImpl.this.lookupListenerProxy);
            }
        }
    }

    private final class LeaseListenerImpl
    implements LeaseListener {
        private final ServiceRegistrar proxy;

        public LeaseListenerImpl(ServiceRegistrar proxy) {
            this.proxy = proxy;
        }

        @Override
        public void notify(LeaseRenewalEvent e) {
            ServiceDiscoveryManager.this.fail(e.getException(), this.proxy, this.getClass().getName(), "notify", "failure occurred while renewing an event lease", false);
        }
    }

    private static final class ProxyReg {
        public ServiceRegistrar proxy;

        public ProxyReg(ServiceRegistrar proxy) {
            if (proxy == null) {
                throw new IllegalArgumentException("proxy cannot be null");
            }
            this.proxy = proxy;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProxyReg) {
                return this.proxy.equals(((ProxyReg)obj).proxy);
            }
            return false;
        }

        public int hashCode() {
            return this.proxy.hashCode();
        }
    }

    private static final class ServiceItemReg {
        private final ArrayList proxys = new ArrayList(1);
        private boolean bDiscarded = false;
        public ServiceItem item;
        public ServiceItem filteredItem;

        public ServiceItemReg(ServiceRegistrar proxy, ServiceItem item) {
            this.addProxy(proxy);
            this.item = item;
        }

        public void addProxy(ServiceRegistrar proxy) {
            if (!this.proxys.contains(proxy)) {
                this.proxys.add(proxy);
            }
        }

        public void removeProxy(ServiceRegistrar proxy) {
            int index = this.proxys.indexOf(proxy);
            if (index != -1) {
                this.proxys.remove(index);
            }
        }

        public boolean hasNoProxys() {
            return this.proxys.isEmpty();
        }

        public void setDiscarded(boolean b) {
            this.bDiscarded = b;
        }

        public boolean isDiscarded() {
            return this.bDiscarded;
        }
    }

    private static final class EventReg {
        Object source;
        public long eventID;
        public long seqNo;
        public Lease lease;
        public ServiceMatches mathces;

        public EventReg(Object source, long eventID, long seqNo, Lease lease, ServiceMatches matches) {
            this.source = source;
            this.eventID = eventID;
            this.seqNo = seqNo;
            this.lease = lease;
            this.mathces = matches;
        }
    }

    private static final class ServiceDiscoveryListenerImpl
    implements ServiceDiscoveryListener {
        ArrayList items = new ArrayList(1);

        private ServiceDiscoveryListenerImpl() {
        }

        @Override
        public synchronized void serviceAdded(ServiceDiscoveryEvent event) {
            this.items.add(event.getPostEventServiceItem());
            this.notifyAll();
        }

        @Override
        public void serviceRemoved(ServiceDiscoveryEvent event) {
        }

        @Override
        public void serviceChanged(ServiceDiscoveryEvent event) {
        }

        public synchronized ServiceItem[] getServiceItem() {
            ServiceItem[] r = new ServiceItem[this.items.size()];
            this.items.toArray(r);
            this.items.clear();
            return r;
        }
    }

    private static abstract class ServiceIdTask
    extends CacheTask {
        protected ServiceID thisTaskSid;

        ServiceIdTask(ClassLoader classLoader, ServiceID srvcId, ProxyReg reg, long seqN) {
            super(classLoader, reg, seqN);
            this.thisTaskSid = srvcId;
        }

        @Override
        public boolean runAfter(List tasks, int size) {
            for (int i = 0; i < size; ++i) {
                ServiceID otherTaskSid;
                TaskManager.Task t = (TaskManager.Task)tasks.get(i);
                if (!(t instanceof ServiceIdTask) || !this.thisTaskSid.equals((Object)(otherTaskSid = ((ServiceIdTask)t).getServiceID())) || this.thisTaskSeqN <= ((ServiceIdTask)t).getSeqN()) continue;
                return true;
            }
            return false;
        }

        public ServiceID getServiceID() {
            return this.thisTaskSid;
        }
    }

    private static abstract class CacheTask
    implements TaskManager.Task {
        private final ClassLoader classLoader;
        protected ProxyReg reg;
        protected long thisTaskSeqN;

        public CacheTask(ClassLoader classLoader, ProxyReg reg, long seqN) {
            this.classLoader = classLoader;
            this.reg = reg;
            this.thisTaskSeqN = seqN;
        }

        public boolean isFromProxy(ProxyReg reg) {
            if (this.reg == null) {
                return false;
            }
            return this.reg.equals(reg);
        }

        @Override
        public boolean runAfter(List tasks, int size) {
            return false;
        }

        public ProxyReg getProxyReg() {
            return this.reg;
        }

        public long getSeqN() {
            return this.thisTaskSeqN;
        }

        @Override
        public void run() {
            ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                this.runInternal();
            }
            finally {
                Thread.currentThread().setContextClassLoader(origClassLoader);
            }
        }

        public abstract void runInternal();
    }
}

