/*
 * Decompiled with CFR 0.152.
 */
package net.jini.lookup.entry;

import com.gigaspaces.api.InternalApi;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jini.entry.AbstractEntry;
import net.jini.lookup.entry.ServiceControlled;

@InternalApi
public class ServiceInfo
extends AbstractEntry
implements ServiceControlled,
Externalizable {
    private static final long serialVersionUID = -1116664185758541509L;
    public String name;
    public String manufacturer;
    public String vendor;
    public String version;
    public String model;
    public String serialNumber;

    public ServiceInfo() {
    }

    public ServiceInfo(String name, String manufacturer, String vendor, String version, String model, String serialNumber) {
        this.name = name;
        this.manufacturer = manufacturer;
        this.vendor = vendor;
        this.version = version;
        this.model = model;
        this.serialNumber = serialNumber;
    }

    private byte buildFlags() {
        byte flags = 0;
        if (this.name != null) {
            flags = (byte)(flags | 1);
        }
        if (this.manufacturer != null) {
            flags = (byte)(flags | 2);
        }
        if (this.vendor != null) {
            flags = (byte)(flags | 4);
        }
        if (this.version != null) {
            flags = (byte)(flags | 8);
        }
        if (this.model != null) {
            flags = (byte)(flags | 0x10);
        }
        if (this.serialNumber != null) {
            flags = (byte)(flags | 0x20);
        }
        return flags;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte flags = this.buildFlags();
        out.writeByte(flags);
        if (flags == 0) {
            return;
        }
        if (this.name != null) {
            out.writeUTF(this.name);
        }
        if (this.manufacturer != null) {
            out.writeUTF(this.manufacturer);
        }
        if (this.vendor != null) {
            out.writeUTF(this.vendor);
        }
        if (this.version != null) {
            out.writeUTF(this.version);
        }
        if (this.model != null) {
            out.writeUTF(this.model);
        }
        if (this.serialNumber != null) {
            out.writeUTF(this.serialNumber);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte flags = in.readByte();
        if (flags == 0) {
            return;
        }
        if ((flags & 1) != 0) {
            this.name = in.readUTF();
        }
        if ((flags & 2) != 0) {
            this.manufacturer = in.readUTF();
        }
        if ((flags & 4) != 0) {
            this.vendor = in.readUTF();
        }
        if ((flags & 8) != 0) {
            this.version = in.readUTF();
        }
        if ((flags & 0x10) != 0) {
            this.model = in.readUTF();
        }
        if ((flags & 0x20) != 0) {
            this.serialNumber = in.readUTF();
        }
    }

    private static interface BitMap {
        public static final byte NAME = 1;
        public static final byte MANUFACTURER = 2;
        public static final byte VENDOR = 4;
        public static final byte VERSION = 8;
        public static final byte MODEL = 16;
        public static final byte SERIAL_NUMBER = 32;
    }
}

