/*
 * Decompiled with CFR 0.152.
 */
package org.jini.rio.core;

import com.gigaspaces.api.InternalApi;
import java.io.Serializable;

@InternalApi
public class ThresholdValues
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private double highThreshold = Double.NaN;
    private double lowThreshold = Double.NaN;
    private double currentHighThreshold = Double.NaN;
    private double currentLowThreshold = Double.NaN;
    private long breachedCount = 0L;
    private long clearedCount = 0L;

    public ThresholdValues() {
    }

    public ThresholdValues(double[] range) {
        if (range.length != 2) {
            throw new IllegalArgumentException("range must be 2 elements");
        }
        if (range[0] >= range[1]) {
            throw new IllegalArgumentException("range is not valid");
        }
        this.currentLowThreshold = this.lowThreshold = range[0];
        this.currentHighThreshold = this.highThreshold = range[1];
    }

    public ThresholdValues(double lowThreshold, double highThreshold) {
        this.lowThreshold = lowThreshold;
        this.currentLowThreshold = lowThreshold;
        this.highThreshold = highThreshold;
        this.currentHighThreshold = highThreshold;
    }

    public double getHighThreshold() {
        return this.highThreshold;
    }

    public double getLowThreshold() {
        return this.lowThreshold;
    }

    public double getCurrentHighThreshold() {
        return this.currentHighThreshold;
    }

    public void setCurrentHighThreshold(double threshold) {
        this.currentHighThreshold = threshold;
    }

    public double getCurrentLowThreshold() {
        return this.currentLowThreshold;
    }

    public void setCurrentLowThreshold(double threshold) {
        this.currentLowThreshold = threshold;
    }

    public void resetLowThreshold() {
        this.currentLowThreshold = this.lowThreshold;
    }

    public void resetHighThreshold() {
        this.currentHighThreshold = this.highThreshold;
    }

    public void incThresholdBreachedCount() {
        ++this.breachedCount;
    }

    public long getThresholdBreachedCount() {
        return this.breachedCount;
    }

    public void incThresholdClearedCount() {
        ++this.clearedCount;
    }

    public long getThresholdClearedCount() {
        return this.clearedCount;
    }

    public String toString() {
        return "low: " + this.lowThreshold + ", high: " + this.highThreshold;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException shouldNotHappen) {
            shouldNotHappen.printStackTrace();
            return null;
        }
    }
}

