# HelloWorld Example

A Processing Unit is a scalable unit of deployment. In this example,
we show how to create and run inside your development environment and 
how to use the XAP basic API, by implementing a simple processor and 
feeder application.

## COMPONENTS

There are three components in our scenario:

- Message Object - a simple POJO with an 'id' and info attributes.

- Processor Processing Unit - Processes Message objects as they are 
  written to the data-grid. It contains a Polling Container component 
  that listens to new Message objects written to the data-grid, and a 
  Processor Bean that is delegated the actual processing work by the 
  Polling Container.

- Feeder - an application that feeds unprocessed Message objects to the 
  data-grid, and after a certain period of time, counts and reads one of
  them at random.


## WORKFLOW

- The feeder application writes 1000 Message objects (POJOs) to the space 
  and waits.

- Inside the Processor Processing Unit, the Polling Container continuously 
  removes unprocessed objects from the data-grid (one at a time) and hands 
  them to its Processor Bean for processing.

- After each Message object has been processed, the Polling Container writes 
  it back to the Space. Steps 2 & 3 repeat, until there are no more unprocessed 
  Message objects left to process in the Space.

- The feeder counts all the processed Message objects inside the data-grid,
  and reads one of them at random. The example waits 5 seconds before counting 
  the processed objects to allow Message objects to be processed.

## BUILD AND DEPLOYMENT

The example uses maven as its build tool. It comes with a build script that 
runs maven automatically. Running the build script with no parameters within 
the current directory will list all the relevant tasks that can be run with 
this example.

The available commands are:

- clean            - Cleans all output dirs
- compile          - Builds all (don't create JARs)
- package          - Builds the distribution
- deploy-processor - Deploys the processor onto the service grid
- run-feeder       - Starts the feeder
- intellij         - Creates run configuration for IntelliJ IDE


Running `build.(sh/bat) compile` will compile all the different modules. 
In case of the Processor and Feeder modules, it will compile the classes
directly into their respective PU structure.

Running `build.(sh/bat) package` will finalize the processing unit structure 
of both the Processor and the Feeder. The Common module jar file will be 
copied into the 'lib' directory within the processing unit structure. In 
case of the processor module,  it will copy the jar file to 
`/examples/first-app/hello-world/processor/target/hello-processor/lib/`, 
and will make `/examples/first-app/hello-world/processor/target/hello-processor` 
a ready to use processing unit.

Running `build.(sh/bat) intellij` will create run configuration for IntelliJ 
IDE, allowing you to run the Processor and the Feeder using IntelliJ run 
(or debug) targets (to run from intellij the mvn profile IDE should be on).

In order to deploy the hello world example onto the Service Grid:

- run XAP agent with manager `$XAP_HOME/bin/xap host run-agent --auto --gsc=2` which will start a Manager, 2 GSCs and GS-WEBUI
  
- run `build.(sh/bat) deploy-processor`. This will deploy the 
  `/examples/first-app/hello-world/processor/target/hello-processor.jar` 
  into the running GSM.
  
- run the command `build.(sh/bat) run-feeder` to start feeding unprocessed 
  Message objects into data-grid.

Look at the GS-WEBUI in order to see the PU instance deployed and track the number 
of messages in the data-grid.
