# Web Example

This example demonstrates how to deploy a simple web application.

The application is composed of a very simple JSP page, which greets the 
user and prints the time, the hostname of the container that served the 
request and some additional details.


## BUILD

The example uses maven as its build tool. It comes with a build script 
that runs maven automatically. Running the build script with no parameters 
within the current directory will list all the relevant tasks that can be 
run with this example.

The available commands are:

- clean    - Cleans all output dirs
- compile  - Builds all (don't create WAR file)
- package  - Builds the distribution
- deploy   - Deploys the web app on the service grid
- undeploy - Undeploys the web app from the service grid

-  Running 'build.(sh/bat) package' will finalize the processing unit structure 
under `/examples/web-app/web-plain/target/PlainWebAppExample/` and create 
a deployment WAR `/examples/web-app/web-plain/target/PlainWebAppExample.war`.

- `/examples/web-app/web-plain/target/PlainWebAppExample/` contains the 
  `hello.jsp`

- `/examples/web-app/web-plain/target/PlainWebAppExample/META-INF/spring/` 
  contains `pu.properties` for the server configuration and `sla.xml` 
  contains the deployment properties (number of instances and constraints)

- `/examples/web-app/web-plain/target/PlainWebAppExample/WEB-INF/` contains 
  the `web.xml` referencing the `hello.jsp`


##  DEPLOYMENT

In order to deploy the web example onto the Service Grid:

- run XAP agent with manager `$XAP_HOME/bin/xap host run-agent --auto --gsc=2` which will start a Manager, 2 GSCs and GS-WEBUI
  
- run `build.(sh/bat) deploy`. This will deploy the 
  `/examples/web-app/web-plain/target/PlainWebAppExample.war` into the 
  running GSM.

- The web page of this application is available at `http://<host IP>:<web port>/PlainWebAppExample/`
  for example ([http://localhost:8181/PlainWebAppExample/](http://localhost:8181/PlainWebAppExample/))
