#!/usr/bin/env bash

DIR_NAME=$(dirname ${BASH_SOURCE[0]})
. $DIR_NAME/../../../bin/setenv.sh

if [ -z "$1" ] || ([ $1 != "clean" ] && [ $1 != "compile" ] && [ $1 != "package" ] && [ $1 != "deploy" ] && [ $1 != "undeploy" ]); then
  echo ""
  echo "Error: Invalid input command $1 "
  echo ""
  echo "The available commands are:"
  echo ""
  echo "clean                    --> Cleans all output dirs"
  echo "compile                  --> Builds all; don't create WAR file"
  echo "package                  --> Builds the distribution"
  echo "deploy                   --> Deploys the web app on the service grid"
  echo "undeploy                 --> Undeploys the web app from the service grid"
  echo ""

elif [ $1 = "clean" ]; then
  (cd $DIR_NAME;
  mvn clean; )

elif [ $1 = "compile" ]; then
  (cd $DIR_NAME;
  mvn compile; )

elif [ $1 = "package" ]; then
  (cd $DIR_NAME;
  mvn --batch-mode package; )

elif [ $1 = "deploy" ]; then
  ${XAP_HOME}/bin/xap pu deploy PlainWebAppExample $DIR_NAME/target/PlainWebAppExample.war

elif [ $1 = "undeploy" ]; then
  ${XAP_HOME}/bin/xap pu undeploy PlainWebAppExample

fi