# Web Example

This example demonstrates how to deploy a web application accessing a single 
Space data-grid.

The `AccessSpaceServlet` is responsible for retrieving request parameters, 
creating an instance of type `UserData` and writing it to the space. 

The `SpaceContents.jsp` displays the contents of all the `UserData` instances 
stored in the Space, and renders two input fields, `Name` and `Value` for 
the user to input new values.


## BUILD

The example uses maven as its build tool. It comes with a build script that 
runs maven automatically. Running the build script with no parameters within 
the current directory will list all the relevant tasks that can be run with 
this example.

The available commands are:

- clean    - Cleans all output dirs
- compile  - Builds all (don't create WAR file)
- package  - Builds the distribution
- deploy   - Deploys the web app on the service grid
- undeploy - Undeploys the web app from the service grid

- Running `build.(sh/bat) package` will finalize the processing unit structure 
  under `/examples/web-app/web-space-access/target/SpaceAccess` and create 
  a deployment WAR `/examples/web-app/web-space-access/target/SpaceAccess.war`.

- `/examples/web-app/web-space-access/target/SpaceAccess/` contains the 
  `SpaceContents.jsp`

- `/examples/web-app/web-space-access/target/SpaceAccess/spring/` contains 
  `pu.properties` and `pu.xml` for the session configuration and `sla.xml` 
  contains the deployment properties (number of instances and constraints)

- `/examples/web-app/web-space-access/target/SpaceAccess/WEB-INF/` contains 
  the `web.xml` referencing the servlet class


## DEPLOYMENT

In order to deploy the web example onto the Service Grid:

- run XAP agent with manager `$XAP_HOME/bin/xap host run-agent --auto --gsc=3` which will start a Manager, 3 GSCs and GS-WEBUI

- run `build.(sh/bat) deploy`. This will deploy the 
  `/examples/web-app/web-space-access/target/SpaceAccess.war` into the 
  running GSM.

- The web page of this application is available at `http://<host IP>:<web port>/SpaceAccess/`
  for example ([http://localhost:8180/SpaceAccess/](http://localhost:8180/SpaceAccess/), [http://localhost:8181/SpaceAccess/](http://localhost:8181/SpaceAccess/) and [http://localhost:8182/SpaceAccess/](http://localhost:8182/SpaceAccess/))
