#!/usr/bin/env bash

. ./setExampleEnv.sh

# Remove class files to ensure recompilations
if [ -d ${TARGET} ]
then
    rm -rf ${TARGET}
fi

# Create the classes dir if it doesn't exist
if [ ! -d ${TARGET} ]
then
    mkdir ${TARGET}
fi

if [ -z "${JAVA_HOME}" ]; then
	JAVACCMD=javac
else
	JAVACCMD="${JAVA_HOME}/bin/javac"
fi

SOURCE=${XAP_HOME}/tools/benchmark/src/main/java
TARGET=${XAP_HOME}/tools/benchmark/classes
JARS="${TARGET}:${XAP_HOME}/lib/required/*:${XAP_HOME}/lib/platform/benchmark/*:${XAP_HOME}/lib/platform/poi/*:${XAP_HOME}/lib/optional/jms/*:${XAP_HOME}/lib/optional/metrics/*:${XAP_HOME}/lib/optional/map/xap-map.jar"
${JAVACCMD} -classpath ${JARS} -d ${TARGET} ${SOURCE}/com/j_spaces/examples/benchmark/*.java ${SOURCE}/com/j_spaces/examples/benchmark/messages/*.java
