package com.j_spaces.examples.benchmark;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.sql.Time;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;

import com.gigaspaces.internal.client.spaceproxy.AbstractSpaceProxy;
import com.gigaspaces.internal.lookup.SpaceUrlUtils;
import com.j_spaces.core.client.*;

import net.jini.core.entry.UnusableEntryException;
import net.jini.core.lease.Lease;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.server.TransactionManager;

import com.gigaspaces.client.transaction.DistributedTransactionManagerProvider;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceConfig;
import com.j_spaces.core.admin.SpaceRuntimeInfo;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.kernel.JSpaceUtilities;
import com.gigaspaces.internal.version.PlatformVersion;
import com.j_spaces.map.CacheFinder;
import com.j_spaces.map.GSMapImpl;
import com.j_spaces.map.IMap;

/**
 * This is the <code>BenchmarkCommand</code> example for performance tests.
 */
public class BenchmarkCommand implements com.j_spaces.examples.benchmark.ICommand {
    // The key arguments
    private static final String KEY_HELP = "h"; // help

    private static final String KEY_CLEAN = "clean"; // clean space/s

    private static final String KEY_SIZE = "s"; // size

    private static final String KEY_CONTENT = "content";    // changing value

    private static final String KEY_TIMEOUT = "t"; // timeout

    public static final String KEY_LEASE_TIME = "lease"; // lease

    private static final String KEY_TAKE = "take"; // take

    private static final String KEY_TX = "tx"; // transaction

    private static final String KEY_READ_TIMES = "repeatsecond"; // read times
    private static final String KEY_WRITE_TIMES = "repeatfirst"; // write times

    private static final String KEY_DCACHE = "cache"; // distributed cache mode

    private static final String KEY_THREADS = "tr"; // threads number

    private static final String KEY_REP_SPACE = "target"; // space to read/take from

    private static final String KEY_MULTIPLE = "m"; // write and read/take multiple

    private static final String KEY_RANDOM = "rand"; // random read/take operation

    //private static final String KEY_UID = "uid"; // UID read/take mode

    private static final String KEY_WRITE_DELAY = "delaywrite"; // write delay

    private static final String KEY_WRITE_RATE = "writerate"; //write rate

    private static final String KEY_NUMBER_OF_ITERATION = "i"; // iterations

    private static final String KEY_FRST_RANGE = "rangefirst";
    private static final String KEY_SCND_RANGE = "rangesecond";

    private static final String KEY_READ_TAKE_DELAY = "delayreadtake"; // read/take delay

    private static final String KEY_MAP = "map"; // use map API

    private static final String KEY_PARALLEL = "parallel"; // all operations run in parallel

    //private static final String KEY_FIFO = "fifo"; // all read/write/take operations run in fifo mode

    private static final String KEY_NOTIFY = "notify"; // notify

    private static final String KEY_ONLY = "execute"; // execute [first|second]

    private static final String KEY_GLOBAL_TP = "showrate"; // having this value write/read/take/notify
    // throughput will be displayed

    private static final String KEY_THREAD_TP = "showthreadrate"; // having this value write/read/take/notify
    // throughput will be displayed

    private static final String KEY_EXIT = "exit"; // exit

    private static final String KEY_HASHTABLE = "hashtable"; // use Java Hashtable

    private static final String KEY_EXT_ENTRY = "externalentry"; // use ExternalEntry - used for GSMapAPI

    private static final String KEY_ALL = "all"; // all

    private static final String KEY_PAUSE = "pause"; //pause at startup

    private static final String KEY_STRESS = "stress";    //stress repeat times

    private static final String KEY_FILE = "f"; // result file name

    private static final String KEY_URL = "url"; // url to use

    private static final String KEY_UPDATE = "update"; // take

    private static final String KEY_BENCH = "bench"; // take

    public static final String KEY_MESSAGE_TYPE = "objecttype"; // object type

    public static final String KEY_USE_SINGLE_SPACE_PROXY = "usesinglespace"; // use single space

    public static final String KEY_IS_RETURN_LEASE = "returnlease"; // return lease

    private BenchmarkConfiguration parameters;

    private final static int ONLY_FIRST = 1;

    private final static int ONLY_SECOND = 2;

    private boolean useReplicationSpace;

    private String firstOperation;

    private String secondOperation;

    private String thirdOperation;

    private String mode;

    private boolean isMap;

    private boolean isHashtable;

    private boolean isExtEntry;

    private boolean isRead;

    private boolean isUseDCache;

    private boolean isAll;

    private int theOnlyOperation;

    private boolean isWriteDelay;

    private boolean isReadTakeDelay;

    private String resultFileName = null;

    private LinkedHashMap<Thread, Operation> threads;

    private ObjectLock objLock;

    private ArrayList<Long> firstOperationTimeOfEachTread;

    private ArrayList<Long> secondOperationTimeOfEachThread;

    private ArrayList<Long> thirdOperationTimeOfEachThread;

    private ArrayList<Long> firstOperationTimeOfEachThreadWFCycle;
    private ArrayList<Long> secondOperationTimeOfEachThreadWFCycle;

    private long initialTestTime;

    private long finalTestTime;

    //the Hashtable which used to demonstrate
    //naive usage of get/put against simple java Hashtable
    private Hashtable m_hashtable = new Hashtable();

    private boolean doneFirstCycle;
    private int stressCycle;

    private BenchmarkOutput benchmarkOutput;

    private PrintStream outWriter;

    public static boolean START_STOP_FLAG = true;

    //////adds
    private static final String KEY_GUI = "gui"; // gui

    private static final String KEY_DTX = "dtx"; // transaction

    //host name for distributed transaction manager
    public static final String KEY_DTX_MANAGER_URL = "dtx-manager-url";

    private BenchmarkListener uiExceptionHandler;

    private boolean _isFirstOperationInitialized = false;
    private boolean _isSecondOperationInitialized = false;
    private boolean _isThirdOperationInitialized = false;

    public double getFirstOperationAverageTotalTime() {
        return _firstOperationAverageTotalTime;
    }

    public double getSecondOperationAverageTotalTime() {
        return _secondOperationAverageTotalTime;
    }

    public double getThirdOperationAverageTotalTime() {
        return _thirdOperationAverageTotalTime;
    }

    public double getFirstAverageThroughput() {
        return _firstAverageThroughput;
    }

    public double getSecondAverageThroughput() {
        return _secondAverageThroughput;
    }

    public double getThirdAverageThroughput() {
        return _thirdAverageThroughput;
    }

    public double getFirstTotalThroughput() {
        return _firstTotalThroughput;
    }

    public double getSecondTotalThroughput() {
        return _secondTotalThroughput;
    }

    public double getThirdTotalThroughput() {
        return _thirdTotalThroughput;
    }

    private double _firstOperationAverageTotalTime = 0;
    private double _secondOperationAverageTotalTime = 0;
    private double _thirdOperationAverageTotalTime = 0;
    private double _firstAverageThroughput = 0;
    private double _secondAverageThroughput = 0;
    private double _thirdAverageThroughput = 0;
    private double _firstTotalThroughput = 0;
    private double _secondTotalThroughput = 0;
    private double _thirdTotalThroughput = 0;

    private final BenchmarkTestResult benchTestResult;

    private DistributedTransactionManagerProvider distributedTransactionManagerProvider;

    /**
     * default class constructor.
     */
    public BenchmarkCommand(BenchmarkOutput benchmarkOutput, BenchmarkTestResult benchTestResult, BenchmarkListener uiExceptionHandler) {
        this.benchmarkOutput = benchmarkOutput;
        this.benchTestResult = benchTestResult;
        this.uiExceptionHandler = uiExceptionHandler;
    }


    /**
     * class constructor.
     */
    public BenchmarkCommand(String spaceUrl, int cycle, PrintStream pw, BenchmarkOutput benchmarkOutput,
                            BenchmarkTestResult benchTestResult, BenchmarkListener uiExceptionHandler) {
        this(benchmarkOutput, benchTestResult, uiExceptionHandler);
        parameters = new BenchmarkConfiguration(spaceUrl);

        isRead = true;
        outWriter = pw;

        useReplicationSpace = false;

        isUseDCache = false;

        firstOperation = "WRITE";

        secondOperation = "READ";

        theOnlyOperation = 0;

        mode = "";

        threads = new LinkedHashMap<Thread, Operation>();

        isMap = false;

        isWriteDelay = false;

        isReadTakeDelay = false;

        objLock = new ObjectLock(parameters.threadCount);

        firstOperationTimeOfEachTread = null;

        secondOperationTimeOfEachThread = null;

        secondOperationTimeOfEachThreadWFCycle = null;

        isAll = false;

        doneFirstCycle = (cycle > 0);
        stressCycle = cycle;
    }


    public void countEntries() {
        long total = 0;

        String output_space = null;
        String output_repSpace = null;

        int length = 0;

        try {
            if (parameters.space instanceof IJSpace) {
                IJSpace _space = parameters.space;
                IRemoteJSpaceAdmin admin = (IRemoteJSpaceAdmin) _space.getAdmin();
                if (Boolean.valueOf(admin.getConfig().isClustered()).booleanValue())
                    return;

                if (isMap) {
                    GSMapImpl map = new GSMapImpl(parameters.space);

                    total = map.size();
                } else {
                    SpaceRuntimeInfo spaceRuntimeInfo = admin.getRuntimeInfo();

                    total = JSpaceUtilities.countSpaceObjects(spaceRuntimeInfo);
                }

                output_space = "**** " + (parameters.space).getName()
                        + " Space stores " + total + " Entries ****";

                length = output_space.length();

                if (parameters.repSpace != null) {
                    _space = parameters.repSpace;
                    admin = (IRemoteJSpaceAdmin) _space.getAdmin();
                    if (Boolean.valueOf(admin.getConfig().isClustered()).booleanValue())
                        return;

                    if (isMap) {
                        GSMapImpl map = new GSMapImpl(parameters.repSpace);

                        total = map.size();
                    } else {
                        SpaceRuntimeInfo spaceRuntimeInfo = admin.getRuntimeInfo();
                        total = JSpaceUtilities.countSpaceObjects(spaceRuntimeInfo);
                    }

                    output_repSpace = "**** "
                            + (parameters.repSpace).getName()
                            + " Space stores " + total + " Entries ****";

                    if (length < output_repSpace.length()) {
                        length = output_repSpace.length();
                    }
                }
            }

            StringBuilder line = new StringBuilder();
            for (int i = 0; i < length; i++) {
                line.append('*');
            }

            String finalLine = line.toString();
            say(finalLine);
            say(output_space);

            if (output_repSpace != null) {
                say(output_repSpace);
            }

            say(finalLine);
        } catch (Exception e) {
            e.printStackTrace();

            if (!parameters.isGUI && parameters.isExit) {
                System.exit(-1);
            } else if (parameters.isGUI) {
//				SpaceBrowser.expDialog.showException( "Count entries", e );
                uiExceptionHandler.onError("Count entries", e);
            }
        }
    }

    public void createFirstOperationThreads() {
        Thread firstOperationThread = null;
        Operation operation = null;
        String operationName = "Read";
        for (int threadNumber = 0; threadNumber < parameters.threadCount; threadNumber++) {
            MessageAdaptor adaptor = MessageAdaptors.getByCode(parameters.messageType);
            if (parameters.isNotify) {
                if (adaptor.isJMS()) {
                    operation = new JMSNotify(parameters, threadNumber, objLock, benchmarkOutput);
                    operationName = "JMSNotify";
                } else {
                    operation = new Notify(parameters, threadNumber, objLock, benchmarkOutput);
                    operationName = "Notify";
                }
            } else if (isAll) {

                if (isMap) {
                    operation = new Put(parameters, threadNumber, objLock, benchmarkOutput);
                    operationName = "Put";
                } else if (parameters.isMultiple) {
                    if (adaptor.isJMS()) {
                        say(JSpaceUtilities.LINE_SEPARATOR +
                                "Multiple Write operation is not supported for JMS message type." +
                                JSpaceUtilities.LINE_SEPARATOR);
                    } else {
                        operation = new WriteMultiple(parameters, threadNumber, objLock, benchmarkOutput);
                        operationName = "WriteMultiple";
                    }
                } else if (adaptor.isJMS()) {
                    operation = new JMSWrite(parameters, threadNumber, objLock, benchmarkOutput);
                    operationName = "JMSWrite";
                } else {
                    operation = new Write(parameters, threadNumber, objLock, benchmarkOutput);
                    operationName = "Write";
                }
            } else if (parameters.isBench) {
                if (isMap) {
                    operation = new PutPutGetRemove(parameters, threadNumber, objLock, benchmarkOutput);
                    operationName = "PutPutGetRemove";
                } else
                    operation = new WriteReadUpdateTake(parameters, threadNumber, objLock, benchmarkOutput);
                operationName = "WriteReadUpdateTake";
            } else if (isMap) //should be below all map permutations!
            {
                operation = new Put(parameters, threadNumber, objLock, benchmarkOutput);
                operationName = "Put";
            } else if (isHashtable) {
                operation = new HashtablePut(parameters, threadNumber, objLock, m_hashtable, benchmarkOutput);
                operationName = "HashtablePut";
            } else if (parameters.isMultiple) {
                if (adaptor.isJMS()) {
                    say(JSpaceUtilities.LINE_SEPARATOR +
                            "Multiple Write operation is not supported for JMS message type." +
                            JSpaceUtilities.LINE_SEPARATOR);
                } else {
                    operation = new WriteMultiple(parameters, threadNumber, objLock, benchmarkOutput);
                    operationName = "WriteMultiple";
                }
            } else if (adaptor.isJMS()) {
                operation = new JMSWrite(parameters, threadNumber, objLock, benchmarkOutput);
                operationName = "JMSWrite";

            } else {
                operation = new Write(parameters, threadNumber, objLock, benchmarkOutput);
                operationName = "Write";
            }

            operationName = operationName + "_" + threadNumber;
            firstOperationThread = new Thread(operation, operationName);
            threads.put(firstOperationThread, operation);
            _isFirstOperationInitialized = operation == null ? false : true;
        }
    }

    public void createSecondOperationThreads(boolean isSetSecondOperation) {
        Thread secondOperationThread = null;
        Operation operation = null;
        String operationName = "Read";
        for (int threadNumber = 0; threadNumber < parameters.threadCount; threadNumber++) {
            MessageAdaptor adaptor = MessageAdaptors.getByCode(parameters.messageType);

            if (parameters.isNotify) {
                //when working with multiple only one single operation is possible - WRITE
                //multiple write operation
                if (parameters.isMultiple) {
                    operation = new WriteMultiple(parameters, threadNumber, objLock, benchmarkOutput);
                    operationName = "WriteMultiple";
                } else if (adaptor.isJMS()) {
                    operation = new JMSWrite(parameters, threadNumber, objLock, benchmarkOutput);
                    operationName = "JMSWrite";
                }
                //regular write operation
                else {
                    operation = new Write(parameters, threadNumber, objLock, benchmarkOutput);
                    operationName = "Write";
                }
            } else if (isAll) {
                if (isMap) {
                    operation = new Get(parameters, threadNumber, objLock, benchmarkOutput);
                    operationName = "Get";
                } else if (adaptor.isJMS()) {
                    say(JSpaceUtilities.LINE_SEPARATOR +
                            "Read operation is not supported for JMS message type." +
                            JSpaceUtilities.LINE_SEPARATOR);
                } else if (parameters.isMultiple) {
                    operation = new ReadMultiple(parameters, threadNumber, objLock, benchmarkOutput);
                    operationName = "ReadMultiple";
                } else {
                    operation = new Read(parameters, threadNumber, objLock, benchmarkOutput);
                    operationName = "Read";
                }
            } else if (isMap) {
                if (isRead) {
                    operation = new Get(parameters, threadNumber, objLock, benchmarkOutput);
                    operationName = "Get";
                } else {
                    operation = new Remove(parameters, threadNumber, objLock, benchmarkOutput);
                    operationName = "Remove";
                }
            } else if (isHashtable) {
                if (isRead)
                    operation = new HashtableGet(parameters, threadNumber, objLock, m_hashtable, benchmarkOutput);
                else
                    operation = new HashtableRemove(parameters, threadNumber, objLock, m_hashtable, benchmarkOutput);

            } else if (parameters.isMultiple) {
                if (isRead) {
                    if (adaptor.isJMS()) {
                        say(JSpaceUtilities.LINE_SEPARATOR +
                                "Multiple Read operation is not supported for JMS message type." +
                                JSpaceUtilities.LINE_SEPARATOR);
                    } else {
                        operation = new ReadMultiple(parameters, threadNumber, objLock, benchmarkOutput);
                        operationName = "ReadMultiple";
                    }
                } else {
                    if (adaptor.isJMS()) {
                        say(JSpaceUtilities.LINE_SEPARATOR +
                                "Multiple Take operation is not supported for JMS message type." +
                                JSpaceUtilities.LINE_SEPARATOR);
                    } else {
                        operation = new TakeMultiple(parameters, threadNumber, objLock, benchmarkOutput);
                        operationName = "TakeMultiple";
                    }
                }
            } else if (parameters.isUpdate) {
                if (isMap) {
                    operation = new GetUpdate(parameters, threadNumber, objLock, benchmarkOutput);
                    operationName = "GetUpdate";
                } else {
                    operation = new ReadUpdate(parameters, threadNumber, objLock, benchmarkOutput);
                    operationName = "ReadUpdate";
                }
            } else {
                if (isRead) {
                    if (adaptor.isJMS()) {
                        say(JSpaceUtilities.LINE_SEPARATOR +
                                "Read operation is not supported for JMS message type." +
                                JSpaceUtilities.LINE_SEPARATOR);
                    } else {
                        operation = new Read(parameters, threadNumber, objLock, benchmarkOutput);
                        operationName = "Read";
                    }
                } else if (adaptor.isJMS()) {
                    operation = new JMSTake(parameters, threadNumber, objLock, benchmarkOutput);
                    operationName = "JMSTake";
                } else {
                    operation = new Take(parameters, threadNumber, objLock, benchmarkOutput);
                    operationName = "Take";
                }
            }

            //fix bug with wrong X parameters for read, take, get, remove operations
            if (isSetSecondOperation)
                operation.setSecondOperation(true);

            operationName = operationName + "_" + threadNumber;
            secondOperationThread = new Thread(operation, operationName);
            _isSecondOperationInitialized = operation == null ? false : true;
            threads.put(secondOperationThread, operation);

        }
    }


    public void createThirdOperationThreads() {
        Operation operation = null;
        String operationName;

        for (int threadNumber = 0; threadNumber < parameters.threadCount; threadNumber++) {
            MessageAdaptor adaptor = MessageAdaptors.getByCode(parameters.messageType);
            if (isMap) {
                operation = new Remove(parameters, threadNumber, objLock, benchmarkOutput);
                operationName = "Remove";
            } else if (adaptor.isJMS()) {
                operationName = "JMSTake";
                if (parameters.isMultiple) {
                    say(JSpaceUtilities.LINE_SEPARATOR +
                            "Multiple Take operation is not supported for JMS message type." +
                            JSpaceUtilities.LINE_SEPARATOR);
                } else {
                    operation = new JMSTake(parameters, threadNumber, objLock, benchmarkOutput);
                }
            } else if (parameters.isMultiple) {
                operation = new TakeMultiple(parameters, threadNumber, objLock, benchmarkOutput);
                operationName = "TakeMultiple";
            } else {
                operation = new Take(parameters, threadNumber, objLock, benchmarkOutput);
                operationName = "Take";
            }

            operationName = operationName + "_" + threadNumber;
            threads.put(new Thread(operation, operationName), operation);
            _isThirdOperationInitialized = operation == null ? false : true;
        }
    }

    /**
     * Added by Eugene. Called by GUI when user presses the Stop button
     */
    public void stopAllThreads() {
        START_STOP_FLAG = false;
//        System.out.println("**** START STOP FLAG IS " + START_STOP_FLAG);
        threads.clear();
        System.gc();
    }

    public void startThreads(int firstIndex, int lastIndex) {
        START_STOP_FLAG = true;
        int i;
        Thread aThread;
        Iterator<Thread> iter = threads.keySet().iterator();

        if (firstIndex != 0) {
            i = 0;

            while (i < firstIndex && iter.hasNext()) {
                iter.next();
                i++;
            }
        }

        for (i = firstIndex; i < lastIndex; i++) {
            if (START_STOP_FLAG && iter.hasNext()) {
                aThread = iter.next();
                aThread.start();
            }
        }
    }


    public void joinThreads(int firstIndex, int lastIndex)
            throws InterruptedException {
        Iterator<Thread> iter = threads.keySet().iterator();

        int i = 0;
        for (; i < firstIndex && iter.hasNext(); ++i) {
            iter.next();
        }

        for (; i < lastIndex && iter.hasNext(); i++) {
            Thread aThread = iter.next();
            aThread.join();
        }
    }

    public void say(String mes) {
        System.out.println(Thread.currentThread().getName() + " - " + mes);
        if (outWriter != null)
            outWriter.println(mes);
    }


    /**
     * Parse the test configuration arguments.
     */
    public boolean initInputConfigurationParameters(Map args, PrintWriter out, IJSpace theSpace, IMap theCache, BenchmarkOutput benchmarkOutput) {
        try {
            // Overwrite the default values if a value had been specified
            // in
            // the args list
            if (args.containsKey(KEY_HELP)) {
                if (out != null)
                    usage(out);
                if (!parameters.isGUI)
                    System.exit(1); // no need to continue ;
            }

            parameters.isGUI = (args.containsKey(KEY_GUI));


            if (args.containsKey(KEY_URL)) {
                String newUrl = (String) args.get(KEY_URL);
                parameters.spaceURL = newUrl;
            }

            //result file
            if (args.containsKey(KEY_FILE)) {
                resultFileName = (String) args.get(KEY_FILE);
                if ((resultFileName == null) || (resultFileName.length() == 0)) {
                    resultFileName = "BenchMarkResult_" + new Date(System.currentTimeMillis()) + "_" + new Time(System.currentTimeMillis());
                    resultFileName = resultFileName.replaceAll(":", "_");
                    resultFileName = resultFileName.replaceAll(" ", "_") + ".xls";
                }
            }

            if (args.containsKey(KEY_ALL)) {
                isAll = true;
                parameters.isAll = true;
                if (isMap) {
                    firstOperation = "PUT";
                    secondOperation = "GET";
                    thirdOperation = "REMOVE";
                } else {
                    firstOperation = "WRITE";
                    secondOperation = "READ";
                    thirdOperation = "TAKE";
                }
            }

            //
            if (args.containsKey(KEY_ONLY)) {
                parameters.isOnly = true;

                if (args.get(KEY_ONLY).equals("first")) {
                    theOnlyOperation = ONLY_FIRST;
                }

                if (args.get(KEY_ONLY).equals("second")) {
                    theOnlyOperation = ONLY_SECOND;
                }
            }

            if (args.containsKey(KEY_TAKE)) {
                isRead = false;
                secondOperation = "TAKE";
            }


            if (args.containsKey(KEY_EXIT)) {
                parameters.isExit = true;
            }

            // message length
            if (args.containsKey(KEY_SIZE)) {
                parameters.messageLength = Integer.parseInt((String) args
                        .get(KEY_SIZE));
                // prepare the message buffer
                parameters.messageBuf = new byte[parameters.messageLength];
            }

            //-value - different values per iteration
            if (args.containsKey(KEY_CONTENT)) {
                parameters.changeContent = true;
            }

            // number of entries/iterations
            if (args.containsKey(KEY_NUMBER_OF_ITERATION)) {
                parameters.numberOfIterations = Integer.parseInt((String) args
                        .get(KEY_NUMBER_OF_ITERATION));

                if ((parameters.numberOfIterations % 2) != 0) {
                    if (!parameters.isGUI) {
                        say("The ITERATIONS number should be even.Benchmark test stopped.");
                        System.exit(-1);
                    } else {
                        if (benchmarkOutput != null)
                            benchmarkOutput.alert("The number of iterations must be even number.");
                        return false;
                    }

                }
            }

            // get range.
            parameters.firstOpRange = args.containsKey(KEY_FRST_RANGE);
            parameters.secondOpRange = args.containsKey(KEY_SCND_RANGE);
            if (parameters.firstOpRange || parameters.secondOpRange) {
                boolean inrange = false;

                if (parameters.firstOpRange) {
                    String range = (String) args.get(KEY_FRST_RANGE);
                    StringTokenizer st = new StringTokenizer(range, "-");

                    if (st.countTokens() == 2) {
                        parameters.firstOpRangeFrom
                                = Integer.parseInt(st.nextToken());
                        parameters.firstOpRangeTo
                                = Integer.parseInt(st.nextToken());
                    }

                    if (parameters.firstOpRangeFrom > parameters.firstOpRangeTo
                            || parameters.firstOpRangeTo == 0) {
                        say("first operation range parameters are invalid.");
                        if (!parameters.isGUI)
                            System.exit(-1);
                    }

                    inrange = true;
                }

                if (parameters.secondOpRange) {
                    String range = (String) args.get(KEY_SCND_RANGE);
                    StringTokenizer st = new StringTokenizer(range, "-");

                    if (st.countTokens() == 2) {
                        parameters.secondOpRangeFrom
                                = Integer.parseInt(st.nextToken());

                        parameters.secondOpRangeTo
                                = Integer.parseInt(st.nextToken());
                    }

                    if (parameters.secondOpRangeFrom > parameters.secondOpRangeTo
                            || parameters.secondOpRangeTo == 0) {
                        say("second operation range parameters are invalid.");
                        if (!parameters.isGUI)
                            System.exit(-1);
                    }
                    inrange = true;
                }

                if (!inrange) {
                    say("range parameter is invalid. Specify each range per operation.");
                    say("-range 1stfrom 1000 1stto 2000");
                    if (!parameters.isGUI)
                        System.exit(-1);
                }
            } else {
                //range doesn't exist,
                //set defaults:
                parameters.firstOpRangeFrom = 0;
                parameters.firstOpRangeTo = parameters.numberOfIterations;

                parameters.secondOpRangeFrom = 0;
                parameters.secondOpRangeTo = parameters.numberOfIterations;

            }

            // write delay
            if (args.containsKey(KEY_WRITE_DELAY)) {
                isWriteDelay = true;

                parameters.delayWrite = Integer.parseInt((String) args
                        .get(KEY_WRITE_DELAY));
            }

            // read/take delay
            if (args.containsKey(KEY_READ_TAKE_DELAY)) {
                isReadTakeDelay = true;

                parameters.delayReadTake = Integer.parseInt((String) args
                        .get(KEY_READ_TAKE_DELAY));
            }

            // write rate
            if (args.containsKey(KEY_WRITE_RATE)) {
                parameters.isWriteRate = true;
                parameters.writeRate = Integer.parseInt((String) args.get(KEY_WRITE_RATE));
                parameters.globalRateIter = new AtomicInteger(0);
            }


            // number of random iterations
            if (args.containsKey(KEY_RANDOM)) {
                parameters.isRandom = true;

                String randValue = (String) args.get(KEY_RANDOM);

                if (randValue.length() > 0) {
                    parameters.numberOfRandomIterations = Integer
                            .parseInt(randValue);
                } else {
                    parameters.numberOfRandomIterations = parameters.numberOfIterations;
                }
            }

            // read times
            if (args.containsKey(KEY_READ_TIMES)) {
                if (!isRead) {
                    if (!parameters.isGUI) {
                        say("Setting READ TIMES and TAKE options is impossible .Benchmark test stopped.");
                        System.exit(-1);
                    } else {
                        if (benchmarkOutput != null)
                            benchmarkOutput.alert("Number of Reads parameter cannot be used with Take operation.");
                        return false;
                    }
                }

                parameters.readRepeatTimes = Integer.parseInt((String) args
                        .get(KEY_READ_TIMES));
                if (parameters.readRepeatTimes <= 0) {
                    if (!parameters.isGUI) {
                        say("The READ TIMES should not be negative.Benchmark test stopped.");
                        System.exit(-1);
                    } else {
                        if (benchmarkOutput != null)
                            benchmarkOutput.alert("Number of Reads cannot be negative number.");
                        return false;
                    }
                }
            }

            // Write times
            if (args.containsKey(KEY_WRITE_TIMES)) {
                parameters.writeRepeatTimes = Integer.parseInt((String) args
                        .get(KEY_WRITE_TIMES));
                if (parameters.writeRepeatTimes <= 0) {
                    say("The WRITE TIMES should not be negative.Benchmark test stopped.");
                    if (!parameters.isGUI)
                        System.exit(-1);
                }
            }

            // number of threads
            if (args.containsKey(KEY_THREADS)) {
                parameters.threadCount = Integer.parseInt((String) args
                        .get(KEY_THREADS));
                objLock = new ObjectLock(parameters.threadCount);
            }


            // read/take timeout
            if (args.containsKey(KEY_TIMEOUT)) {
                parameters.timeout = Long.parseLong((String) args.get(KEY_TIMEOUT));
            }

            //Return lease
            parameters.isReturnLease = args.containsKey(KEY_IS_RETURN_LEASE);


            //Use clustered proxy
            parameters.isUseSingleSpaceProxy = args.containsKey(KEY_USE_SINGLE_SPACE_PROXY);


            // all operations run in parallel
            // in this case timeout is 10 sec by default
            if (args.containsKey(KEY_PARALLEL)) {
                parameters.isParallel = true;
                //for parallel operations that are running NOT from GUI set default timeout
                if (parameters.timeout <= 0 && !parameters.isGUI)
                    parameters.timeout = BenchmarkConfiguration.DEFAULT_TIMEOUT_VALUE; // 60 sec

                if (!isAll || parameters.isGUI)
                    objLock = new ObjectLock(parameters.threadCount * 2);
                else
                    objLock = new ObjectLock(parameters.threadCount * 3);
            }

            if (args.containsKey(KEY_MESSAGE_TYPE)) {
                parameters.messageType = MessageAdaptors.getMessageType((String) args.get(KEY_MESSAGE_TYPE));
            }

            // having this value write/read/take/notify
            // thread throughput will be displayed
            // default throughput iterations is 1000
            if (args.containsKey(KEY_THREAD_TP)) {
                parameters.isThreadThroughput = true;

                if (!(args.get(KEY_THREAD_TP)).equals("")) {
                    parameters.threadThroughputIterations = Integer.parseInt((String) args.get(KEY_THREAD_TP));
                }
            }

            // having this value write/read/take/notify
            // global throughput will be displayed
            // default throughput iterations is 1000
            if (args.containsKey(KEY_GLOBAL_TP)) {
                parameters.isGlobalThroughput = true;

                parameters.globalThroughputFirstList = new LinkedList<Double>();

                parameters.globalThroughputSecondList = new LinkedList<Double>();

                if (isAll)
                    parameters.globalThroughputThirdList = new LinkedList<Double>();

                if (!(args.get(KEY_GLOBAL_TP)).equals("")) {
                    parameters.globalThroughputIterations = Integer.parseInt((String) args.get(KEY_GLOBAL_TP));
                }

                parameters.globalThroughputFirstOperationCounter = new AtomicInteger(0);
                parameters.globalThroughputSecondOperationCounter = new AtomicInteger(0);
                parameters.globalThroughputThirdOperationCounter = new AtomicInteger(0);
            }

            // write/writemultiple/put/notify lease
            if (args.containsKey(KEY_LEASE_TIME)) {
                parameters.lease = Long.parseLong((String) args.get(KEY_LEASE_TIME));
            }

            // notify
            if (args.containsKey(KEY_NOTIFY)) {
                parameters.isNotify = true;
                isRead = false;
                firstOperation = "NOTIFY";
                secondOperation = "WRITE";
            }

            // multiple write and read/take
            if (args.containsKey(KEY_MULTIPLE)) {
                if (parameters.isRandom) {
                    if (!parameters.isGUI) {
                        say("Setting MULTIPLE and RANDOM options is impossible. Benchmark test stopped.");
                        System.exit(-1);
                    } else {
                        if (benchmarkOutput != null)
                            benchmarkOutput.alert("Random option cannot be used with batch operations.");
                        return false;
                    }
                }

                parameters.isMultiple = true;
                mode = "MULTIPLE";
                parameters.numOfBatches = Integer.parseInt((String) args
                        .get(KEY_MULTIPLE));

                if ((parameters.numberOfIterations % parameters.numOfBatches) != 0) {


                    if (!parameters.isGUI) {
                        say("The BATCH SIZE must be integer and not "
                                + ((double) parameters.numberOfIterations / parameters.numOfBatches)
                                + ". Benchmark test stopped.");
                        System.exit(-1);
                    } else {
                        if (benchmarkOutput != null)
                            benchmarkOutput.alert("The number of batches value must be Modulo of " + parameters.numberOfIterations);
                        return false;
                    }
                }

                parameters.batchAmount = parameters.numberOfIterations
                        / parameters.numOfBatches;
            }


            // Master-Local
            {
                //	find useLocalCache in url
                boolean useLocalCacheFALSE = false;
                String urlParams = null;
                StringTokenizer st = new StringTokenizer(parameters.spaceURL, "?");
                while (st.hasMoreTokens())
                    urlParams = st.nextToken();

                st = new StringTokenizer(urlParams, "&");
                while (st.hasMoreTokens()) {
                    urlParams = st.nextToken();
                    if (urlParams.equals(SpaceURL.USE_LOCAL_CACHE) || urlParams.equals(SpaceURL.USE_LOCAL_CACHE + "=true")) {
                        isUseDCache = true;
                        break;
                    } else if (urlParams.equals(SpaceURL.USE_LOCAL_CACHE + "=false")) {
                        useLocalCacheFALSE = true;
                        break;
                    }
                }

                if (!isUseDCache && !useLocalCacheFALSE && args.containsKey(KEY_DCACHE)) {
                    isUseDCache = true;
                    parameters.spaceURL = SpaceUrlUtils.setPropertyInUrl(parameters.spaceURL, SpaceURL.USE_LOCAL_CACHE, null, false);
                }
            }


            // get main space
            try {

                //changed by Evgeny on 30.08.2005 in order to unit two logics: from spacebrowser and from examples
                if (args.containsKey(KEY_MAP)) {

                    if (parameters.isGUI) {
                        isMap = true;
                        firstOperation = "PUT";
                        secondOperation = "GET";
                    } else {
                        parameters.cache = (IMap) CacheFinder.find(parameters.spaceURL);
                        parameters.space = parameters.cache.getMasterSpace();
                    }
                } else {
                    if (!parameters.isGUI) {
                        Object foundObj = SpaceFinder.find(parameters.spaceURL);
                        if (foundObj instanceof IJSpace) {
                            parameters.space = (IJSpace) foundObj;
                        } else {
                            parameters.space = (IJSpace) foundObj;
                        }
                    }
                }

                //only for CLI Benchmark treat in Clustered proxy.
                //The same is already done in GigaBenchmark class for UI Benchmark
                //there we already have space instance, that prevents from us
                //to unit these UI and CLI logics
                if (!parameters.isGUI) {
                    IJSpace spaceProxy = parameters.space;
                    if (parameters.isUseSingleSpaceProxy && ((ISpaceProxy) spaceProxy).isClustered()) {
                        parameters.space = spaceProxy.getDirectProxy().getNonClusteredProxy();

                        if (args.containsKey(KEY_MAP)) {
                            //call again to CacheFinder.find() because it's impossible now to retrieve
                            //map implementation with regular space proxy that belongs to cluster
                            parameters.cache = (IMap) CacheFinder.find(parameters.space.getFinderURL().getURL());
                        }
                    }
                }


            } catch (FinderException ex) {
                ex.printStackTrace();

                if (!parameters.isGUI) {
                    say(parameters.spaceURL + " space was not found. Benchmark test stopped.");
                    System.exit(-1);
                } else {
                    if (benchmarkOutput != null)
                        benchmarkOutput.alert("Space not found: " + parameters.spaceURL);
                    return false;
                }
            }


            if (parameters.isGUI) {
                //if( theCache != null )
                //	System.out.println( "~BenchmarkCommand, map=" + theCache.hashCode() );
                parameters.cache = theCache;
                parameters.space = theSpace;
            }

            //parameters.space.setNOWriteLeaseMode( !parameters.isReturnLease );
            int updateModifier = parameters.isReturnLease ?
                    Modifiers.NONE :
                    UpdateModifiers.UPDATE_OR_WRITE;
            parameters.space.setUpdateModifiers(updateModifier);

            // get replication space
            try {
                if (args.containsKey(KEY_REP_SPACE)) {
                    useReplicationSpace = true;

                    parameters.repSpaceURL = (String) args.get(KEY_REP_SPACE);

                    if (isUseDCache) {
                        parameters.repSpaceURL = parameters.repSpaceURL + "?"
                                + SpaceURL.USE_LOCAL_CACHE + "=" + parameters.dCacheMode;
                    }

                    if (args.containsKey(KEY_MAP)) {
                        parameters.repCache = (IMap) CacheFinder.find(parameters.repSpaceURL);
                        parameters.repSpace = parameters.repCache.getMasterSpace();
                    } else {
                        Object foundRepSpace = SpaceFinder.find(parameters.repSpaceURL);
                        if (foundRepSpace instanceof IJSpace) {
                            parameters.repSpace = (IJSpace) foundRepSpace;
                        } else {
                            parameters.repSpace = (IJSpace) foundRepSpace;
                        }
                    }

                }
            } catch (FinderException ex) {
                ex.printStackTrace();

                if (!parameters.isGUI) {
                    say(parameters.repSpace + " space was not found. Benchmark test stoped.");
                    System.exit(-1);
                } else {
                    if (benchmarkOutput != null)
                        benchmarkOutput.alert("Space not found: " + parameters.spaceURL);
                    return false;
                }
            }

            if (args.containsKey(KEY_MAP)) {
                isMap = true;

                if (!args.containsKey(KEY_UPDATE) && !args.containsKey(KEY_BENCH)) {
                    firstOperation = "PUT";
                    if (isRead)
                        secondOperation = "GET";
                    else
                        secondOperation = "REMOVE";

                    if (isAll) {
                        firstOperation = "PUT";
                        secondOperation = "GET";
                        thirdOperation = "REMOVE";
                    }
                }
            }

            if (args.containsKey(KEY_HASHTABLE)) {
                isHashtable = true;
                firstOperation = "HASHTABLE_PUT";
                if (isRead)
                    secondOperation = "HASHTABLE_GET";
                else
                    secondOperation = "HASHTABLE_REMOVE";


                if (isAll) {
                    firstOperation = "HASHTABLE_PUT";
                    secondOperation = "HASHTABLE_GET";
                    thirdOperation = "HASHTABLE_REMOVE";
                }
            }

            if (args.containsKey(KEY_EXT_ENTRY)) {
                isExtEntry = true;
            }

            if (args.containsKey(KEY_CLEAN)) {
                parameters.isCleanSpace = true;

                //changes added by Evgeny on 30.08.2005 in order to support in both logics: GUI and examples
                if (parameters.isGUI) {
                    if (!isUseDCache) {
                        say("Cleaning " + (parameters.space).getName()
                                + " Space before test...");
                        (parameters.space).clear(null, null);
                        ///ADDEd BY SHAY - May 26 2005
                        if ((parameters.space).isEmbedded()) {
                            System.gc();
                        }

                        if (useReplicationSpace) {
                            say("Cleaning " + parameters.repSpace.getName()
                                    + " Space before test...");
                            parameters.repSpace.clear(null, null);
                        }
                    } else {

                        if (isMap) {
                            parameters.cache.clear(true);
                        } else {
                            ((AbstractSpaceProxy) parameters.space).getRemoteSpace().clear(null, null);
                            ((AbstractSpaceProxy) parameters.space).getLocalSpace().clear(null, null);
                        }

                        if (useReplicationSpace) {


                            if (isMap) {
                                parameters.repCache.clear(true);
                            } else {
                                ((AbstractSpaceProxy) parameters.repSpace).getRemoteSpace().clear(null, null);
                                ((AbstractSpaceProxy) parameters.repSpace).getLocalSpace().clear(null, null);
                            }
                        }
                    }
                }
                //not GUI
                else {

                    if (!isUseDCache) {
                        say("Cleaning Space before test...");

                        if (parameters.space instanceof IJSpace) {
                            parameters.space.clear(null, null);
                        } else {
                            cleanJavaSpace(parameters.space);
                        }

                        if (useReplicationSpace) {
                            if (parameters.repSpace instanceof IJSpace) {
                                say("Cleaning " + parameters.repSpace.getName()
                                        + " Space before test...");
                                parameters.repSpace.clear(null, null);
                            } else {
                                cleanJavaSpace(parameters.repSpace);
                            }
                        }
                    } else {
                        say("Cleaning remote Space and local Cache before test...");

                        if (isMap) {
                            parameters.cache.clear(true);
                        } else {
                            ((AbstractSpaceProxy) parameters.space).getRemoteSpace().clear(null, null);
                            ((AbstractSpaceProxy) parameters.space).getLocalSpace().clear(null, null);
                        }

                        if (useReplicationSpace) {
                            if (isMap) {
                                parameters.repCache.clear(true);
                            } else {
                                ((AbstractSpaceProxy) parameters.repSpace).getRemoteSpace().clear(null, null);
                                ((AbstractSpaceProxy) parameters.repSpace).getLocalSpace().clear(null, null);
                            }
                        }
                    }
                }//end of else
            }

            // number of transaction iterations before the commit
            if (args.containsKey(KEY_TX)) {
                if (args.get(KEY_TX).equals("")) {
                    parameters.isSingleTransaction = true;
                    parameters.txIterations = parameters.numberOfIterations;
                } else {
                    parameters.txIterations = Integer.parseInt((String) args
                            .get(KEY_TX));
                }

                parameters.transactionType = BenchmarkConfiguration.TRANSACTION_TYPE_LOCAL;

                if (distributedTransactionManagerProvider == null)
                    distributedTransactionManagerProvider = new DistributedTransactionManagerProvider();

                parameters.spaceTransactionManager = distributedTransactionManagerProvider.getTransactionManager();

                if (parameters.repSpace != null) {
                    parameters.repSpaceTransactionManager = distributedTransactionManagerProvider.getTransactionManager();
                }
            }

            // -stress
            if (args.containsKey(KEY_STRESS)) {
                parameters.stressRepeatTimes = Integer.parseInt((String) args
                        .get(KEY_STRESS));
                parameters.isStress = true;
            }

            // leave this as the last if statement
            // when stress is on, only first cycle is paused.
            if (args.containsKey(KEY_PAUSE) && !doneFirstCycle) {
                System.out.println("\n[ Benchmark Paused ] - Connection with space established, press any key to continue...\n");
                System.in.read();
            }


            // number of transaction iterations before the commit
            if (args.containsKey(KEY_DTX)) {
                if (args.get(KEY_DTX).equals("")) {
                    parameters.isSingleTransaction = true;
                    parameters.txIterations = parameters.numberOfIterations;
                } else {
                    parameters.txIterations = Integer.parseInt((String) args
                            .get(KEY_DTX));
                }

                String dtxManagerHostName = null;

                if (args.containsKey(KEY_DTX_MANAGER_URL)) {
                    dtxManagerHostName = (String) args.get(KEY_DTX_MANAGER_URL);
                }

//				if( args.containsKey( KEY_MULTIPLE ) &&
//					( parameters.numOfBatches % parameters.txIterations ) != 0 )
//				{
//					say( "The BATCH NUMBER modulo txIterations must be ZERO "
//							+ ". Benchmark test stopped." );
//					return;
//				}

                try {

                    parameters.spaceTransactionManager =
                            findTransactionManager(dtxManagerHostName);

                    parameters.transactionType = BenchmarkConfiguration.TRANSACTION_TYPE_DISTRIBUTED;
                    if (parameters.repSpace != null) {
                        parameters.repSpaceTransactionManager = parameters.spaceTransactionManager;
                    }
                } catch (Throwable e) {
                    String message =
                            "Distributed Transaction Manager (Mahalo) can not be found.\n" +
                                    "Check if Distributed Transaction Manager is running on <" +
                                    dtxManagerHostName + "> or use Local Transaction instead.";

                    say(message);
                    if (benchmarkOutput != null) {
                        benchmarkOutput.showException(message + "\n", e.toString(), e);
                    }

                    if (!parameters.isGUI) {
                        System.exit(-1);
                    }

                    return false;
                }
            }

        } catch (Exception ex) {
            ex.printStackTrace();
            if (!parameters.isGUI)
                System.exit(-1);
        }

        //in order to allow writing the same message instances that
        //only differs with its content, set Optimistic Locking to false
        if (parameters.space != null) {
            parameters.space.setOptimisticLocking(false);
        }

        return true;
    }


    private TransactionManager findTransactionManager(String hostName) throws FinderException {
        LookupRequest request = LookupRequest.TransactionManager()
                .setLocators(hostName)
                .setTimeout(15 * 1000);
        TransactionManager transactionManager = (TransactionManager) LookupFinder.find(request);

        return transactionManager;
    }

    /**
     * Returns the approximate size of entry in bytes.
     */
    public byte[] getObjectByteSize()
            throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(outStream);

        MessageAdaptor adaptor = MessageAdaptors.getByCode(parameters.messageType);
        Object entry = adaptor.create(25000, parameters.messageBuf);
        out.writeObject(entry);

        byte[] byteObj = outStream.toByteArray();

        out.close();
        outStream.close();

        return byteObj;
    }


    /**
     * prints configuration parameters to out.
     */
    public void printConfigurationMessages(Map args)
            throws Exception {
        say("|");
        say("|\t" + PlatformVersion.getOfficialVersion());
        say("|\t@version: " + BenchmarkVersion.VERSION);
        say("|\n");

        say("benchmark parameters: " + args);
        say("use -h for more benchmark parameters.\n");

        //verbose:
        //say("space instance: " + parameters.space);
        //say("cache instance: " + parameters.cache);

        if (isAll) {
            say("This Test will perform " + firstOperation + ", " + secondOperation + " and " + thirdOperation);
        } else if (parameters.isOnly) {
            if (theOnlyOperation == ONLY_FIRST) {
                say("This Test will perform " + mode + " " + firstOperation);
            } else {
                say("This Test will perform " + mode + " " + secondOperation);
            }
        } else {
            say("This Test will perform " + mode + " " + firstOperation + " and "
                    + secondOperation);
        }

        say("MASTER SPACE URL: " + parameters.spaceURL);

        if (isUseDCache) {
            say("USING Master-Local Cache WITH " + (parameters.space).getName()
                    + " Space");
        }

        if (useReplicationSpace) {
            say("REPLICA SPACE URL: " + parameters.repSpaceURL);

            if (isUseDCache) {
                say("USING Master-Local Cache WITH "
                        + parameters.repCache.getMasterSpace().getName() + " Space");
            }
        }

        //String timeout = "FOREVER";

        //if( parameters.timeout != Long.MAX_VALUE )
        //{
        String timeout = String.valueOf(parameters.timeout) + " milliseconds";
        //}

        String lease = "FOREVER";

        if (parameters.lease != Lease.FOREVER) {
            lease = String.valueOf(parameters.lease) + " milliseconds";
        }

        if (!parameters.isParallel) {
            say("SEQUENTIAL EXECUTION");
        } else {
            say("PARALLEL EXECUTION");
        }

        MessageAdaptor adaptor = MessageAdaptors.getByCode(parameters.messageType);
        if (adaptor.isFifo()) {
            say("FIFO mode");
        }

        if (theOnlyOperation == ONLY_FIRST) {
            if (parameters.isBench)
                say("EXECUTING BENCH OPERATIONS");
            else
                say("EXECUTING ONLY FIRST OPERATION");
        } else if (theOnlyOperation == ONLY_SECOND) {
            say("EXECUTING ONLY SECOND OPERATION");
        } else {
            say("EXECUTING BOTH OPERATIONS");
        }

        say("TIMEOUT: " + timeout);

        say("LEASE: " + lease);

        say("BUFFERSIZE: " + parameters.messageLength + " bytes");

        byte[] entry = getObjectByteSize();
        say("APPROXIMATE ENTRY SIZE: " + entry.length + " bytes");

        if (parameters.firstOpRange || parameters.secondOpRange) {
            if (parameters.firstOpRange)
                say("RANGE:\tFIRST OPERATION - FROM: " + parameters.firstOpRangeFrom
                        + " TO: " + parameters.firstOpRangeTo
                        + " , ITERATIONS: " + (parameters.firstOpRangeTo - parameters.firstOpRangeFrom));

            if (parameters.secondOpRange)
                say("RANGE:\tSECONDS OPERATION - FROM: " + parameters.secondOpRangeFrom
                        + " TO: " + parameters.secondOpRangeTo
                        + " , ITERATIONS: " + (parameters.secondOpRangeTo - parameters.secondOpRangeFrom));
        } else
            say("ITERATIONS: " + parameters.numberOfIterations);

        if (parameters.writeRepeatTimes > 1)
            say("FIRST OPERTATION REPEATS: " + parameters.writeRepeatTimes + " TIMES");

        if (parameters.readRepeatTimes > 1)
            say("SECOND OPERTATION REPEATS: " + parameters.readRepeatTimes + " TIMES");

        if (parameters.isRandom) {
            say("RANDOM ITERATIONS: " + parameters.numberOfRandomIterations);
        }

        if (parameters.isSingleTransaction) {
            say("SINGLE TRANSACTION");
        }

        if (parameters.txIterations != 0) {
            say("TRANSACTION COMMIT EVERY " + parameters.txIterations
                    + " ITERATIONS");
        }

        say("NUMBER OF THREADS: " + parameters.threadCount + " for each operation");

        if ((String) args.get(KEY_MESSAGE_TYPE) != null) {
            say("USING: " + (String) args.get(KEY_MESSAGE_TYPE));
        }

        if (parameters.isGlobalThroughput) {
            say("DISPLAY TP EVERY " + parameters.globalThroughputIterations + " ITERATIONS");
        }


        if (parameters.isMultiple) {
            say("NUMBER OF BATCHES: " + parameters.numOfBatches);
            say("BATCH SIZE: " + parameters.batchAmount);
        }

        if (isWriteDelay) {
            say(firstOperation + " DELAY: " + parameters.delayWrite
                    + " milliseconds");
        }

        if (isReadTakeDelay) {
            say(secondOperation + "  DELAY: " + parameters.delayReadTake
                    + " milliseconds");
        }

        if (parameters.isWriteRate) {
            say(firstOperation + " RATE: " + parameters.writeRate + " msg/sec");
        }

        if (isMap) {
            say("USING MAP API");
            if (isExtEntry)
                say("USING MAP API with ExternalEntry");
        }

        if (parameters.isStress)
            say("STRESS REPEATS : " + (stressCycle + 1) + " out of " + parameters.stressRepeatTimes + " TIMES");

        if (args.containsKey(KEY_FILE)) {
            say("RESULT FILE: " + resultFileName);
        }

        say("");
    }

    public void printTotalTestTime() {
        long totalTestTime = finalTestTime - initialTestTime;

        say("TOTAL TEST TIME = " + totalTestTime + " milliseconds");
    }


    private ThroughputWrapper printAllOutput(String operation, ArrayList operationTimes, long iterations) {
        double operationAverageTotalTime = 0;
        long threadOperationTime = 0;
        DecimalFormat benchFormat = new DecimalFormat("0.000");
        double totalThroughput = 0;
        double totalThroughput_MB = 0;
        double threadThroughput;
        double averageThroughput = 0;

        final BenchmarkTestResult.Result result = benchTestResult.buildResult(operation);

        for (int threadNumber = 0; threadNumber < parameters.threadCount; threadNumber++) {
            threadOperationTime = ((Long) operationTimes.get(threadNumber)).longValue();
            // in msg/sec
            threadThroughput = (1000.0 * iterations) / threadOperationTime;

            totalThroughput += threadThroughput;

            say(operation + " " + mode + " for thread " +
                    threadNumber + ": TP = " + benchFormat.format(threadThroughput) +
                    " msg/sec , TEST TIME = " + threadOperationTime + " ms");

            operationAverageTotalTime += threadOperationTime;

            result.addThreadResult(threadThroughput, threadOperationTime);
        }

        operationAverageTotalTime /= parameters.threadCount;

        say("----------------- " + operation + " " + mode + " SUMMARY ---------------------");


        String operationAverageTotalTimeStr = benchFormat.format(operationAverageTotalTime);
        say(operation + " " + mode + " AVG   TEST TIME  for all threads = " +
                operationAverageTotalTimeStr + " ms");

        result.setAverageDuration(operationAverageTotalTime);

        averageThroughput = totalThroughput / parameters.threadCount;

        String averageThroughputStr = benchFormat.format(averageThroughput);
        say(operation + " " + mode + " AVG   TP for all threads = " +
                averageThroughputStr + " msg/sec");

        result.setAverageThroughput(averageThroughput);

        // in MB/sec
        totalThroughput_MB = (totalThroughput * parameters.messageBuf.length) / (1024 * 1024);

        String totalThroughputStr = benchFormat.format(totalThroughput);
        say(operation + " " + mode + " TOTAL TP for all threads = " +
                totalThroughputStr + " msg/sec , " +
                benchFormat.format(totalThroughput_MB) + " MB/sec");

        result.setTotalThroughput(totalThroughput);

        say("-------------------------------------------------------------\n");

        return new ThroughputWrapper(operationAverageTotalTime,
                averageThroughput,
                totalThroughput);
    }


    public void computeAveragePerformanceTime() throws IOException {
        _firstOperationAverageTotalTime = 0;
        _secondOperationAverageTotalTime = 0;
        _thirdOperationAverageTotalTime = 0;

        _firstAverageThroughput = 0;
        _secondAverageThroughput = 0;
        _thirdAverageThroughput = 0;

        _firstTotalThroughput = 0;
        _secondTotalThroughput = 0;
        _thirdTotalThroughput = 0;


        long threadFirstOperationTime = 0;
        long threadSecondOperationTime = 0;
        DecimalFormat benchFormat = new DecimalFormat("0.000");
        double firstTotalThroughput_MB = 0;
        double secondTotalThroughput_MB = 0;
        double threadThroughput = 0;


        double threadThroughputWFCycle = 0;
        double threadFirstOperationTimeWFCycle = 0;
        double threadSecondOperationTimeWFCycle = 0;
        double firstTotalThroughputWFCycle = 0;
        double firstAverageThroughputWFCycle = 0;
        double firstTotalThroughputWFCycle_MB = 0;
        double secondTotalThroughputWFCycle = 0;
        double secondAverageThroughputWFCycle = 0;
        double secondTotalThroughputWFCycle_MB = 0;

        long iterations = parameters.numberOfIterations;

        if (isAll) {
            ThroughputWrapper throughputWrapper;
            if (_isFirstOperationInitialized) {
                throughputWrapper =
                        printAllOutput(firstOperation, firstOperationTimeOfEachTread, parameters.firstOpRangeTo - parameters.firstOpRangeFrom);

                _firstOperationAverageTotalTime = throughputWrapper.getOperationAverageTotalTime();
                _firstAverageThroughput = throughputWrapper.getAverageThroughput();
                _firstTotalThroughput = throughputWrapper.getTotalThroughput();
            }
            if (_isSecondOperationInitialized) {
                throughputWrapper =
                        printAllOutput(secondOperation, secondOperationTimeOfEachThread, parameters.secondOpRangeTo - parameters.secondOpRangeFrom);

                _secondOperationAverageTotalTime = throughputWrapper.getOperationAverageTotalTime();
                _secondAverageThroughput = throughputWrapper.getAverageThroughput();
                _secondTotalThroughput = throughputWrapper.getTotalThroughput();
            }
            if (_isThirdOperationInitialized) {
                throughputWrapper =
                        printAllOutput(thirdOperation, thirdOperationTimeOfEachThread, parameters.secondOpRangeTo - parameters.secondOpRangeFrom);

                _thirdOperationAverageTotalTime = throughputWrapper.getOperationAverageTotalTime();
                _thirdAverageThroughput = throughputWrapper.getAverageThroughput();
                _thirdTotalThroughput = throughputWrapper.getTotalThroughput();
            }
        } else {
            if (theOnlyOperation != 2) {
                final BenchmarkTestResult.Result result = benchTestResult.buildResult(firstOperation);

                iterations = parameters.firstOpRangeTo - parameters.firstOpRangeFrom;
                // time for write for each thread
                for (int threadNumber = 0; threadNumber < parameters.threadCount; threadNumber++) {
                    //  used only when repeatfirst > 1
                    if (parameters.writeRepeatTimes > 1) {
                        threadFirstOperationTimeWFCycle =
                                firstOperationTimeOfEachThreadWFCycle.get(threadNumber);

                        threadThroughputWFCycle =
                                (1000 * iterations * (parameters.writeRepeatTimes - 1)) / threadFirstOperationTimeWFCycle;

                        firstTotalThroughputWFCycle += threadThroughputWFCycle;
                    }

                    //this if condition prevents java.lang.IndexOutOfBoundsException in the case of Stop benchmark
                    if (threadNumber < firstOperationTimeOfEachTread.size()) {

                        threadFirstOperationTime =
                                firstOperationTimeOfEachTread.get(threadNumber);

                        if (threadFirstOperationTime != 0) {
                            // in msg/sec
                            threadThroughput = (1000.0 * iterations) / threadFirstOperationTime;

                            _firstTotalThroughput += threadThroughput;

                            say(firstOperation + " " + mode + " for thread " +
                                    threadNumber + ": TP = " + benchFormat.format(threadThroughput) +
                                    " msg/sec , TEST TIME = " + threadFirstOperationTime + " ms");

                            result.addThreadResult(threadThroughput, threadFirstOperationTime);

                            _firstOperationAverageTotalTime += threadFirstOperationTime;
                        }
                    }
                }

                _firstOperationAverageTotalTime /= parameters.threadCount;

                say("----------------- " + firstOperation + " " + mode + " SUMMARY ---------------------");

                say(firstOperation + " " + mode + " AVG   TEST TIME  for all threads = " +
                        benchFormat.format(_firstOperationAverageTotalTime) + " ms");

                result.setAverageDuration(_firstOperationAverageTotalTime);

                _firstAverageThroughput = _firstTotalThroughput / parameters.threadCount;

                say(firstOperation + " " + mode + " AVG   TP for all threads = " +
                        benchFormat.format(_firstAverageThroughput) + " msg/sec");

                result.setAverageThroughput(_firstAverageThroughput);

                //used -repeatfirst
                if (parameters.writeRepeatTimes > 1) {
                    firstAverageThroughputWFCycle = firstTotalThroughputWFCycle / parameters.threadCount;

                    say(firstOperation + " " + mode + " AVG   TP WITHOUT FIRST CYCLE for all threads = " +
                            benchFormat.format(firstAverageThroughputWFCycle) + " msg/sec");
                }

                // in MB/sec
                firstTotalThroughput_MB = (_firstTotalThroughput * parameters.messageBuf.length) / (1024 * 1024);

                say(firstOperation + " " + mode + " TOTAL TP for all threads = " +
                        benchFormat.format(_firstTotalThroughput) + " msg/sec , " +
                        benchFormat.format(firstTotalThroughput_MB) + " MB/sec");

                result.setTotalThroughput(_firstTotalThroughput);

                if (parameters.writeRepeatTimes > 1) {
                    // in MB/sec
                    firstTotalThroughputWFCycle_MB = (firstTotalThroughputWFCycle * parameters.messageBuf.length) / (1024 * 1024);

                    say(firstOperation + " " + mode + " TOTAL TP WITHOUT FIRST CYCLE for all threads = " +
                            benchFormat.format(firstTotalThroughputWFCycle) + " msg/sec , " +
                            benchFormat.format(firstTotalThroughputWFCycle_MB) + " MB/sec");
                }

                say("-------------------------------------------------------------\n");
            }

            if (parameters.isRandom) {
                iterations = parameters.numberOfRandomIterations;
            }

            iterations = parameters.secondOpRangeTo - parameters.secondOpRangeFrom;
            if (theOnlyOperation != 1) {
                final BenchmarkTestResult.Result result = benchTestResult.buildResult(secondOperation);

                int secondOperationListSize = secondOperationTimeOfEachThreadWFCycle.size();
                // time for read/take for each thread
                for (int threadNumber = 0; threadNumber < parameters.threadCount; threadNumber++) {

                    // used only when repeatsecond > 1
                    if (parameters.readRepeatTimes > 1 && threadNumber < secondOperationListSize) {
                        threadSecondOperationTimeWFCycle =
                                secondOperationTimeOfEachThreadWFCycle.get(threadNumber).longValue();

                        threadThroughputWFCycle =
                                (1000 * iterations * (parameters.readRepeatTimes - 1)) / threadSecondOperationTimeWFCycle;

                        secondTotalThroughputWFCycle += threadThroughputWFCycle;
                    }
                    //this if condition prevents java.lang.IndexOutOfBoundsException in the case of Stop benchmark
                    if (threadNumber < secondOperationTimeOfEachThread.size()) {
                        threadSecondOperationTime =
                                secondOperationTimeOfEachThread.get(threadNumber);

                        // in msg/sec
                        if (threadSecondOperationTime != 0)
                            threadThroughput = (1000.0 * iterations * parameters.readRepeatTimes) / threadSecondOperationTime;

                        _secondTotalThroughput += threadThroughput;

                        say(secondOperation + " " + mode + " for thread " +
                                threadNumber + ": TP = " + benchFormat.format(threadThroughput) +
                                " msg/sec , TEST TIME = " + threadSecondOperationTime + " ms");

                        result.addThreadResult(threadThroughput, threadSecondOperationTime);

                        _secondOperationAverageTotalTime += threadSecondOperationTime;
                    }
                }

                _secondOperationAverageTotalTime /= parameters.threadCount;

                say("----------------- " + secondOperation + " " + mode + " SUMMARY ---------------------");

                say(secondOperation + " " + mode + " AVG   TEST TIME  for all threads = " +
                        benchFormat.format(_secondOperationAverageTotalTime) + " ms");

                result.setAverageDuration(_secondOperationAverageTotalTime);

                _secondAverageThroughput = _secondTotalThroughput / parameters.threadCount;

                say(secondOperation + " " + mode + " AVG   TP for all threads = " +
                        benchFormat.format(_secondAverageThroughput) + " msg/sec");

                result.setAverageThroughput(_secondAverageThroughput);

                if (parameters.readRepeatTimes > 1) {
                    secondAverageThroughputWFCycle = secondTotalThroughputWFCycle / parameters.threadCount;

                    say(secondOperation + " " + mode + " AVG   TP WITHOUT FIRST CYCLE for all threads = " +
                            benchFormat.format(secondAverageThroughputWFCycle) + " msg/sec");
                }

                // in MB/sec
                secondTotalThroughput_MB = (_secondTotalThroughput * parameters.messageBuf.length) / (1024 * 1024);

                say(secondOperation + " " + mode + " TOTAL TP for all threads = " +
                        benchFormat.format(_secondTotalThroughput) + " msg/sec , " +
                        benchFormat.format(secondTotalThroughput_MB) + " MB/sec");

                result.setTotalThroughput(_secondTotalThroughput);

                if (parameters.readRepeatTimes > 1) {
                    // in MB/sec
                    secondTotalThroughputWFCycle_MB = (secondTotalThroughputWFCycle * parameters.messageBuf.length) / (1024 * 1024);

                    say(secondOperation + " " + mode + " TOTAL TP WITHOUT FIRST CYCLE for all threads = " +
                            benchFormat.format(secondTotalThroughputWFCycle) + " msg/sec , " +
                            benchFormat.format(secondTotalThroughputWFCycle_MB) + " MB/sec");
                }

                say("-------------------------------------------------------------\n");
            }
        }
    }


    public void retrieveOperationTimeOfEachTread() {
        firstOperationTimeOfEachTread = new ArrayList<Long>();
        firstOperationTimeOfEachThreadWFCycle = new ArrayList<Long>();
        secondOperationTimeOfEachThread = new ArrayList<Long>();
        secondOperationTimeOfEachThreadWFCycle = new ArrayList<Long>();
        thirdOperationTimeOfEachThread = new ArrayList<Long>();
        int i = 1; //(i++)
        for (Operation op : threads.values()) {
            if (op != null) {
                long value = op.getResultTime();

                if ((i <= parameters.threadCount) && (theOnlyOperation != 2)) {
                    firstOperationTimeOfEachTread.add(value);

                    if (parameters.writeRepeatTimes > 1) {
                        long valueWFCycle = op.getResultTimeWFCycle();
                        firstOperationTimeOfEachThreadWFCycle.add(valueWFCycle);
                    }
                } else if (i <= parameters.threadCount * 2) {
                    secondOperationTimeOfEachThread.add(value);

                    if (parameters.readRepeatTimes > 1) {
                        long valueWFCycle = op.getResultTimeWFCycle();
                        secondOperationTimeOfEachThreadWFCycle.add(valueWFCycle);
                    }
                } else {
                    thirdOperationTimeOfEachThread.add(value);
                }
            }
            i++;
        }
    }


    public void doPerformanceTest() throws InterruptedException {
        int first = 0;
        int last = parameters.threadCount;


        countEntries();

        initialTestTime = System.currentTimeMillis();
        boolean twoOperations = false;

        // isParallel = false
        if (isAll && !parameters.isParallel) {
            say("Initializing " + firstOperation + " " + mode + " threads...");
            createFirstOperationThreads();

            say("Starting     " + firstOperation + " " + mode + " threads...");
            startThreads(0, parameters.threadCount);

            say("Running      " + firstOperation + " " + mode + " threads...");
            joinThreads(0, parameters.threadCount);

            say("Initializing " + secondOperation + " " + mode + " threads...");
            createSecondOperationThreads(twoOperations);

            say("Starting     " + secondOperation + " " + mode + " threads...");
            startThreads(parameters.threadCount, parameters.threadCount * 2);

            say("Running      " + secondOperation + " " + mode + " threads...");
            joinThreads(parameters.threadCount, parameters.threadCount * 2);

            say("Initializing " + thirdOperation + " " + mode + " threads...");
            createThirdOperationThreads();

            say("Starting     " + thirdOperation + " " + mode + " threads...");
            startThreads(parameters.threadCount * 2, parameters.threadCount * 3);

            say("Running      " + thirdOperation + " " + mode + " threads...");
            joinThreads(parameters.threadCount * 2, parameters.threadCount * 3);
        } else if (!parameters.isParallel) {
            if (theOnlyOperation != 2) {
                say("Initializing " + firstOperation + " " + mode + " threads...");

                createFirstOperationThreads();
                twoOperations = true;

                say("Starting     " + firstOperation + " " + mode + " threads...");
                startThreads(0, parameters.threadCount);

                say("Running      " + firstOperation + " " + mode + " threads...");
                joinThreads(0, parameters.threadCount);
            }

            if (theOnlyOperation != 1) {
                if (theOnlyOperation == 0) {
                    first = parameters.threadCount;
                    last = parameters.threadCount * 2;
                }

                say("Initializing " + secondOperation + " " + mode + " threads...");
                createSecondOperationThreads(twoOperations);

                say("Starting     " + secondOperation + " " + mode + " threads...");
                startThreads(first, last);

                say("Running      " + secondOperation + " " + mode + " threads...");
                joinThreads(first, last);
            }
        } else // isParalell = true
        {
            if (!isAll) {
                say("Initializing " + firstOperation + " " + mode + " threads...");
                createFirstOperationThreads();
                say("Initializing " + secondOperation + " " + mode + " threads...");
                //createSecondOperationThreads();
                createSecondOperationThreads(twoOperations);

                say("Starting     " + firstOperation + " and " + secondOperation + " " + mode + " threads...");
                startThreads(0, parameters.threadCount * 2);

                say("Running      " + firstOperation + " and " + secondOperation + " " + mode + " threads...");
                joinThreads(0, parameters.threadCount * 2);
            } else    //isALL && isParallel
            {
                say("Initializing " + firstOperation + " " + mode + " threads...");
                createFirstOperationThreads();

                say("Initializing " + secondOperation + " " + mode + " threads...");
                //createSecondOperationThreads();
                createSecondOperationThreads(twoOperations);

                say("Initializing " + thirdOperation + " " + mode + " threads...");
                createThirdOperationThreads();

                say("Starting     " + firstOperation + ", " + secondOperation + " and " + thirdOperation + " " + mode + " threads...");
                startThreads(0, parameters.threadCount * 3);

                say("Running      " + firstOperation + ", " + secondOperation + " and " + thirdOperation + " " + mode + " threads...");
                joinThreads(0, parameters.threadCount * 3);
            }
        }

        finalTestTime = System.currentTimeMillis();

        countEntries();

        retrieveOperationTimeOfEachTread();

    }

    //close all dired objects, in our case for Notify operation NotifyDelegator closed
    //in the feature Operation class should have abstract method close() that each extend
    //class will be implement
    private void closeObjects() {
        for (Iterator operations = threads.values().iterator(); operations.hasNext(); ) {
            Operation operation = (Operation) operations.next();
            if (operation instanceof Notify) {
                ((Notify) operation).close();
            } else if (operation instanceof JMSNotify) {
                ((JMSNotify) operation).close();
            }
        }
    }

    /**
     * Method execute will produce statistic data concerning operations with Java space.
     *
     * @param args - The switch option\s given by the user
     * @param out  - PrintWriter argument
     */
    public boolean execute(Map args, PrintWriter out, IJSpace theSpace,
                           IMap theCache, BenchmarkOutput benchmarkOutput) throws BenchmarkCommandException {
        if (initInputConfigurationParameters(args, out, theSpace, theCache, benchmarkOutput)) {
            try {
                printConfigurationMessages(args);

                if (isParametersValid()) {

                    doPerformanceTest();

                    computeAveragePerformanceTime();

                    printTotalTestTime();

                    if (resultFileName != null) {
                        BenchmarkCommandReport report = new BenchmarkCommandReport(this);
                        report.outDebugInfo(resultFileName);
                    }

                }
            } catch (Exception ex) {
                ex.printStackTrace();
                benchTestResult.setException(ex);
                return true;
            } finally {
                closeObjects();
            }
        }

        return parameters.isExit;

    }

    private boolean isParametersValid() {
        if (parameters.isMultiple && isMap) {
            say(JSpaceUtilities.LINE_SEPARATOR +
                    "Multiple operation is not supported for Space Map API." +
                    JSpaceUtilities.LINE_SEPARATOR);

            return false;
        }

        return true;
    }


    /**
     * Method execute will produce statistic data concerning operations with Java space.
     *
     * @param args - The switch option\s given by the user
     * @param out  - PrintWriter argument
     **/
    public boolean execute(Map args, PrintWriter out) throws BenchmarkCommandException {
        return execute(args, out, null, null, benchmarkOutput);
    }


    /**
     * Clears JavaSpace.
     */
    public void cleanJavaSpace(IJSpace space)
            throws RemoteException, UnusableEntryException, TransactionException, InterruptedException {
        while (space.take(null, null, Long.MAX_VALUE) != null) ;
    }

	/*
    public void outDebugInfo( String k )
		throws FileNotFoundException
	{
		FileOutputStream fileOut = null;
		PrintStream ps           = null;

		fileOut = new FileOutputStream( "test_" + resultFileName, true );
		ps = new PrintStream( fileOut );

		if( parameters.isThreadThroughput )
		{
			printConfig( ps );
		    write2FileEachThreadThroughput( ps );
		}

		if( parameters.isGlobalThroughput )
		{
			printConfig( ps );
		    write2FileEachOperationGlobalThroughput( ps );
		}

		ps.close();
	}
	*/

    public void printConfig(PrintStream ps) {
        try {
            ps.println("Space Config Info\t");
            ps.print("---------------------------\t");

            IJSpace space = (IJSpace) SpaceFinder.find(parameters.spaceURL);
            IRemoteJSpaceAdmin admin = (IRemoteJSpaceAdmin) space.getAdmin();
            SpaceConfig config = admin.getConfig();
            ClusterPolicy clusterPolicy = admin.getClusterPolicy();
            String configStr = "";
            configStr += "\nPersistent:\t" + (config.isPersistent());

            configStr += "\nserializationType:\t" + config.getSerializationType();
            configStr += "\nMemoryUsageEnabled:\t" + config.isEngineMemoryUsageEnabled();
            configStr += "\nisClustered:\t" + config.isClustered();
            configStr += "\ncachePolicy :\t" + config.getCachePolicy();
            if (Boolean.valueOf(config.isClustered()).booleanValue()) {
                configStr += "\nReplicationChunkSize:\t" + clusterPolicy.m_ReplicationPolicy.m_ReplicationChunkSize;
                configStr += "\nReplicationIntervalMillis:\t" + clusterPolicy.m_ReplicationPolicy.m_ReplicationIntervalMillis;
                configStr += "\nReplicationIntervalOperations:\t" + clusterPolicy.m_ReplicationPolicy.m_ReplicationIntervalOperations;
                configStr += "\nSyncOnCommit:\t" + clusterPolicy.m_ReplicationPolicy.m_SyncOnCommit;
                configStr += "\nReliable:\t" + clusterPolicy.m_ReplicationPolicy.isReliableAsyncRepl();
            }
            ps.println(configStr + "\n");
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }


    /**
     * Method usage functions as a help file.
     *
     * @param out - PrintWriter
     */
    public void usage(PrintWriter out) {

        System.out.println("\n\n-------------------------------------------------------");
        System.out.println("\t GigaSpaces Benchmark v" + BenchmarkVersion.VERSION + " Help");
        System.out.println("\n-------------------------------------------------------\n\n");

        System.out.println("Usage: BenchmarkTest [space url] <options>");
        System.out.println("where 'space url' is in the form of protocol://[host]:<port>/[container name]/[space name]\n");
        System.out.println("Option arguments in square brackets [] are required;\nOption arguments in triangular brackets <> are optional.\n");

        //SETUP
        System.out.println("\nSetup:");
        System.out.println("---------");

        String adaptorsUsage = "";
        MessageAdaptor[] adaptors = MessageAdaptors.getMessageAdaptors();
        for (MessageAdaptor adaptor : adaptors)
            adaptorsUsage += "\t" + adaptor.getName() + " - " + adaptor.getDescription() + "\n" + adaptor.getUsageInfo() + "\n\n";

        addUsage("-" + KEY_MESSAGE_TYPE, "Defines the object type that will be written " +
                "to the space. " +
                "\n\tUsage: " + "-" + KEY_MESSAGE_TYPE + " " + MessageAdaptors.getByCode((short) 1).getName() +
                "\n\n\tOther possible values are: \n\n  " + adaptorsUsage);


        addUsage("-clean", "Clean space before benchmark starts");

        addUsage("-url [url]", "Connection url; If none provided the one defined as part of the script file will be used");
        addExample("-url", "-url jini://localhost/container/space", "protocol://[host]:<port>/[container name]/[space name]");

        addUsage("-f [FileName]", "dump results into file. Works with -showrate option. Default File name is BenchMarkResult{Date}_{Time}.");
        addExample("-f", "-f resultsfile.xsl -showrate", "dump results into resultsfile.xsl");

        addUsage("-pause", "Pauses once connection with space is established.");
        addUsage("-exit", "Benchmark will hang once finished. When used with embedded space, space will still be alive.");

        showUsage();

        //OPERATIONS
        System.out.println("\nOperations:");
        System.out.println("-------------");
        addUsage("-write", "perform first operation as write/put");
        addUsage("-read", "perform second operation as read/get");
        addUsage("-update", "perform second operation as update (with uid)");
        addUsage("-take", "perform second/third operation as take/remove");
        addUsage("-all", "perform all operations - first, second and then third");
        addUsage("-execute [ first/second ]", "enables execution of only first or second operation.");
        addExample("-execute", "-execute first", "will perform only write/put operations");
        addExample("-execute", "-execute second", "will perform only read operations");
        addExample("-execute", "-execute second -take", "will perform only take operations");
        addUsage("-bench", "perform first-*second-second-third operation with uid");
        addExample("-bench", "-bench -map", "will perform put,put(update),get,remove with uid");
        addExample("-bench", "-bench", "will perform write,update,read,take with uid");


        showUsage();


        //OPTIONS
        System.out.println("\nOptions:");
        System.out.println("----------");
        addUsage("-i <number of iterations>", "number of iterations; default is 1000");

        addUsage("-" + KEY_LEASE_TIME + " [time in ms]", "lease timeout in milliseconds of the write/put operation");
        addExample("-" + KEY_LEASE_TIME, "-i 1000 -" + KEY_LEASE_TIME +
                " 20000 -execute first", "perform 1st operation with entry lease of 2 sec");

        addUsage("-t [time in ms]", "timeout in milliseconds of the read/take/get/remove operations");
        addExample("-t", "-i 1000 -t 20000 -execute second", "perform 2nd operation with timeout of 2 sec");

        addUsage("-s [size in bytes]", "set byte size of the entry object.");
        addExample("-s", "-s 1000", "define 1K size entries each");

        addUsage("-content", "changes the content value each iteration");
        addExample("-content", "-i 1000 -content -s 1000", "defines an entry with a changing content of 1K");

        addUsage("-tr [number of threads]", "number of threads performing each operation");
        addExample("-tr", "-i 1000 -tr 4", "will perform 1000 iterations by each of the 4 threads");

        addUsage("-rangefirst [from-to]", "will perform first operation with ids/keys between range");
        addExample("-rangefirst", "-rangefirst 1000-2000", "will write/put ids/keys from 1000 to 2000");

        addUsage("-rangesecond [from-to]", "will perform second operation with ids/keys between range");
        addExample("-rangesecond", "-rangesecond 1000-2000", "will read/take/get/remove ids/keys from 1000 to 2000");

        addUsage("-repeatfirst [repeats]", "repeat times of first operation");
        addExample("-repeatfirst", "-i 1000 -repeatfirst 10", "will write/put 10 times 1000 entries");

        addUsage("-repeatsecond [repeats]", "repeat times of second operation");
        addExample("-repeatsecond", "-i 1000 -repeatsecond 10", "will read/get or take/remove 10 times 1000 entries");

        addUsage("-m [batch size]", "specifies the batch size when performing batch operations");
        addExample("-m", "-m 100 -i 1000", "will use 10 batches of 100 to perform operations on 1000 entries.");

        addUsage("-rand <number of iterations>", "will randomize second operation ids/keys in a range; default is by -i");
        addExample("-rand", "-i 1000 -rand", "will randomize second operation ids/keys from 0 to 1000");
        addExample("-rand", "-i 10000 -rand 40000", "will randomize between ids/keys in the range of 0-40000");
        addExample("-rand", "-rangesecond 10000-25000 -rand", "will randomize between 10000-25000");

        addUsage("-tx [nth-iteration]", "tx will be committed every nth-iteration; if zero, as specified by -i");
        addUsage("-delaywrite [t ms]", "delays first operation every t milliseconds");
        addUsage("-delayreadtake [t ms]", "delays second & third operation every t milliseconds");

        addUsage("-writerate [Max Rate msg/sec]", "will limit the first operation rate (msg in 1 second) for all threads");
        addExample("-writerate", "-i 100000 -writerate 50000 -tr 4", "4 threads will write 100000 entries each with a maximum TP rate of 50000 msg/sec");

        addUsage("-notify", "registers for notifications on all events");
        addExample("-notify", "-notify -i 1000 -tr 5", "will start 5 threads that will write and notify 1000 entries");

        addUsage("-parallel", "parallel execution of the operations");
        addExample("-parallel", "-parallel -i 1000 -tr 5", "will start 5 parallel threads, each performing 1000 operations");

        addUsage("-" + KEY_USE_SINGLE_SPACE_PROXY,
                "This parameter indicates if operation will be performed using a single direct space proxy (and not clustered proxy) ");
        addExample("-" + KEY_USE_SINGLE_SPACE_PROXY, "-" + KEY_USE_SINGLE_SPACE_PROXY +
                        " -i 100000",
                "will write 100000 objects to specific single cluster space");

        addUsage("-" + KEY_IS_RETURN_LEASE, "This parameter indicates if write operation will return a lease object");
        addExample("-" + KEY_IS_RETURN_LEASE, "-" + KEY_IS_RETURN_LEASE +
                        " -i 100000",
                "will write 100000 objects with returning Lease object");


        showUsage();

        //Transactions
        System.out.println("\nTransactions:");
        System.out.println("--------------");
        addUsage("-" + KEY_TX + " 2000 ", "Perform operation under local transaction, commit every 2000 operations.");
        addUsage("-" + KEY_DTX + " 1000 ", "Perform operation under distributed transaction, commit every 1000 operations.");
        addExample("-" + KEY_DTX_MANAGER_URL, "-" + KEY_DTX + " 1000 " + KEY_DTX_MANAGER_URL + " thunder1:3733",
                "Use distributed transaction. Commit every 1000 operations." +
                        "Transaction Manager registered on LUS that is running on machine thunder1:3733");
        showUsage();

        //TOPOLOGIES
        System.out.println("\nTopologies:");
        System.out.println("-------------");
        addUsage("-cache", "Turn on local cache mode; default is false");
        addExample("-cache", "-cache", "will use local cache to remote space.");

        addUsage("-map", "Map API - first/second/third operations as: put, get, remove.");
        addExample("-map", "-map -all -i 1000", "will put/get/remove 1000 entries.");

        addUsage("-map -cache", "Map API with local cache.");
        addExample("-map", "-map -cache -i 1000 -repeatsecond 4", "will put 1000 entries, first get from space, successive gets from local cache.");

        addUsage("-target [space name]", "Space name to perform second operations on (in a cluster configuration)");
        addExample("-target", "-target jini://host:port/container/space_name", "will perform second operation this target space");

        addUsage("-hashtable", "use java.util.Hashtable API-  first/second/third operations as: put,get, remove");

        showUsage();

        //STATISTICS
        System.out.println("\nStatistics:");
        System.out.println("-------------");
        addUsage("-showrate <iteration cycle>", "global throughput will be displayed every iteration cycle; default is 1000");
        addExample("-showrate", "-showrate 10000", "will show TP every 10000 iterations");

        addUsage("-showthreadrate <iteration cycle>", "thread throughput will be displayed every iteration cycle; default is 1000");
        addExample("-showthreadrate", "-showthreadrate 10000", "will show each thread-TP every 10000 iterations");

        addUsage("-stress [repeat times]", "runs the entire benchmark as many as 'repeat times' as stated");
        addExample("-stress", "-map -all -stress 10", "will run 10 cycles of map api put/get/remove");

        showUsage();

        System.out.println("\nExamples:");
        System.out.println("------------");

        showExamples();
    }

    //displays a formatted key-definition-example
    int _maxKeyLength = 0;
    private ArrayList<String> usageKey = new ArrayList<String>();
    private ArrayList<String> usageDef = new ArrayList<String>();

    private void addUsage(String key, String def) {
        _maxKeyLength = key.length() > _maxKeyLength ? key.length() : _maxKeyLength;
        usageKey.add(key);
        usageDef.add(def);
    }

    private final static String PADD = " ";
    private final static String TAB = "\t";

    private void showUsage() {
        String output;
        for (int i = 0; i < usageKey.size(); i++) {
            output = usageKey.get(i);
            int spread = _maxKeyLength - output.length();
            for (int p = 0; p < spread; p++) {
                output += PADD;
            }
            output += TAB + usageDef.get(i) + "\n";

            System.out.println(PADD + output);
        }

        usageKey.clear();
        usageDef.clear();
        _maxKeyLength = 0;
    }

    //displays a formatted example key-example
    int _maxExKeyLength;
    private ArrayList<String> examplesKey = new ArrayList<String>();
    private ArrayList<String> examplesEg = new ArrayList<String>();
    private ArrayList<String> exampleEx = new ArrayList<String>();

    private void addExample(String key, String example, String explain) {
        _maxExKeyLength = key.length() > _maxExKeyLength ? key.length() : _maxExKeyLength;
        examplesKey.add(key);
        examplesEg.add(example);
        exampleEx.add(explain);
    }

    private void showExamples() {
        String output;
        String padd;
        for (int i = 0; i < examplesKey.size(); i++) {
            int keyLength = examplesKey.get(i).length();
            output = examplesKey.get(i);
            int spread = _maxExKeyLength - keyLength;
            padd = "";
            for (int p = 0; p < spread; p++) {
                padd += PADD;
            }
            output += padd + TAB + examplesEg.get(i);

            for (int p = 0; p < keyLength; p++) {
                padd += PADD;
            }

            output += "\n" + padd + TAB + exampleEx.get(i) + "\n";

            System.out.println(output);
        }
    }

    public BenchmarkConfiguration getParameters() {
        return parameters;
    }

    public boolean isMap() {
        return isMap;
    }

    public boolean isUseDCache() {
        return isUseDCache;
    }

    public String getFirstOperation() {
        return firstOperation;
    }

    public String getSecondOperation() {
        return secondOperation;
    }

    public String getThirdOperation() {
        return thirdOperation;
    }

    public boolean isFirstOperationInitialized() {
        return _isFirstOperationInitialized;
    }

    public boolean isSecondOperationInitialized() {
        return _isSecondOperationInitialized;
    }

    public boolean isThirdOperationInitialized() {
        return _isThirdOperationInitialized;
    }

    private class ThroughputWrapper {
        private double _operationAverageTotalTime;
        private double _averageThroughput;
        private double _totalThroughput;

        ThroughputWrapper(double operationAverageTotalTime,
                          double averageThroughput,
                          double totalThroughput) {
            _operationAverageTotalTime = operationAverageTotalTime;
            _averageThroughput = averageThroughput;
            _totalThroughput = totalThroughput;
        }

        public double getOperationAverageTotalTime() {
            return _operationAverageTotalTime;
        }

        public double getAverageThroughput() {
            return _averageThroughput;
        }

        public double getTotalThroughput() {
            return _totalThroughput;
        }
    }
}
