package com.j_spaces.examples.benchmark;

import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;

import net.jini.core.lease.Lease;
import net.jini.core.transaction.server.TransactionManager;

import com.j_spaces.core.IJSpace;
import com.j_spaces.map.IMap;


public class BenchmarkConfiguration {
    public int stressRepeatTimes = 1;
    public boolean isStress;
    public boolean isRandom;
    public boolean isNotify;
    public boolean isUpdate;
    public boolean isBench;
    public boolean isSingleTransaction;

    public String spaceURL;
    public String repSpaceURL;
    public IJSpace space;
    public IMap cache;
    public IMap repCache;
    public IJSpace repSpace;
    public TransactionManager spaceTransactionManager;
    public TransactionManager repSpaceTransactionManager;

    public int delayWrite;
    public int delayReadTake;
    public boolean isWriteRate;
    public int writeRate;
    protected AtomicInteger globalRateIter;
    protected long globalInitialRateTime;

    // The number of times a read/take pair will be performed
    public int numberOfIterations = 1000;

    // first and second iterations i=From..i<To
    public boolean firstOpRange;
    public boolean secondOpRange;
    public int firstOpRangeFrom;
    public int firstOpRangeTo;
    public int secondOpRangeFrom;
    public int secondOpRangeTo;
    public int numOfBatches;
    public int batchAmount;

    // The number of random read/take operations
    public int numberOfRandomIterations = numberOfIterations;

    // The length of the message that will be read/write
    public int messageLength = 100;

    // The timeout for this action
    public long timeout;

    // The lease for this action
    public long lease = Lease.FOREVER;
    public int txIterations;

    // The number of read times
    public long readRepeatTimes = 1;
    public long writeRepeatTimes = 1;

    // thread count
    public int threadCount = 1;

    // The bytes number of the message
    public byte[] messageBuf = new byte[messageLength];
    public boolean isMultiple;

    // DCache mode may be standard or light
    public String dCacheMode;
    public boolean isParallel;
    public short messageType;

    // use single operation
    public boolean isOnly;
    public boolean isAll;
    final static public boolean debug = Boolean.valueOf((System.getProperty("com.gs.debug", "false")));

    public boolean isExit;

    // variables for global throughput calculations
    public boolean isGlobalThroughput;
    public int globalThroughputIterations = 1000;
    public AtomicInteger globalThroughputFirstOperationCounter;
    public AtomicInteger globalThroughputSecondOperationCounter;
    public AtomicInteger globalThroughputThirdOperationCounter;
    public long globalThroughputFirstInitialTime;
    public long globalThroughputFirstFinalTime;
    public long globalThroughputSecondInitialTime;
    public long globalThroughputSecondFinalTime;
    public long globalThroughputThirdInitialTime;
    public long globalThroughputThirdFinalTime;
    public LinkedList<Double> globalThroughputFirstList;
    public LinkedList<Double> globalThroughputSecondList;
    public LinkedList<Double> globalThroughputThirdList;
    final static public DecimalFormat decFormat = new DecimalFormat("0.000");

    // per thread
    public boolean isThreadThroughput;
    public long threadThroughputIterations = 1000;
    public boolean changeContent;

    //adds
    public boolean isGUI;

    //default timeout value in ms., now its 60 sec
    public final static long DEFAULT_TIMEOUT_VALUE = 60000;


    public boolean isCleanSpace;
    public boolean isUseSingleSpaceProxy;
    public boolean isReturnLease;
    public short transactionType = -1;

    final static public short TRANSACTION_TYPE_LOCAL = 1;
    final static public short TRANSACTION_TYPE_DISTRIBUTED = 2;


    public BenchmarkConfiguration(String url) {
        spaceURL = url;
    }

    public MessageAdaptor getMessageAdaptor() {
        return MessageAdaptors.getByCode(messageType);
    }
}
