package com.j_spaces.examples.benchmark;

import java.io.PrintStream;

import java.io.PrintWriter;
import java.util.Map;

import com.j_spaces.core.IJSpace;
import com.j_spaces.map.IMap;

/**
 * Main class BenchmarkTest This class provide a command line interface wrapper on the benchmark
 * utility.
 */
public class BenchmarkTest {
    // The valid options
    private static OptionHandler option = new OptionHandler(
            "i,s,t,h,read,take,tx,tr," +
                    "map,m,cache,repeatfirst,repeatsecond,target,rand," +
                    "delayreadtake,delaywrite,clean," +
                    "notify,parallel,execute,showrate," +
                    "exit,showthreadrate,hashtable," +
                    "externalentry,all," +
                    "pause,rangefirst,rangesecond,writerate," +
                    "content, stress, f, url,update,bench," +
                    "dtx,file,results,gui," +
                    BenchmarkCommand.KEY_LEASE_TIME + "," +
                    BenchmarkCommand.KEY_IS_RETURN_LEASE + "," +
                    BenchmarkCommand.KEY_USE_SINGLE_SPACE_PROXY + "," +
                    BenchmarkCommand.KEY_MESSAGE_TYPE + "," +
                    BenchmarkCommand.KEY_DTX_MANAGER_URL);

    private BenchmarkTestResult benchTestResult = new BenchmarkTestResult();
    private BenchmarkCommand bc;

    public static void main(String[] args) {
        if (args.length < 1) {
            BenchmarkCommand bc = new BenchmarkCommand(null, null, null);
            bc.usage(new PrintWriter(System.out));

            System.exit(1);
        } else {
            new BenchmarkTest(args);
        }
    }

    public BenchmarkTest() {
    }

    public BenchmarkTest(String[] args) {
        try {
            // Initialize constructor
            boolean isExit = false;
            int repeats;
            int repeatCount = 0;

            Map<String, String> argsToOptions = option.getOptions(args);

            benchTestResult.setInputArguments(argsToOptions);

            do {
                argsToOptions.put(BenchmarkCommand.KEY_MESSAGE_TYPE, String.valueOf(MessageAdaptors.CODE_POJO));
                BenchmarkCommand cs = new BenchmarkCommand(args[0], repeatCount, null, null, benchTestResult, null);
                isExit = cs.execute(argsToOptions, new PrintWriter(System.out));

                repeats = cs.getParameters().stressRepeatTimes;
                ++repeatCount;
                if (repeats > 1) {
                    printNextRound(repeatCount, repeats);
                }

            } while (repeatCount < repeats);

            if (isExit) {
                System.out.println("Benchmark Done! - Press Enter To Exit!");
                try {
                    System.in.read();
                } catch (Exception e) {
                }
                System.exit(0);
            }
        } catch (BenchmarkCommandException ex) {
            benchTestResult.setException(ex);
            System.out.println(ex.toString());
        }
    }

    public BenchmarkTestResult getBenchmarkTestResult() {
        return benchTestResult;
    }

    public void stop() {
        bc.stopAllThreads();
    }

    public int runBenchmark(String[] args, PrintStream out, IJSpace theSpace, IMap theCache, BenchmarkListener manager, BenchmarkOutput benchmarkOutput) {

        int retValue = 0;

        try {
            if (args.length < 1) {
                bc = new BenchmarkCommand(benchmarkOutput, benchTestResult, manager);

                //bc.usage(out);

                retValue = 1;
            } else {
                // Initialize constructor
                bc = new BenchmarkCommand(args[0], 0, out, benchmarkOutput, benchTestResult, manager);

                boolean isExit = bc.execute(option.getOptions(args), null/*out*/, theSpace, theCache, benchmarkOutput);

                if (isExit) {
                    System.out.println("Done benchmark!");
//                    GigaBenchmark.getGUI().onStopTest();
                    retValue = 0;
                }
            } /* else */
        } catch (Exception ex) {
            benchTestResult.setException(ex);
            out.println(ex.toString());

            if (manager == null) //when usage is other than through UI
                throw new RuntimeException(ex);
        } finally {
            if (manager != null)
                manager.onStopTest();
        }

        return retValue;
    }

    private static void printNextRound(int repeatCount, int repeats) {
        System.out.println("\n--------------------------------------------\n" +
                " - Stress Repeat:\n" +
                "  - End Round " + repeatCount + "  of " + repeats);

        System.out.print("  - Starting garbage collector... \n\t");
        long time = System.currentTimeMillis();
        System.gc();
        time = System.currentTimeMillis() - time;
        System.out.print("[ DONE ] in " + time + " ms");
        System.out.println("\n____________________________________________\n");
    }
}
