package com.j_spaces.examples.benchmark;

/**
 * <pre>
 * Versions are denoted using a standard triplet of integers: MAJOR.MINOR.PATCH.
 * The basic intent is that:
 * <li>MAJOR versions are sync with GigaSpaces API version. </li>
 * <li>MINOR versions are incremented upon enhancements/features in Benchmark functionality.</li>
 * <li>PATCH level are incremented on each patch to the Benchmark functionality.</li>
 *
 * The major version number identifies the GigaSpaces API version.
 * Increments are based on the Platform version.
 *
 * The minor version number identifies enhancements/features to Benchmark functionality.
 * Increments to minor version set the patch version to zero.
 *
 * The patch version number identifies revisions.
 * Increments to patch number only.
 */
public final class BenchmarkVersion {

    /**
     * only benchmark version
     */
    public static final String VERSION = "0.2";
}
