package com.j_spaces.examples.benchmark;


public class Get extends Operation {
    private Object retObject;
    private IMapDriver map;

    // constructor
    Get(BenchmarkConfiguration parameters, int threadID, ObjectLock objLock, BenchmarkOutput benchmarkOutput) {
        super(parameters, threadID, objLock, benchmarkOutput);

        // Creates the distributed cache MAP Interface
        try {
            String mapDriver = System.getProperty(IMapDriver.MAP_DRIVER_PROP);
            if (mapDriver == null) {
                map = new MapDriver();
                map.init(parameters);
            } else {
                map = (IMapDriver) classForName(mapDriver);
                map.init(parameters);
            }
        } catch (Exception e) {
            e.printStackTrace();
            if (parameters.isGUI)
                benchmarkOutput.showException("Exception", e);
            else
                System.exit(-1);
        }
    }


    private String prepareKey(int iter) {
        if (parameters.isRandom) {
            return String.valueOf(randomCounter[rand_iter++]);
        }

        return String.valueOf(iter);
    }

    @Override
    public void prepare() {
        min_iter = threadID * parameters.numberOfIterations;

        max_iter = min_iter + parameters.numberOfIterations - 1;

        if (parameters.secondOpRange) {
            min_iter = parameters.secondOpRangeFrom;
            max_iter = parameters.secondOpRangeTo - 1;
        }

        if (parameters.isRandom) {
            if (!parameters.secondOpRange) {
                min_iter = 0;
                max_iter = parameters.numberOfRandomIterations - 1;
            }
            randomCounter = randomGenerator();
        }
    }

    @Override
    public void doOperation() {
        try {
            int globalTpCounter;
            for (int iter = min_iter; iter <= max_iter && BenchmarkCommand.START_STOP_FLAG; iter++) {
                String key = prepareKey(iter);
                retObject = map.get(key);

                if (retObject == null) {
                    if (parameters.isStress && parameters.isParallel)
                        if (!parameters.isAll)//no remove is involved
                            while (map.get(key) == null) ;
                        else
                            continue;
                    else
                        throw new Exception("Thread "
                                + Thread.currentThread().getName()
                                + " get NULL entry by GET operation of object");
                }

                if (parameters.isThreadThroughput) {
                    if (iter == min_iter) {
                        initialThreadThroughputTime = System.currentTimeMillis();
                    }

                    if ((iter + 1) % parameters.threadThroughputIterations == 0) {
                        printThreadThroughput(OPER_GET, (iter + 1));
                    }
                }

                //  print global throughput
                if (parameters.isGlobalThroughput) {
                    globalTpCounter = parameters.globalThroughputSecondOperationCounter.getAndIncrement();
                    if (globalTpCounter == 0) {
                        parameters.globalThroughputSecondInitialTime = System.currentTimeMillis();
                    }

                    if ((globalTpCounter + 1) %
                            parameters.globalThroughputIterations == 0) {
                        printGlobalOperationThroughput(OPER_GET, (globalTpCounter + 1));
                    }
                }
            }
        } catch (Exception ex) {
            System.out.println("Thread " + Thread.currentThread().getName()
                    + " failed to complete GET operation of object");

            ex.printStackTrace();
            if (parameters.isGUI)
                benchmarkOutput.showException("Exception", ex);
            else
                System.exit(-1);
        }
    }
}
