package com.j_spaces.examples.benchmark;

import java.util.Hashtable;

public class HashtablePut extends Operation {
    private Hashtable<String, Object> m_hashtable;
    private Object putEntry;

    // constructor
    HashtablePut(BenchmarkConfiguration parameters, int threadID, ObjectLock objLock, Hashtable<String, Object> hash, BenchmarkOutput benchmarkOutput) {
        super(parameters, threadID, objLock, benchmarkOutput);
        m_hashtable = hash;
    }


    private void prepareEntry(int iter) {
        // regular write
        parameters.getMessageAdaptor().setCounter(putEntry, iter);

        //different content per iteration
        if (parameters.changeContent)
            parameters.getMessageAdaptor().setPayload(putEntry, new byte[parameters.messageBuf.length]);
    }

    @Override
    public void prepare() {
        putEntry = parameters.getMessageAdaptor().create(-1, parameters.messageBuf);
        min_iter = threadID * parameters.numberOfIterations;
        max_iter = min_iter + parameters.numberOfIterations - 1;
    }

    @Override
    public void doOperation() {
        try {
            int globalTpCounter;
            for (int iter = min_iter; iter <= max_iter && BenchmarkCommand.START_STOP_FLAG; iter++) {
                prepareEntry(iter);
                m_hashtable.put(String.valueOf(iter), putEntry);

                // print thread throughput
                if (parameters.isThreadThroughput) {
                    if (iter == min_iter) {
                        initialThreadThroughputTime = System.currentTimeMillis();
                    }

                    if ((iter + 1) % parameters.threadThroughputIterations == 0) {
                        printThreadThroughput("HASHTABLE_PUT", (iter + 1));
                    }
                }

                //  print global throughput
                if (parameters.isGlobalThroughput) {
                    globalTpCounter = parameters.globalThroughputFirstOperationCounter.getAndIncrement();
                    if (globalTpCounter == 0) {
                        parameters.globalThroughputFirstInitialTime = System.currentTimeMillis();
                    }

                    if ((globalTpCounter + 1) %
                            parameters.globalThroughputIterations == 0) {
                        printGlobalOperationThroughput("HASHTABLE_PUT", (globalTpCounter + 1));
                    }
                }
            }
        } catch (Exception ex) {
            System.out.println("Thread " + Thread.currentThread().getName()
                    + " failed to complete HASHTABLE_PUT operation of entry");

            ex.printStackTrace();
            if (parameters.isGUI)
                benchmarkOutput.showException("Exception", ex);
            else
                System.exit(-1);
        }
    }
}
