package com.j_spaces.examples.benchmark;


import java.util.Hashtable;

public class HashtableRemove extends Operation {
    private Object retObject;
    private Hashtable<String, Object> m_hashtable;


    // constructor
    HashtableRemove(BenchmarkConfiguration parameters, int threadID,
                    ObjectLock objLock, Hashtable<String, Object> hash, BenchmarkOutput benchmarkOutput) {
        super(parameters, threadID, objLock, benchmarkOutput);

        retObject = null;

        if (parameters.repSpace != null) {
            space = parameters.repSpace;
        } else {
            space = parameters.space;
        }

        //creating newly Hashtable
        m_hashtable = hash;
    }


    private String prepareKey(int iter) {
        if (parameters.isRandom) {
            return String.valueOf(randomCounter[rand_iter++]);
        }

        return String.valueOf(iter);
    }


    public void prepare() {
        min_iter = threadID * parameters.numberOfIterations;

        max_iter = min_iter + parameters.numberOfIterations - 1;

        if (parameters.secondOpRange) {
            min_iter = parameters.secondOpRangeFrom;
            max_iter = parameters.secondOpRangeTo - 1;
        }

        if (parameters.isRandom) {
            if (!parameters.secondOpRange) {
                min_iter = 0;
                max_iter = parameters.numberOfRandomIterations - 1;
            }
            randomCounter = randomGenerator();
        }
    }


    public void doOperation() {
        try {
            int globalTpCounter;
            for (int iter = min_iter; iter <= max_iter && BenchmarkCommand.START_STOP_FLAG; iter++) {
                String key = prepareKey(iter);

                retObject = m_hashtable.remove(key);

                if (retObject == null) {
                    throw new Exception("Thread "
                            + Thread.currentThread().getName()
                            + " get NULL entry by HASHTABLE_REMOVE operation of object");
                }

                if (parameters.isThreadThroughput) {
                    if (iter == min_iter) {
                        initialThreadThroughputTime = System.currentTimeMillis();
                    }

                    if ((iter + 1) % parameters.threadThroughputIterations == 0) {
                        printThreadThroughput("HASHTABLE_REMOVE", (iter + 1));
                    }
                }

                //  print global throughput
                if (parameters.isGlobalThroughput) {
                    globalTpCounter = parameters.globalThroughputSecondOperationCounter.getAndIncrement();
                    if (globalTpCounter == 0) {
                        parameters.globalThroughputSecondInitialTime = System.currentTimeMillis();
                    }

                    if ((globalTpCounter + 1) %
                            parameters.globalThroughputIterations == 0) {
                        printGlobalOperationThroughput("HASHTABLE_REMOVE", (globalTpCounter + 1));
                    }
                }
            }
        } catch (Exception ex) {
            System.out.println("Thread " + Thread.currentThread().getName()
                    + " failed to complete HASHTABLE_REMOVE operation of object");

            ex.printStackTrace();
            if (parameters.isGUI)
                benchmarkOutput.showException("Exception", ex);
            else
                System.exit(-1);
        }
    }
}
