package com.j_spaces.examples.benchmark;

import java.util.*;
import java.io.*;

/**
 * This interface should be the basic interface for all utlilties used in by j-spaces. It follows
 * the command pattern that is each utility should implement this interaface and overite its execute
 * method. The command wrapper should provide means of the specific command environement. By means
 * of environement we mean that a command could be executed under most of the popular command shells
 * This includes CommandLineInterface, Web Interface , Application interface ( AWT , SWING ).
 *
 * @dependency com.j_spaces.util.CommandException
 */
public interface ICommand {
    /**
     * Provide an interface for printing the usage of the specific command. The usage normaly
     * contains the name of the property , possible values list for this property and a description.
     * This information should be provided in a free text format.
     */
    public void usage(PrintWriter out);

    /**
     * This is the main method for executing the command.
     *
     * @param out  output stream provides a standard output interface for all commands.Ignored if
     *             null.
     * @param args The named value argument list for the command
     */
    public boolean execute(Map args, PrintWriter out) throws BenchmarkCommandException;
}

