/*
 * Title:		IMapDriver.java
 * Description:	
 * Company:		GigaSpaces Technologies
 * 
 * @author		Moran Avigdor
 * @version		1.0 10/07/2005
 * @since		4.1 Build#
 */
package com.j_spaces.examples.benchmark;

import java.util.Map;

/**
 */
public interface IMapDriver extends Map<String, Object> {
    /**
     * use "-Dmap.driver" to specify map driver class name to load. This class must be in the
     * classpath, and an implementation of this IMapDriver interface.
     */
    static final String MAP_DRIVER_PROP = "map.driver";

    /**
     * Instantiates an instance of this Map implementation. The underlying map service will be
     * started if necessary.
     *
     * @param input an initialized input if needed.
     * @return a reference to a map instance.
     * @throws Exception if instantiation failed for any reason.
     */
    public Object init(BenchmarkConfiguration input) throws Exception;
}
