package com.j_spaces.examples.benchmark;


import java.rmi.Remote;
import java.util.concurrent.atomic.AtomicInteger;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;

import com.j_spaces.jms.utils.GSJMSAdmin;


public class JMSNotify
        extends Operation
        implements Remote {
    private AtomicInteger eventCounter;

    //private AtomicInteger myCounter;

    private ConnectionFactory connectionFactory;
    private Connection connection;
    private boolean isTransaction = false;
    private Session session;
    //private Queue dest;
    private Topic dest;
    private MessageConsumer messageConsumer;


    public JMSNotify(BenchmarkConfiguration parameters,
                     int threadID,
                     ObjectLock objLock, BenchmarkOutput benchmarkOutput) {
        super(parameters, threadID, objLock, benchmarkOutput);

        eventCounter = new AtomicInteger(0);
        //myCounter = new AtomicInteger( 0 );

        System.out.println("=== IN JMS NOTIFY constructor ===");

        if (parameters.repSpace != null) {
            space = parameters.repSpace;
        } else {
            space = parameters.space;
        }


        try {
            connectionFactory = GSJMSAdmin.getInstance().getConnectionFactory(space);
            connection = connectionFactory.createConnection();
            session = connection.createSession(isTransaction, Session.AUTO_ACKNOWLEDGE);
            //dest = GSJMSAdmin.getInstance().getQueue("benchmark");
            dest = GSJMSAdmin.getInstance().getTopic("benchmark");
            messageConsumer = session.createConsumer(dest);
            connection.start();
        } catch (JMSException e) {
            e.printStackTrace();
            closeJMSResources();
            if (parameters.isGUI)
                benchmarkOutput.showException("Exception", e);
            else
                System.exit(-1);
        }
    }


    private void closeJMSResources() {
        //System.out.println("closing resources!!");
        if (connection != null) {
            try {
                connection.close();
            } catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }

    //private int x;

    @Override
    public void prepare() {
        //System.out.println("setting message listener!!");

        try {
            messageConsumer.setMessageListener(new MessageListener() {
                public void onMessage(Message m) {
//					x = myCounter.incrementAndGet();
//					if (x%1000 == 0)
//					{
//						System.out.println("notify myCounter="+x);
//					}


                    incrementEventCounter();

                    if (getEventCounter() == 1) {
                        initialTime = System.currentTimeMillis();
                    }

                    // print thread throughput
                    if (parameters.isThreadThroughput) {
                        if (getEventCounter() == 1) {
                            initialThreadThroughputTime = initialTime;
                        }

                        if (getEventCounter() % parameters.threadThroughputIterations == 0) {
                            printThreadThroughput("NOTIFY", getEventCounter());
                        }
                    }

                    //  print global throughput
                    if (parameters.isGlobalThroughput) {
                        int globalTpCounter = parameters.globalThroughputSecondOperationCounter.getAndIncrement();
                        if (globalTpCounter == 0) {
                            parameters.globalThroughputSecondInitialTime = System.currentTimeMillis();
                        }

                        if ((globalTpCounter + 1) % parameters.globalThroughputIterations == 0) {
                            printGlobalOperationThroughput("NOTIFY", (globalTpCounter + 1));
                        }
                    }
                }
            });
        } catch (JMSException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void doOperation() {
        //System.out.println("do operation empty!!");
    }

    private void incrementEventCounter() {
        if (eventCounter.incrementAndGet() == parameters.numberOfIterations)//*parameters.threadCount )
        {
            try {

                if (transaction != null) {
                    transaction.commit();
                }
                synchronized (this) {

                    //System.out.println(Thread.currentThread().getName()+": finished:"+this);
                    notify();


                }

                finalTime = System.currentTimeMillis();

                operationResultTime = new Result(initialTime, initialTimeWFCycle, finalTime);
            } catch (Exception ex) {
                ex.printStackTrace();
                if (parameters.isGUI)
                    benchmarkOutput.showException("Exception", ex);
                else
                    System.exit(-1);
            }
        }
    }

    private int getEventCounter() {
        return eventCounter.get();
    }


    public long getResultTime() {
        //System.out.println("Getting result: "+this);
        synchronized (this) {
            try {
                if (getEventCounter() < parameters.numberOfIterations)//*parameters.threadCount )
                {
                    //System.out.println("waiting for result: "+this);
                    this.wait();
                }
                //System.out.println("finished waiting for result: "+this);
            } catch (Exception ex) {
                ex.printStackTrace();
                if (parameters.isGUI)
                    benchmarkOutput.showException("Exception", ex);
                else
                    System.exit(-1);
            }
        }

        return operationResultTime.getResultTime();
    }


    public void close() {
        closeJMSResources();
    }
}
