package com.j_spaces.examples.benchmark;


import com.j_spaces.jms.utils.GSJMSAdmin;

import javax.jms.*;


public class JMSTake extends Operation {
    private Message retEntry;

    private ConnectionFactory connectionFactory;
    private Connection connection;
    private boolean isTransaction = false;
    private Session session;
    private Queue dest;
    //private Topic dest;
    private MessageConsumer messageConsumer;


    // constructor
    JMSTake(BenchmarkConfiguration parameters, int threadID, ObjectLock objLock, BenchmarkOutput benchmarkOutput) {
        super(parameters, threadID, objLock, benchmarkOutput);

        retEntry = null;


        if (parameters.repSpace != null) {
            space = parameters.repSpace;
        } else {
            space = parameters.space;
        }


        try {
            connectionFactory = GSJMSAdmin.getInstance().getConnectionFactory(space);
            connection = connectionFactory.createConnection();
            session = connection.createSession(isTransaction, Session.AUTO_ACKNOWLEDGE);
            dest = GSJMSAdmin.getInstance().getQueue("benchmark");
            //dest = GSJMSAdmin.getInstance().getTopic("benchmark");
            messageConsumer = session.createConsumer(dest);
            connection.start();
        } catch (JMSException e) {
            e.printStackTrace();
            closeJMSResources();
            if (parameters.isGUI)
                benchmarkOutput.showException("Exception", e);
            else
                System.exit(-1);
        }

    }

    private void closeJMSResources() {
        if (connection != null) {
            try {
                connection.close();
            } catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }


    @Override
    public void prepare() {
        min_iter = threadID * parameters.numberOfIterations;

        max_iter = min_iter + parameters.numberOfIterations - 1;

        if (parameters.secondOpRange) {
            min_iter = parameters.secondOpRangeFrom;
            max_iter = parameters.secondOpRangeTo - 1;
        }

        if (parameters.isRandom) {
            if (!parameters.secondOpRange) {
                min_iter = 0;
                max_iter = parameters.numberOfRandomIterations - 1;
            }
            randomCounter = randomGenerator();
        }
    }

    @Override
    public void doOperation() {
        try {
            int globalTpCounter;
            for (int iter = min_iter; iter <= max_iter && BenchmarkCommand.START_STOP_FLAG; iter++) {
                retEntry = messageConsumer.receive(10000);
                //System.out.println(retEntry.getJMSMessageID());

                if (parameters.isThreadThroughput) {
                    if (iter == min_iter) {
                        initialThreadThroughputTime = System.currentTimeMillis();
                    }

                    if ((iter + 1) % parameters.threadThroughputIterations == 0) {
                        printThreadThroughput(OPER_TAKE, (iter + 1));
                    }
                }

                if (parameters.isGlobalThroughput) {
                    if (parameters.isAll) {
                        globalTpCounter = parameters.globalThroughputThirdOperationCounter.getAndIncrement();
                        if (globalTpCounter == 0) {
                            parameters.globalThroughputThirdInitialTime = System.currentTimeMillis();
                        }

                        if ((globalTpCounter + 1) %
                                parameters.globalThroughputIterations == 0) {
                            printGlobalOperationThroughput(OPER_TAKE, (globalTpCounter + 1));
                        }
                    } else {
                        globalTpCounter = parameters.globalThroughputSecondOperationCounter.getAndIncrement();
                        if (globalTpCounter == 0) {
                            parameters.globalThroughputSecondInitialTime = System.currentTimeMillis();
                        }

                        if ((globalTpCounter + 1) %
                                parameters.globalThroughputIterations == 0) {
                            printGlobalOperationThroughput(OPER_TAKE, (globalTpCounter + 1));
                        }
                    }
                }
            }
        } catch (Exception e) {
            System.out.println("Thread " + Thread.currentThread().getName()
                    + " failed to complete JMSTake operation");

            e.printStackTrace();
            if (parameters.isGUI)
                benchmarkOutput.showException("Exception", e);
            else
                System.exit(-1);
        } finally {
            closeJMSResources();
        }
    }
}
