package com.j_spaces.examples.benchmark;


import java.rmi.RemoteException;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
//import javax.jms.Topic;

import com.j_spaces.jms.utils.GSJMSAdmin;

public class JMSWrite
        extends Operation {
    private Message writeEntry;

    private ConnectionFactory connectionFactory;
    private Connection connection;
    private boolean isTransaction = false;
    private Session session;
    private Queue dest;
    //private Topic dest;
    private MessageProducer messageProducer;

    // constructor
    JMSWrite(BenchmarkConfiguration parameters, int threadID, ObjectLock objLock, BenchmarkOutput benchmarkOutput)

    {
        super(parameters, threadID, objLock, benchmarkOutput);


        if (parameters.isNotify && parameters.repSpace != null) {
            space = parameters.repSpace;
        } else {
            space = parameters.space;
        }

        try {
            connectionFactory = GSJMSAdmin.getInstance().getConnectionFactory(space);
            connection = connectionFactory.createConnection();
            session = connection.createSession(isTransaction, Session.AUTO_ACKNOWLEDGE);
            //dest = GSJMSAdmin.getInstance().getTopic("benchmark");
            dest = GSJMSAdmin.getInstance().getQueue("benchmark");
            messageProducer = session.createProducer(dest);
        } catch (JMSException e) {
            e.printStackTrace();
            closeJMSResources();
            if (parameters.isGUI)
                benchmarkOutput.showException("Exception", e);
            else
                System.exit(-1);
        }

    }

    @Override
    public void prepare() {
        try {
            MessageAdaptor adaptor = MessageAdaptors.getByCode(parameters.messageType);
            writeEntry = (Message) adaptor.create(-1, parameters.messageBuf);
            parameters.space.snapshot(adaptor.create());

            if (parameters.firstOpRange) {
                min_iter = parameters.firstOpRangeFrom;
                max_iter = parameters.firstOpRangeTo - 1;
            } else {
                min_iter = threadID * parameters.numberOfIterations;
                max_iter = min_iter + parameters.numberOfIterations - 1;
            }
        } catch (RemoteException e) {
            e.printStackTrace();
            closeJMSResources();
            if (parameters.isGUI)
                benchmarkOutput.showException("Exception", e);
            else
                System.exit(-1);
        }
    }


    private void closeJMSResources() {
        if (connection != null) {
            try {
                connection.close();
            } catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }


//    private AtomicInteger myCounter = new AtomicInteger(0);
//    int x;

    @Override
    public void doOperation() {
        try {
            int rateIter, globalTpCounter;

            for (long iter = min_iter; iter <= max_iter && BenchmarkCommand.START_STOP_FLAG; iter++) {
//    			x = myCounter.incrementAndGet();
//    			if (x % 1000 == 0)
//    			{
//    				System.out.println("write myCounter="+x);
//    			}

                messageProducer.send(writeEntry);

                if (parameters.isWriteRate) {
                    rateIter = parameters.globalRateIter.getAndIncrement();
                    if (rateIter == 0) {
                        parameters.globalInitialRateTime = System.currentTimeMillis();
                    }

                    if ((rateIter + 1) % parameters.writeRate == 0) {
                        waitWriteRate(OPER_WRITE, (rateIter + 1));
                    }
                }

                // print thread throughput
                if (parameters.isThreadThroughput) {
                    if (iter == min_iter) {
                        initialThreadThroughputTime = System.currentTimeMillis();
                    }

                    if ((iter + 1) % parameters.threadThroughputIterations == 0) {
                        printThreadThroughput(OPER_WRITE, (iter + 1));
                    }
                }

                //  print global throughput
                if (parameters.isGlobalThroughput) {
                    globalTpCounter = parameters.globalThroughputFirstOperationCounter.getAndIncrement();
                    if (globalTpCounter == 0) {
                        parameters.globalThroughputFirstInitialTime = System.currentTimeMillis();
                    }

                    if ((globalTpCounter + 1) %
                            parameters.globalThroughputIterations == 0) {
                        printGlobalOperationThroughput(OPER_WRITE, (globalTpCounter + 1));
                    }
                }
            }
        } catch (Exception e) {
            System.out.println("Thread " + Thread.currentThread().getName()
                    + " failed to complete JMSWrite operation of entry");

            e.printStackTrace();
            if (parameters.isGUI)
                benchmarkOutput.showException("Exception", e);
            else
                System.exit(-1);
        } finally {
            closeJMSResources();
        }
    }
}
