/*
 * Title:			MapDriver.java
 * Description: 	GSMapImple Map Driver	
 * Company:			GigaSpaces Technologies
 * 
 * @author		Moran Avigdor
 * @version		1.0 10/07/2005
 * @since		4.1 Build#1193
 */
package com.j_spaces.examples.benchmark;

import java.util.Collection;
import java.util.Set;

import com.j_spaces.map.IMap;

/**
 */
public class MapDriver implements IMapDriver {
    private IMap map;
    private BenchmarkConfiguration parameters;

    /**
     * instantiates a MapDriver; this construction should call init(Object) method for any further
     * initialization.
     */
    public MapDriver() {
    }


    /**
     * Instantiates a MapCache map implementation.
     *
     * @param bcnfgParameters of benchmark configuration
     * @return Map instance
     * @see com.j_spaces.examples.benchmark.IMapDriver#getMap(java.lang.String)
     */
    public Object init(BenchmarkConfiguration bcnfgParameters) throws Exception {
        parameters = bcnfgParameters;

        map = parameters.cache;

        return map;
    }


    /**
     * @see com.j_spaces.map.IMap#size()
     */
    public int size() {
        return map.size();
    }

    /**
     * @see com.j_spaces.map.IMap#isEmpty()
     */
    public boolean isEmpty() {
        return map.isEmpty();
    }

    /*
     * @see com.j_spaces.map.IMap#containsKey(java.lang.Object)
     */
    public boolean containsKey(Object key) {
        return map.containsKey(key);
    }

    /*
     * @see com.j_spaces.map.IMap#containsValue(Object)
     */
    public boolean containsValue(Object value) {
        return map.containsValue(value);
    }

    /*
     * @see com.j_spaces.map.IMap#get(java.lang.Object)
     */
    public Object get(Object key) {
        return map.get(key, parameters.timeout);
    }

    /*
     * @see com.j_spaces.map.IMap#put(K, V)
     */
    public Object put(String key, Object value) {
        return map.put(key, value, parameters.lease);
    }

    /*
     * @see com.j_spaces.map.IMap#remove(java.lang.Object)
     */
    public Object remove(Object key) {
        return map.remove(key, parameters.timeout);
    }

    /*
     * @see com.j_spaces.map.IMap#clear()
     */
    public void clear() {
        map.clear();
    }

    /*
     * @see com.j_spaces.map.IMap#putAll(java.util.Map)
     */
    public void putAll(java.util.Map<? extends String, ? extends Object> t) {
        map.putAll(t);
    }

    /*
     * @see com.j_spaces.map.IMap#keySet()
     */
    public Set keySet() {
        return map.keySet();
    }

    /*
     * @see com.j_spaces.map.IMap#values()
     */
    public Collection values() {
        return map.values();
    }

    /*
     * @see jcom.j_spaces.map.IMap#entrySet()
     */
    public Set entrySet() {
        return map.entrySet();
    }
}
