package com.j_spaces.examples.benchmark;

public abstract class MessageAdaptor<T> {
    public abstract short getCode();

    public abstract String getName();

    public abstract int getGroup();

    /**
     * GUI combo label
     */
    public abstract String getLabel();

    public abstract String getDescription();

    public String getUsageInfo() {
        return "";
    }

    public boolean isEntry() {
        return false;
    }

    public boolean isFifo() {
        return false;
    }

    public boolean isJMS() {
        return false;
    }

    public abstract T create();

    public T create(long counter, byte[] content) {
        T result = create();
        setCounter(result, counter);
        setPayload(result, content);
        return result;
    }

    public abstract void setCounter(T instance, long counter);

    public abstract void setPayload(T instance, byte[] payload);
}
