package com.j_spaces.examples.benchmark;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.j_spaces.examples.benchmark.adaptors.MessageJMSAdaptor;
import com.j_spaces.examples.benchmark.adaptors.MessagePOJOAdaptor;
import com.j_spaces.examples.benchmark.adaptors.MessagePOJOExternalizableAdaptor;
import com.j_spaces.examples.benchmark.adaptors.MessagePOJOExternalizableFifoAdaptor;
import com.j_spaces.examples.benchmark.adaptors.MessagePOJOFifoAdaptor;

public class MessageAdaptors {
    public static final short CODE_POJO = 1;
    public static final short CODE_POJO_FIFO = 2;
    public static final short CODE_POJO_EXTERNALIZABLE = 3;
    public static final short CODE_POJO_EXTERNALIZABLE_FIFO = 4;
    public static final short CODE_JMS = 7;

    public static final int GROUP_SERIALIZABLE = 1;
    public static final int GROUP_EXTERNALIZABLE = 2;
    public static final int GROUP_JMS = 3;

    // Array of all adaptors:
    private static final MessageAdaptor[] _adaptors;
    // Mapping of adaptor code to adaptor:
    private static final Map<Short, MessageAdaptor> _codeAdaptorMap;
    // Mapping of adaptor name to adaptor
    private static final Map<String, MessageAdaptor> _nameAdaptorMap;
    // Mapping of group code to list of adaptors of same group.
    private static final Map<Integer, List<MessageAdaptor>> _groupAdaptorsMap;

    static {
        _adaptors = new MessageAdaptor[]
                {
                        new MessagePOJOAdaptor(),
                        new MessagePOJOFifoAdaptor(),
                        new MessagePOJOExternalizableAdaptor(),
                        new MessagePOJOExternalizableFifoAdaptor(),
                        new MessageJMSAdaptor()
                };

        _codeAdaptorMap = new HashMap<Short, MessageAdaptor>();
        _nameAdaptorMap = new HashMap<String, MessageAdaptor>();
        _groupAdaptorsMap = new HashMap<Integer, List<MessageAdaptor>>();

        for (MessageAdaptor adaptor : _adaptors) {
            _codeAdaptorMap.put(adaptor.getCode(), adaptor);
            _nameAdaptorMap.put(adaptor.getName(), adaptor);
            List<MessageAdaptor> groupAdaptors = _groupAdaptorsMap.get(adaptor.getGroup());
            if (groupAdaptors == null) {
                groupAdaptors = new ArrayList<MessageAdaptor>();
                _groupAdaptorsMap.put(adaptor.getGroup(), groupAdaptors);
            }
            groupAdaptors.add(adaptor);
        }
    }

    public static MessageAdaptor[] getMessageAdaptors() {
        return _adaptors;
    }

    public static MessageAdaptor getByCode(short code) {
        return _codeAdaptorMap.get(code);
    }

    public static MessageAdaptor getByName(String name) {
        return _nameAdaptorMap.get(name);
    }

    public static String getMessageName(short type) {
        MessageAdaptor adaptor = getByCode(type);
        return adaptor != null ? adaptor.getLabel() : String.valueOf(type);
    }

    public static short getMessageType(String type) {
        MessageAdaptor adaptor = getByName(type);
        return adaptor != null ? adaptor.getCode() : 1;
    }

    public static String getComparisonString(MessageAdaptor adaptor) {
        String result = "This object's result are comparable with the following objects: ";

        List<MessageAdaptor> adaptors = _groupAdaptorsMap.get(adaptor.getGroup());
        result += adaptors.get(0).getLabel();
        for (int i = 1; i < adaptors.size(); i++)
            result += ", " + adaptors.get(i).getLabel();

        return result + ".";
    }
}
