package com.j_spaces.examples.benchmark;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;

/**
 * This class has some common methods that are used by different modules and class of Benchmark
 *
 * @author evgenyf
 * @version 1.0
 * @since 6.0
 */
public class MessageUtilities {
    /**
     * This method returns list filled with GregorianCalendar class instances. Size of list is
     * defined by passed parameter.
     *
     * @param size defines size of list
     * @return list
     */
    public static List<GregorianCalendar> generateData(int size) {
        if (size <= 0)
            return null;

        List<GregorianCalendar> list = new ArrayList<GregorianCalendar>(size);
        for (int i = 0; i < size; i++) {
            int year = (int) (Math.random() * 2000);
            int month = (int) (Math.random() * 12);
            int day = (int) (Math.random() * 31);
            list.add(i, new GregorianCalendar(year, month, day));
        }

        return list;
    }

    /**
     * This method returns list filled with GregorianCalendar class instances which are read from
     * ObjectInput.
     *
     * @param in ObjectInput instance
     * @return list
     */
    public static List<GregorianCalendar> copyDataFromObjectInputToList(ObjectInput in)
            throws IOException {
        int size = in.readInt();
        List<GregorianCalendar> list = new ArrayList<GregorianCalendar>(size);
        for (int i = 0; i < size; i++) {
            int year = in.readInt();
            int month = in.readInt();
            int day = in.readInt();
            list.add(i, new GregorianCalendar(year, month, day));
        }

        return list;
    }

    /**
     * This method goes over list of GregorianCalendar class instances and write them to
     * ObjectOutput.
     *
     * @param list list
     * @param out  ObjectOutput class instance
     */
    public static void copyDataFromListToObjectOutput(
            List<GregorianCalendar> list, ObjectOutput out)
            throws IOException {
        if (list == null)
            out.writeBoolean(false);
        else {
            out.writeBoolean(true);
            out.writeInt(list.size());
            for (GregorianCalendar date : list) {
                out.writeInt(date.get(Calendar.YEAR));
                out.writeInt(date.get(Calendar.MONTH));
                out.writeInt(date.get(Calendar.DAY_OF_MONTH));
            }
        }
    }
}
