package com.j_spaces.examples.benchmark;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.concurrent.atomic.AtomicInteger;

import com.gigaspaces.events.DataEventSessionFactory;

import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import net.jini.core.lease.UnknownLeaseException;

import com.gigaspaces.events.DataEventSession;
import com.gigaspaces.events.EventSessionConfig;
import com.gigaspaces.events.NotifyActionType;

public class Notify
        extends Operation
        implements RemoteEventListener, Remote {
    private Object notifyTemplate;

    private AtomicInteger eventCounter;

    private DataEventSession session;


    public Notify(BenchmarkConfiguration parameters,
                  int threadID,
                  ObjectLock objLock, BenchmarkOutput benchmarkOutput) {
        super(parameters, threadID, objLock, benchmarkOutput);


        notifyTemplate = null;

        eventCounter = new AtomicInteger(0);

        session = null;

        System.out.println("=== IN NOTIFY constructor ===");
    }

    @Override
    public void prepare() {
        MessageAdaptor adaptor = MessageAdaptors.getByCode(parameters.messageType);

        notifyTemplate = adaptor.create();

        parameters.getMessageAdaptor().setCounter(notifyTemplate, -1);//threadID

        try {
            EventSessionConfig config = new EventSessionConfig().setFifo(false);
            session = DataEventSessionFactory.create(parameters.space, config);
            session.addListener(notifyTemplate, this, parameters.lease, NotifyActionType.NOTIFY_ALL);

            if (parameters.repSpace != null) {
                session = DataEventSessionFactory.create(parameters.repSpace, config);
                session.addListener(notifyTemplate, this, parameters.lease, NotifyActionType.NOTIFY_ALL);
            }
        } catch (Exception e) {
            e.printStackTrace();
            if (parameters.isGUI)
                benchmarkOutput.showException("Exception", e);
            else
                System.exit(-1);
        }
    }

    @Override
    public void doOperation() {

    }

    private void incrementEventCounter() {
        if (eventCounter.incrementAndGet() == parameters.numberOfIterations) {
            try {

                if (transaction != null) {
                    transaction.commit();
                }
                synchronized (this) {

                    notify();


                }

                finalTime = System.currentTimeMillis();

                operationResultTime = new Result(initialTime, initialTimeWFCycle, finalTime);
            } catch (Exception ex) {
                ex.printStackTrace();
                if (parameters.isGUI)
                    benchmarkOutput.showException("Exception", ex);
                else
                    System.exit(-1);
            }
        }
    }

    private int getEventCounter() {
        return eventCounter.get();
    }


    public long getResultTime() {
        synchronized (this) {
            try {
                if (getEventCounter() != parameters.numberOfIterations) {
                    this.wait();
                }
            } catch (Exception ex) {
                ex.printStackTrace();
                if (parameters.isGUI)
                    benchmarkOutput.showException("Exception", ex);
                else
                    System.exit(-1);
            }
        }

        return operationResultTime.getResultTime();
    }


    public void notify(RemoteEvent event)
            throws UnknownEventException, RemoteException {
        incrementEventCounter();

        if (getEventCounter() == 1) {
            initialTime = System.currentTimeMillis();
        }

        // print thread throughput
        if (parameters.isThreadThroughput) {
            if (getEventCounter() == 1) {
                initialThreadThroughputTime = initialTime;
            }

            if (getEventCounter() % parameters.threadThroughputIterations == 0) {
                printThreadThroughput("NOTIFY", getEventCounter());
            }
        }

        //  print global throughput
        if (parameters.isGlobalThroughput) {
            int globalTpCounter = parameters.globalThroughputSecondOperationCounter.getAndIncrement();
            if (globalTpCounter == 0) {
                parameters.globalThroughputSecondInitialTime = System.currentTimeMillis();
            }

            if ((globalTpCounter + 1) % parameters.globalThroughputIterations == 0) {
                printGlobalOperationThroughput("NOTIFY", (globalTpCounter + 1));
            }
        }
    }

    public void close() {
        try {
            session.close();
        } catch (RemoteException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        } catch (UnknownLeaseException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }
}
